#ifndef _FTAPE_DYNMEM_H
#define _FTAPE_DYNMEM_H
/*
 *      Copyright (C) 1994 Claus-Justus Heine.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 /home/cvs/zftape/ftape-dynmem.h,v
 root
 *
 1.1.1.1
 1995/11/15 16:55:47
 Exp
 *
 *   memory allocation routines. Tries to use remaining parts of dma-buffer
 *   (wich is aligned to 32k) for ordinary buffers. 
 *
 */

#ifdef DYN_ALLOC

/*
 *   MAX_DMA_BUFFERS gives the number of dma-able areas that we are able
 *   to manage. Each area can be at most 4*32k-24, so that we have
 *   actually at most MAX_DMA_BUFFERS*3 tape-buffers.
 */
#define MAX_DMA_AREAS 6
#define MAX_DMA_BUFFERS (MAX_DMA_AREAS * 3)
#define BUFF_BUFFER_SIZE ( MAX_DMA_BUFFERS * sizeof(buffer_struct))

/*
 *   called by init_module()
 */
extern int  ftape_get_tape_buffer( int *num_buffers );
/*
 *   called by cleanup_module()
 */
extern void ftape_cleanup_mem( void );
/*
 *   called by ftape_zap_read_buffers();
 */
extern void ftape_init_tape_buffer ( void );
/*
 *   called via MTSETDRVBUFFER
 */
extern int  ftape_change_dma_size( int num_buffers );

#endif /* DYN_ALLOC */

extern int ftape_num_buffers;



#endif
