/*
 *   I use these routines just to decide when I have to fake a 
 *   volume-table to preserve compatability to original ftape.
 */
/*
 *      Copyright (C) 1994-1995 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 /home/cvs/zftape/ftape-eof.c,v
 root
 *
 1.1.1.1
 1995/11/15 16:55:47
 Exp
 *
 *      This file contains the eof mark handling code
 *      for the QIC-40/80 floppy-tape driver for Linux.
 */

static char RCSid[] =
"ftape-eof.c,v 1.1.1.1 1995/11/15 16:55:47 root Exp";
  
  
#include "ftape.h"
#include <linux/string.h>
#include <linux/errno.h>

#include "ftape-eof.h"
#include "ftape-write.h"
#include "ftape-read.h"
#include "ftape-rw.h"
#include "ftape-ctl.h"
#include "ftape-bsm.h"

/*      Global vars.
 */
int failed_sector_log_changed = 0;
int eof_mark = 0;
/*  a copy of the failed sector log from the header segment.
 */
#ifdef DYN_ALLOC
eof_mark_union *eof_map;
#else
eof_mark_union eof_map[ EOF_MAP_SIZE/4 ] = { { .entry = 0UL }, };
#endif
/*  number of eof marks (entries in bad sector log) on tape.
 */
int nr_of_eof_marks = -1;


/*      Local vars.
 */

static char linux_tape_label[] = "Linux raw format V";
enum { min_fmt_version = 1, max_fmt_version = 2 };
static unsigned ftape_fmt_version = 0;


/*  Ftape (mis)uses the bad sector log to record end-of-file marks.
 *  Initially (when the tape is erased) all entries in the bad sector
 *  log are added to the tape's bad sector map. The bad sector log
 *  then is cleared.
 *
 *  The bad sector log normally contains entries of the form:
 *  even 16-bit word: segment number of bad sector
 *   odd 16-bit word: encoded date
 *  There can be a total of 448 entries (1792 bytes).
 *
 *  My guess is that no program is using this bad sector log (the
 *  format seems useless as there is no indication of the bad sector
 *  itself, only the segment)
 *  However, if any program does use the bad sector log, the format
 *  used by ftape will let the program think there are some bad sectors
 *  and no harm is done.
 *  
 *  The eof mark entries that ftape stores in the bad sector log:
 *  even 16-bit word: segment number of eof mark
 *   odd 16-bit word: sector number of eof mark [1..32]
 *  
 *  The eof_map as maintained is a sorted list of eof mark entries.
 *
 *
 *  The tape name field in the header segments is used to store a
 *  linux tape identification string and a version number.
 *  This way the tape can be recognized as a Linux raw format
 *  tape when using tools under other OS's.
 *
 *  'Wide' QIC tapes (format code 4) don't have a failed sector list
 *  anymore. That space is used for the (longer) bad sector map that
 *  now is a variable length list too.
 *  We now store our end-of-file marker list after the bad-sector-map
 *  on tape. The list is delimited by a (long) 0 entry.
 */

int
ftape_validate_label( char* label)
{
  TRACE_FUN( 8, "ftape_validate_label");
  int result = 0;

  TRACEx1( 4, "tape  label = `%s'", label);
  ftape_fmt_version = 0;
  if (memcmp( label, linux_tape_label, strlen( linux_tape_label)) == 0) {
    int pos = strlen( linux_tape_label);
    while (label[ pos] >= '0' && label[ pos] <= '9') {
      ftape_fmt_version *= 10;
      ftape_fmt_version = label[ pos++] - '0';
    }
    result = (ftape_fmt_version >= min_fmt_version &&
              ftape_fmt_version <= max_fmt_version);
  }
  TRACEx1( 4, "format version = %d", ftape_fmt_version);
  TRACE_EXIT;
  return result;
}

static byte*
find_end_of_eof_list( byte* ptr, byte* limit)
{
  while (ptr + 3 < limit) {
    if (*(unsigned long*)ptr) {
      ++(unsigned long*)ptr;
    } else {
      return ptr;
    }
  }
  return NULL;
}

void
extract_file_marks( byte* address)
{
  TRACE_FUN( 8, "extract_file_marks");
  int i;

  if (format_code == 4) {
    byte* end;
    byte* start = find_end_of_bsm_list( address + 256,
                                       address + 29 * SECTOR_SIZE);

#ifdef DYN_ALLOC
    memset( eof_map, 0, EOF_MAP_SIZE );
#else
    memset( eof_map, 0, sizeof( eof_map));
#endif
    nr_of_eof_marks = 0;
    if (start) {
      start += 3;               /* skip end of list mark */
      end = find_end_of_eof_list( start, address + 29 * SECTOR_SIZE);
#ifdef DYN_ALLOC
      if (end && end - start <= EOF_MAP_SIZE ) {
#else
      if (end && end - start <= sizeof( eof_map)) {
#endif
        nr_of_eof_marks = (end - start) / sizeof( unsigned long);
        memcpy( eof_map, start, end - start);
      } else {
        TRACE( 1, "File Mark List is too long or damaged !");
      }
    } else {
      TRACE( 1, "Bad Sector List is too long or damaged !");
    }
  } else {
#ifdef DYN_ALLOC
    memcpy( eof_map, address + 256, EOF_MAP_SIZE );
#else
    memcpy( eof_map, address + 256, sizeof( eof_map));
#endif
    nr_of_eof_marks = GET2( address, 144);
  }
  TRACEi( 4, "number of file marks:", nr_of_eof_marks);
  if (ftape_fmt_version == 1) {
    TRACE( -1, "swapping version 1 fields");
    /*  version 1 format uses swapped sector and segment fields, correct that !
     */
    for (i = 0; i < nr_of_eof_marks; ++i) {
      unsigned short tmp = eof_map[ i].mark.segment;
      eof_map[ i].mark.segment = eof_map[ i].mark.sector;
      eof_map[ i].mark.sector = tmp;
    }
  }
  for (i = 0; i < nr_of_eof_marks; ++i) {
    TRACEx2( 4, "eof mark: %5d/%2d",
            eof_map[ i].mark.segment, eof_map[ i].mark.sector);
  }
  TRACE_EXIT;
}

int
update_failed_sector_log( byte* buffer)
{
  TRACE_FUN( 8, "update_failed_sector_log");

  if (ftape_fmt_version != 0 && failed_sector_log_changed) {
    if (format_code == 4) {
      byte* dest = find_end_of_bsm_list( buffer + 256,
                                        buffer + 29 * SECTOR_SIZE) + 3;
 
      if (dest) {
        TRACEx2( 4, "eof_map at byte offset %6d, size %d",
                dest - buffer - 256, nr_of_eof_marks * sizeof( unsigned long));
        memcpy( dest, eof_map, nr_of_eof_marks * sizeof( unsigned long));
        PUT4( dest, nr_of_eof_marks * sizeof( unsigned long), 0);
      }
    } else {
#ifdef DYN_ALLOC
      memcpy( buffer + 256, eof_map, EOF_MAP_SIZE );
#else
      memcpy( buffer + 256, eof_map, sizeof( eof_map) );
#endif
      PUT2( buffer, 144, nr_of_eof_marks);
    }
    failed_sector_log_changed = 0;
    return 1;
  }
  TRACE_EXIT;
  return 0;
}

/*{{{}}}*/
