#ifndef _FTAPE_EOF_H
#define _FTAPE_EOF_H

/*
 * Copyright (C) 1994-1995 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 /home/cvs/zftape/ftape-eof.h,v
 root
 *
 1.1.1.1
 1995/11/15 16:55:47
 Exp
 *
 *      Definitions and declarations for the end of file markers
 *      for the QIC-40/80 floppy-tape driver for Linux.
 */


#define EOF_MAP_SIZE (2048 - 256)

struct failed_sector_entry {
  unsigned short segment;
  unsigned short sector;
};

typedef union {
  struct failed_sector_entry mark;
  unsigned long entry;
} eof_mark_union;

/*      ftape-eof.c defined global vars.
 */
extern int failed_sector_log_changed;
#ifdef DYN_ALLOC
extern eof_mark_union *eof_map;
#else
extern eof_mark_union eof_map[EOF_MAP_SIZE/4];
#endif
extern int nr_of_eof_marks;

/*      ftape-eof.c defined global functions.
 */
extern void extract_file_marks( byte* address);
extern int update_failed_sector_log( byte* buffer);
extern int ftape_validate_label( char* label);

#endif
