#ifndef _FTAPE_RW_H
#define _FTAPE_RW_H

/*
 * Copyright (C) 1993-1995 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 /home/cvs/zftape/ftape-rw.h,v
 claus
 *
 1.2
 1995/11/16 13:37:17
 Exp
 *
 *      This file contains the definitions for the read and write
 *      functions for the QIC-117 floppy-tape driver for Linux.
 *
 */

#include "ftape-dynmem.h"
#include "fdc-io.h"
#include "kernel-interface.h"

#define GET2( address, offset) (int)*(unsigned short*)(address + offset)
#define GET4( address, offset) *(long*)(address + offset)
#define PUT2( address, offset, value) *(unsigned short *)(address + offset) = (unsigned short)(value)
#define PUT4( address, offset, value) *(unsigned long*)(address + offset) = (unsigned long)(value)

enum runner_status_enum {
  idle = 0,
  running,
  do_abort,
  aborting,
  logical_eot, 
  end_of_tape,
  buffer_overrun,
  buffer_underrun,
};        

typedef struct {
  byte* address;
  volatile buffer_state_enum status;
  volatile byte* ptr;
  volatile unsigned bytes;
  volatile unsigned segment_id;

  /* bitmap for remainder of segment not yet handled.
   * one bit set for each bad sector that must be skipped.
   */
  volatile unsigned long bad_sector_map;

  /* bitmap with bad data blocks in data buffer.
   * the errors in this map may be retried.
   */
  volatile unsigned long soft_error_map;

  /* bitmap with bad data blocks in data buffer
   * the errors in this map may not be retried.
   */
  volatile unsigned long hard_error_map;
  
  /* retry counter for soft errors.
   */
  volatile int retry;

  /* sectors to skip on retry ???
   */
  volatile unsigned int skip;

  /* nr of data blocks in data buffer
   */
  volatile unsigned data_offset;

  /* offset in segment for first sector to be handled.
   */
  volatile unsigned sector_offset;

  /* size of cluster of good sectors to be handled.
   */
  volatile unsigned sector_count;

  /* size of remaining part of segment to be handled.
   */
  volatile unsigned remaining;

  /* points to next segment (contigious) to be handled,
   * or is zero if no read-ahead is allowed.
   */
  volatile unsigned next_segment;

  /* flag being set if deleted data was read.
   */
  volatile int deleted;

  volatile byte head;
  volatile byte cyl;
  volatile byte sect;
} buffer_struct;

typedef struct {
  int active;
  int error;
  int offset;
} ftape_fast_start_struct;

typedef struct {
  int track;                    /* tape head position */
  volatile int known;           /* validates bot, segment, sector */
  volatile int bot;             /* logical begin of track */
  volatile int eot;             /* logical end of track */
  volatile int segment;         /* current segment */
  volatile int sector;          /* sector offset within current segment */
} location_record;

typedef enum {
  fmt_normal = 2, fmt_1100ft = 3, fmt_wide = 4, fmt_425ft = 5
} format_type;

typedef enum
{ 
  io_idle = 0,
  io_reading,
  io_writing,
} ftape_io_status_enum;

#define DEBLOCK_SIZE ((SECTORS_PER_SEGMENT - 3) * SECTOR_SIZE)
#define SCRATCH_SIZE ((SECTORS_PER_SEGMENT - 3) * SECTOR_SIZE)
#ifndef DYN_ALLOC
#define BUFF_BUFFER_SIZE (NR_FTAPE_BUFFERS * sizeof(buffer_struct))
#else
/* see ftape-dynmem.h
 */
#endif

/*      ftape-rw.c defined global vars.
 */
extern int tracing;
extern byte trace_id;
extern location_record location;
extern volatile ftape_fast_start_struct ftape_fast_start;
#ifdef DYN_ALLOC
extern byte *deblock_buffer;
extern byte *scratch_buffer;
extern buffer_struct *buffer;
#else
extern byte deblock_buffer[ DEBLOCK_SIZE ];
extern byte scratch_buffer[ SCRATCH_SIZE ];
extern buffer_struct buffer[ NR_FTAPE_BUFFERS];
#endif
extern int header_segment_1;
extern int header_segment_2;
extern int used_header_segment;
extern unsigned int fast_seek_segment_time;
extern volatile int tape_running;
extern format_type format_code;
extern int ftape_deblock_segment;
extern ftape_io_status_enum ftape_io_state;
extern int ftape_label_changed;
extern char ftape_label[45];

/*      ftape-rw.c defined global functions.
 */
extern int valid_segment_no( unsigned segment);
extern int setup_new_segment( buffer_struct* buff, unsigned int segment_id,
                             int offset);
extern int calc_next_cluster( buffer_struct* buff);
extern buffer_struct* next_buffer( volatile int* x);
extern int ftape_read_id( void);
extern void ftape_tape_parameters( byte drive_configuration);
extern int wait_segment( buffer_state_enum state);
extern int ftape_dumb_stop( void);
extern int ftape_start_tape( int segment_id, int offset);

extern void ftape_advance_to_next_segment( void );
extern void ftape_set_flags( unsigned minor_unit );
extern int  ftape_physical_sector( int segment, int logical_sector );
extern int  ftape_logical_sector( int segment, int physical_sector );
extern int  ftape_calc_seg_byte_coord(int *seg_data_pos, int data_pos );
extern int  ftape_calc_data_pos(int segment, int byte_pos);
extern void ftape_calc_data_amount ( void );
extern void ftape_update_label( char *label );
extern int  ftape_erase( void);
extern int  ftape_verify_write_segment( unsigned segment, byte* buffer);


/*      fdc-io.c defined global functions.
 */
extern int setup_fdc_and_dma( buffer_struct* buff, byte operation);

/*      Count nr of 1's in pattern.
 */
static inline int count_ones( unsigned long mask)
{
  int bits;

  for (bits = 0; mask != 0; mask >>= 1) {
    if (mask & 1) {
      ++bits;
    }
  }
  return bits;
}


#endif /* _FTAPE_RW_H */
