/* $Header: config.h,v 2.10 90/05/03 10:28:48 chip Exp $
 *
 * Deliver configuration.
 *
 * $Log:	config.h,v $
 * Revision 2.10  90/05/03  10:28:48  chip
 * Add UUCP configuration.
 * 
 * Revision 2.9  90/03/06  12:21:08  chip
 * Move logging into log.c and address parsing into addr.c.
 * New: error delivery file for messages that fail.
 * Major rearrangement of delivery file code.
 * 
 * Revision 2.8  90/02/23  14:16:39  chip
 * Support "#!" in delivery files.
 * Support "user|program" and "user?error" from delivery files.
 * Improve debugging and error message formatting.
 * Rearrange code for clarity.
 * 
 * Revision 2.7  90/02/06  11:56:37  chip
 * Enforce MBX_MODE regardless of UMASK.
 * Enforce ordered logging with a log lockfile.
 * Revise log format.
 * 
 * Revision 2.6  89/12/14  17:42:25  network
 * Rework setvbuf() configuration to avoid errors.
 * 
 * Revision 2.5  89/11/10  12:23:49  network
 * Handle recursion.
 * 
 * Revision 2.4  89/11/01  10:33:36  network
 * Add UMASK, LOG, ERRLOG.
 * 
 * Revision 2.3  89/09/29  18:16:52  network
 * Save message when delivery file produces no output,
 * unless delivery file output the "DROP" string.
 * Don't recopy temp files for sys and post-user delfiles.
 * 
 * Revision 2.2  89/06/09  13:07:38  network
 * Adapt to BSD quirks.
 * 
 * Revision 2.1  89/06/09  12:25:11  network
 * Update RCS revisions.
 * 
 * Revision 1.11  89/06/09  12:23:38  network
 * Baseline for 2.0 release.
 * 
 */

/*----------------------------------------------------------------------
 * SCO Xenix System V compilers define M_SYSV, which implies USG.
 */

#ifdef M_SYSV
#ifndef USG
#define USG
#endif
#endif

/*----------------------------------------------------------------------
 * Trusted users.
 * Deliver permits "trusted" users to specify delivery filenames
 * without renouncing setuid privileges.  Essentially, these users
 * are given the root password.  Beware!
 */

#define TRUSTED_USERS   "root"

/*----------------------------------------------------------------------
 * Signal function type.
 * Signal catching routines have this return value.
 * (For System V Release 3.0 or later, use "void".)
 */

#ifdef USG
# define SIGTYPE void
#else
# define SIGTYPE int
#endif

/*----------------------------------------------------------------------
 * Argument order for setvbuf():
 *     SETVBUF_BUF_TYPE     (.., buf, type, ..)         (Correct)
 *     SETVBUF_TYPE_BUF     (.., type, buf, ..)         (Broken)
 *
 * Broken systems that need SETVBUF_TYPE_BUF include:
 *     SCO Xenix development system 2.2
 *     SysVR3.0 (Probably)
 *     SysVR3.1 (Maybe)
 *
 * If neither is defined, then setvbuf() will not be called.
 * >>> Be sure to get this one right, or the program will dump core. <<<
 */

#define SETVBUF_BUF_TYPE
/* #define SETVBUF_TYPE_BUF */

/*----------------------------------------------------------------------
 * Signal function declaration.
 * Define this if your <signal.h> doesn't declare signal() correctly.
 */

/* #define DECLARE_SIGNAL */

/*----------------------------------------------------------------------
 * Signal flag type.
 * Variables of this type may be set by signal catching routines.
 */

#if __STDC__
#define SIGFLAG sig_atomic_t
#else
#define SIGFLAG short   /* or "volatile short" for aggressive optimizers */
#endif

#undef SIGFLAG
#define SIGFLAG short

/*----------------------------------------------------------------------
 * Various kinds of mailbox locking.
 * You may define one or both of ML_DOTLOCK and ML_DOTMLK.
 * You may define no more than one of ML_FCNTL, ML_LOCKF and ML_LOCKING.
 *
 * File creation locking:
 *     ML_DOTLOCK   create <mailbox>.lock       (most systems except BSD4.3)
 *     ML_DOTMLK    create /tmp/<basename>.mlk  (Xenix)
 *
 * Kernel record locking:
 *     ML_FCNTL     lock with fcntl(F_SETLKW)   (SVID systems only)
 *     ML_LOCKF     lock with lockf(F_LOCK)     (SVID systems only)
 *     ML_LOCKING   lock with locking(LK_LOCK)  (Xenix systems only)
 */

#ifdef M_XENIX
#define ML_DOTMLK
#define ML_LOCKING
#else
#define ML_DOTLOCK
#endif

/*----------------------------------------------------------------------
 * Maximum filename length.
 * Note that this is for _filenames_, not _pathnames_.
 * For AT&T file systems, the usual value is 14.
 * For Berzerkley file systems, use something big like 255.
 */

#ifdef BSD
#define MAX_NAMESIZE    255
#else
#define MAX_NAMESIZE    14
#endif

/*----------------------------------------------------------------------
 * How to get the host name.
 * Define one.
 *
 * HOSTFILE             file containing name    (Xenix)
 * UNAME                uname()                 (System V)
 * GETHOSTNAME          gethostname()           (BSD)
 * HOSTNAME             host name string        (V7)
 */

#ifdef M_XENIX
#define HOSTFILE   "/etc/systemid"
#else
#ifdef USG
#define UNAME
#else
#ifdef BSD
#define GETHOSTNAME
#else
#define HOSTNAME   "mxd120"
#endif
#endif
#endif

/*----------------------------------------------------------------------
 * Is <varargs.h> or <stdarg.h> available?
 */

#if __STDC__
#define HAS_STDARG
#else
#ifdef USG
#define HAS_VARARGS
#else
#ifdef BSD
#define HAS_VARARGS
#endif
#endif
#endif

/*----------------------------------------------------------------------
 * Are vprintf() and friends available?
 */

#ifdef USG
#define HAS_VPRINTF
#endif

/*----------------------------------------------------------------------
 * Is putenv() available?
 */

#ifdef USG
#define HAS_PUTENV
#endif

/*----------------------------------------------------------------------
 * Is getopt() available?
 */

#ifdef USG
#define HAS_GETOPT
#endif

/*----------------------------------------------------------------------
 * UUCP configuration.
 *
 * UUCP_NAMESIZE        Maximum size of a UUCP system name.
 * UUX_OPTS             Options for uux; "-r" means queue but don't call.
 * UUX_ARGCOUNT         Maximum count of arguments for uux.
 * UUX_ARGSIZE          Maximum total size of arguments for uux.
 */

#define UUCP_NAMESIZE 16
#define UUX_OPTS      "-r"
#define UUX_ARGCOUNT  16
#define UUX_ARGSIZE   512

/*----------------------------------------------------------------------
 * Default shell for executing delivery files and pipes.
 * (Now that Deliver recognizes the "#!" hack, this value is less
 * important than it used to be.)
 * Note that the default shell must support the "-c" option.
 */

#define SHELL   "/bin/sh"

/*----------------------------------------------------------------------
 * Safe directories for child processes' PATH variables.
 * Note that including "." is a security hole.
 * For the superuser, "/etc:" is automatically prepended.
 */

#ifdef BSD
#define SAFEPATH  "/bin:/usr/ucb:/usr/bin"
#else
#define SAFEPATH  "/bin:/sbin:/usr/sbin:/usr/bin"
#endif

/*----------------------------------------------------------------------
 * File creation mask.
 * Bits turned on here are turned off in newly created files.
 * This mask is the default when executing delivery files,
 * but mailboxes have their own mode value (MBX_MODE).
 */

#define UMASK   022

/*----------------------------------------------------------------------
 * Recursion limit.
 * If Deliver detects recursion deeper than this value,
 * it will assume infinite recursion and abort.
 */

#define REC_LIMIT  8

/*----------------------------------------------------------------------
 * Characters that may not appear in addresses.
 * (This string should include all metacharacters for your chosen shell.)
 */

#define SANITIZE   "$*?=\\`'\"|^&;{}()<> \t\n"

/*----------------------------------------------------------------------
 * Standard mailbox location.
 *
 * Define either MBX_NAME or MBOX_DIR.
 * If MBX_NAME is defined, then the default mailbox is a file with
 * that name in the user's home directory.
 * If MBX_DIR is defined, then the default mailbox is a file in that
 * directory with the same name as the user.
 *
 * Define MBX_GROUP if all mailboxes must be owned by a specific group.
 * (System V requires this feature.)  If MBX_GROUP is not defined,
 * mailboxes will have their groups set to the recipients' default group.
 *
 * Define MBX_MODE to the file access modes for new mailboxes.
 * (System V requires group write permissions, i.e. 0020.)
 *
 * Define MBX_UNDEL to the mailbox for undelivered mail.
 */

#if defined(USG) && !defined(M_XENIX)
/* #define MBX_NAME   "mbox" */
#define MBX_DIR     "/var/spool/mail"
#define MBX_MODE    0660
#define MBX_GROUP   "mail"
#else
/* #define MBX_NAME   "mbox" */
#define MBX_DIR     "/var/spool/mail"
#define MBX_MODE    0600
#endif

#undef MBX_DIR
#undef MBX_MODE
#undef MBX_GROUP
#define MBX_DIR     "/var/spool/mail"
#define MBX_MODE    0660
#define MBX_GROUP   "mail"

#define MBX_UNDEL     "Undel.mail"

/*----------------------------------------------------------------------
 * Delivery file directives.
 * When delivery files output these strings as "user names", they
 * are considered instructions.
 */

#define DFILE_DROP    "DROP"            /* Drop this message    */

/*----------------------------------------------------------------------
 * Names of delivery files.
 *
 * SYS_DELIVER          system-wide delivery file
 * POST_DELIVER         post-user delivery file
 * ERR_DELIVER          error delivery file
 * USER_DELIVER         user delivery file (in user's home directory)
 */

#define SYS_DELIVER     "/var/deliver/deliver.sys"
#define POST_DELIVER    "/var/deliver/deliver.post"
#define ERR_DELIVER     "/var/deliver/deliver.err"
#define USER_DELIVER    ".deliver"

/*----------------------------------------------------------------------
 * Log file names.
 * Errors and warnings are output to stderr and to this file.
 * To disable logging, don't define LOG.
 * To disable error logging, don't define ERRLOG.
 * Define LOGLOCK to be the temp file controlling access to log files.
 */

#define LOG             "/var/adm/deliver.log"
#define ERRLOG          "/var/adm/deliver.errlog"
#define LOGLOCK         "/tmp/dl.loglock"

/*----------------------------------------------------------------------
 * Environment variables passed to child processes.
 */

#define ENV_DPID        "DELPID"        /* Deliver process id           */
#define ENV_DLEVEL      "DELLEVEL"      /* Level of recursion           */
#define ENV_DFLAGS      "DELFLAGS"      /* Flags: [-[Avdt]]             */

#define ENV_SYSDEL      "SYSDELFILE"    /* System delivery file         */
#define ENV_POSTDEL     "POSTDELFILE"   /* Post-user delivery file      */
#define ENV_ERRDEL      "ERRDELFILE"    /* Error delivery file          */
#define ENV_USERDEL     "USERDELFILE"   /* User delivery file           */

#define ENV_HOSTNAME    "HOSTNAME"      /* Name of this host            */
#define ENV_SENDER      "SENDER"        /* Message sender               */
#define ENV_HEADER      "HEADER"        /* Message header file          */
#define ENV_BODY        "BODY"          /* Message body file            */
