------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              S E M _ C H 3                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.44 $                             --
--                                                                          --
--        Copyright (C) 1992,1993,1994 Free Software Foundation, Inc.       --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

with Nlists; use Nlists;
with Types;  use Types;

package Sem_Ch3  is
   procedure Analyze_Component_Declaration              (N : Node_Id);
   procedure Analyze_Implicit_Types                     (N : Node_Id);
   procedure Analyze_Number_Declaration                 (N : Node_Id);
   procedure Analyze_Incomplete_Type_Decl               (N : Node_Id);
   procedure Analyze_Object_Declaration                 (N : Node_Id);
   procedure Analyze_Others_Choice                      (N : Node_Id);
   procedure Analyze_Subtype_Declaration                (N : Node_Id);
   procedure Analyze_Subtype_Indication                 (N : Node_Id);
   procedure Analyze_Type_Declaration                   (N : Node_Id);
   procedure Analyze_Variant_Part                       (N : Node_Id);
   procedure Analyze_Private_Extension_Declaration      (N : Node_Id);

   function Access_Definition (
     Related_Nod : Node_Id;
     N           : Node_Id)
     return        Entity_Id;
   --  An access definition defines a general access type for a formal
   --  parameter.  The procedure is called when processing formals, when
   --  the current scope is the subprogram. The Implicit type is attached
   --  to the Related_Nod put into the enclosing scope, so that the only
   --  entities defined in the spec are the formals themselves.

   procedure Access_Subprogram_Declaration
     (T_Name : Entity_Id;
      T_Def  : Node_Id);
   --  The subprogram specification yields the signature of an implicit
   --  type, whose Ekind is Access_Subprogram_Type. This implicit type is
   --  the designated type of the declared access type. In subprogram calls,
   --  the signature of the implicit type works like the profile of a regular
   --  subprogram.

   procedure Analyze_Declarations (L : List_Id);
   --  Called to analyze a list of declarations (in what context ???). Also
   --  performs necessary freezing actions (more description needed ???)

   procedure Analyze_Default_Expression (N : Node_Id; T : Entity_Id);
   --  Default expressions do not freeze their components, and must be
   --  analyzed and resolved accordingly, by setting the global flag
   --  In_Default_Expression.

   procedure Array_Type_Declaration (T : in out Entity_Id; Def : Node_Id);
   --  Process an array type declaration. If the array is constrained, we
   --  create an implicit parent array type, with the same index types and
   --  component type.

   procedure Access_Type_Declaration (T : Entity_Id; Def : Node_Id);
   --  Process an access type declaration

   procedure Check_Abstract_Overriding (T : Entity_Id);
   --  Check that all abstract subprograms inherited from T's parent type
   --  have been overridden as required, and that nonabstract subprograms
   --  have not been incorrectly overridden with an abstract subprogram.

   procedure Check_Completion (Body_Id : Node_Id := Empty);
   --  At the end of a declarative part,  verify that all entities that
   --  require completion have received one. If Body_Id is absent, the
   --  error indicating a missing completion is placed on  the declaration
   --  that needs completion. If Body_Id is present,  it is the defining
   --  identifier of a package body, and errors are posted on that node,
   --  rather than on the declarations that require completion in the package
   --  declaration.

   function Collect_Primitive_Operations (T : Entity_Id) return Elist_Id;
   --  Called upon type derivation and extension. We scan the declarative
   --  part in  which the type appears, and collect subprograms that have
   --  one subsidiary subtype of the type. These subprograms can only
   --  appear after the type itself.

   procedure Determine_Enum_Representation (T : Entity_Id);
   --  Determine the size in bits necessary to store enumeration literals
   --  of type T. The sizes are rounded to 8, 16, 32 or 64 bit quantites.
   --  The determination is based on the representation of the last literal,
   --  and the resulting size is stored in the Esize field of T.

   function Expand_To_Girder_Constraint
     (Typ        : Entity_Id;
      Constraint : Elist_Id)
      return       Elist_Id;
   --  Given a constraint on the specified discriminants of Typ, expand it
   --  into a constraint on the girder discriminants.

   function Find_Type_Name (N : Node_Id) return Entity_Id;
   --  Enter the identifier in a type definition, or find the entity already
   --  declared, in the case of the full declaration of an incomplete or
   --  private type.

   function Get_Discriminant_Value
     (Discriminant         : Entity_Id;
      Typ_For_Constraint   : Entity_Id;
      Constraint           : Elist_Id)
      return                 Node_Id;
   --  Given a discriminant somewhere in the Typ_For_Constraint tree
   --  and a Constraint, return the value of that discriminant.

   function Is_Visible_Component (C : Entity_Id) return Boolean;
   --  Determines if a component is visible in the present context.
   --  it may be a component inherited from a private extension which
   --  is not visible at this moment.

   procedure Make_Index
     (I            : Node_Id;
      Related_Nod  : Node_Id;
      Related_Id   : Entity_Id := Empty;
      Suffix_Index : Nat := 1);
   --  Process an index that is given in an array declaration, an entry
   --  family declaration or a loop iteration. The index is given by an
   --  index declaration (a 'box'), or by a discrete range. The later can
   --  be the name of a discrete type, or a subtype indication.
   --  Related_Nod is the node where the potential generated implicit types
   --  will be inserted. The 2 last parameters are used for creating the name.

   procedure Make_Class_Wide_Type (T : Entity_Id);
   --  A Class_Wide_Type is created for each tagged type definition. The
   --  attributes of a class wide type are inherited from those of the type
   --  T. If T is introduced by a private declaration, the corresponding
   --  class wide type is created at the same time, and therefore there is
   --  a private and a full declaration for the class wide type type as well.

   procedure Process_Range_Expr_In_Decl
     (R           : Node_Id;
      T           : Entity_Id;
      Related_Nod : Node_Id;
      Check_List  : List_Id := Empty_List;
      R_Check_Off : Boolean := False);
   --  Process a range expression that appears in a declaration context. The
   --  range is analyzed and resolved with the base type of the given type,
   --  and an appropriate check for expressions in non-static contexts made
   --  on the bounds. R is analyzed and resolved using T, so the caller should
   --  if necessary link R into the tree before the call, and in particular in
   --  the case of a subtype declaration, it is appropriate to set the parent
   --  pointer of R so that the types get properly frozen. The Check_List
   --  parameter is used when the subprogram is called from
   --  Build_Record_Init_Proc and is used to return a set of constraint
   --  checking statements generated by the Checks package. R_Check_Off is
   --  set to True when the call to Range_Check is to be skipped.

   function Process_Subtype
     (S           : Node_Id;
      Related_Nod : Node_Id;
      Related_Id  : Entity_Id := Empty;
      Suffix      : Character := ' ')
      return        Entity_Id;
   --  Process a subtype indication and return corresponding entity.
   --  Related_Nod is the node where the potential generated implicit types
   --  will be inserted. The Related_Id and Suffix parameters are used to
   --  build the associated Implicit type name.

   procedure Process_Discriminants (N : Node_Id);
   --  Process discriminants of a type with discriminants

   procedure Set_Girder_Constraint_From_Discriminant_Constraint
     (E : Entity_Id);
   --  Expand the Discriminant_Constraint into the
   --  Girder_Constraint

end Sem_Ch3;
