#include <stdio.h>
#include <stdarg.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/***************************************************************************
 *
 * Function:    fprintf
 *
 * Description:
 *     Formatted print data to the stream
 *
 * Input:
 *     stream   - pointer to the output stream
 *     format   - pointer to the format string
 *     ep       - pointer to the output strings
 *
 * Result:
 *     The number of characters written to the output.
 */

int fprintf (FILE *fpStream, const char *pszFormat, ...)
    {
    va_list vaArg;
    int     fBuffering;
    int     nAnswer;
    FUNC_ENTRY ("fprintf");
/*
 *  Ensure that the file is fully buffered and edit the output stream.
 */
    fBuffering = _stbuf (fpStream);
/*
 *  Output the stream
 */
    va_start (vaArg, pszFormat);
    nAnswer = _doprnt (pszFormat, vaArg, fpStream);
    va_end (vaArg);
/*
 *  Restore the buffering state and return the number of characters
 *  written to the output file.
 */
    _ftbuf (fBuffering, fpStream);
    FUNC_EXIT ("fprintf");
    return(nAnswer);
    }
