#ifndef _OUTPUT_H
#define _OUTPUT_H

/* ANSI specification states that the printf() routine must be able to
   format a string of a minimum of 509 characters. Assuming that the
   string is simply "%509.509d", this must work. The use of alloc() would
   probably be a better solution to the variable buffer size. If someone
   can write the _doprnt code to use alloc() then it would help.          */

#define DEFAULT		 -1	 /* Value not specified condition	  */
#define MAXDIGITS	 56      /* Maximum number of digits to edit      */
#define SIZE		465	 /* Additional space for editing routines */
#define CVTMAX	(MAXDIGITS+SIZE) /* Total space for editing routines	  */
#define EDITMAX (CVTMAX-5)       /* Maximum number of decimals to use     */

typedef struct
    {
    int           size;
    int           decimals;
    unsigned short use_space   : 1;
    unsigned short right_just  : 1;
    unsigned short sign        : 1;
    unsigned short pad         : 1;
    unsigned short alt_form    : 1;
    unsigned short is_num      : 1;
    unsigned short is_long     : 1;
    char          type;
    } DESCRIPTOR;

#endif
