/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.util.Vector;
import sun.rmi.transport.Connection;
import sun.rmi.transport.RMIThread;
import sun.rmi.transport.tcp.TCPTransport;

class ConnectionAcceptor
implements Runnable {
    private TCPTransport transport;
    private Vector queue = new Vector(4);
    private static int threadNum;

    public ConnectionAcceptor(TCPTransport tCPTransport) {
        this.transport = tCPTransport;
    }

    public void startNewAcceptor() {
        Thread thread = RMIThread.newThread(this, "Multiplex Accept-" + ++threadNum, true);
        thread.start();
    }

    public void accept(Connection connection) {
        Vector vector = this.queue;
        synchronized (vector) {
            this.queue.addElement(connection);
            this.queue.notify();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection connection;
        Vector vector = this.queue;
        synchronized (vector) {
            while (true) {
                if (this.queue.size() != 0) {
                    this.startNewAcceptor();
                    connection = (Connection)this.queue.elementAt(0);
                    this.queue.removeElementAt(0);
                    break;
                }
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.transport.handleMessages(connection, true);
    }
}

