/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Graphics;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public abstract class Image
implements Codable {
    public static final int CENTERED = 0;
    public static final int SCALED = 1;
    public static final int TILED = 2;
    public static final String IMAGE_TYPE = "netscape.application.Image";

    public static Image imageNamed(String string) {
        Image image;
        Class<?> clazz;
        String string2 = "";
        int n = string.indexOf(47);
        if (n == -1) {
            n = string.indexOf(92);
        }
        if (n == -1) {
            return null;
        }
        String string3 = string.substring(0, n);
        try {
            string2 = "netscape.application." + string3;
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        if (clazz == null) {
            try {
                string2 = string3;
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
        }
        if (clazz == null) {
            return null;
        }
        try {
            image = (Image)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new InconsistencyException("Unable to instantiate class \"" + string2 + "\" -- " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InconsistencyException("Illegal access to class \"" + string2 + "\" -- " + illegalAccessException.getMessage());
        }
        return image.imageWithName(string.substring(n + 1));
    }

    public abstract int width();

    public abstract int height();

    public abstract void drawAt(Graphics var1, int var2, int var3);

    public void drawScaled(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawCentered(graphics, n, n2, n3, n4);
    }

    public String name() {
        return null;
    }

    public void drawCentered(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawAt(graphics, n + (n3 - this.width()) / 2, n2 + (n4 - this.height()) / 2);
    }

    public void drawCentered(Graphics graphics, Rect rect) {
        if (rect == null) {
            return;
        }
        this.drawCentered(graphics, rect.x, rect.y, rect.width, rect.height);
    }

    public void drawScaled(Graphics graphics, Rect rect) {
        if (rect == null) {
            return;
        }
        this.drawScaled(graphics, rect.x, rect.y, rect.width, rect.height);
    }

    public void drawTiled(Graphics graphics, int n, int n2, int n3, int n4) {
        Rect rect = graphics.clipRect();
        int n5 = this.width();
        int n6 = this.height();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        graphics.pushState();
        graphics.setClipRect(new Rect(n, n2, n3, n4));
        int n7 = n > rect.x ? n : n + n5 * ((rect.x - n) / n5);
        int n8 = n + n3 < rect.maxX() ? n + n3 : rect.maxX();
        int n9 = n2 > rect.y ? n2 : n2 + n6 * ((rect.y - n2) / n6);
        int n10 = n2 + n4 < rect.maxY() ? n2 + n4 : rect.maxY();
        n = n7;
        while (n < n8) {
            n2 = n9;
            while (n2 < n10) {
                this.drawAt(graphics, n, n2);
                n2 += n6;
            }
            n += n5;
        }
        graphics.popState();
    }

    public void drawTiled(Graphics graphics, Rect rect) {
        if (rect == null) {
            return;
        }
        this.drawTiled(graphics, rect.x, rect.y, rect.width, rect.height);
    }

    public void drawWithStyle(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 0: {
                this.drawCentered(graphics, n, n2, n3, n4);
                return;
            }
            case 1: {
                this.drawScaled(graphics, n, n2, n3, n4);
                return;
            }
            case 2: {
                this.drawTiled(graphics, n, n2, n3, n4);
                return;
            }
        }
        throw new InconsistencyException("Unknown style: " + n5);
    }

    public void drawWithStyle(Graphics graphics, Rect rect, int n) {
        this.drawWithStyle(graphics, rect.x, rect.y, rect.width, rect.height, n);
    }

    public Image imageWithName(String string) {
        return null;
    }

    public boolean isTransparent() {
        return true;
    }

    public void describeClassInfo(ClassInfo classInfo) {
    }

    public void encode(Encoder encoder) throws CodingException {
    }

    public void decode(Decoder decoder) throws CodingException {
    }

    public void finishDecoding() throws CodingException {
    }
}

