#ifndef _state_h_
#define _state_h_

/*
 * asapm is the APM (Advanced Power Management) monitor utility for X Windows
 * Copyright (c) 1998  Albert Dorofeev <Albert@mail.dma.be>
 * For the updates see http://bewoner.dma.be/Albert/linux/
 * 
 * This software is distributed under GPL. For details see LICENSE file.
 */


/* file -> APM device */
#if defined(__FreeBSD__)
#define APM_PROC "/dev/apm"
#else
#define APM_PROC "/proc/apm"
#endif

/*
 * The AC on-line / off-line status
 */
#define AC_BATTERY      0x00
#define AC_ONLINE       0x01
#define AC_BACKUP       0x02
#define AC_UNKNOWN      0x03

/*
 * The battery status
 */
#define BATTERY_HIGH            0x00
#define BATTERY_LOW             0x01
#define BATTERY_CRITICAL        0x02
#define BATTERY_CHARGING        0x03
#define BATTERY_UNKNOWN         0xff

/*
 * The flags to indicate what changed in the APM state
 */
#define CHANGE_AC_ON		0x01
#define CHANGE_AC_OFF		0x02
#define CHANGE_POWER_DOWN	0x04
#define CHANGE_POWER_UP		0x08

struct apm_state {
	/* information that can be gathered from APM daemon */
	char driver_version[10];
	char apm_bios_info_version[10];
	unsigned int apm_bios_info_flags;
	unsigned int ac_line_status;
	unsigned int battery_status;
	unsigned int battery_flag;
	int time_left;
	int percent;
	int time_estimate;

	/* state variables */
	int system_levels;
	int system_time;
	long int apm_interval; /* interval to check the APM status */
	long int x11_interval; /* interval to check for X11 events */

	/* "Something has changed - need redraw" indicator */
	int update;
	/* Flags to indicate the kind of change in APM state */
	unsigned int flags;
	/* Irrecoverable error flag */
	int error;
	int fail;
	/* The screen color depth in bpp */
	int color_depth;
};

#endif

