/*
 * Copyright (c) 1990,1995 Regents of The University of Michigan.
 * All Rights Reserved. See COPYRIGHT.
 */

/*
 * PostScript Accounting, psa.
 *
 * psa is invoked by psf, as output for a communication program.  The
 * communication program is expected to send a small program before and
 * after each job, which causes the page count to be emitted in a well
 * known format.  psa reads its input, looking for page counts and other
 * interesting data.  Any data that it doesn't understand, it emits to
 * stderr, the lpd log file.  Data that it does understand may be written
 * to a status file or logged.  Once all input has been received, psa
 * subtracts the beginning and end page counts, and log an accounting
 * record in the accounting file.
 */

#include <stdio.h>

main( ac, av )
    int		ac;
    char	**av;
{
    FILE	*af;
    char	*acc, *user, *host;
    char	buf[ 2 ][ 1024 ], *p, *end;
    int		cc[ 2 ], n = 0, ipc, fpc;

    if ( ac != 4 ) {
	fprintf( stderr, "Usage:\t%s accounting-file user host\n", av[ 0 ] );
	exit( 2 );
    }

    acc = av[ 1 ];
    user = av[ 2 ];
    host = av[ 3 ];

    if (( cc[ n ] = read( 0, buf[ n ], sizeof( buf[ n ] ))) < 0 ) {
	perror( "read" );
	exit( 2 );
    }
    if ( cc[ n ] == 0 ) {
	fprintf( stderr, "Premature EOF!\n" );
	exit( 2 );
    }

    p = buf[ n ];
    if ( *p != '*' ) {
	fprintf( stderr, "Bad format!\n" );
	exit( 2 );
    }

    /* find initial pagecount */
    for ( end = buf[ n ] + cc[ n ]; p < end; p++ ) {
	if ( *p == '\n' || *p == '\r' ) {
	    break;
	}
    }
    if ( p == end ) {
	fprintf( stderr, "Can't find initial page count!\n" );
	exit( 2 );
    }

    p++;
    ipc = atoi( buf[ n ] + 1 );
    cc[ n ] -= ( p - buf[ n ] );
    if ( cc[ n ] != 0 ) {
	bcopy( p, buf[ n ], cc[ n ] );
    }

    /*
     * Explain n = !n ...  Is there no beauty in truth?
     */
    n = !n;
    while (( cc[ n ] = read( 0, buf[ n ], sizeof( buf[ n ] ))) > 0 ) {
	if ( cc[ !n ] != 0 && write( 2, buf[ !n ], cc[ !n ] ) != cc[ !n ] ) {
	    fprintf( stderr, "write 1: 2 %X %d\n", buf[ !n ], cc[ !n ] );
	    perror( "write" );
	    exit( 2 );
	}
	n = !n;
    }
    if ( cc[ n ] < 0 ) {
	perror( "read" );
	exit( 2 );
    }

    /* find final pagecount */
    n = !n;
    for ( p = buf[ n ] + cc[ n ] - 1; p >= buf[ n ]; p-- ) {
	if ( *p != '\n' && *p != '\r' ) {
	    break;
	}
    }
    if ( p < buf[ n ] ) {
	fprintf( stderr, "Can't find final page count!\n" );
	exit( 2 );
    }

    for ( ; p >= buf[ n ]; p-- ) {
	if ( *p == '\n' || *p == '\r' ) {
	    break;
	}
    }

    if ( p < buf[ n ] ) {
	p = buf[ n ];
    } else {
	cc[ n ] = p - buf[ n ];
	p++;

	if ( cc[ n ] != 0 && write( 2, buf[ n ], cc[ n ] ) != cc[ n ] ) {
	    fprintf( stderr, "write 2: 2 %X %d\n", buf[ n ], cc[ n ] );
	    perror( "write" );
	    exit( 2 );
	}
    }

    if ( *p != '*' ) {
	fprintf( stderr, "Bad format!\n" );
	exit( 2 );
    }
    fpc = atoi( p + 1 );

    /*
     * Write accounting record.
     */
    if (( af = fopen( acc, "a" )) != NULL ) {
	fprintf( af, "%7.2f\t%s:%s\n", (float)( fpc - ipc ), host, user );
    } else {
	perror( acc );
	exit( 2 );
    }

    exit( 0 );
}
