/**
 *
 * $Id: RedirectStdErr.c,v 1.1 1998/06/03 21:55:05 rwscott Exp $
 *
 * Copyright (C) 1996 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Extension Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#include <unistd.h>

#include <Xm/MessageB.h>
#include <Xm/Text.h>

static const char rcsid[] = "$Id: RedirectStdErr.c,v 1.1 1998/06/03 21:55:05 rwscott Exp $";

void debug();

/* ******************** */

static Widget CreateDialog(Widget Parent)
{
Widget Text = NULL;
Widget Shell = Parent;
Widget StdErrShell;
Arg args[2];
int n = 0;

	while (XtParent(Shell) && !XtIsTopLevelShell(Shell)) Shell = XtParent(Shell);
	StdErrShell = XmCreateMessageDialog(Shell,"StdErrShell",NULL,0);
	XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNeditable, False); n++;
	Text = XmCreateScrolledText(StdErrShell,"StdErrText",args,n);
	XtManageChild(Text);
	return(Text);
}

/* ******************** */

static void StdErrInput(Widget Parent, int *Fd, XtInputId *Id)
{
static char data[1024];
static Widget Text = NULL;
int n;

	if (Text == NULL)
	{
		Text = CreateDialog(Parent);
	}
	XtManageChild(XtParent(XtParent(Text)));
	n = read(*Fd,&data[0],sizeof(data) - 1);
	data[n] = '\0';
	/*
	printf("%lu %s",XmTextGetLastPosition(Text),data);
	*/
	XmTextInsert(Text,XmTextGetLastPosition(Text),data);
	XmTextSetInsertionPosition(Text,XmTextGetLastPosition(Text));
	
	/*
	printf("%s",data);
	*/
}

/* ******************** */

void XltRedirectStdErr(Widget Parent)
{
int NewStdErr[2];

	pipe(NewStdErr);
	XtAppAddInput(XtWidgetToApplicationContext(Parent),
		NewStdErr[0],
		(caddr_t)XtInputReadMask,
		(XtInputCallbackProc)StdErrInput,
		(caddr_t)Parent);
	dup2(NewStdErr[1],2);
	close(NewStdErr[1]);
}

