/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.server.LogStream;
import java.rmi.server.RMISocketFactory;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.proxy.RMISocketInfo;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.rmi.transport.tcp.TCPTransport;

public class TCPConnection
implements Connection {
    private Socket socket;
    private Channel channel;
    private InputStream in;
    private OutputStream out;
    private long expiration = Long.MAX_VALUE;

    public TCPConnection(TCPChannel tCPChannel, InputStream inputStream, OutputStream outputStream) {
        this.socket = null;
        this.channel = tCPChannel;
        this.in = inputStream;
        this.out = outputStream;
    }

    public TCPConnection(Channel channel, TCPEndpoint tCPEndpoint) throws RemoteException {
        this.channel = channel;
        RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
        if (rMISocketFactory == null) {
            rMISocketFactory = TCPTransport.defaultSocketFactory;
        }
        try {
            this.socket = rMISocketFactory.createSocket(tCPEndpoint.getHost(), tCPEndpoint.getPort());
        }
        catch (java.net.UnknownHostException unknownHostException) {
            throw new UnknownHostException("Unknown host: " + tCPEndpoint, unknownHostException);
        }
        catch (ConnectException connectException) {
            throw new java.rmi.ConnectException("Connection refused to host: " + tCPEndpoint, connectException);
        }
        catch (IOException iOException) {
            throw new ConnectIOException("Error creating connection to: " + tCPEndpoint, iOException);
        }
        try {
            this.socket.setTcpNoDelay(true);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public TCPConnection(TCPChannel tCPChannel, Socket socket) {
        this.socket = socket;
        this.channel = tCPChannel;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
        }
        return this.out;
    }

    public void releaseOutputStream() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = this.socket.getInputStream();
        }
        return this.in;
    }

    public void releaseInputStream() {
    }

    public boolean isReusable() {
        if (this.socket != null && this.socket instanceof RMISocketInfo) {
            return ((RMISocketInfo)((Object)this.socket)).isReusable();
        }
        return true;
    }

    void setExpiration(long l) {
        this.expiration = l;
    }

    boolean expired(long l) {
        return this.expiration <= l;
    }

    public void close() throws IOException {
        if (TCPTransport.logLevel >= 10) {
            LogStream.log("tcp").println("TCPConnection.close: close connection");
        }
        if (this.socket != null) {
            this.socket.close();
            return;
        }
        this.in.close();
        this.out.close();
    }

    public Channel getChannel() {
        return this.channel;
    }
}

