/*****************************************************************************/
/* Enlightenment - The Window Manager that dares to do what others don't     */
/*****************************************************************************/
/* Copyright (C) 1997 - 1999 Carsten Haitzler (The Rasterman)                */
/*                                                                           */
/* This program and utilites is free software; you can redistribute it       */
/* and/or modify it under the terms of the License shown in COPYING          */
/*                                                                           */
/* This software is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                      */
/*****************************************************************************/

#include "../econfig.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xlocale.h>
#include <X11/cursorfont.h>
#include <X11/extensions/shape.h>
/*#include <X11/extensions/XTest.h> */
#include <X11/extensions/XShm.h>
#include <Imlib.h>
#include <Fnlib.h>
/* sgi's stdio.h has:
 * 
 * #if _SGIAPI && _NO_ANSIMODE
 * extern int      vsnprintf(char *, ssize_t, const char *, char *);
 * #endif
 * 
 * so workaround...
 */
#ifdef __sgi
#ifdef _NO_ANSIMODE
#undef _NO_ANSIMODE
#endif
#endif
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <string.h>
#include <fcntl.h>
#include <dirent.h>
#include <signal.h>
#include <time.h>
#include <math.h>
#include <pwd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/resource.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <freetype.h>
#include "econfig.h"

#define RESET_ALERT \
  AssignTitleText("Enlightenment Message Dialog"); \
  AssignIgnoreText("Ignore this message"); \
  AssignRestartText("Restart the Window Manager"); \
  AssignExitText("Quit the Window Manager");

#define ASSIGN_ALERT(a, b, c, d) \
  AssignTitleText(a); \
  AssignIgnoreText(b); \
  AssignRestartText(c); \
  AssignExitText(d);

/************************************************************************/
/* dialog macro convenience funcs                                       */
/************************************************************************/

#define DIALOG_OK(title, text) \
{ \
  Dialog *__d; \
  __d = CreateDialog("DIALOG"); \
  DialogSetTitle(__d, title); \
  DialogSetText(__d, text); \
  DialogAddButton(__d, "OK", NULL, 1); \
  ShowDialog(__d); \
}

#define DIALOG_PARAM_OK(title) \
{ \
  Dialog *__d; \
  __d = CreateDialog("DIALOG"); \
  DialogSetTitle(__d, title);

#define DIALOG_PARAM \
DialogSetParamText(__d,

#define DIALOG_PARAM_END \
  ); \
  DialogAddButton(__d, "OK", NULL, 1); \
  ShowDialog(__d); \
}

/************************************************************************/

#ifndef HAVE_GETCWD
#error "ERROR: Enlightenment needs a system with getcwd() in it's libs."
#error "You may have to upgrade your Operating system, Distribution, base"
#error "system libraries etc. Please see the the instructions for your"
#error "particular Operating System or Distribution"
#endif
#ifndef HAVE_MKDIR
#error "ERROR: Enlightenment needs a system with mkdir() in it's libs."
#error "You may have to upgrade your Operating system, Distribution, base"
#error "system libraries etc. Please see the the instructions for your"
#error "particular Operating System or Distribution"
#endif

#ifndef DEFAULT_SH_PATH
#ifdef __sgi
/*
 * It appears that SGI (at least IRIX 6.4) uses ksh as their sh, and it
 * seems to run in restricted mode, so things like restart fail miserably.
 * Let's use csh instead
 * -KDT 07/31/98
 */
#define DEFAULT_SH_PATH "/sbin/csh"
#else
#define DEFAULT_SH_PATH "/bin/sh"
#endif
#endif

/* shut warnings up
 * pid_t               wait3(int *status, int options, struct rusage *rusage);
 * int                 setenv(const char *name, const char *value, int overwrite);
 */

#define FILEPATH_LEN_MAX 4096
/* This turns on E's internal stack tracking system for  coarse debugging */
/* and being able to trace E for profiling/optimisation purposes (which */
/* believe it or not I'm actually doing) */

/* #define DEBUG 1 */

#ifdef DEBUG
extern int          call_level;
extern int          debug_level;
extern char        *call_stack[1024];

#endif
#ifdef DEBUG
#define EDBUG(l,x) \
{ \
  call_stack[call_level] = x; \
  call_level++; \
}
#else
#define EDBUG(l,x)  \
;
#endif

#ifdef DEBUG
#define EDBUG_RETURN(x)  \
{ \
  call_level--; \
  return (x); \
}
#define EDBUG_RETURN_  \
{ \
  call_level--; \
  return; \
}
#else
#define EDBUG_RETURN(x)  \
{ \
  return (x); \
}
#define EDBUG_RETURN_  \
{ \
  return; \
}
#endif

int                 Evsnprintf(char *str, size_t count, const char *fmt, va_list args);

#ifdef HAVE_STDARGS
int                 Esnprintf(char *str, size_t count, const char *fmt,...);

#else
int                 Esnprintf(va_alist);

#endif

#define Esetenv(var, val, overwrite) \
{ \
  static char envvar[FILEPATH_LEN_MAX]; \
  Esnprintf(envvar, FILEPATH_LEN_MAX, "%s=%s", var, val);\
  putenv(envvar);\
}

#ifdef HAVE_LIBESD
#include <esd.h>
#endif

#include "arrange.h"

#define TT_VALID( handle )  ( ( handle ).z != NULL )
#ifndef MAX
#define MAX(a,b)  ((a)>(b)?(a):(b))
#endif

#define IN_RANGE(a, b, range) \
   ((((a) >  (b)) && ((a) - (b) <= (range))) || \
   (((a) <= (b)) && ((b) - (a) <= (range))))

#define IN_ABOVE(a, b, range) \
   (((a) >=  (b)) && ((a) - (b) <= (range)))

#define IN_BELOW(a, b, range) \
   (((a) <= (b)) && ((b) - (a) <= (range)))

#define SPANS_COMMON(x1, w1, x2, w2) \
   (!((((x2) + (w2)) <= (x1)) || ((x2) >= ((x1) + (w1)))))

#define EERR_NONE               0
#define EERR_OUT_OF_MEMORY      1
#define EERR_FILE_NOT_EXIST     2
#define EERR_PERMISSION_DENIED  3
#define EERR_FILING_SYSTEM_FULL 4

#ifndef ENLIGHTENMENT_ROOT
#define ENLIGHTENMENT_ROOT           "/usr/local/enlightenment"
#endif
#define ENLIGHTENMENT_SYSTEM_CONFIG  ENLIGHTENMENT_ROOT"/system_config"
#define ENLIGHTENMENT_SYSTEM_THEMES  ENLIGHTENMENT_ROOT"/themes"
#define ENLIGHTENMENT_SYSTEM_BGS     ENLIGHTENMENT_ROOT"/backgrounds"

#define ENLIGHTENMENT_CONF_NUM_DESKTOPS 32
/* the cast is so -1 will == UINT_MAX */
#define DESKTOPS_WRAP_NUM(x) \
 (((unsigned int) (x)) % mode.numdesktops)

#define LIST_FINDBY_NAME        0
#define LIST_FINDBY_ID          1
#define LIST_FINDBY_BOTH        2
#define LIST_FINDBY_NONE        3
#define LIST_FINDBY_POINTER     4

#define LIST_TYPE_COUNT         28
#define LIST_TYPE_ANY            0
#define LIST_TYPE_CLIENT         1
#define LIST_TYPE_EWIN           2
#define LIST_TYPE_BORDER         3
#define LIST_TYPE_ICLASS         4
#define LIST_TYPE_ACLASS         5
#define LIST_TYPE_AWAIT_ICLASS   6
#define LIST_TYPE_ACLASS_GLOBAL  7
#define LIST_TYPE_ACLASS_DESK    8
#define LIST_TYPE_TCLASS         9
#define LIST_TYPE_BACKGROUND    10
#define LIST_TYPE_BUTTON        11
#define LIST_TYPE_SCLASS        12
#define LIST_TYPE_WINDOWMATCH   13
#define LIST_TYPE_COLORMODIFIER 14
#define LIST_TYPE_ICONIFIEDS    15
#define LIST_TYPE_SLIDEOUT      16
#define LIST_TYPE_DRAW          17
#define LIST_TYPE_TOOLTIP       18
#define LIST_TYPE_CONTAINER     19
#define LIST_TYPE_QUEUE_ENTRY   20
#define LIST_TYPE_MENU          21
#define LIST_TYPE_MENU_STYLE    22
#define LIST_TYPE_ECURSOR       23
#define LIST_TYPE_SNAPSHOT      24
#define LIST_TYPE_DIALOG        25
#define LIST_TYPE_CLONE         26
#define LIST_TYPE_PAGER         27

#define BEVEL_NONE              0
#define BEVEL_AMIGA             1
#define BEVEL_MOTIF             2
#define BEVEL_NEXT              3
#define BEVEL_DOUBLE            4
#define BEVEL_WIDEDOUBLE        5
#define BEVEL_THINPOINT         6
#define BEVEL_THICKPOINT        7

#define EWIN_NORMAL             0
#define EWIN_ACTIVE             1
#define EWIN_STICKY             2
#define EWIN_ICONIFIED          4

#define STATE_NORMAL            0
#define STATE_HILITED           1
#define STATE_CLICKED           2
#define STATE_DISABLED          3

#define FILL_STRETCH            0
#define FILL_TILE               1
#define FILL_INTEGER_TILE       2

#define FLAG_BUTTON             0
#define FLAG_TITLE              1
#define FLAG_MINIICON           2
#define FLAG_FIXED              4
#define FLAG_FIXED_HORIZ        8
#define FLAG_FIXED_VERT         16

#define FOCUS_POINTER           0
#define FOCUS_SLOPPY            1
#define FOCUS_CLICK             2

#define DOCK_LEFT               0
#define DOCK_RIGHT              1
#define DOCK_UP                 2
#define DOCK_DOWN               3

#define ICON_LEFT               0
#define ICON_RIGHT              1
#define ICON_UP                 2
#define ICON_DOWN               3

#define ACTION_NONE                   0
#define ACTION_EXEC                   1
#define ACTION_ALERT                  2
#define ACTION_MOVE	              3
#define ACTION_RESIZE                 4
#define ACTION_RAISE                  5
#define ACTION_LOWER                  6
#define ACTION_EXIT                   7
#define ACTION_CLEANUP                8
#define ACTION_SHOW_MENU              9
#define ACTION_HIDE_MENU              10
#define ACTION_RESIZE_H               11
#define ACTION_RESIZE_V               12
#define ACTION_KILL                   13
#define ACTION_KILL_NASTY             14
#define ACTION_DESKTOP_NEXT           15
#define ACTION_DESKTOP_PREV           16
#define ACTION_DESKTOP_RAISE          17
#define ACTION_DESKTOP_LOWER          18
#define ACTION_DESKTOP_DRAG           19
#define ACTION_STICK                  20
#define ACTION_DESKTOP_INPLACE        21
#define ACTION_DRAG_BUTTON            22
#define ACTION_FOCUSMODE_SET          23
#define ACTION_MOVEMODE_SET           24
#define ACTION_RESIZEMODE_SET         25
#define ACTION_SLIDEMODE_SET          26
#define ACTION_CLEANUPSILDE_SET       27
#define ACTION_MAPSLIDE_SET           28
#define ACTION_SOUND_SET              29
#define ACTION_BUTTONMOVE_RESIST_SET  30
#define ACTION_DESKTOPBG_TIMEOUT_SET  31
#define ACTION_MAPSLIDE_SPEED_SET     32
#define ACTION_CLEANUPSLIDE_SPEED_SET 33
#define ACTION_DRAGDIR_SET            34
#define ACTION_DRAGBAR_ORDER_SET      35
#define ACTION_DRAGBAR_WIDTH_SET      36
#define ACTION_DRAGBAR_LENGTH_SET     37
#define ACTION_DESKSLIDE_SET          38
#define ACTION_DESKSLIDE_SPEED_SET    39
#define ACTION_HIQUALITYBG_SET        40
#define ACTION_PLAYSOUNDCLASS         41
#define ACTION_GOTO_DESK              42
#define ACTION_DESKRAY                43
#define ACTION_AUTOSAVE_SET           44
#define ACTION_HIDESHOW_BUTTON        45
#define ACTION_ICONIFY                46
#define ACTION_SLIDEOUT               47
#define ACTION_SCROLL_WINDOWS         48
#define ACTION_SHADE                  49
#define ACTION_MAX_HEIGHT             50
#define ACTION_MAX_WIDTH              51
#define ACTION_MAX_SIZE               52
#define ACTION_SEND_TO_NEXT_DESK      53
#define ACTION_SEND_TO_PREV_DESK      54
#define ACTION_SNAPSHOT               55
#define ACTION_SCROLL_CONTAINER       56
#define ACTION_TOOLTIP_SET            57
#define ACTION_FOCUS_NEXT             58
#define ACTION_FOCUS_PREV             59
#define ACTION_FOCUS_SET              60
#define ACTION_BACKGROUND_SET         61
#define ACTION_AREA_SET               62
#define ACTION_MOVE_BY                63
#define ACTION_TOGGLE_FIXED           64
#define ACTION_SET_LAYER              65
#define ACTION_WARP_POINTER           66
#define ACTION_MOVE_WINDOW_TO_AREA    67
#define ACTION_MOVE_WINDOW_BY_AREA    68
#define ACTION_SET_WINDOW_BORDER      69
#define ACTION_LINEAR_AREA_SET        70
#define ACTION_LINEAR_MOVE_BY         71
#define ACTION_ABOUT                  72
#define ACTION_FX                     73
#define ACTION_MOVE_WINDOW_TO_LINEAR_AREA 74
#define ACTION_MOVE_WINDOW_BY_LINEAR_AREA 75
/* false number excluding the above list */
#define ACTION_NUMBEROF               76

#define MODE_NONE         0
#define MODE_MOVE         1
#define MODE_RESIZE       2
#define MODE_RESIZE_H     3
#define MODE_RESIZE_V     4
#define MODE_DESKDRAG     5
#define MODE_BUTTONDRAG   6
#define MODE_DESKRAY      7

#define EVENT_MOUSE_DOWN  0
#define EVENT_MOUSE_UP    1
#define EVENT_MOUSE_ENTER 2
#define EVENT_MOUSE_LEAVE 3
#define EVENT_KEY_DOWN    4
#define EVENT_KEY_UP      5
#define EVENT_DOUBLE_DOWN 6

typedef struct _menu Menu;
typedef struct _dialog Dialog;
typedef struct _pager Pager;

typedef struct _actiontype
  {
    void               *params;
    struct _actiontype *Next;
    int                 Type;
  }
ActionType;

typedef struct _list
  {
    char               *name;
    int                 id;
    void               *item;

    struct _list       *next;
  }
List;

typedef struct _client
  {
    char               *name;
    Window              win;
    char               *msg;
    char               *clientname;
    char               *version;
    char               *author;
    char               *email;
    char               *web;
    char               *address;
    char               *info;
    Pixmap              pmap;
  }
Client;

typedef struct _root
  {
    Window              win;
    Visual             *vis;
    int                 depth;
    Colormap            cmap;
    int                 scr;
    int                 w, h;
    Window              focuswin;
  }
Root;

typedef struct _modcurve
  {
    int                 num;
    unsigned char      *px;
    unsigned char      *py;
    unsigned char       map[256];
  }
ModCurve;

typedef struct _colormodifierclass
  {
    char               *name;
    ModCurve            red, green, blue;
  }
ColorModifierClass;

typedef struct _imagestate
  {
    char               *im_file;
    char               *real_file;
    char                unloadable;
    ImlibImage         *im;
    ImlibColor         *transp;
    ImlibBorder        *border;
    int                 pixmapfillstyle;
    ImlibColor          bg, hi, lo, hihi, lolo;
    int                 bevelstyle;
    ColorModifierClass *colmod;
  }
ImageState;

typedef struct _imageclass
  {
    char               *name;
    char                external;
    struct
      {
	ImageState         *normal;
	ImageState         *hilited;
	ImageState         *clicked;
	ImageState         *disabled;
      }
    norm               , active, sticky, sticky_active;
    ImlibBorder         padding;
    ColorModifierClass *colmod;
  }
ImageClass;

typedef struct _efont
  {
    TT_Engine           engine;
    TT_Face             face;
    TT_Instance         instance;
    TT_Face_Properties  properties;
    int                 num_glyph;
    TT_Glyph           *glyphs;
    TT_Raster_Map     **glyphs_cached;
    int                 max_descent;
    int                 max_ascent;
  }
Efont;

typedef struct _textstate
  {
    char               *fontname;
    FnlibStyle          style;
    FnlibFont          *font;
    ImlibColor          fg_col;
    ImlibColor          bg_col;
    int                 effect;
    Efont              *efont;
    XFontStruct        *xfont;
    XFontSet            xfontset;
    int                 xfontset_ascent;
  }
TextState;

typedef struct _textclass
  {
    char               *name;
    struct
      {
	TextState          *normal;
	TextState          *hilited;
	TextState          *clicked;
	TextState          *disabled;
      }
    norm               , active, sticky, sticky_active;
    int                 justification;
  }
TextClass;

typedef struct _action
  {
    char                event;
    char                anymodifier;
    int                 modifiers;
    char                anybutton;
    int                 button;
    char                anykey;
    KeyCode             key;
    char               *key_str;
    ActionType         *action;
  }
Action;

typedef struct _actionclass
  {
    char               *name;
    int                 num;
    Action            **list;
    char               *tooltipstring;
  }
ActionClass;

typedef struct _constraints
  {
    int                 min, max;
  }
Constraints;

typedef struct _winpoint
  {
    int                 originbox;
    struct
      {
	int                 percent;
	int                 absolute;
      }
    x                  , y;
  }
WinPoint;

typedef struct _geometry
  {
    Constraints         width, height;
    WinPoint            topleft, bottomright;
  }
Geometry;

typedef struct _winbutton
  {
    char               *name;
    ImageClass         *iclass;
    ActionClass        *aclass;
    int                 width, height;
  }
WinButton;

typedef struct _winbuttons
  {
    int                 num;
    WinButton          *buttons;
  }
WinButtons;

typedef struct _ecursor
  {
    char               *name;
    ImlibColor          fg, bg;
    char               *file;
    Cursor              cursor;
  }
ECursor;

typedef struct _winpart
  {
    Geometry            geom;
    ImageClass         *iclass;
    ActionClass        *aclass;
    TextClass          *tclass;
    ECursor            *ec;
    struct
      {
	char                is;
	char                expandable;
	char                order;
	char                orientation;
	WinButtons          buttons;
      }
    region;
    char                ontop;
    int                 flags;
    char                keep_for_shade;
  }
WinPart;

typedef struct _border
  {
    char               *name;
    ImlibBorder         border;
    int                 num_winparts;
    WinPart            *part;
    char                changes_shape;
    char                shadedir;
  }
Border;

typedef struct _ewinbit
  {
    Window              win;
    int                 x, y, w, h;
    int                 cx, cy, cw, ch;
    int                 state;
    char                expose;
    char                no_expose;
    char                left;
  }
EWinBit;

typedef struct _winclient
  {
    Window              win;
    char               *title;
    int                 x, y, w, h;
    Colormap            cmap;
    Window              icon_win;
    Pixmap              icon_pmap;
    Pixmap              icon_mask;
    char                start_iconified;
    Window              group;
    Window              client_leader;
    char                need_input;
    char                transient;
    Window              transient_for;
    char               *class;
    char               *name;
    char               *role;
    char               *command;
    char               *machine;
    char               *icon_name;
    char                is_group_leader;
    char                no_resize_h;
    char                no_resize_v;
    char                shaped;
    Constraints         width, height;
    int                 base_w, base_h;
    int                 w_inc, h_inc;
    double              aspect_min, aspect_max;
    char                already_placed;
    char                mwm_decor_border;
    char                mwm_decor_resizeh;
    char                mwm_decor_title;
    char                mwm_decor_menu;
    char                mwm_decor_minimize;
    char                mwm_decor_maximize;
    char                mwm_func_resize;
    char                mwm_func_move;
    char                mwm_func_minimize;
    char                mwm_func_maximize;
    char                mwm_func_close;
    unsigned int        app_state;
  }
WinClient;

typedef struct _ewin
  {
    Window              win;
    int                 x, y, w, h, reqx, reqy;
    int                 lx, ly, lw, lh;
    char                toggle;
    Window              win_container;
    WinClient           client;
    Border             *border;
    char                border_new;
    EWinBit            *bits;
    int                 flags;
    int                 desktop;
    int                 group;
    int                 docked;
    char                sticky;
    char                visible;
    char                iconified;
    char                shaded;
    char                active;
    int                 layer;
    char                never_use_area;
    Window              parent;
    char                floating;
    char                shapedone;
    char                fixedpos;
    int                 expanded_x;
    int                 expanded_y;
    int                 expanded_width;
    int                 expanded_height;
    char                ignorearrange;
    char                skiptask;
    char                skipfocus;
    char                skipwinlist;
    char                focusclick;
    char                internal;
    Menu               *menu;
    Window              shownmenu;
    Dialog             *dialog;
    Pager              *pager;
    int                 area_x;
    int                 area_y;
    char               *session_id;
    int                 has_transients;
    int                 mini_w, mini_h;
    Pixmap              mini_pmap, mini_mask;
  }
EWin;

typedef struct _awaiticlass
  {
    Window              client_win;
    int                 ewin_bit;
    ImageClass         *iclass;
  }
AwaitIclass;

typedef struct _bgeometry
  {
    Constraints         width, height;
    int                 xorigin, yorigin;
    int                 xabs, xrel;
    int                 yabs, yrel;
    int                 xsizerel, xsizeabs;
    int                 ysizerel, ysizeabs;
    char                size_from_image;
  }
BGeometry;

typedef struct _strip Strip;
typedef struct _stripjoint Stripjoint;

typedef struct _button
  {
    char               *name;
    BGeometry           geom;
    ImageClass         *iclass;
    ActionClass        *aclass;
    char                ontop;
    int                 flags;
    char                sticky;
    int                 desktop;
    char                visible;
    char                internal;
    char                default_show;
    char                used;

    Window              win;
    int                 x, y, w, h;
    int                 cx, cy, cw, ch;
    int                 state;
    char                expose;
    Window              inside_win;
    Window              event_win;
    char                destroy_inside_win;
    char                left;
  }
Button;

typedef struct _buttoncontainer
  {
    char               *name;
    ImageClass         *iclass;

    Window              win;
    int                 w, h;
    int                 state;
    char                expose;
    char                orientation;
    Button            **ButtonList;
    int                 numofbuttonsinlist;
  }
Container;

struct _strip
  {
    char               *name;
    int                 xabs, yabs;
    int                 xrel, yrel;
    char                ontop;
    char                sticky;
    int                 desktop;
    char                orientation;
    char                out;
    int                 justification;
    int                 spacing;

    char               *anchor_name;
    char               *bg_name;
    Button             *anchor;
    Button             *bg;

    int                 num_buttons;
    Button             *button;

    Window              win;
    int                 x, y, w, h;
    int                 cx, cy, cw, ch;
  };

typedef struct _background
  {
    char               *name;
    Pixmap              pmap;
    time_t              last_viewed;
    struct _bg
      {
	ImlibColor          solid;
	char               *file;
	char               *real_file;
	ImlibImage         *im;
	char                tile;
	char                keep_aspect;
	int                 xjust, yjust;
	int                 xperc, yperc;
      }
    bg;
    struct _top
      {
	char               *file;
	char               *real_file;
	ImlibImage         *im;
	char                keep_aspect;
	int                 xjust, yjust;
	int                 xperc, yperc;
      }
    top;
    ColorModifierClass *cmclass;
  }
Background;

typedef struct _desk
  {
    char                viewable;
    Window              win;
    int                 x, y;
    Background         *bg;
    int                 num;
    EWin              **list;
    Button             *tag;
    int                 current_area_x;
    int                 current_area_y;
  }
Desk;

typedef struct _desktops
  {
    int                 current;
    Desk                desk[ENLIGHTENMENT_CONF_NUM_DESKTOPS];
    int                 dragdir;
    int                 dragbar_width;
    int                 dragbar_ordering;
    int                 dragbar_length;
    char                slidein;
    int                 slidespeed;
    char                hiqualitybg;
  }
Desktops;

typedef struct _sample
  {
    int                 rate;
    int                 format;
    int                 samples;
    unsigned char      *data;
    int                 id;
  }
Sample;

typedef struct _soundclass
  {
    char               *name;
    char               *file;
    Sample             *sample;
  }
SoundClass;

typedef struct _windowmatch
  {
    char               *name;
    char               *win_title;
    char               *win_name;
    char               *win_class;
    Constraints         width;
    Constraints         height;
    signed char         transient;
    signed char         no_resize_h;
    signed char         no_resize_v;
    signed char         shaped;
    Border             *border;
    ImageClass         *icon;
    int                 desk;
    char                make_sticky;
  }
WindowMatch;

typedef struct
  {
    char               *name;
    char                direction;
    int                 num_buttons;
    Button            **button;
    int                 w, h;
    Window              win;
    Window              from_win;
  }
Slideout;

typedef struct _emode
  {
    int                 mode;
    int                 deskmode;
    char                place;
    char                flipp;
    char                startup;
    int                 next_move_x_plus;
    int                 next_move_y_plus;
    EWin               *ewin;
    Button             *button;
    int                 resize_detail;
    int                 win_x, win_y, win_w, win_h;
    int                 start_x, start_y;
    char                noewin;
    char                have_place_grab;
    int                 focusmode;
    char                dockdirmode;
    char                primaryicondir;
    char                click_focus_grabbed;
    EWin               *focuswin;
    EWin               *realfocuswin;
    EWin               *mouse_over_win;
    EWin               *context_ewin;
    int                 px, py, x, y;
    char                firstlast;
    int                 movemode;
    int                 resizemode;
    int                 slidemode;
    char                cleanupslide;
    char                mapslide;
    int                 slidespeedmap;
    int                 slidespeedcleanup;
    int                 shadespeed;
    char                doingslide;
    int                 server_grabbed;
    int                 desktop_bg_timeout;
    int                 deskdrag;
    char                sound;
    int                 button_move_resistance;
    char                button_move_pending;
    Colormap            current_cmap;
    char                autosave;
    char                memory_paranoia;
    char                destroy;
    char                adestroy;
    Slideout           *slideout;
    Window              context_win;
    char                tooltips;
    double              tiptime;
    char                autoraise;
    double              autoraisetime;
    int                 dockstartx;
    int                 dockstarty;
    char                save_under;
    char                cur_menu_mode;
    int                 cur_menu_depth;
    Menu               *cur_menu[256];
    char                menuslide;
    char                numdesktops;
    char                transientsfollowleader;
    char                switchfortransientmap;
    char                showicons;
    char                snap;
    int                 edge_snap_dist;
    int                 screen_snap_dist;
    Window              menu_cover_win;
    char                all_new_windows_get_focus;
    char                new_transients_get_focus;
    char                new_transients_get_focus_if_group_focused;
    char                transients_follow_leader;
    char                manual_placement;
    char                raise_on_next_focus;
    char                warp_on_next_focus;
    int                 edge_flip_resistance;
    EWin               *moveresize_pending_ewin;
    char                borderpartpress;
    char                windowdestroy;
    int                 context_w;
    int                 context_h;
#ifdef AUTOUPGRADE
    char                autoupgrade;
    char                activenetwork;
    int                 motddate;
    char                motd;
    char                alreadytestingnetwork;
#endif
    char                show_pagers;
  }
EMode;

typedef struct _handlestruct
  {
    void                (*func) (XEvent * ev);
  }
HandleStruct;

typedef struct _IPCstruct
  {
    void                (*func) (char *params, Client * c);
    char               *commandname;
    char               *help_text;
    char               *extended_help_text;
  }
IPCStruct;

typedef struct _drawqueue
  {
    Window              win;
    ImageClass         *iclass;
    int                 w, h, active, sticky, state, expose;
    TextClass          *tclass;
    char               *text;
    char                shape_propagate;
    Pager              *pager;
    Pager              *redraw_pager;
    char                newbg;
  }
DrawQueue;

typedef struct _tooltip
  {
    char               *name;

    ImageClass         *iclass;
    ImageClass         *s_iclass[4];
    TextClass          *tclass;
    int                 dist;
    Window              win;
    Window              iwin;
    Window              s_win[4];
    char                visible;
    ImageClass         *tooltippic;
  }
ToolTip;

typedef struct _qentry
  {
    char               *name;
    double              in_time;
    void                (*func) (int val, void *data);
    struct _qentry     *next;
    int                 runtime_val;
    void               *runtime_data;
    char                just_added;
  }
Qentry;

typedef struct _menustyle
  {
    char               *name;
    TextClass          *tclass;
    ImageClass         *bg_iclass;
    ImageClass         *item_iclass;
    ImageClass         *sub_iclass;
    char                use_item_bg;
    char                iconpos;
    int                 maxx;
    int                 maxy;
    char               *border_name;
  }
MenuStyle;

typedef struct _menuitem
  {
    ImageClass         *icon_iclass;
    char               *text;
    ActionClass        *aclass;
    Menu               *child;
    int                 state;
    Pixmap              pmap[3];
    Pixmap              mask[3];
    Window              win;
    Window              icon_win;
    int                 icon_w;
    int                 icon_h;
    int                 text_w;
    int                 text_h;
    int                 text_x;
    int                 text_y;
  }
MenuItem;

struct _menu
  {
    char               *name;
    char               *title;
    MenuStyle          *style;
    int                 num;
    MenuItem          **items;
    Window              win;
    Pixmap              pmap;
    Pixmap              mask;
    char                stuck;
    Menu               *parent;
    MenuItem           *sel_item;
    time_t              last_change;
    void               *data;
    Menu               *ref_menu;
  };

typedef struct _configtype
  {
    char               *name;
    char               *key;
    char                TypeOfConfig;
    char               *StringValue;
    int                 IntValue;
    int                 NumberOfSubMembers;
    void               *Data;
    struct _configtype **SubMembers;
  }
ConfigType;

typedef struct _progressbar
  {
    char               *name;
    int                 value;
    int                 x;
    int                 y;
    int                 w;
    int                 h;
    Window              win;
    Window              n_win;
    Window              p_win;
    ImageClass         *ic, *inc, *ipc;
    TextClass          *tc, *tnc;
  }
Progressbar;

typedef struct _snapshot
  {
    char               *name;
    char               *win_title;
    char               *win_name;
    char               *win_class;
    char               *border_name;
    char                use_desktop;
    int                 desktop;
    char                use_area;
    int                 area_x, area_y;
    char                use_wh;
    int                 w, h;
    char                use_xy;
    int                 x, y;
    char                use_layer;
    int                 layer;
    char                use_sticky;
    char                sticky;
    char               *iclass_name;
    char                use_shade;
    char                shade;
  }
Snapshot;

typedef struct _dbutton
  {
    char               *text;
    void                (*func) (int val, void *data);
    Window              win;
    int                 x, y, w, h;
    char                hilited;
    char                clicked;
    char                close;
    TextClass          *tclass;
    ImageClass         *iclass;
  }
DButton;

struct _dialog
  {
    char               *name;
    char               *title;
    char               *text;
    int                 num_buttons;

    Window              win;
    DButton           **button;
    TextClass          *tclass;
    ImageClass         *iclass;
    int                 w, h;
  };

typedef struct _PixImg
  {
    XImage             *xim;
    XShmSegmentInfo    *shminfo;
    Pixmap              pmap;
    GC                  gc;
  }
PixImg;

typedef struct _Clone
  {
    char               *name;
    Window              win;
  }
Clone;

struct _pager
  {
    char               *name;
    Window              win;
    Pixmap              pmap;
    Pixmap              bgpmap;
    int                 desktop;
    int                 w, h;
    int                 dw, dh;
    char                visible;
    int                 update_phase;
    EWin               *ewin;
    char               *border_name;
    Window              sel_win;
    char                hi_visible;
    Window              hi_win;
    EWin               *hi_ewin;
  };

void                Efont_extents(Efont * f, char *text,
				  int *font_ascent_return,
				  int *font_descent_return, int *width_return,
				  int *max_ascent_return,
				  int *max_descent_return,
				  int *lbearing_return, int *rbearing_return);
Efont              *Efont_load(char *file, int size);
void                Efont_free(Efont * f);
void                EFont_draw_string(Display * disp, Drawable win, GC gc,
				      int x, int y, char *text,
				      Efont * font, Visual * vis, Colormap cm);

void                ErrAlert(int erno);

void                EDisplayMemUse(void);
int                 EExit(void *code);
void                ShowEdgeWindows(void);
void                HideEdgeWindows(void);
int                 IsEdgeWin(Window win);
void                EdgeHandleEnter(XEvent * ev);
void                EdgeHandleLeave(XEvent * ev);
void                EdgeHanleMotion(XEvent * ev);

void               *FindItem(char *name, int id, int find_by, int type);
void                AddItem(void *item, char *name, int id, int type);
void               *RemoveItem(char *name, int id, int find_by, int type);
void              **ListItemType(int *num, int type);
char              **ListItems(int *num, int type);
void              **ListItemTypeID(int *num, int type, int id);
void              **ListItemTypeName(int *num, int type, char *name);
void                MoveItemToListTop(void *item, int type);

void                SetupInit(void);

void                MapUnmap(int start);
void                SetupSignals(void);
void                SetupX(void);
void                SetupDirs(void);
void                SetupEnv(void);
Window              MakeExtInitWin(void);

void                HandleSigHup(int num);
void                HandleSigInt(int num);
void                HandleSigQuit(int num);
void                HandleSigIll(int num);
void                HandleSigAbrt(int num);
void                HandleSigFpe(int num);
void                HandleSigSegv(int num);
void                HandleSigPipe(int num);
void                HandleSigAlrm(int num);
void                HandleSigTerm(int num);
void                HandleSigUsr1(int num);
void                HandleSigUsr2(int num);
void                HandleSigChild(int num);
void                HandleSigTstp(int num);
void                HandleSigBus(int num);
void                EHandleXError(Display * d, XErrorEvent * ev);
void                HandleXIOError(Display * d);

void                CommsSetup(void);
void                CommsFindCommsWindow(void);
void                CommsSend(Client * c, char *s);
void                CommsSendToMasterWM(char *s);
char               *CommsGet(Client ** c, XEvent * ev);
void                CommsBroadcast(char *s);
void                CommsBroadcastToSlaveWMs(char *s);
Client             *MakeClient(Window win);
void                ListFreeClient(void *ptr);
void                DeleteClient(Client * c);
void                HandleComms(XEvent * ev);
void                DisplayClientInfo(Client * c, int onoff);
void                HideClientInfo(void);

Window              ECreateWindow(Window parent, int x, int y, int w, int h,
				  int saveunder);
Window              ECreateEventWindow(Window parent, int x, int y, int w,
				       int h);
Window              ECreateFocusWindow(Window parent, int x, int y, int w,
				       int h);
void                GrabX(void);
void                UngrabX(void);
void                SetBG(Window win, Pixmap pmap, int color);
void                GetWinXY(Window win, int *x, int *y);
void                GetWinWH(Window win, unsigned int *w, unsigned int *h);
int                 GetWinDepth(Window win);
int                 WinExists(Window win);
Window              WindowAtXY_0(Window base, int bx, int by, int x, int y);
Window              WindowAtXY(int x, int y);
void                PointerAt(int *x, int *y);

void                DebugEvent(XEvent * ev);
void                HandleEvent(XEvent * ev);
void                CheckEvent(void);
void                WaitEvent(void);

void                DetermineEwinFloat(EWin * ewin, int dx, int dy);
void                SetEInfoOnAll(void);
EWin               *GetEwinPointerInClient(void);
EWin               *GetEwin(void);
EWin               *GetFocusEwin(void);
void                SlideEwinTo(EWin * ewin, int fx, int fy, int tx, int ty,
				int speed);
void                AddToFamily(Window win);
EWin               *AddInternalToFamily(Window win, char noshow, char *bname);
void                SetEwinBorder(EWin * ewin);
void                SetEwinToBorder(EWin * ewin, Border * b);
void                HonorIclass(char *s, int id);
void                SyncBorderToEwin(EWin * ewin);
void                UpdateBorderInfo(EWin * ewin);
void                RealiseEwinWinpart(EWin * ewin, int i);
int                 DrawEwinWinpart(EWin * ewin, int i);
int                 ChangeEwinWinpart(EWin * ewin, int i);
void                DrawEwin(EWin * ewin);
int                 ChangeEwinWinpartContents(EWin * ewin, int i);
void                CalcEwinWinpart(EWin * ewin, int i);
void                CalcEwinSizes(EWin * ewin);
EWin               *Adopt(Window win);
EWin               *AdoptInternal(Window win, Border * border);
EWin               *CreateEwin(void);
void                FreeEwin(EWin * ewin);

WindowMatch        *CreateWindowMatch(char *name);
char                TestWindowMatch(EWin * ewin, WindowMatch * b);
Border             *MatchEwinBorder(EWin * ewin, WindowMatch * b);
ImageClass         *MatchEwinIcon(EWin * ewin, WindowMatch * b);
int                 MatchEwinDesktop(EWin * ewin, WindowMatch * b);
void               *MatchEwinByFunction(EWin * ewin,
	       void *              (*FunctionToTest) (EWin *, WindowMatch *));

void                ResizeEwin(EWin * ewin, int w, int h);
void                DetermineEwinArea(EWin * ewin);
void                MoveEwin(EWin * ewin, int x, int y);
void                MoveResizeEwin(EWin * ewin, int x, int y, int w, int h);
void                FloatEwin(EWin * ewin);
void                FloatEwinAt(EWin * ewin, int x, int y);
void                RestackEwin(EWin * ewin);
void                RaiseEwin(EWin * ewin);
void                LowerEwin(EWin * ewin);
void                ShowEwin(EWin * ewin);
void                HideEwin(EWin * ewin);
Border             *CreateBorder(char *name);
void                AddBorderPart(Border * b, ImageClass * iclass,
				  ActionClass * aclass, TextClass * tclass,
				  ECursor * ec,
				  char ontop, int flags, char isregion,
				  int wmin, int wmax, int hmin, int hmax,
				  int torigin, int txp, int txa, int typ,
				  int tya, int borigin, int bxp, int bxa,
				  int byp, int bya, char keep_for_shade);
void                MinShadeSize(EWin * ewin, int *mw, int *mh);
void                InstantShadeEwin(EWin * ewin);
void                InstantUnShadeEwin(EWin * ewin);
void                ShadeEwin(EWin * ewin);
void                UnShadeEwin(EWin * ewin);
void                SetEwinBitGravities(EWin * ewin);

ImageClass         *CreateIclass(void);
ImageState         *CreateImageState(void);
void                ImageStatePopulate(ImageState * is);
void                IclassPopulate(ImageClass * iclass);
void                IclassApply(ImageClass * iclass, Window win, int w, int h,
			      int active, int sticky, int state, char expose);
void                IclassApplyCopy(ImageClass * iclass, Window win, int w,
				    int h, int active, int sticky, int state,
				    Pixmap * pret, Pixmap * mret);

void                HandleDrawQueue(void);
char                IsPropagateEwinOnQueue(EWin * ewin);
void                EFillPixmap(Window win, Pixmap pmap, int x, int y, int w, int h);
void                EPastePixmap(Window win, Pixmap pmap, int x, int y, int w, int h);
void                EBlendRemoveShape(EWin * ewin, Pixmap pmap);
PixImg             *ECreatePixImg(Window win, int w, int h);
void                EDestroyPixImg(PixImg * pi);
void                EBlendPixImg(EWin * ewin, PixImg * s1, PixImg * s2, PixImg * dst, int x, int y, int w, int h);

ImlibImage         *ELoadImage(char *file);
ImlibImage         *ELoadImageImlibData(ImlibData * imd, char *file);
void                DrawEwinShape(EWin * ewin, int md, int x, int y, int w,
				  int h, char firstlast);
void                PropagateShapes(Window win);

void                FlipFocusList(void);
void                RemoveEwinFromFocusList(EWin * ewin);
void                AddEwinToFocusList(EWin * ewin);
void                GetNextFocusEwin(void);
void                GetPrevFocusEwin(void);
void                FixFocus(void);
void                FocusToEWin(EWin * ewin);
void                FocusToNone(void);
void                BeginNewDeskFocus(void);
void                NewDeskFocus(void);

void                ICCCM_GetTitle(EWin * ewin);
void                ICCCM_GetColormap(EWin * ewin);
void                ICCCM_Delete(EWin * ewin);
void                ICCCM_Save(EWin * ewin);
void                ICCCM_Iconify(EWin * ewin);
void                ICCCM_DeIconify(EWin * ewin);
void                ICCCM_MatchSize(EWin * ewin);
void                ICCCM_Configure(EWin * ewin);
void                ICCCM_AdoptStart(EWin * ewin, Window win);
void                ICCCM_Adopt(EWin * ewin, Window win);
void                ICCCM_Cmap(EWin * ewin);
void                ICCCM_Focus(EWin * ewin);
void                ICCCM_GetGeoms(EWin * ewin);
void                ICCCM_GetInfo(EWin * ewin);
void                ICCCM_GetHints(EWin * ewin);
void                ICCCM_GetShapeInfo(EWin * ewin);
void                ICCCM_SetIconSizes(void);
void                ICCCM_SetEInfo(EWin * ewin);
int                 ICCCM_GetEInfo(EWin * ewin);
void                ICCCM_SetMainEInfo(void);
void                ICCCM_GetMainEInfo(void);

void                GrabButtonGrabs(EWin * ewin);
void                UnGrabButtonGrabs(EWin * ewin);
ActionClass        *CreateAclass(char *name);
Action             *CreateAction(char event, char anymod, int mod, int anybut,
				 int but, char anykey, char *key);
void                RemoveActionType(ActionType * ActionTypeToRemove);
void                RemoveAction(Action * ActionToRemove);
void                RemoveActionClass(ActionClass * ActionToRemove);
void                AddToAction(Action * act, int id, void *params);
void                AddAction(ActionClass * a, Action * act);
int                 EventAclass(XEvent * ev, ActionClass * a);
int                 handleAction(ActionType * Action);
int                 spawnMenu(void *params);
int                 hideMenu(void *params);
int                 doNothing(void *params);
int                 execApplication(void *params);
int                 alert(void *params);
int                 doExit(void *params);
int                 doMove(void *params);
int                 doResize(void *params);
int                 doResizeH(void *params);
int                 doResizeV(void *params);
int                 doResizeEnd(void *params);
int                 doMoveEnd(void *params);
int                 doRaise(void *params);
int                 doLower(void *params);
int                 doCleanup(void *params);
int                 doKill(void *params);
int                 doKillNasty(void *params);
int                 doNextDesktop(void *params);
int                 doPrevDesktop(void *params);
int                 doRaiseDesktop(void *params);
int                 doLowerDesktop(void *params);
int                 doDragDesktop(void *params);
int                 doStick(void *params);
int                 doInplaceDesktop(void *params);
int                 doDragButtonStart(void *params);
int                 doDragButtonEnd(void *params);
int                 doFocusModeSet(void *params);
int                 doMoveModeSet(void *params);
int                 doResizeModeSet(void *params);
int                 doSlideModeSet(void *params);
int                 doCleanupSlideSet(void *params);
int                 doMapSlideSet(void *params);
int                 doSoundSet(void *params);
int                 doButtonMoveResistSet(void *params);
int                 doDesktopBgTimeoutSet(void *params);
int                 doMapSlideSpeedSet(void *params);
int                 doCleanupSlideSpeedSet(void *params);
int                 doDragdirSet(void *params);
int                 doDragbarOrderSet(void *params);
int                 doDragbarWidthSet(void *params);
int                 doDragbarLengthSet(void *params);
int                 doDeskSlideSet(void *params);
int                 doDeskSlideSpeedSet(void *params);
int                 doHiQualityBgSet(void *params);
int                 doPlaySoundClass(void *params);
int                 doGotoDesktop(void *params);
int                 doDeskray(void *params);
int                 doAutosaveSet(void *params);
int                 doHideShowButton(void *params);
int                 doIconifyWindow(void *params);
int                 doSlideout(void *params);
int                 doScrollWindows(void *params);
int                 doShade(void *params);
int                 doMaxH(void *params);
int                 doMaxW(void *params);
int                 doMax(void *params);
int                 doSendToNextDesk(void *params);
int                 doSendToPrevDesk(void *params);
int                 doSnapshot(void *params);
int                 doScrollContainer(void *params);
int                 doToolTipSet(void *params);
int                 doFocusNext(void *params);
int                 doFocusPrev(void *params);
int                 doFocusSet(void *params);
int                 doBackgroundSet(void *params);
int                 doAreaSet(void *params);
int                 doAreaMoveBy(void *params);
int                 doToggleFixedPos(void *params);
int                 doSetLayer(void *params);
int                 doWarpPointer(void *params);
int                 doMoveWinToArea(void *params);
int                 doMoveWinByArea(void *params);
int                 doSetWinBorder(void *params);
int                 doLinearAreaSet(void *params);
int                 doLinearAreaMoveBy(void *params);
int                 doAbout(void *params);
int                 doFX(void *params);
int                 doMoveWinToLinearArea(void *params);
int                 doMoveWinByLinearArea(void *params);
int                 initFunctionArray(void);

void                GrabActionKey(Action * a);
void                UnGrabActionKey(Action * a);
void                GrabTheButtons(Window win);
void                GrabThePointer(Window win);
void                UnGrabTheButtons(void);

void                ChangeNumberOfDesktops(int quantity);
void                ShowDesktopControls(void);
void                ShowDesktopTabs(void);
void                HideDesktopTabs(void);
void                MoveToDeskTop(int num);
void                MoveToDeskBottom(int num);
void                SlideWindowTo(Window win, int fx, int fy, int tx, int ty,
				  int speed);
Background         *CreateDesktopBG(char *name, ImlibColor * solid,
				    char *bg, char tile, char keep_aspect,
				    int xjust, int yjust, int xperc, int yperc,
				    char *top, char tkeep_aspect, int txjust,
				    int tyjust, int txperc, int typerc);
void                RefreshCurrentDesktop(void);
void                RefreshDesktop(int num);
void                SetBackgroundTo(ImlibData * imd, Window win, Background * dsk, char setbg);
void                InitDesktopBgs(void);
void                InitDesktopControls(void);
void                SetDesktopBg(int desk, Background * bg);
void                ConformEwinToDesktop(EWin * ewin);
int                 DesktopAt(int x, int y);
void                MoveStickyWindowsToCurrentDesk(void);
void                GotoDesktop(int num);
void                MoveDesktop(int num, int x, int y);
void                RaiseDesktop(int num);
void                LowerDesktop(int num);
void                HideDesktop(int num);
void                ShowDesktop(int num);
void                StackDesktops(void);
void                UncoverDesktop(int num);
void                MoveEwinToDesktop(EWin * ewin, int num);
void                DesktopAddEwinToBottom(EWin * ewin);
void                DesktopAddEwinToTop(EWin * ewin);
void                DesktopRemoveEwin(EWin * ewin);
void                MoveEwinToDesktopAt(EWin * ewin, int num, int x, int y);
void                FloatEwinAboveDesktops(EWin * ewin);
void                DesktopAccounting(void);

int                 AddEToFile(char *file);
int                 CreateEFile(char *file);
void                AddE(void);
void                CreateStartupDisplay(char start);

TextClass          *CreateTclass(void);
TextState          *CreateTextState(void);
void                TclassPopulate(TextClass * tclass);
void                TclassApply(ImageClass * iclass, Window win, int w,
			int h, int active, int sticky, int state, char expose,
				TextClass * tclass, char *text);

void                HandleClientMessage(XEvent * ev);
void                HandleFocusWindowIn(Window win);
void                HandleFocusWindow(Window win);
void                HandleChildShapeChange(XEvent * ev);
void                HandleMotion(XEvent * ev);
void                HandleDestroy(XEvent * ev);
void                HandleProperty(XEvent * ev);
void                HandleCirculate(XEvent * ev);
void                HandleReparent(XEvent * ev);
void                HandleConfigureRequest(XEvent * ev);
void                HandleResizeRequest(XEvent * ev);
void                HandleUnmap(XEvent * ev);
void                HandleMapRequest(XEvent * ev);
void                HandleExpose(XEvent * ev);
void                HandleMouseDown(XEvent * ev);
void                HandleMouseUp(XEvent * ev);
void                HandleMouseIn(XEvent * ev);
void                HandleMouseOut(XEvent * ev);

void                FocusToEWin(EWin * ewin);
EWin               *FindEwinByBase(Window win);
EWin               *FindEwinByChildren(Window win);
EWin               *FindEwinByDecoration(Window win);
Button             *FindButton(Window win);
ActionClass        *FindActionClass(Window win);
Menu               *FindMenuItem(Window win, MenuItem ** mi);
Menu               *FindMenu(Window win);
EWin               *FindEwinByMenu(Menu * m);
EWin              **ListTransientsFor(Window win, int *num);
EWin              **ListGroupMembers(Window win, int *num);
EWin               *FindEwinByDialog(Dialog * d);
Dialog             *FindDialogButton(Window win, int *bnum);
Dialog             *FindDialog(Window win);
EWin               *FindEwinSpawningMenu(Menu * m);
Pager              *FindPager(Window win);

void                MWM_GetHints(EWin * ewin);
void                MWM_SetInfo(void);

Container          *InitializeContainer(char *name, ImageClass * iclass,
				     int width, int height, char orientation);
void                AddButtonToContainer(Container * bc, Button * b);
void                RemoveButtonFromContainer(Container * bc, Button * b);
void                DestroyContainer(Container * bc);
void                RemoveContainer(Container * bc);

Button             *CreateButton(char *name, ImageClass * iclass,
				 ActionClass * aclass, char ontop, int flags,
				 int minw, int maxw, int minh,
				 int maxh, int xo, int yo, int xa, int xr,
				 int ya, int yr, int xsr, int xsa, int ysr,
				 int ysa, char simg, int desk, char sticky);
void                DestroyButton(Button * b);
void                CalcButton(Button * b);
void                ShowButton(Button * b);
void                SimpleShowButton(Button * b);
void                MoveButtonToDesktop(Button * b, int num);
void                HideButton(Button * b);
void                DrawButton(Button * b);
void                MovebuttonToCoord(Button * b, int x, int y);
int                 EmbedWindowIntoButton(Button * ButtonToUse,
					  Window WindowToEmbed);
void                FindEmptySpotForButton(Button * bt, char *listname, char dirtomove);

void               *AtomGet(Window win, Atom to_get, Atom type, int *size);
void                GNOME_GetHintIcons(EWin * ewin);
void                GNOME_SetCurrentDesk(void);
void                GNOME_SetUsedHints(void);
void                GNOME_GetExpandedSize(EWin * ewin);
void                GNOME_GetHintDesktop(EWin * ewin);
void                GNOME_GetHint(EWin * ewin);
void                GNOME_GetHintAppState(EWin * ewin);
void                GNOME_GetHintState(EWin * ewin);
void                GNOME_GetHintLayer(EWin * ewin);
void                GNOME_SetEwinArea(EWin * ewin);
void                GNOME_SetWMCheck(void);
void                GNOME_SetDeskCount(void);
void                GNOME_SetDeskNames(void);
void                GNOME_SetClientList(void);
void                GNOME_GetHints(EWin * ewin);
void                GNOME_SetHint(EWin * ewin);
void                GNOME_SetEwinDesk(EWin * ewin);
void                GNOME_SetHints(void);
void                GNOME_SetCurrentArea(void);
void                GNOME_SetAreaCount(void);
void                GNOME_SetWMNameVer(void);
void                GNOME_DelHints(EWin * ewin);

Sample             *LoadWav(char *file);
void                SoundPlay(Sample * s);
void                DestroySample(Sample * s);
void                DestroySclass(SoundClass * sclass);
SoundClass         *CreateSoundClass(char *name, char *file);
void                ApplySclass(SoundClass * sclass);
void                SoundInit(void);
void                SoundExit(void);

int                 isafter(int p, char *s1, char *s2);
int                 matchregexp(char *rx, char *s);

void                DoIn(char *name, double in_time,
			 void                (*func) (int val, void *data),
			 int runtime_val, void *runtime_data);
Qentry             *GetHeadTimerQueue(void);
void                HandleTimerEvent(void);
void                RemoveTimerEvent(char *name);

void                CreateCurve(ModCurve * c);
ColorModifierClass *CreateCMClass(char *name,
				  int rnum, unsigned char *rpx,
				  unsigned char *rpy, int gnum,
				  unsigned char *gpx, unsigned char *gpy,
				  int bnum, unsigned char *bpx,
				  unsigned char *bpy);
void                ModifyCMClass(char *name,
				  int rnum, unsigned char *rpx,
				  unsigned char *rpy, int gnum,
				  unsigned char *gpx, unsigned char *gpy,
				  int bnum, unsigned char *bpx,
				  unsigned char *bpy);

char               *GetLine(char *s, int size, FILE * f);
int                 testForComment(char *line);
int                 GetNextLine(char *line, FILE * ConfigFile);
void                Config_Text(FILE * ConfigFile);
void                Config_Slideout(FILE * ConfigFile);
void                Config_Control(FILE * ConfigFile);
void                Config_MenuStyle(FILE * ConfigFile);
void                Config_Menu(FILE * ConfigFile);
void                BorderPartLoad(FILE * ConfigFile, char type, Border * b);
void                Config_Border(FILE * ConfigFile);
void                Config_Button(FILE * ConfigFile);
void                Config_Desktop(FILE * ConfigFile);
void                Config_ECursor(FILE * ConfigFile);
void                Config_Iconbox(FILE * ConfigFile);
void                Config_Sound(FILE * ConfigFile);
void                Config_ActionClass(FILE * ConfigFile);
void                Config_ImageClass(FILE * ConfigFile);
void                Config_ColorModifier(FILE * ConfigFile);
void                Config_FX(FILE * ConfigFile);
void                Config_WindowMatch(FILE * ConfigFile);
int                 IsWhitespace(const char *s);
FILE               *OpenConfigFileForReading(char *path, char preprocess);
void                Config_ToolTip(FILE * ConfigFile);
int                 LoadConfigFile(char *file);
int                 LoadOpenConfigFile(FILE * ConfigFile);
int                 LoadStringFiles(void);
char               *ExtractTheme(char *theme);
char               *FindFile(char *file);
char               *FindNoThemeFile(char *file);
char               *FindTheme(char *theme);
int                 LoadEConfig(char *themelocation);
void                SaveUserControlConfig(FILE * autosavefile);
void                RecoverUserConfig(void);

void                HKeyPress(XEvent * ev);
void                HKeyRelease(XEvent * ev);
void                HButtonPress(XEvent * ev);
void                HButtonRelease(XEvent * ev);
void                HMotionNotify(XEvent * ev);
void                HEnterNotify(XEvent * ev);
void                HLeaveNotify(XEvent * ev);
void                HFocusIn(XEvent * ev);
void                HFocusOut(XEvent * ev);
void                HKeymapNotify(XEvent * ev);
void                HExpose(XEvent * ev);
void                HGraphicsExpose(XEvent * ev);
void                HNoExpose(XEvent * ev);
void                HVisibilityNotify(XEvent * ev);
void                HCreateNotify(XEvent * ev);
void                HDestroyNotify(XEvent * ev);
void                HUnmapNotify(XEvent * ev);
void                HMapNotify(XEvent * ev);
void                HMapRequest(XEvent * ev);
void                HReparentNotify(XEvent * ev);
void                HConfigureNotify(XEvent * ev);
void                HConfigureRequest(XEvent * ev);
void                HGravityNotify(XEvent * ev);
void                HResizeRequest(XEvent * ev);
void                HCirculateNotify(XEvent * ev);
void                HCirculateRequest(XEvent * ev);
void                HPropertyNotify(XEvent * ev);
void                HSelectionClear(XEvent * ev);
void                HSelectionRequest(XEvent * ev);
void                HSelectionNotify(XEvent * ev);
void                HColormapNotify(XEvent * ev);
void                HClientMessage(XEvent * ev);
void                HMappingNotify(XEvent * ev);
void                DefaultFunc(XEvent * ev);

void                IconifyEwin(EWin * ewin);
void                DeIconifyEwin(EWin * ewin);
void                RemoveMiniIcon(EWin * ewin);
void                MakeIcon(EWin * ewin);
void                DockIt(EWin * ewin);
void                DockDestroy(EWin * ewin);
void                HideIcons(void);
void                ShowIcons(void);
void                HandlePager(void);

void                SlideWindowSizeTo(Window win, int fx, int fy,
				      int tx, int ty,
				      int fw, int fh,
				      int tw, int th, int speed);
Slideout           *CreateSlideout(char *name, char dir);
void                ShowSlideout(Slideout * s, Window win);
void                HideSlideout(Slideout * s, Window w);
void                CalcSlideoutSize(Slideout * s);
void                AddButtonToSlideout(Slideout * s, Button * b);
void                RemoveButtonFromSlideout(Slideout * s, Button * b);

Strip              *CreateStrip(char *name);
void                DestroyStrip(Strip * s);
void                RotateStripTo(Strip * s, char rot);
void                MoveStripTo(Strip * s, int x, int y);
void                ShowStrip(Strip * s);
void                HideStrip(Strip * s);
void                RemoveButtonFromStrip(Strip * s, Button * b);
void                AddButtonToStrip(Strip * s, Button * b, int x, int y);
void                RepackStrip(Strip * s);
Strip              *IsInStrip(int x, int y);

TextState          *TextGetState(TextClass * tclass, int active, int sticky,
				 int state);
char              **TextGetLines(char *text, int *count);
void                TextStateLoadFont(TextState * ts);
void                TextSize(TextClass * tclass, int active, int sticky,
			     int state, char *text, int *width, int *height,
			     int fsize);
void                TextDraw(TextClass * tclass, Window win, int active,
			     int sticky, int state, char *text, int x, int y,
			     int w, int h, int fsize, int justification);

void                SetupInit(void);

ToolTip            *CreateToolTip(char *name, ImageClass * ic0, ImageClass * ic1,
				  ImageClass * ic2, ImageClass * ic3,
			       ImageClass * ic4, TextClass * tclass, int dist,
				  ImageClass * tooltippic);
void                ShowToolTip(ToolTip * tt, char *text, int x,
				int y);
void                HideToolTip(ToolTip * tt);

void                ShowTaskMenu(void);
void                ShowAllTaskMenu(void);
void                ShowDeskMenu(void);
Menu               *RefreshTaskMenu(int desk);
Menu               *RefreshAllTaskMenu(Menu * m);
Menu               *RefreshDeskMenu(Menu * m);
void                HideMenu(Menu * m);
void                ShowMenu(Menu * m, char noshow);
MenuStyle          *CreateMenuStyle(void);
MenuItem           *CreateMenuItem(char *text, ImageClass * iclass, ActionClass * aclass, Menu * child);
Menu               *CreateMenu(void);
void                DestroyMenu(Menu * m);
void                AddItemToMenu(Menu * menu, MenuItem * item);
void                AddTitleToMenu(Menu * menu, char *title);
void                RealizeMenu(Menu * m);
void                DrawMenuItem(Menu * m, MenuItem * mi, char shape);
Menu               *CreateMenuFromDirectory(char *name, MenuStyle * ms, char *dir);
Menu               *CreateMenuFromFlatFile(char *name, MenuStyle * ms, char *file, Menu * parent);
Menu               *CreateMenuFromGnome(char *name, MenuStyle * ms, char *dir);
Menu               *CreateMenuFromAllEWins(char *name, MenuStyle * ms);
Menu               *CreateMenuFromDesktopEWins(char *name, MenuStyle * ms, int desk);
Menu               *CreateMenuFromDesktops(char *name, MenuStyle * ms);
Menu               *CreateMenuFromThemes(char *name, MenuStyle * ms);
Menu               *CreateMenuFromBorders(char *name, MenuStyle * ms);
void                ShowMenuMasker(Menu * m);
void                HideMenuMasker(void);
void                RepackMenu(Menu * m);
void                EmptyMenu(Menu * m);

void                SetNewAreaSize(int ax, int ay);
void                GetCurrentArea(int *ax, int *ay);
void                SetAreaSize(int aw, int ah);
void                GetAreaSize(int *aw, int *ah);
void                InitCurrentArea(int ax, int ay);
void                SetCurrentArea(int ax, int ay);
void                MoveEwinToArea(EWin * ewin, int ax, int ay);
void                SetEwinToCurrentArea(EWin * ewin);
void                MoveCurrentAreaBy(int ax, int ay);
void                SetCurrentLinearArea(int a);
int                 GetCurrentLinearArea(void);
void                MoveCurrentLinearAreaBy(int a);
void                SlideWindowsBy(Window * win, int num, int dx, int dy, int speed);
void                MoveEwinToLinearArea(EWin * ewin, int a);
void                MoveEwinLinearAreaBy(EWin * ewin, int a);

int                 Emkstemp(char *template);
void                SnapEwin(EWin * ewin, int dx, int dy, int *new_dx, int *new_dy);
void                SessionInit(void);
void                SessionSave(int shutdown);
void                doSMExit(void *params);
void                ProcessICEMSGS(void);
int                 GetSMfd(void);
void                SessionGetInfo(EWin * ewin);
void                SetSMID(char *smid);
void                SetSMFile(char *path);
void                SetSMUserThemePath(char *path);
char               *GetSMFile(void);
char               *GetGenericSMFile(void);
void                MatchEwinToSM(EWin * ewin);
void                SaveSession(int shutdown);
void                autosave(void);

Progressbar        *CreateProgressbar(char *name, int width, int height);
void                SetProgressbar(Progressbar * p, int progress);
void                ShowProgressbar(Progressbar * p);
void                HideProgressbar(Progressbar * p);
void                FreeProgressbar(Progressbar * p);
Window             *ListProgressWindows(int *num);
void                RaiseProgressbars(void);

#if defined(__FILE__) && defined(__LINE__)
#define Efree(x) \
__Efree(x, __FILE__, __LINE__);
#define Emalloc(x) \
__Emalloc(x, __FILE__, __LINE__)
#define Erealloc(x, y) \
__Erealloc(x, y, __FILE__, __LINE__)
#else
#define Efree(x) \
free(x);
#define Emalloc(x) \
malloc(x)
#define Erealloc(x, y) \
realloc(x, y)
#endif

void               *__Emalloc(int size, const char *file, int line);
void               *__Erealloc(void *ptr, int size, const char *file, int line);
void                __Efree(void *ptr, const char *file, int line);
char               *duplicate(char *s);

void                Alert(char *fmt,...);
void                InitStringList(void);
void                AssignIgnoreFunction(int (*FunctionToAssign) (void *), void *params);
void                AssignRestartFunction(int (*FunctionToAssign) (void *), void *params);
void                AssignExitFunction(int (*FunctionToAssign) (void *), void *params);
void                AssignTitleText(char *text);
void                AssignIgnoreText(char *text);
void                AssignRestartText(char *text);
void                AssignExitText(char *text);

void                Etmp(char *s);
void                md(char *s);
int                 exists(char *s);
void                mkdirs(char *s);
int                 isfile(char *s);
int                 isdir(char *s);
char              **ls(char *dir, int *num);
void                freestrlist(char **l, int num);
void                rm(char *s);
void                mv(char *s, char *ss);
void                cp(char *s, char *ss);
time_t              moddate(char *s);
int                 filesize(char *s);
int                 fileinode(char *s);
int                 filedev(char *s);
void                cd(char *s);
char               *cwd(void);
int                 permissions(char *s);
int                 owner(char *s);
int                 group(char *s);
char               *username(int uid);
char               *homedir(int uid);
char               *usershell(int uid);
char               *atword(char *s, int num);
char               *atchar(char *s, char c);
char               *getword(char *s, int num);
void                word(char *s, int num, char *wd);
int                 canread(char *s);
int                 canwrite(char *s);
int                 canexec(char *s);
char               *fileof(char *s);
char               *fullfileof(char *s);
char               *pathtoexec(char *file);
char               *pathtofile(char *file);
char               *FileExtension(char *file);
char               *field(char *s, int field);
int                 fillfield(char *s, int field, char *buf);
void                fword(char *s, int num, char *wd);

ECursor            *CreateECursor(char *name, char *image, ImlibColor * fg, ImlibColor * bg);
void                ApplyECursor(Window win, ECursor * ec);

Snapshot           *FindSnapshot(EWin * ewin);
Snapshot           *GetSnapshot(EWin * ewin);
Snapshot           *NewSnapshot(char *name);
void                SnapshotEwinBorder(EWin * ewin);
void                SnapshotEwinDesktop(EWin * ewin);
void                SnapshotEwinArea(EWin * ewin);
void                SnapshotEwinSize(EWin * ewin);
void                SnapshotEwinLocation(EWin * ewin);
void                SnapshotEwinLayer(EWin * ewin);
void                SnapshotEwinSticky(EWin * ewin);
void                SnapshotEwinIcon(EWin * ewin);
void                SnapshotEwinShade(EWin * ewin);
void                SnapshotEwinAll(EWin * ewin);
void                UnsnapshotEwin(EWin * ewin);
void                SaveSnapInfo(void);
void                LoadSnapInfo(void);
void                MatchEwinToSnapInfo(EWin * ewin);
void                MatchEwinToSnapInfoAfter(EWin * ewin);

void                SetCoords(int x, int y, int w, int h);
void                HideCoords(void);

char               *append_merge_dir(char *dir, char ***list, int *count);
char              **ListThemes(int *number);
char               *GetDefaultTheme(void);
void                SetDefaultTheme(char *theme);

char                SanitiseThemeDir(char *dir);

Dialog             *CreateDialog(char *name);
void                FreeDButton(DButton * db);
void                FreeDialog(Dialog * d);
void                DialogSetText(Dialog * d, char *text);
void                DialogSetTitle(Dialog * d, char *title);
void                DialogAddButton(Dialog * d, char *text, void (*func) (int val, void *data), char close);
void                DialogDrawButton(Dialog * d, int bnum);
void                DialogActivateButton(Window win, int inclick);
void                DialogDraw(Dialog * d);
void                DialogRedraw(Dialog * d);
void                ShowDialog(Dialog * d);
void                DialogClose(Dialog * d);
void                DialogSetParamText(Dialog * d, char *fmt,...);
void                DialogAlert(char *fmt,...);
void                DialogAlertOK(char *fmt,...);
void                DialogRestart(int val, void *data);
void                DialogQuit(int val, void *data);

Window              SC_GetDestWin(void);
void                SC_PassEvent(XEvent * ev);
void                SC_Main(void);
void                SC_Init(void);
void                SC_SetWait(void);
void                SC_Normal(void);
void                SC_SetHotspot(int x, int y);
void                SC_SetImage(char *file);
void                SC_Kill(void);

/* fx.c exportable functions */
void                FX_Start(char *name);
void                FX_DeskChange(void);
void                FX_Pause(void);
char              **FX_Active(int *num);
int                 FX_IsOn(char *effect);
void                FX_Deactivate(char *effect);
void                FX_Activate(char *effect);

/* ipc.c functions */

int                 HandleIPC(char *params, Client * c);

/* sticky.c functions */

void                MakeWindowSticky(EWin * ewin);
void                MakeWindowUnSticky(EWin * ewin);

/* size.c functions */

void                MaxSize(EWin * ewin, char *resize_type);
void                MaxWidth(EWin * ewin, char *resize_type);
void                MaxHeight(EWin * ewin, char *resize_type);

Clone              *CloneEwin(EWin * ewin);
void                FreeClone(Clone * c);
void                RemoveClones(void);
void                CloneDesktop(int d);

Pager              *CreatePager(void);
EWin               *EwinInPagerAt(Pager * p, int x, int y);
void                PagerResize(Pager * p, int w, int h);
void                PagerShow(Pager * p);
void                PagerHide(Pager * p);
void                PagerTitle(Pager * p, char *title);
void                PagerKill(Pager * p);
Pager             **PagersForDesktop(int d, int *num);
void                RedrawPagersForDesktop(int d, char newbg);
void                ForceUpdatePagersForDesktop(int d);
void                PagerEwinUpdateMini(Pager * p, EWin * ewin);
void                PagerEwinUpdateFromPager(Pager * p, EWin * ewin);
void                PagerRedraw(Pager * p, char newbg);
void                PagerForceUpdate(Pager * p);
void                PagerShowMenu(Pager * p, int x, int y);
void                PagerReArea(void);
void                PagerEwinOutsideAreaUpdate(EWin * ewin);
void                PagerAreaAt(Pager * p, int x, int y, int *ax, int *ay);
void                UpdatePagerSel(void);
void                PagerHandleMotion(Pager * p, Window win, int x, int y);
void                EnableAllPagers(void);
void                DisableAllPagers(void);

extern pid_t        master_pid;
extern int          master_screen;
extern int          display_screens;
extern int          single_screen_mode;
extern Display     *disp;
extern ImlibData   *id;
extern ImlibData   *ird;
extern FnlibData   *fd;
extern List        *lists;
extern int          event_base_shape;
extern Window       comms_win;
extern Root         root;
extern int          (*(ActionFunctions[ACTION_NUMBEROF])) (void *);
extern EMode        mode;
extern Desktops     desks;
extern Window       grab_window;
extern Window       init_win1;
extern Window       init_win2;
extern Window       init_win_ext;
extern Window       bpress_win;
extern int          deskorder[ENLIGHTENMENT_CONF_NUM_DESKTOPS];
extern int          sound_fd;

#define FILEPATH_LEN_MAX 4096
extern char         themepath[FILEPATH_LEN_MAX];
extern char         themename[FILEPATH_LEN_MAX];
extern char        *command;
extern char         mustdel;
extern char         queue_up;
extern char         just_flipped;
extern Menu        *all_task_menu;
extern Menu        *task_menu[ENLIGHTENMENT_CONF_NUM_DESKTOPS];
extern Menu        *desk_menu;
extern char         no_overwrite;
extern Window       external_pager_window;
extern char         clickmenu;
extern Window       last_bpress;
extern int          child_count;
extern pid_t       *e_children;
extern int          numlock_mask;
extern int          scrollock_mask;
extern int          mask_mod_combos[8];

/* This turns on E's internal stack tracking system for coarse debugging */
/* and being able to trace E for profiling/optimisation purposes (which */
/* believe it or not I'm actually doing) */

/* #define DEBUG 1 */
