#include "E.h"
#include <errno.h>

void                DeskAccountTimeout(int val, void *data);
void                AutosaveTimeout(int val, void *data);

HandleStruct        HArray[] =
{
  {DefaultFunc},
  {DefaultFunc},
  {HKeyPress},
  {HKeyRelease},
  {HButtonPress},
  {HButtonRelease},
  {HMotionNotify},
  {HEnterNotify},
  {HLeaveNotify},
  {HFocusIn},
  {HFocusOut},
  {HKeymapNotify},
  {HExpose},
  {HGraphicsExpose},
  {HNoExpose},
  {HVisibilityNotify},
  {HCreateNotify},
  {HDestroyNotify},
  {HUnmapNotify},
  {HMapNotify},
  {HMapRequest},
  {HReparentNotify},
  {HConfigureNotify},
  {HConfigureRequest},
  {HGravityNotify},
  {HResizeRequest},
  {HCirculateNotify},
  {HCirculateRequest},
  {HPropertyNotify},
  {HSelectionClear},
  {HSelectionRequest},
  {HSelectionNotify},
  {HColormapNotify},
  {HClientMessage},
  {HMappingNotify},
  {DefaultFunc}
};

static char         diddeskaccount = 1;
static char         didautosave = 1;

void
DeskAccountTimeout(int val, void *data)
{
  EDBUG(5, "DeskAccountTimeout");

  DesktopAccounting();
  diddeskaccount = 1;
  data = NULL;
  val = 0;
}

void
AutosaveTimeout(int val, void *data)
{
  EDBUG(5, "AutosaveTimeout");

  autosave();
  didautosave = 1;
  data = NULL;
  val = 0;
}

void
DebugEvent(XEvent * ev)
{
  EDBUG(8, "DebugEvent");
  if (ev->type == event_base_shape + ShapeNotify)
    printf("EV: ShapeNotify:\n");
  else
    {
      switch (ev->type)
	{
	case KeyPress:
	  printf("EV: KeyPress:\n");
	  break;
	case KeyRelease:
	  printf("EV: KeyRelease:\n");
	  break;
	case ButtonPress:
	  printf("EV: ButtonPress:\n");
	  break;
	case ButtonRelease:
	  printf("EV: ButtonRelease:\n");
	  break;
	case MotionNotify:
	  printf("EV: MotionNotify:\n");
	  break;
	case EnterNotify:
	  printf("EV: EnterNotify:\n");
	  break;
	case LeaveNotify:
	  printf("EV: LeaveNotify:\n");
	  break;
	case FocusIn:
	  printf("EV: FocusIn:\n");
	  break;
	case FocusOut:
	  printf("EV: FocusOut:\n");
	  break;
	case KeymapNotify:
	  printf("EV: KeymapNotify:\n");
	  break;
	case Expose:
	  printf("EV: Expose:\n");
	  break;
	case GraphicsExpose:
	  printf("EV: GraphicsExpose:\n");
	  break;
	case NoExpose:
	  printf("EV: NoExpose:\n");
	  break;
	case VisibilityNotify:
	  printf("EV: VisibilityNotify:\n");
	  break;
	case CreateNotify:
	  printf("EV: CreateNotify:\n");
	  break;
	case DestroyNotify:
	  printf("EV: DestroyNotify:\n");
	  break;
	case UnmapNotify:
	  printf("EV: UnmapNotify:\n");
	  break;
	case MapNotify:
	  printf("EV: MapNotify:\n");
	  break;
	case MapRequest:
	  printf("EV: MapRequest:\n");
	  break;
	case ReparentNotify:
	  printf("EV: ReparentNotify:\n");
	  break;
	case ConfigureNotify:
	  printf("EV: ConfigureNotify:\n");
	  break;
	case ConfigureRequest:
	  printf("EV: ConfigureRequest:\n");
	  break;
	case GravityNotify:
	  printf("EV: GravityNotify:\n");
	  break;
	case ResizeRequest:
	  printf("EV: ResizeRequest:\n");
	  break;
	case CirculateNotify:
	  printf("EV: CirculateNotify:\n");
	  break;
	case CirculateRequest:
	  printf("EV: CirculateRequest:\n");
	  break;
	case PropertyNotify:
	  printf("EV: PropertyNotify:\n");
	  break;
	case SelectionClear:
	  printf("EV: SelectionClear:\n");
	  break;
	case SelectionRequest:
	  printf("EV: SelectionRequest:\n");
	  break;
	case SelectionNotify:
	  printf("EV: SelectionNotify:\n");
	  break;
	case ColormapNotify:
	  printf("EV: ColormapNotify:\n");
	  break;
	case ClientMessage:
	  printf("EV: ClientMessage:\n");
	  break;
	case MappingNotify:
	  printf("EV: MappingNotify:\n");
	  break;
	default:
	  printf("EV: ???\n");
	  break;
	}
    }
  EDBUG_RETURN_;
}

void
HandleEvent(XEvent * ev)
{
  void              **lst;
  int                 i, num;

  EDBUG(7, "HandleEvent");
/*  DebugEvent(ev); */
  if (ev->type == event_base_shape + ShapeNotify)
    HandleChildShapeChange(ev);
  if ((ev->type == KeyPress) || (ev->type == KeyRelease) ||
      (ev->type == ButtonPress) || (ev->type == ButtonRelease) ||
      (ev->type == EnterNotify) || (ev->type == LeaveNotify))
    {
      lst = ListItemType(&num, LIST_TYPE_ACLASS_GLOBAL);
      if (lst)
	{
	  for (i = 0; i < num; i++)
	    EventAclass(ev, (ActionClass *) lst[i]);
	  Efree(lst);
	}
    }
  if (ev->type <= 35)
    HArray[ev->type].func(ev);

  if (diddeskaccount)
    {
      DoIn("DESKTOP_ACCOUNTING_TIMEOUT", 30.0, DeskAccountTimeout, 0, NULL);
      diddeskaccount = 0;
    }
/*  disable autosave every 60 seconds 
 * if (didautosave)
 * {
 * DoIn("AUTOSAVE_TIMEOUT", 60.0, AutosaveTimeout, 0, NULL);
 * didautosave = 0;
 * }
 */
  EDBUG_RETURN_;
}

void
CheckEvent()
{
  XEvent              ev;

  EDBUG(7, "CheckEvent");
  while (XPending(disp))
    {
      XNextEvent(disp, &ev);
      HandleEvent(&ev);
    }
  EDBUG_RETURN_;
}

void
WaitEvent()
{
  XEvent              ev;
  fd_set              fdset;
  struct timeval      tval;
  static struct timeval tval_last =
  {0, 0};
  double              time1, time2;
  Qentry             *qe;
  int                 count;
  int                 fdsize;
  int                 xfd, smfd;

  EDBUG(7, "WaitEvent");
  smfd = GetSMfd();
  xfd = ConnectionNumber(disp);
  fdsize = MAX(xfd, smfd) + 1;

  /* if we've never set the time we were last here before */
  if ((tval_last.tv_sec == 0) && (tval_last.tv_usec == 0))
    gettimeofday(&tval_last, NULL);
  /* time1 = time we last entered this routine */
  time1 = ((double)tval_last.tv_sec) + (((double)tval_last.tv_usec) / 1000000);
  gettimeofday(&tval, NULL);
  tval_last.tv_sec = tval.tv_sec;
  tval_last.tv_usec = tval.tv_usec;
  /* time2 = current time */
  time2 = ((double)tval.tv_sec) + (((double)tval.tv_usec) / 1000000);
  time2 -= time1;
  if (time2 < 0.0)
    time2 = 0.0;
  /* time2 = time spent since we last were here */

  count = 0;
  while (XPending(disp))
    {
      XNextEvent(disp, &ev);
      HandleEvent(&ev);
      count++;
    }
  HandleDrawQueue();
  XFlush(disp);
  count = 0;
  while (XPending(disp))
    {
      XNextEvent(disp, &ev);
      HandleEvent(&ev);
      count++;
    }
  if (count > 0)
    XFlush(disp);

  FD_ZERO(&fdset);
  FD_SET(xfd, &fdset);
  if (smfd >= 0)
    FD_SET(smfd, &fdset);

  qe = GetHeadTimerQueue();
  if (qe)
    {
      if (qe->just_added)
	{
	  qe->just_added = 0;
	  time1 = qe->in_time;
	}
      else
	{
	  time1 = qe->in_time - time2;
	  if (time1 < 0.0)
	    time1 = 0.0;
	  qe->in_time = time1;
	}
      tval.tv_sec = (long)time1;
      tval.tv_usec = (long)((time1 - ((double)tval.tv_sec)) * 1000000);
      count = select(fdsize, &fdset, NULL, NULL, &tval);
    }
  else
    count = select(fdsize, &fdset, NULL, NULL, NULL);
  if (count < 0)
    {
      /*
       * if (errno == EINTR)
       * fprintf(stderr, "Enlightenment: select() returns due to "
       * "interrupted system call\n");
       * else
       * fprintf(stderr, "Enlightenment: select() returns due to "
       * "error %d\n", errno);
       */
      EDBUG_RETURN_;
    }
  if ((smfd >= 0) && (count > 0) && (FD_ISSET(smfd, &fdset)))
    ProcessICEMSGS();
  if ((!(FD_ISSET(xfd, &fdset))) && (qe) && (count == 0) &&
      (((smfd >= 0) && (!(FD_ISSET(smfd, &fdset)))) || (smfd < 0)))
    HandleTimerEvent();
  EDBUG_RETURN_;
}

void
HKeyPress(XEvent * ev)
{
  EDBUG(7, "HKeyPress");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HKeyRelease(XEvent * ev)
{
  EDBUG(7, "HKeyRelease");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HButtonPress(XEvent * ev)
{
  EDBUG(7, "HButtonPress");
  ApplySclass(FindItem("SOUND_BUTTON_CLICK", 0,
		       LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
  HandleMouseDown(ev);
  EDisplayMemUse();
  EDBUG_RETURN_;
}

void
HButtonRelease(XEvent * ev)
{
  EDBUG(7, "HButtonRelease");
  ApplySclass(FindItem("SOUND_BUTTON_RAISE", 0,
		       LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
  HandleMouseUp(ev);
  EDBUG_RETURN_;
}

void
HMotionNotify(XEvent * ev)
{
  EDBUG(7, "HMotionNotify");
  while (XCheckTypedEvent(disp, ev->type, ev));
  HandleMotion(ev);
  EDBUG_RETURN_;
}

void
HEnterNotify(XEvent * ev)
{
  EDBUG(7, "HEnterNotify");
  if (mode.mode == MODE_NONE)
    {
      /*
       * multi screen handling -- root windows receive
       * enter / leave notify
       */
      if (ev->xany.window == root.win)
	{
	  if (!mode.focuswin || FOCUS_POINTER == mode.focusmode)
	    HandleFocusWindow(root.focuswin);
	}
      else
	{
	  HandleMouseIn(ev);
	  HandleFocusWindow(ev->xcrossing.window);
	}
    }
  EDBUG_RETURN_;
}

void
HLeaveNotify(XEvent * ev)
{
  EDBUG(7, "HLeaveNotify");
  if (mode.mode == MODE_NONE)
    {
      HandleMouseOut(ev);

      /*
       * If we are leaving the root window, we are switching
       * screens on a multi screen system - need to unfocus
       * to allow other desk to grab focus...
       */
      if (ev->xcrossing.window == root.win)
	{
	  if (ev->xcrossing.mode == NotifyNormal &&
	      ev->xcrossing.detail != NotifyInferior &&
	      mode.focuswin)
	    HandleFocusWindow(root.focuswin);
	}
      else
	HandleFocusWindow(ev->xcrossing.window);
    }
  EDBUG_RETURN_;
}

void
HFocusIn(XEvent * ev)
{
  EDBUG(7, "HFocusIn");
  if (ev->xfocus.detail != NotifyPointer)
    HandleFocusWindowIn(ev->xfocus.window);
  EDBUG_RETURN_;
}

void
HFocusOut(XEvent * ev)
{
  EDBUG(7, "HFocusOut");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HKeymapNotify(XEvent * ev)
{
  EDBUG(7, "HKeymapNotify");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HExpose(XEvent * ev)
{
  EDBUG(7, "HExpose");
  if (!ev->xexpose.count)
    HandleExpose(ev);
  EDBUG_RETURN_;
}

void
HGraphicsExpose(XEvent * ev)
{
  EDBUG(7, "HGraphicsExpose");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HNoExpose(XEvent * ev)
{
  EDBUG(7, "HNoExpose");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HVisibilityNotify(XEvent * ev)
{
  EDBUG(7, "HVisibilityNotify");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HCreateNotify(XEvent * ev)
{
  EDBUG(7, "HCreateNotify");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HDestroyNotify(XEvent * ev)
{
  EDBUG(7, "HDestroyNotify");
  HandleDestroy(ev);
  EDBUG_RETURN_;
}

void
HUnmapNotify(XEvent * ev)
{
  EDBUG(7, "HUnmapNotify");
  HandleUnmap(ev);
  EDBUG_RETURN_;
}

void
HMapNotify(XEvent * ev)
{
  EDBUG(7, "HMapNotify");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HMapRequest(XEvent * ev)
{
  EDBUG(7, "HMapRequest");
  HandleMapRequest(ev);
  EDBUG_RETURN_;
}

void
HReparentNotify(XEvent * ev)
{
  EDBUG(7, "HReparentNotify");
  HandleReparent(ev);
  EDBUG_RETURN_;
}

void
HConfigureNotify(XEvent * ev)
{
  EDBUG(7, "HConfigureNotify");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HConfigureRequest(XEvent * ev)
{
  EDBUG(7, "HConfigureRequest");
  HandleConfigureRequest(ev);
  EDBUG_RETURN_;
}

void
HGravityNotify(XEvent * ev)
{
  EDBUG(7, "HGravityNotify");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HResizeRequest(XEvent * ev)
{
  EDBUG(7, "HResizeRequest");
  HandleResizeRequest(ev);
  EDBUG_RETURN_;
}

void
HCirculateNotify(XEvent * ev)
{
  EDBUG(7, "HCirculateNotify");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HCirculateRequest(XEvent * ev)
{
  EDBUG(7, "HCirculateRequest");
  HandleCirculate(ev);
  EDBUG_RETURN_;
}

void
HPropertyNotify(XEvent * ev)
{
  EDBUG(7, "HPropertyNotify");
  HandleProperty(ev);
  EDBUG_RETURN_;
}

void
HSelectionClear(XEvent * ev)
{
  EDBUG(7, "HSelectionClear");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HSelectionRequest(XEvent * ev)
{
  EDBUG(7, "HSelectionRequest");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HSelectionNotify(XEvent * ev)
{
  EDBUG(7, "HSelectionNotify");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HColormapNotify(XEvent * ev)
{
  EDBUG(7, "HColormapNotify");
  ev = NULL;
  EDBUG_RETURN_;
}

void
HClientMessage(XEvent * ev)
{
  EDBUG(7, "HClientMessage");
  HandleClientMessage(ev);
  EDBUG_RETURN_;
}

void
HMappingNotify(XEvent * ev)
{
  EDBUG(7, "HMappingNotify");
  ev = NULL;
  EDBUG_RETURN_;
}

void
DefaultFunc(XEvent * ev)
{
  EDBUG(7, "DefaultFunc");
  ev = NULL;
  EDBUG_RETURN_;
}
