#include "E.h"
#include "timestamp.h"

int
main(int argc, char **argv)
{
  Border             *b;
  ImageClass         *ic;
  ActionClass        *ac;
  Action             *a;
  Background         *bg;
  ImlibColor          icl;
  ECursor            *ec = NULL;

  single_screen_mode = 0;
/*  unsetenv("LD_PRELOAD"); */

#ifdef DEBUG
  call_level = 0;
  debug_level = 0;
  {
    char               *debug_str;

    debug_str = getenv("EDBUG");
    if (debug_str)
      debug_level = atoi(debug_str);
  }
#endif
  InitStringList();
  EDBUG(1, "main");
  lists = Emalloc(sizeof(List) * LIST_TYPE_COUNT);
  lists = memset(lists, 0, (sizeof(List) * LIST_TYPE_COUNT));
  AssignTitleText("Enlightenment Message Dialog");
  AssignIgnoreText("Ignore this message");
  AssignRestartText("Restart the Window Manager");
  AssignExitText("Quit the Window Manager");
  AssignRestartFunction(doExit, "restart");
  AssignExitFunction(doExit, NULL);
  srand(time(NULL));

  command = duplicate(argv[0]);
  themepath[0] = 0;
  {
    int                 j = 0;

    /* Set a default location for the "previous session" data when
     * we do not actually have a previous session. */
    SetSMFile(NULL);

    for (j = 1; j < argc; j++)
      {
	if ((!strcmp("-theme", argv[j])) && (argc - j > 1))
	  Esnprintf(themepath, sizeof(themepath), "%s", argv[++j]);
	else if (!strcmp("-single", argv[j]))
	  single_screen_mode = 1;
	else if ((!strcmp("-smid", argv[j])) && (argc - j > 1))
	  SetSMID(argv[++j]);
	else if ((!strcmp("-clientId", argv[j])) && (argc - j > 1))
	  SetSMID(argv[++j]);
	else if ((!strcmp("--sm-client-id", argv[j])) && (argc - j > 1))
	  SetSMID(argv[++j]);
	else if ((!strcmp("-smfile", argv[j])) && (argc - j > 1))
	  SetSMFile(argv[++j]);
	else if ((!strcmp("-ext_init_win", argv[j])) && (argc - j > 1))
	  init_win_ext = atoi(argv[++j]);
	else if (!strcmp("-no_overwrite", argv[j]))
	  no_overwrite = 1;
      }
  }

  if (themepath[0] == 0)
    {
      FILE               *f;
      char                s[FILEPATH_LEN_MAX];
      char               *file;

      file = FindFile("user_theme.cfg");
      if (file)
	{
	  s[0] = 0;
	  f = fopen(file, "r");
	  if (f)
	    {
	      if (fscanf(f, "%4000s", s) < 1)
		s[0] = 0;
	      fclose(f);
	      if (s[0])
		Esnprintf(themepath, sizeof(themepath), "%s", s);
	    }
	  Efree(file);
	}
      if (themepath[0] == 0)
	{
	  char               *def;

	  def = GetDefaultTheme();
	  fprintf(stderr, "DEF %s\n", def);
	  if (def)
	    {
	      Esnprintf(themepath, sizeof(themepath), "%s", def);
	      Efree(def);
	    }
	}
    }
  SetSMUserThemePath(themepath);

  SetupSignals();
  SetupX();
  SetupDirs();
/*  SC_Init();
 * SC_SetHotspot(30, 30);
 * SC_SetWait(); */
  SetupEnv();
  InitDesktopBgs();
  GotoDesktop(0);
  CommsSetup();
  CommsFindCommsWindow();
  GrabX();
  LoadSnapInfo();
  MapUnmap(0);

  /*
   * The next section creates simple internal data members to be used in 
   * emergencies - ie when all else fails - ie a button is told to use an
   * imageclass that doesn't exist, or no DEFAULT border is defined... at 
   * least E won't barf on us then.
   */

  /* create a default fallback actionclass for the fallback border */
  ac = CreateAclass("__FALLBACK_ACTION");
  AddItem(ac, ac->name, 0, LIST_TYPE_ACLASS);
  a = CreateAction(EVENT_MOUSE_DOWN, 1, 0, 0, 1, 0, NULL);
  AddAction(ac, a);
  AddToAction(a, ACTION_MOVE, NULL);
  a = CreateAction(EVENT_MOUSE_DOWN, 1, 0, 0, 2, 0, NULL);
  AddAction(ac, a);
  AddToAction(a, ACTION_KILL, NULL);
  a = CreateAction(EVENT_MOUSE_DOWN, 1, 0, 0, 3, 0, NULL);
  AddAction(ac, a);
  AddToAction(a, ACTION_RESIZE, NULL);

  /* create a fallback imageclass in case no imageclass can be found */
  ic = CreateIclass();
  ic->name = duplicate("__FALLBACK_ICLASS");
  ic->norm.normal = CreateImageState();
  ic->norm.normal->hihi.r = 255;
  ic->norm.normal->hihi.g = 255;
  ic->norm.normal->hihi.b = 255;
  ic->norm.normal->hi.r = 255;
  ic->norm.normal->hi.g = 255;
  ic->norm.normal->hi.b = 255;
  ic->norm.normal->bg.r = 160;
  ic->norm.normal->bg.g = 160;
  ic->norm.normal->bg.b = 160;
  ic->norm.normal->lo.r = 0;
  ic->norm.normal->lo.g = 0;
  ic->norm.normal->lo.b = 0;
  ic->norm.normal->lolo.r = 0;
  ic->norm.normal->lolo.g = 0;
  ic->norm.normal->lolo.b = 0;
  ic->norm.normal->bevelstyle = BEVEL_AMIGA;
  ic->norm.hilited = CreateImageState();
  ic->norm.hilited->hihi.r = 255;
  ic->norm.hilited->hihi.g = 255;
  ic->norm.hilited->hihi.b = 255;
  ic->norm.hilited->hi.r = 255;
  ic->norm.hilited->hi.g = 255;
  ic->norm.hilited->hi.b = 255;
  ic->norm.hilited->bg.r = 192;
  ic->norm.hilited->bg.g = 192;
  ic->norm.hilited->bg.b = 192;
  ic->norm.hilited->lo.r = 0;
  ic->norm.hilited->lo.g = 0;
  ic->norm.hilited->lo.b = 0;
  ic->norm.hilited->lolo.r = 0;
  ic->norm.hilited->lolo.g = 0;
  ic->norm.hilited->lolo.b = 0;
  ic->norm.hilited->bevelstyle = BEVEL_AMIGA;
  ic->norm.clicked = CreateImageState();
  ic->norm.clicked->hihi.r = 0;
  ic->norm.clicked->hihi.g = 0;
  ic->norm.clicked->hihi.b = 0;
  ic->norm.clicked->hi.r = 0;
  ic->norm.clicked->hi.g = 0;
  ic->norm.clicked->hi.b = 0;
  ic->norm.clicked->bg.r = 192;
  ic->norm.clicked->bg.g = 192;
  ic->norm.clicked->bg.b = 192;
  ic->norm.clicked->lo.r = 255;
  ic->norm.clicked->lo.g = 255;
  ic->norm.clicked->lo.b = 255;
  ic->norm.clicked->lolo.r = 255;
  ic->norm.clicked->lolo.g = 255;
  ic->norm.clicked->lolo.b = 255;
  ic->norm.clicked->bevelstyle = BEVEL_AMIGA;
  ic->active.normal = CreateImageState();
  ic->active.normal->hihi.r = 255;
  ic->active.normal->hihi.g = 255;
  ic->active.normal->hihi.b = 255;
  ic->active.normal->hi.r = 255;
  ic->active.normal->hi.g = 255;
  ic->active.normal->hi.b = 255;
  ic->active.normal->bg.r = 180;
  ic->active.normal->bg.g = 140;
  ic->active.normal->bg.b = 160;
  ic->active.normal->lo.r = 0;
  ic->active.normal->lo.g = 0;
  ic->active.normal->lo.b = 0;
  ic->active.normal->lolo.r = 0;
  ic->active.normal->lolo.g = 0;
  ic->active.normal->lolo.b = 0;
  ic->active.normal->bevelstyle = BEVEL_AMIGA;
  ic->active.hilited = CreateImageState();
  ic->active.hilited->hihi.r = 255;
  ic->active.hilited->hihi.g = 255;
  ic->active.hilited->hihi.b = 255;
  ic->active.hilited->hi.r = 255;
  ic->active.hilited->hi.g = 255;
  ic->active.hilited->hi.b = 255;
  ic->active.hilited->bg.r = 230;
  ic->active.hilited->bg.g = 190;
  ic->active.hilited->bg.b = 210;
  ic->active.hilited->lo.r = 0;
  ic->active.hilited->lo.g = 0;
  ic->active.hilited->lo.b = 0;
  ic->active.hilited->lolo.r = 0;
  ic->active.hilited->lolo.g = 0;
  ic->active.hilited->lolo.b = 0;
  ic->active.hilited->bevelstyle = BEVEL_AMIGA;
  ic->active.clicked = CreateImageState();
  ic->active.clicked->hihi.r = 0;
  ic->active.clicked->hihi.g = 0;
  ic->active.clicked->hihi.b = 0;
  ic->active.clicked->hi.r = 0;
  ic->active.clicked->hi.g = 0;
  ic->active.clicked->hi.b = 0;
  ic->active.clicked->bg.r = 230;
  ic->active.clicked->bg.g = 190;
  ic->active.clicked->bg.b = 210;
  ic->active.clicked->lo.r = 255;
  ic->active.clicked->lo.g = 255;
  ic->active.clicked->lo.b = 255;
  ic->active.clicked->lolo.r = 255;
  ic->active.clicked->lolo.g = 255;
  ic->active.clicked->lolo.b = 255;
  ic->active.clicked->bevelstyle = BEVEL_AMIGA;
  IclassPopulate(ic);
  AddItem(ic, ic->name, 0, LIST_TYPE_ICLASS);

  /* create a fallback border in case no border is found */
  b = CreateBorder("__FALLBACK_BORDER");
  b->border.left = 8;
  b->border.right = 8;
  b->border.top = 8;
  b->border.bottom = 8;
  AddBorderPart(b, ic, ac, NULL, NULL, 1, FLAG_BUTTON, 0, 8, 99999, 8, 99999,
		-1, 0, 0, 0, 0,
		-1, 1024, -1, 0, 7, 1);
  AddBorderPart(b, ic, ac, NULL, NULL, 1, FLAG_BUTTON, 0, 8, 99999, 8, 99999,
		-1, 0, 0, 1024, -8,
		-1, 1024, -1, 1024, -1, 1);
  AddBorderPart(b, ic, ac, NULL, NULL, 1, FLAG_BUTTON, 0, 8, 99999, 8, 99999,
		-1, 0, 0, 0, 8,
		-1, 0, 7, 1024, -9, 1);
  AddBorderPart(b, ic, ac, NULL, NULL, 1, FLAG_BUTTON, 0, 8, 99999, 8, 99999,
		-1, 1024, -8, 0, 8,
		-1, 1024, -1, 1024, -9, 1);
  AddItem(b, b->name, 0, LIST_TYPE_BORDER);

  bg = CreateDesktopBG("NONE", &icl, NULL, 0, 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 0);
  AddItem(bg, bg->name, 0, LIST_TYPE_BACKGROUND);

  UngrabX();

  AssignRestartFunction((*doExit), duplicate("restart"));
  AssignExitFunction((*EExit), (void *)1);
  desks.desk[0].viewable = 0;
  LoadEConfig(themepath);
  /* multihead - let children continue after stop */
  {
    int                 i;

    for (i = 0; i < child_count; i++)
      kill(e_children[i], SIGCONT);
  }
  desks.desk[0].viewable = 1;
  RefreshDesktop(0);

  SoundInit();

  if (mode.sound)
    {
      ApplySclass(FindItem("SOUND_STARTUP", 0,
			   LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
      DestroySclass(RemoveItem("SOUND_STARTUP", 0,
			       LIST_FINDBY_NAME, LIST_TYPE_SCLASS));
    }
  InitDesktopControls();
  {
    Button            **lst;
    int                 i, num;

    lst = (Button **) ListItemTypeID(&num, LIST_TYPE_BUTTON, 0);
    if (lst)
      {
	for (i = 0; i < num; i++)
	  {
	    if ((!lst[i]->internal) && (lst[i]->default_show))
	      SimpleShowButton(lst[i]);
	  }
	Efree(lst);
      }
  }
  GNOME_SetHints();
  SessionInit();
  ShowDesktopControls();
  CheckEvent();
  if (mode.mapslide)
    CreateStartupDisplay(0);
  ICCCM_GetMainEInfo();
  MapUnmap(1);
  GNOME_SetCurrentArea();
  HandlePager();
  {
    Pager              *p;
    int                 i;
    char                s[1024];

    queue_up = 0;
    for (i = 0; i < mode.numdesktops; i++)
      {
	p = CreatePager();
	if (p)
	  {
	    p->desktop = i;
	    Esnprintf(s, sizeof(s), "%i", i);
	    PagerTitle(p, s);
	    PagerShow(p);
	  }
      }
    queue_up = 1;
    UpdatePagerSel();
  }
  if (!mode.mapslide)
    CreateStartupDisplay(0);
  if (getpid() == master_pid && init_win_ext)
    {
      XKillClient(disp, init_win_ext);
      init_win_ext = 0;
    }
  GNOME_SetClientList();
  XSync(disp, False);
  queue_up = 1;

  if (mode.resizemode == 5)
    mode.resizemode = 0;

  ec = FindItem("DEFAULT", 0, LIST_FINDBY_NAME, LIST_TYPE_ECURSOR);
  ApplyECursor(root.win, ec);

  mode.startup = 0;
/*  SC_Kill(); */
  for (;;)
    WaitEvent();
  EDBUG_RETURN(0);
}
