/*
 * IceWM
 *
 * Copyright (C) 1997 Marko Macek
 */

#include "icewm.h"

void YFrameWindow::updateMenu() {
    YMenu *windowMenu = this->windowMenu();
    // enable all commands
    windowMenu->enableCommand(cmdNone);

    if (style & fsMaximized)
        windowMenu->disableCommand(cmdMaximize);
    if (style & fsMinimized)
        windowMenu->disableCommand(cmdMinimize);
    if (!(style & (fsMaximized | fsMinimized | fsHidden)))
        windowMenu->disableCommand(cmdRestore);
    if (style & (fsShaded | fsMinimized | fsHidden))
        windowMenu->disableCommand(cmdSize);
    if (style & (fsMinimized | fsHidden))
        windowMenu->disableCommand(cmdMove);
    if (this == app->bottom(layer()))
        windowMenu->disableCommand(cmdLower);

    unsigned long func = frameFunctions();

    if (!(func & ffMove))
        windowMenu->disableCommand(cmdMove);
    if (!(func & ffResize))
        windowMenu->disableCommand(cmdSize);
    if (!(func & ffMinimize))
        windowMenu->disableCommand(cmdMinimize);
    if (!(func & ffHide))
        windowMenu->disableCommand(cmdHide);
    if (!(func & ffShade))
        windowMenu->disableCommand(cmdShade);
    if (!(func & ffMaximize))
        windowMenu->disableCommand(cmdMaximize);
    if (!(func & ffClose))
        windowMenu->disableCommand(cmdClose);

    YMenu::YMenuItem *item = windowMenu->findItem(cmdShade);
    if (item)
        item->setCheck(shaded() ? 1 : 0);
    item = windowMenu->findItem(cmdOccupyAllOrCurrent);
    if (item)
        item->setCheck(client()->allWorkspaces() ? 1 : 0);
    for (int ii = 0; ii < occupyMenu->itemCount(); ii++) {
        item = occupyMenu->item(ii);
        if (item->command() == cmdOccupyAllOrCurrent)
            item->setCheck(client()->allWorkspaces() ? 1 : 0);
        else if (item->command() == cmdOccupyWorkspace) {
            item->setCheck(visibleOn((int)item->context()) ? 1 : 0);
            if (client()->allWorkspaces())
                item->disable();
            else
                item->enable();
        }
    }
}

#ifdef SHAPE
void YFrameWindow::setShape() {
    if (shapesSupported && client()->shaped()) {
        XShapeCombineShape (app->display(), handle(),
                            ShapeBounding,
                            borderX(),
                            borderY()
#ifndef TITLEBAR_BOTTOM
                                + wsTitleBar
#endif
                                ,
                            client()->handle(),
                            ShapeBounding, ShapeSet);
        if (titlebar()) {
            XRectangle rect;
            
            rect.x = borderX();
            rect.y = borderY();
            rect.width  = width() - 2 * borderX();
            rect.height = titlebar()->height();

            XShapeCombineRectangles(app->display(), handle(),
                                    ShapeBounding,
                                    0, 0, &rect, 1,
                                    ShapeUnion, Unsorted);
        }
        if (frameDecors() & fdResize) {
            XRectangle rect[4];

            rect[0].x = 0;
            rect[0].y = 0;
            rect[0].width = width();
            rect[0].height = borderY();

            rect[1] = rect[0];
            rect[1].y = height() - borderY();

            rect[2].x = 0;
            rect[2].y = borderY();
            rect[2].width = borderX();
            rect[2].height = height() - 2 * borderY();

            rect[3] = rect[2];
            rect[3].x = width() - borderX();
            
            XShapeCombineRectangles(app->display(), handle(),
                                    ShapeBounding,
                                    0, 0, rect, 4,
                                    ShapeUnion, Unsorted);
        }
    }
}
#endif

void YFrameWindow::configure(int x, int y, unsigned int width, unsigned int height) {
    //int oldX = this->x();
    //int oldY= this->y();
#ifdef SHAPE
    unsigned int oldWidth = this->width();
    unsigned int oldHeight = this->height();
#endif
    
    YWindow::configure(x, y, width, height);

    layoutTitleBar();

    layoutButtons();

    layoutResizeIndicators();

    layoutClient();
    
    // ?
    //if (x != oldX ||
    //    y != oldY)
    sendConfigure();
    
#ifdef SHAPE
    if (width != oldWidth || height != oldHeight)
        setShape();
#endif
    
}

void YFrameWindow::layoutTitleBar() {

    if (titleY() == 0) {
        titlebar()->hide();
    } else {
        titlebar()->show();

        int title_width = width() - 2 * borderX();
        MSG(("configure titlebar: width = %d", title_width - 2));
        titlebar()->setGeometry(borderX(),
                                borderY()
#ifdef TITLEBAR_BOTTOM
                                + height() - titleY() - 2 * borderY()
#endif
                                ,
                                (title_width > 0) ? title_width : 1,
                                titleY());
    }
}

void YFrameWindow::layoutButtons() {
    if (titleY() == 0)
        return ;
    
    int title_width = width() - 2 * borderX();

    unsigned long decors = frameDecors();

    if (decors & fdMinimize)
        fMinimizeButton->show();
    else
        fMinimizeButton->hide();

    if (decors & fdMaximize)
        fMaximizeButton->show();
    else
        fMaximizeButton->hide();

    if ((decors & fdClose) && useXButton)
        fCloseButton->show();
    else
        fCloseButton->hide();

    if (decors & fdSysMenu)
        fMenuButton->show();
    else
        fMenuButton->hide();

    int xPos = title_width;

    if (wmLook == lookWin95) {
        fMenuButton->setGeometry(0, 0, wsTitleBar, wsTitleBar);

        if ((decors & fdClose) && useXButton) {
            xPos -= titleY() + 1;
            fCloseButton->setGeometry(xPos, 2, titleY(), titleY() - 3);
            xPos -= 2;
        }


        if (decors & fdMaximize) {
            xPos -= titleY();
            fMaximizeButton->setGeometry(xPos, 2, titleY(), titleY() - 3);
        }

        if (decors & fdMinimize) {
            xPos -= titleY();
            fMinimizeButton->setGeometry(xPos, 2, titleY(), titleY() - 3);
        }
    } else if (wmLook == lookMotif || wmLook == lookWarp3 || wmLook == lookWarp4 || wmLook == lookNice) {
        fMenuButton->setGeometry(0, 0, wsTitleBar, wsTitleBar);
        
        if (decors & fdMaximize) {
            xPos -= titleY();
            fMaximizeButton->setGeometry(xPos, 0, titleY(), titleY());
        }
        if (decors & fdMinimize) {
            xPos -= titleY();
            fMinimizeButton->setGeometry(xPos, 0, titleY(), titleY());
        }
        if ((decors & fdClose) && useXButton) {
            xPos -= titleY();
            fCloseButton->setGeometry(xPos, 0, titleY(), titleY());
        }
    }
}

void YFrameWindow::layoutResizeIndicators() {
    if ((frameDecors() & fdResize) && !shaded()) {
        if (!indicatorsVisible) {
            indicatorsVisible = 1;

            XMapWindow(app->display(), topSide);
            XMapWindow(app->display(), leftSide);
            XMapWindow(app->display(), rightSide);
            XMapWindow(app->display(), bottomSide);

            XMapWindow(app->display(), topLeftCorner);
            XMapWindow(app->display(), topRightCorner);
            XMapWindow(app->display(), bottomLeftCorner);
            XMapWindow(app->display(), bottomRightCorner);
        }
    } else {
        if (indicatorsVisible) {
            indicatorsVisible = 0;
            
            XUnmapWindow(app->display(), topSide);
            XUnmapWindow(app->display(), leftSide);
            XUnmapWindow(app->display(), rightSide);
            XUnmapWindow(app->display(), bottomSide);

            XUnmapWindow(app->display(), topLeftCorner);
            XUnmapWindow(app->display(), topRightCorner);
            XUnmapWindow(app->display(), bottomLeftCorner);
            XUnmapWindow(app->display(), bottomRightCorner);
        }
    }
    if (!indicatorsVisible)
        return;

    XMoveResizeWindow(app->display(), topSide, 0, 0, width(), borderY());
    XMoveResizeWindow(app->display(), leftSide, 0, 0, borderX(), height());
    XMoveResizeWindow(app->display(), rightSide, width() - borderX(), 0, borderY(), height());
    XMoveResizeWindow(app->display(), bottomSide, 0, height() - borderY(), width(), borderY());
    
    XMoveResizeWindow(app->display(), topLeftCorner, 0, 0, wsCornerX, wsCornerY);
    XMoveResizeWindow(app->display(), topRightCorner, width() - wsCornerX, 0, wsCornerX, wsCornerY);
    XMoveResizeWindow(app->display(), bottomLeftCorner, 0, height() - wsCornerY, wsCornerX, wsCornerY);
    XMoveResizeWindow(app->display(), bottomRightCorner, width() - wsCornerX, height() - wsCornerY, wsCornerX, wsCornerY);
}

void YFrameWindow::layoutClient() {
    if (style & fsShaded) {
        fClientContainer->setGeometry(borderX(),
                                      borderY()
#ifndef TITLEBAR_BOTTOM
                                      + titleY()
#endif
                                      ,
                                      width() - 2 * borderX(),
                                      client()->height());

        fClient->setGeometry(0, 0,
                             width() - 2 * borderX(),
                             client()->height());
    } else {
        fClientContainer->setGeometry(borderX(),
                                      borderY()
#ifndef TITLEBAR_BOTTOM
                                      + titleY()
#endif
                                      ,
                                      width() - 2 * borderX(),
                                      height() - 2 * borderY() - titleY());
        fClient->setGeometry(0, 0,
                             width() - 2 * borderX(),
                             height() - 2 * borderY() - titleY());
    }
}

int YFrameWindow::canClose() {
    if (frameFunctions() & ffClose)
        return 1;
    else
        return 0;
}

int YFrameWindow::canMaximize() {
    if (frameFunctions() & ffMaximize)
        return 1;
    else
        return 0;
}

int YFrameWindow::canMinimize() {
    if (frameFunctions() & ffMinimize)
        return 1;
    else
        return 0;
}

int YFrameWindow::canShade() {
    if (frameFunctions() & ffShade)
        return 1;
    else
        return 0;
}

int YFrameWindow::canHide() {
    if (frameFunctions() & ffHide)
        return 1;
    else
        return 0;
}
