# Module: MkMaster.tk
# 25.4.96 T.Niederreiter
# 20.4.97 tn - rewrite for 0.96
# 
# External called functions:
# - MkMaster { w }: creates the master-menu 
#

# Creates the Master-CD-Menu

proc MkMaster { w } {
global sidebar

	log $w "entering Master-CD"
	
	mastersidebar

	# init some variables
	master:initvars 

	MkMasterSub 1 $w $sidebar.all
}


# button-handler - called when a sidebar button is pressed

proc MkMasterSub { id w but } {

	catch { destroy $w.all }
        frame $w.all
        pack $w.all -expand 1 -fill both
        set m $w.all

        deactivebutton $but.b1
        deactivebutton $but.b2
        deactivebutton $but.b3
        deactivebutton $but.b4
        deactivebutton $but.b5
        deactivebutton $but.b6
        deactivebutton $but.b8

	if { $id == 1 } {
		activebutton $but.b1
		MkMasterFrom $m
	}
	if { $id == 2 } {
		activebutton $but.b2
		setimgtype $m
	}
	if { $id == 3 } {
		activebutton $but.b3
		setisoheader $m
	}
	if { $id == 4 } {
		activebutton $but.b4
		masterimage $m
	}
	if { $id == 5 } {
		activebutton $but.b5
		writeimagedialog $m
	}
	if { $id == 6 } {
		activebutton $but.b6
		verify2imagedialog $m
	}

        if { $id == 8 } {
                activebutton $but.b8
                delaudiodialog $m data 
        }


}


# Display the master-sidebar

proc mastersidebar { } {
global sidebar
global statusbar
global maincanv
global XCDR_DEST_WRITER_DEV XCDR_AUDIO_SOURCE_CDROM XCDR_DATA_SOURCE_CDROM

        set w $sidebar.all
        catch { destroy $w }
        frame $w
        pack $w -expand 1 -fill both

	button $w.b1 -text "Master from/to" -command "MkMasterSub 1 $maincanv $w"
	button $w.b2 -text "Set Image-Type" -command "MkMasterSub 2 $maincanv $w"
	button $w.b3 -text "Set ISO-Header" -command "MkMasterSub 3 $maincanv $w"
	button $w.b4 -text "Master Image" -command "MkMasterSub 4 $maincanv $w"
	button $w.b5 -text "Write Image" -command "MkMasterSub 5 $maincanv $w"
	button $w.b6 -text "Verify burned Img." -command "MkMasterSub 6 $maincanv $w"
	button $w.b8 -text "Delete Images" -command "MkMasterSub 8 $maincanv $w"
	button $w.b7 -text "Back to Main" -command "master:cancel_cmd"

        tixForm $w.b1 -top %10 -left %10 -right %90
        tixForm $w.b2 -top %20 -left %10 -right %90
        tixForm $w.b3 -top %30 -left %10 -right %90
        tixForm $w.b4 -top %40 -left %10 -right %90
        tixForm $w.b5 -top %50 -left %10 -right %90
        tixForm $w.b6 -top %60 -left %10 -right %90
	tixForm $w.b8 -top %70 -left %10 -right %90
        tixForm $w.b7 -top %85 -left %10 -right %90

	tixBalloon $w.bal1 -state status -statusbar $statusbar -initwait 0
	$w.bal1 bind $w.b1 -msg "Select which data you want to master and where to store the generated Image"
	tixBalloon $w.bal2 -state status -statusbar $statusbar -initwait 0
	$w.bal2 bind $w.b2 -msg "Select the Image preferences"
	tixBalloon $w.bal3 -state status -statusbar $statusbar -initwait 0
	$w.bal3 bind $w.b3 -msg "Set the strings that will be saved in the ISO9660-Header"
	tixBalloon $w.bal4 -state status -statusbar $statusbar -initwait 0
	$w.bal4 bind $w.b4 -msg "Master the selected data and generate the new Image"
	tixBalloon $w.bal5 -state status -statusbar $statusbar -initwait 0
	$w.bal5 bind $w.b5 -msg "Write the Image to a CD-Recordable"
	tixBalloon $w.bal6 -state status -statusbar $statusbar -initwait 0
	$w.bal6 bind $w.b6 -msg "Verify the just burned CD with the Image"
	tixBalloon $w.bal7 -state status -statusbar $statusbar -initwait 0
	$w.bal7 bind $w.b7 -msg "Go back to the main menu"
        tixBalloon $w.bal8 -state status -statusbar $statusbar -initwait 0
        $w.bal8 bind $w.b8 -msg "Delete Image-Files or Audio-Tracks"

	
	# disable buttons that need a CD-ROM
	if { $XCDR_DATA_SOURCE_CDROM == "" } {
		$w.b6 config -state disabled
	}

        # disable buttons that need a Writer-Device
        if { $XCDR_DEST_WRITER_DEV == "" } {
                $w.b5 config -state disabled
        }
}


# returns the the main-menu

proc master:cancel_cmd { } {

	mainsidebar
}


# inits some vars for mastering

proc master:initvars { } {
global ISOtag
global MSTR_TYPE
global ISOtypes

        # predefine available types and their names 
        set ISOtag(urr) "Unix Rock-Ridge"
	set ISOtag(rrw) "Rock-Ridge + Win95/NT"
        set ISOtag(w95) "Win95/NT (long filenames)"
        set ISOtag(dos) "MS-DOS"
        set ISOtag(cust) "Custom"

	if { $MSTR_TYPE == "" } {
		set MSTR_TYPE "urr"
		
		# try to load the defaultsfile
		mstrloadtype 
		mstrloadheader
	}

	newimgtype $MSTR_TYPE
}


# called when the user double-clicks on the dirlist
# in the master from/to-menu

proc master:dirlist_click { widget dir } {
global MSTR_DIR

	# write the actual dir in the entry-widget
	set w [$widget subwidget entry]
	$w delete 0 end
	$w insert end $dir
	set MSTR_DIR $dir
}


# called when the user presses return in the dir-entry
# in the master from/to-menu

proc master:dirlist_return { w dirlist entry } {
global MSTR_DIR

	# get value from entry-widget
	set ent [$entry subwidget entry]
	set val [$ent get]

	# check if this is an valid directory
	if { [file isdirectory $val] == 0 } {
		Msg_NoMasterDir .invdir .root
		$ent delete 0 end
		set MSTR_DIR ""
		return
	}
	
	$dirlist config -value $val
	set MSTR_DIR $val
}


# called when the add-exclude-path button is pressed
# in the master from/to-menu

proc master:addpath { entry listbox } {
global MSTR_EXPATHLIST

	# get value from entry-widget
	set ent [$entry subwidget entry]
	set val [string trim [$ent get]]

	# check if this is an valid directory
	if { [file isdirectory $val] == 0 } {
		Msg_InvMasterExPath .invdir .root
		$ent delete 0 end
		return
	}

	set lb [$listbox subwidget listbox]
	$lb insert end "$val"

	set MSTR_EXPATHLIST [$lb get 0 end]
}


# called when the del-exclude-path button is pressed
# in the master from/to-menu

proc master:delpath { listbox } {
global MSTR_EXPATHLIST

	set lb [$listbox subwidget listbox]

	# delete the current selected entry
	set sel [$lb curselection]

	# nothing selected?
	if { $sel == "" } {
		Msg_InvMasterDelExPath .invdir .root
		return
	}
	$lb del $sel
	set MSTR_EXPATHLIST [$lb get 0 end]
}


# called when the add-exclude-glob button is pressed
# in the master from/to-menu

proc master:addglob { entry listbox } {
global MSTR_EXGLOBLIST

	# get value from entry-widget
	set ent [$entry subwidget entry]
	set val [string trim [$ent get]]

	#ignore empty strings
	if { $val == "" } {
		return
	}
	set lb [$listbox subwidget listbox]
	$lb insert end "$val"
	set MSTR_EXGLOBLIST [$lb get 0 end]

}


# called when the del-exclude-glob button is pressed
# in the master from/to-menu

proc master:delglob { listbox } {
global MSTR_EXGLOBLIST

	set lb [$listbox subwidget listbox]

	# delete the current selected entry
	set sel [$lb curselection]

	# nothing selected?
	if { $sel == "" } {
		Msg_InvMasterDelExGlob .invdir .root
		return
	}
	$lb del $sel
	set MSTR_EXGLOBLIST [$lb get 0 end]

}


# called by the reset-settings button
# in the master from/to-menu

proc master:reset { w } {
global MSTR_EXGLOBLIST
global MSTR_EXPATHLIST
global MSTR_DIR

	set ent [$w.m.l.ent subwidget entry]
	$ent delete 0 end
	set MSTR_DIR ""

	set ent [$w.m.r.1.exclude subwidget entry]
	$ent delete 0 end
	set lb [$w.m.r.2.ex2 subwidget listbox]
	$lb delete 0 end
	set MSTR_EXPATHLIST ""

	set ent [$w.m.r.3.exclude subwidget entry]
	$ent delete 0 end
	set lb [$w.m.r.4.ex2 subwidget listbox]
	$lb delete 0 end
	set MSTR_EXGLOBLIST ""
}

 
# Master from/to - Menu

proc MkMasterFrom { w } {
global MSTR_DATA_PART
global MSTR_DATA_MNTPNT
global MSTR_FROM
global MSTR_DIR
global MSTR_TYPE
global MSTR_EXPATHLIST
global MSTR_EXGLOBLIST
global MSTR_VOLID MSTR_PUBID MSTR_PREID MSTR_APPID
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_SPEED
global XCDR_DEFAULT_PART
global XCDR_IMAGE_PART
global XCDR_IMAGE_MNTPNT
global XCDR_IMAGE_PART2
global XCDR_IMAGE_MNTPNT2
global XCDR_IMAGE_FIXED
global TMP_XCDR_DEFAULT_PART

        # Draw header-bar
        label $w.l -text "MASTER FROM/TO" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

        # Create Devices-Setup
        tixLabelFrame $w.devs -label Devices-Setup 
        set w1 [$w.devs subwidget frame]
        pack $w.devs -expand 1 -fill x

        frame $w1.2
        tixLabelWidget $w1.2.imgl -label "Master to (Image-Device) : " \
                -options {label.width 25 label.anchor e}
        message $w1.2.imgt -anchor w -width 300 -relief groove  
        $w1.2.imgt configure -text "\n\n" 

        set tmpval $TMP_XCDR_DEFAULT_PART
        unset TMP_XCDR_DEFAULT_PART

        # prepare the quick-image-select menu
        tixOptionMenu $w1.2.select -variable TMP_XCDR_DEFAULT_PART \
                -options { label.width 0 menubutton.width 12 } \
                -command "quickselimage $w1 $w"

        if { $XCDR_IMAGE_PART != "" && $XCDR_IMAGE_MNTPNT != "" } {
                $w1.2.select add command "Partition 1"
        }
        if { $XCDR_IMAGE_PART2 != "" && $XCDR_IMAGE_MNTPNT2 != "" } {
                $w1.2.select add command "Partition 2"
        }
        if { $XCDR_IMAGE_FIXED != "" } {
                $w1.2.select add command "Image-Path"
        }

        if { $XCDR_DEFAULT_PART == "1" } {
                catch { $w1.2.select configure -value "Partition 1" }
        }       
        if { $XCDR_DEFAULT_PART == "2" } {
                catch { $w1.2.select configure -value "Partition 2" }
        }       
        if { $XCDR_DEFAULT_PART == "3" } {
                catch { $w1.2.select configure -value "Image-Path" }
        }       
        if { $tmpval != "" } {
                catch { $w1.2.select configure -value $tmpval }
        }

        tixForm $w1.2.imgl -left %0
        tixForm $w1.2.imgt -left %32 -right %80
        tixForm $w1.2.select -left %82 -right %99

        frame $w1.3
        tixLabelWidget $w1.3.writel -label "Write-Device : " \
                -options {label.width 25 label.anchor e}
        message $w1.3.writet -anchor w -width 300 -relief groove
        $w1.3.writet configure -text $XCDR_DEST_WRITER_DEV
        label $w1.3.spd -text "Speed: $XCDR_DEST_WRITER_SPEED x"

        tixForm $w1.3.writel -left %0
        tixForm $w1.3.writet -left %32 -right %80
        tixForm $w1.3.spd -left %82
        
        pack $w1.2 $w1.3 -side top -expand 1 -fill x

        #-------------------------------------------------

        # Tile the window, create a left and a right frame
        frame $w.m
        frame $w.m.l
        frame $w.m.r
        pack $w.m.l $w.m.r -side left -pady 10 -padx 10
        pack $w.m

	tixLabelEntry $w.m.l.ent -label "Directory with data to master:" \
		-labelside top -options {
			entry.width 30 
			label.anchor w
		}
	tixDirList $w.m.l.dl -width 250 \
		-showhidden 1 \
		-disablecallback 1 \
		-command "master:dirlist_click $w.m.l.ent"
	pack $w.m.l.dl
	pack $w.m.l.ent

	# bind Return to entry-widget 
	bind $w.m.l.ent.frame.entry <Return> \
		"master:dirlist_return $w $w.m.l.dl $w.m.l.ent"

	# allow callback again
        $w.m.l.dl config -disablecallback 0

	frame $w.m.r.1
	pack $w.m.r.1
	tixLabelEntry $w.m.r.1.exclude -label "Exclude paths:" \
		-labelside top -options {
			entry.width 20
			label.anchor w
		}
	button $w.m.r.1.add -text "Add Path" \
		-command "master:addpath $w.m.r.1.exclude $w.m.r.2.ex2"

	# bind Return to entry-widget (same as add-button)
	bind $w.m.r.1.exclude.frame.entry <Return> \
		"master:addpath $w.m.r.1.exclude $w.m.r.2.ex2"

	tixForm $w.m.r.1.exclude -left %0 -right %80
	tixForm $w.m.r.1.add -left %80 -right %100 -bottom %100
	
	frame $w.m.r.2
	pack $w.m.r.2
	tixScrolledListBox $w.m.r.2.ex2 -scrollbar auto -options {
		listbox.height 3
	}
	button $w.m.r.2.del -text "Del Path" \
		-command "master:delpath $w.m.r.2.ex2"

	# bind Del to entry-widget 
	bind $w.m.r.2.ex2.listbox <Delete> \
		 "master:delpath $w.m.r.2.ex2"

	tixForm $w.m.r.2.ex2 -left %0 -right %80
	tixForm $w.m.r.2.del -left %80 -right %100

	frame $w.m.r.3
	pack $w.m.r.3
	tixLabelEntry $w.m.r.3.exclude -label "Exclude globs:" \
		-labelside top -options {
			entry.width 20
			label.anchor w
		}
	button $w.m.r.3.add -text "Add Glob" \
		-command "master:addglob $w.m.r.3.exclude $w.m.r.4.ex2"

	# bind Return to entry-widget (same as add-button)
	bind $w.m.r.3.exclude.frame.entry <Return> \
		"master:addglob $w.m.r.3.exclude $w.m.r.4.ex2"

	tixForm $w.m.r.3.exclude -left %0 -right %80
	tixForm $w.m.r.3.add -left %80 -right %100 -bottom %100
	
	frame $w.m.r.4
	pack $w.m.r.4
	tixScrolledListBox $w.m.r.4.ex2 -scrollbar auto -options {
		listbox.height 3
	}
	button $w.m.r.4.del -text "Del Glob" \
		-command "master:delglob $w.m.r.4.ex2"

	# bind Del to entry-widget 
	bind $w.m.r.4.ex2.listbox <Delete> \
		 "master:delglob $w.m.r.4.ex2"

	tixForm $w.m.r.4.ex2 -left %0 -right %80
	tixForm $w.m.r.4.del -left %80 -right %100

	# now set old values set in a prior call to this menu
	if { $MSTR_DIR != "" } {
		# directory exists?
		if { [file isdirectory $MSTR_DIR] == 1 } {
			# activate this directory
		 	master:dirlist_click $w.m.l.ent $MSTR_DIR
			$w.m.l.dl config -value $MSTR_DIR
		} else {
			set $MSTR_DIR ""
		}
	}
	if { $MSTR_EXPATHLIST != "" } {
		foreach i $MSTR_EXPATHLIST {
			set ent [$w.m.r.2.ex2 subwidget listbox]
			$ent insert end $i
		}	
	}
	if { $MSTR_EXGLOBLIST != "" } {
		foreach i $MSTR_EXGLOBLIST {
			set ent [$w.m.r.4.ex2 subwidget listbox]
			$ent insert end $i
		}	
	}

        #----------------------------------------------

        canvas $w.30 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.30 -pady 5 -fill x -expand 1

	button $w.preview -text "Preview CD-Contents" \
		-command "masterpreviewcd .masterpreview $w"
	button $w.reset -text "Reset Settings" \
		-command "master:reset $w"

	pack $w.preview $w.reset -pady 10 -side left -expand 1

}


# Called by Preview-CD-Contents-button

proc masterpreviewcd { w wroot } {
global MSTR_DIR

	# create new window
	set oldf [createsubwindow $w .root 2 ""]

	tixLabelFrame $w.l -label "Preview CD-Contents before Mastering:"
	set w1 [$w.l subwidget frame]
	pack $w.l -expand 1 -fill both

	tixScrolledListBox $w1.b -scrollbar auto -options {
		listbox.width 45
		listbox.height 12
	}

	pack $w1.b -expand 1 -fill both

        frame $w.1
        tixLabelWidget $w.1.imgsize -label "Image-Size : " \
                -options { label.width 15 label.anchor e }
        message $w.1.imgsizeval -width 150 -relief sunken -borderwidth 1 \
                -text "unknown"
        button $w.1.calc -text "Calculate Size" -bd 1 \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "mstrupdatesize $w.1.imgsizeval .root"

        pack $w.1 -fill x -expand 1 -padx 10 -pady 5 
        tixForm $w.1.imgsize -left %0
        tixForm $w.1.imgsizeval -left %35 -right %68
        tixForm $w.1.calc -left %70 -right %95 


	button $w.cancel -text "Done" \
		-command "destroysubwindow $w .root {$oldf} 2"
	pack $w.cancel -pady 5 -side left -expand 1


	# No directory set?
	if { $MSTR_DIR == "" } {
		$w1.b subwidget listbox insert 0 \
			"" "" "" "" "" "" "                           No Master-Directory set!"

		tkwait window $w
		return
	}	

	set out [getdircontents $MSTR_DIR]

	# no such directory?
	if { $out == -1 } {
		$w1.b subwidget listbox insert 0 \
			"" "" "" "" "" "" "                            Invalid Directory!"
		tkwait window $w
		return
	}

	foreach i $out {
		# check if excluded by glob or path
		if { [check_if_exclude $i] == 0 } {	
			$w1.b subwidget listbox insert end $i
		}
	}

	tkwait window $w
}


# look if this filename is excluded by glob of path
# return 1 if so

proc check_if_exclude { file } {
global MSTR_EXGLOBLIST
global MSTR_EXPATHLIST
global MSTR_DIR

	# check for path first
	set idx [string length $file]
	# we found a directory
	if { [string index $file [expr $idx-1]] == "/" } {
		# construct full name (with path)
		set name [string range $file 0 [expr $idx-2]]
		if { $MSTR_DIR == "/" } {
			set fullname "/$name"
		} else {
			set fullname "$MSTR_DIR/$name"
		}

		# search exclude list
		# if one match found, return 1 to indicate skip
		foreach i $MSTR_EXPATHLIST {
			if { $i == $fullname } {
				return 1
			}
		}
	}

	# now check for globs. (globs also apply to directories)

	# first skip any last special char (/,*,|,=,@)
	set lastchar [string index $file [expr $idx-1]]
	if { $lastchar == "/" || $lastchar == "*" || $lastchar == "|" ||
	     $lastchar == "=" || $lastchar == "@" } {
		set file [string range $file 0 [expr $idx-2]]
	}
	
	# search exclude list
	# if one match found, return 1 to indicate skip
	foreach i $MSTR_EXGLOBLIST {
		if { [string match $i $file] == 1 } {
			return 1
		}
	}

	# not matched, display filename
	return 0
}


# Called by Review-Image-Contents-button

proc masterreviewimage { w wroot } {
global TMP_DESTNAME 
global TMP_DEST
global IMAGE_MNTPNT
global IMAGE_PART

        # Sets the image-destination
        if { $TMP_DEST == "file" } {
                # Image to file
                set imgfile [ file tail $TMP_DESTNAME]
                set imagedest "$IMAGE_MNTPNT/$imgfile"
        } else {
                # Image to partition
                set imagedest $IMAGE_PART
        }

        if {[checkifiso $imagedest] == 0 } {
                set NONISO 1
        } else {
                set NONISO 0
        }

        if { [file exists $imagedest] == 0 } {
		# This way we run this check later, where it is 
		# proper handled
                set NONISO 0
        }


	# create new window
	set oldf [createsubwindow $w .root 2 ""]

	tixLabelFrame $w.l -label "Contents of Image-Root-Directory:"
	set w1 [$w.l subwidget frame]
	pack $w.l -expand 1 -fill both

	tixScrolledListBox $w1.b -scrollbar auto -options {
		listbox.width 45
		listbox.height 12
	}

	pack $w1.b -expand 1 -fill both

        frame $w.16
        tixLabelWidget $w.16.imglabel -label "Image-ISO9660-Label : " \
                -options { label.width 22 label.anchor e }
        message $w.16.imglabelval -width 250 -relief sunken -borderwidth 1 \
                -text ""
        pack $w.16 -fill x -expand 1 -padx 10 -pady 5 
        tixForm $w.16.imglabel -left %0
        tixForm $w.16.imglabelval -left %50 -right %98

        frame $w.17
        tixLabelWidget $w.17.imglabel -label "Image-Size : " \
                -options { label.width 22 label.anchor e }
        message $w.17.imglabelval -width 250 -relief sunken -borderwidth 1 \
                -text ""
        pack $w.17 -fill x -expand 1 -padx 10 -pady 5 
        tixForm $w.17.imglabel -left %0
        tixForm $w.17.imglabelval -left %50 -right %98

	button $w.cancel -text "Done" \
		-command "destroysubwindow $w .root {$oldf} 2"
	pack $w.cancel -pady 5 -side left -expand 1


	if { $NONISO == 0 } {
		# only ISO-filesystems can be shown
		set out [getimagecontents $imagedest]
	} else {
		set out -2
	}

	# no such directory?
	if { $out == -1 } {
		$w1.b subwidget listbox insert 0 \
			"" "" "" "" "" "" "                                 Invalid Image!"

		tkwait window $w
		return
	}

	# NON-ISO
	if { $out == -2 } {
		$w1.b subwidget listbox insert 0 \
			"" "" "" "" "" "" "                                 NON-ISO9660 Image!"

		tkwait window $w
		return
	}

	foreach i $out {
		$w1.b subwidget listbox insert end $i
	}


	if { $TMP_DEST == "file" } {
		set size [file size $imagedest] 
	} else {
		set size [getisosize $imagedest]
	}	
	set size [expr $size/1024/1024]
	$w.17.imglabelval config -text "$size MB"

	set label [getisolabel $imagedest]
	$w.16.imglabelval config -text "$label"

	
	tkwait window $w
}


# Called by the Set-Image-Type-Button

proc setimgtype { w } {
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_SPEED
global ISOtypes
global ISOtag
global MSTR_TYPE
global MSTR_DIR
global XCDR_DEFAULT_PART
global IMAGE_LABEL

	# Draw header-bar
	label $w.l -text "SET IMAGE TYPE" -relief sunken -borderwidth 2 -anchor c
	pack $w.l -fill x -expand 1 -ipady 10 -pady 5

        # Create Devices-Setup
        tixLabelFrame $w.devs -label Devices-Setup 
        set w1 [$w.devs subwidget frame]
        pack $w.devs -expand 1 -fill x

        frame $w1.1
        tixLabelWidget $w1.1.readl -label "Master from : " \
                -options {label.width 25 label.anchor e}
        message $w1.1.readt -anchor w -width 300 -relief groove
	if { $MSTR_DIR != "" } {
        	$w1.1.readt configure -text $MSTR_DIR
	} else {
        	$w1.1.readt configure -text "Not set yet" 
	}
        tixForm $w1.1.readl -left %0
        tixForm $w1.1.readt -left %32 -right %80

        frame $w1.2
        tixLabelWidget $w1.2.imgl -label "Save Image on : " \
                -options {label.width 25 label.anchor e}
        message $w1.2.imgt -anchor w -width 300 -relief groove  
        label $w1.2.lbl -text "\[$IMAGE_LABEL\]"
        redraw_imagebox $w1.2.imgt

        tixForm $w1.2.imgl -left %0
        tixForm $w1.2.imgt -left %32 -right %80
        tixForm $w1.2.lbl -left %82 

        frame $w1.3
        tixLabelWidget $w1.3.writel -label "Write-Device : " \
                -options {label.width 25 label.anchor e}
        message $w1.3.writet -anchor w -width 300 -relief groove
        $w1.3.writet configure -text $XCDR_DEST_WRITER_DEV
        label $w1.3.spd -text "Speed: $XCDR_DEST_WRITER_SPEED x"

        tixForm $w1.3.writel -left %0
        tixForm $w1.3.writet -left %32 -right %80
        tixForm $w1.3.spd -left %82

        pack $w1.1 $w1.2 $w1.3 -side top -expand 1 -fill x

        #-------------------------------------------------

	set tmpval $MSTR_TYPE
	unset MSTR_TYPE

	tixOptionMenu $w.opt -label "Select Image-Type : " \
		-variable MSTR_TYPE -command "newimgtype" \
		-options { label.width 25 label.anchor e menubutton.width 25 }

	# We disable callback here, because the command connected to
	# the Options would delete our ISOtypes-array.
	$w.opt configure -disablecallback 1
	$w.opt add command urr -label $ISOtag(urr) 
	$w.opt add command rrw -label $ISOtag(rrw) 
	$w.opt add command w95 -label $ISOtag(w95) 
	$w.opt add command dos -label $ISOtag(dos)
	$w.opt add command cust -label $ISOtag(cust)
	$w.opt configure -disablecallback 0

	catch { $w.opt configure -value $tmpval }

	pack $w.opt

	tixLabelFrame $w.f -label "ISO-Filesystem Options"
	set f [$w.f subwidget frame]
	pack $w.f

	frame $f.l 
	frame $f.r
	pack $f.l $f.r -side left

	checkbutton $f.l.b1 -text "Include all files" \
		-variable ISOtypes(1) -onvalue "-a" -offvalue "" \
		-command "entercustom $w.opt"
	checkbutton $f.l.b2 -text "Follow symb. Links" \
		-variable ISOtypes(2) -onvalue "-f" -offvalue "" \
		-command "entercustom $w.opt"
	checkbutton $f.l.b3 -text "Allow long (32-char) filenames" \
		-variable ISOtypes(3) -onvalue "-l" -offvalue "" \
		-command "entercustom $w.opt"
	checkbutton $f.l.b4 -text "Enable Rock Ridge extensions" \
		-variable ISOtypes(4) -onvalue "-R" -offvalue "" \
		-command "entercustom $w.opt"
	checkbutton $f.l.b5 -text "Rock Ridge with anonymity" \
		-variable ISOtypes(5) -onvalue "-r" -offvalue "" \
		-command "entercustom $w.opt"
	checkbutton $f.r.b6 -text "Create TRANS.TBL-files" \
		-variable ISOtypes(6) -onvalue "-T" -offvalue "" \
		-command "entercustom $w.opt"
	checkbutton $f.r.b7 -text "Omit trailing periods" \
		-variable ISOtypes(7) -onvalue "-d" -offvalue "" \
		-command "entercustom $w.opt"
	checkbutton $f.r.b8 -text "Do not use deep dir. relocation" \
		-variable ISOtypes(8) -onvalue "-D" -offvalue "" \
		-command "entercustom $w.opt"
	checkbutton $f.r.b9 -text "Allow files beginning with a dot" \
		-variable ISOtypes(9) -onvalue "-L" -offvalue "" \
		-command "entercustom $w.opt"
	checkbutton $f.r.b10 -text "Omit ISO version numbers" \
		-variable ISOtypes(10) -onvalue "-N" -offvalue "" \
		-command "entercustom $w.opt"
	checkbutton $f.l.b11 -text "Enable Joliet extensions" \
		-variable ISOtypes(11) -onvalue "-J" -offvalue "" \
		-command "entercustom $w.opt"
 
	pack $f.l.b1 $f.l.b2 $f.l.b3 $f.l.b4 $f.l.b5 $f.l.b11 -anchor w
	pack $f.r.b6 $f.r.b7 $f.r.b8 $f.r.b9 $f.r.b10 -anchor w 

        #----------------------------------------------

        canvas $w.30 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.30 -pady 5 -fill x -expand 1

        button $w.save -text "Save as default" \
		-command "mstrsavetype $w"

        pack $w.save -pady 5 -side left -expand 1

}


# save the current setup of the master-type window

proc mstrsavetype { w } {
global ISOtypes
global ISOtag
global MSTR_TYPE
global MSTRTYPEFILE
global CONFDIR

	# open file for writing
	set fileid [open $CONFDIR/$MSTRTYPEFILE w]
	chownfile $CONFDIR/$MSTRTYPEFILE

	puts $fileid "$MSTR_TYPE"

	for { set i 1 } { $i <= 11 } { incr i } {
		puts $fileid "$ISOtypes($i)"
	}

	close $fileid

	Msg_CfgSaved .cfgsave .root
}


# load the master-type config-file

proc mstrloadtype { } {
global ISOtypes
global ISOtag
global MSTR_TYPE
global MSTRTYPEFILE
global CONFDIR

	# open file for reading 
	set opnflg [catch { set fileid [open $CONFDIR/$MSTRTYPEFILE r] }]

	# no such file
	if { $opnflg != 0 } {
		return -1
	}

	gets $fileid MSTR_TYPE

	for { set i 1 } { $i <= 11 } { incr i } {
		gets $fileid ISOtypes($i)
	}

	close $fileid

}


# Called when the user chooses a new ISO-Type from the OptionMenu

proc newimgtype { value } {
global ISOtypes

	# Full control-string for reference:
	#      { "-a" "-f" "-l" "-R" "-r" "-T" "-d" "-D" "-L" "-N" "-J" } 

	# Set default-values for each type
	switch $value {

		"urr" {
		set ctrl { "-a" "" "-l" "" "-r" "" "" "" "-L" "" "" }
		}

		"rrw" {
		set ctrl { "-a" "" "-l" "" "-r" "" "" "-D" "-L" "" "-J" }
		}
	
		"w95" {
		set ctrl { "-a" "" "-l" "" "" "" "" "-D" "-L" "" "-J" }
		}

		"dos" {
		set ctrl { "-a" "" "" "" "" "" "" "" "" "" "" }
		}

		"cust" {
			return
		}
	}

	set i 1
	foreach j $ctrl {
	 	set ISOtypes($i) $j
		incr i
	}
}


# This is called when a user presses a checkbutton in the set-type-menu
# We consider this as the wish to enter a custom-config

proc entercustom { w } {

	$w configure -value "cust"
}


# Called by the Set-ISO-Header Button

proc setisoheader { w } {
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_SPEED
global XCDR_DEFAULT_PART
global IMAGE_LABEL
global MSTR_DIR
global MSTR_VOLID
global MSTR_PUBID
global MSTR_PREID
global MSTR_APPID

	# Draw header-bar
	label $w.l -text "SET ISO9660-HEADER-STRINGS" -relief sunken -borderwidth 2 -anchor c
	pack $w.l -fill x -expand 1 -ipady 10 -pady 5

        # Create Devices-Setup
        tixLabelFrame $w.devs -label Devices-Setup 
        set w1 [$w.devs subwidget frame]
        pack $w.devs -expand 1 -fill x

        frame $w1.1
        tixLabelWidget $w1.1.readl -label "Master from : " \
                -options {label.width 25 label.anchor e}
        message $w1.1.readt -anchor w -width 300 -relief groove
        if { $MSTR_DIR != "" } {
                $w1.1.readt configure -text $MSTR_DIR
        } else {
                $w1.1.readt configure -text "Not set yet" 
        }
        tixForm $w1.1.readl -left %0
        tixForm $w1.1.readt -left %32 -right %80

        frame $w1.2
        tixLabelWidget $w1.2.imgl -label "Save Image on : " \
                -options {label.width 25 label.anchor e}
        message $w1.2.imgt -anchor w -width 300 -relief groove  
        label $w1.2.lbl -text "\[$IMAGE_LABEL\]"
        redraw_imagebox $w1.2.imgt

        tixForm $w1.2.imgl -left %0
        tixForm $w1.2.imgt -left %32 -right %80
        tixForm $w1.2.lbl -left %82 

        frame $w1.3
        tixLabelWidget $w1.3.writel -label "Write-Device : " \
                -options {label.width 25 label.anchor e}
        message $w1.3.writet -anchor w -width 300 -relief groove
        $w1.3.writet configure -text $XCDR_DEST_WRITER_DEV
        label $w1.3.spd -text "Speed: $XCDR_DEST_WRITER_SPEED x"

        tixForm $w1.3.writel -left %0
        tixForm $w1.3.writet -left %32 -right %80
        tixForm $w1.3.spd -left %82

        pack $w1.1 $w1.2 $w1.3 -side top -expand 1 -fill x

        #-------------------------------------------------

	tixLabelEntry $w.e1 -label "Volume-ID: " \
		-options { entry.width 32 label.width 14 entry.textVariable MSTR_VOLID }
	tixLabelEntry $w.e2 -label "Publisher-ID: " \
		-options { entry.width 64 label.width 14 entry.textVariable MSTR_PUBID }
	$w.e2.frame.entry config -xscrollcommand "$w.f1.s2 set"
	frame $w.f1
	scrollbar $w.f1.s2 -orient horiz -command "$w.e2.frame.entry xview" 

	tixLabelEntry $w.e3 -label "Preparer-ID: " \
		-options { entry.width 64 label.width 14 entry.textVariable MSTR_PREID }
	$w.e3.frame.entry config -xscrollcommand "$w.f2.s3 set"
	frame $w.f2
	scrollbar $w.f2.s3 -orient horiz -command "$w.e3.frame.entry xview"
	tixLabelEntry $w.e4 -label "Application-ID: " \
		-options { entry.width 64 label.width 14 entry.textVariable MSTR_APPID }
	$w.e4.frame.entry config -xscrollcommand "$w.f3.s4 set"
	frame $w.f3
	scrollbar $w.f3.s4 -orient horiz -command "$w.e4.frame.entry xview"

	# this generates some free space between the sliders
	label $w.tmp 
	label $w.tmp2
	label $w.tmp3

	pack $w.e1 -anchor w -padx 10

	pack $w.tmp
	pack $w.e2 -anchor w -padx 10
	pack $w.f1 -padx 10 -fill x
	tixForm $w.f1.s2 -left %18 -right %100

	pack $w.tmp2
	pack $w.e3 -anchor w -padx 10
	pack $w.f2 -padx 10 -fill x
	tixForm $w.f2.s3 -left %18 -right %100

	pack $w.tmp3
	pack $w.e4 -anchor w -padx 10
	pack $w.f3 -padx 10 -fill x
	tixForm $w.f3.s4 -left %18 -right %100

        #----------------------------------------------

        canvas $w.30 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.30 -pady 5 -fill x -expand 1

	button $w.b2 -text "Clear Entries" -command "clearisoheader $w"
	button $w.b1 -text "Read ID's from CD" -command "readisoheader"
	button $w.b3 -text "Save as default" \
		-command "mstrsavestrings $w"
	pack $w.b1 $w.b2 $w.b3 -side left -pady 10 -expand 1

}


# save the current setup of the master-iso-strings window

proc mstrsavestrings { w } {
global MSTRHEADER
global CONFDIR
global MSTR_VOLID
global MSTR_PUBID
global MSTR_PREID
global MSTR_APPID

	# open file for writing
	set fileid [open $CONFDIR/$MSTRHEADER w]
	chownfile $CONFDIR/$MSTRHEADER

	puts $fileid "$MSTR_VOLID"
	puts $fileid "$MSTR_PUBID"
	puts $fileid "$MSTR_PREID"
	puts $fileid "$MSTR_APPID"

	close $fileid

	Msg_CfgSaved .cfgsave .root
}


# load the master-header config-file

proc mstrloadheader { } {
global MSTRHEADER
global CONFDIR
global MSTR_VOLID
global MSTR_PUBID
global MSTR_PREID
global MSTR_APPID

	# open file for reading 
	set opnflg [catch { set fileid [open $CONFDIR/$MSTRHEADER r] }]

	# no such file
	if { $opnflg != 0 } {
		return -1
	}

	gets $fileid MSTR_VOLID
	gets $fileid MSTR_PUBID
	gets $fileid MSTR_PREID
	gets $fileid MSTR_APPID

	close $fileid
}


# Called by the clear-entries-button in setisoheader

proc clearisoheader { w } {
global MSTR_VOLID
global MSTR_PUBID
global MSTR_PREID
global MSTR_APPID

	set stat [Msg_ClearISOstrings .clrisoheader .root ]
	if { $stat == 0 } {	;# Yes
		set MSTR_VOLID ""
		set MSTR_PUBID ""
		set MSTR_PREID ""
		set MSTR_APPID ""
	}
}


# Called by the read-entries-button in setisoheader

proc readisoheader {} {
global ISODETECT
global MSTR_VOLID
global MSTR_PUBID
global MSTR_PREID
global MSTR_APPID

	set stat [Msg_ReadISOstrings .clrisoheader .root]
	if { $stat == 0 } {	;# Yes
		set dev [ convCD2block data ]
	
		catch { set MSTR_VOLID [ exec $ISODETECT -V -d $dev ] } 
		catch { set MSTR_PUBID [ exec $ISODETECT -P -d $dev ] } 
		catch { set MSTR_PREID [ exec $ISODETECT -p -d $dev ] } 
		catch { set MSTR_APPID [ exec $ISODETECT -A -d $dev ] } 
	}
}


# Show the Master-Image-Dialog

proc masterimage { w } {
global IMAGE_PART
global IMAGE_MNTPNT
global XCDR_DEFAULT_PART
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_SPEED
global IMAGE_LABEL
global TMP_DESTNAME
global TMP_DEST
global MSTR_DIR
global MSTR_TYPE
global ISOtag
global remount_active
global TMP_freespace
global TMP_spaceused
global MSTR_VOLID
global MSTR_PUBID
global MSTR_PREID
global MSTR_APPID

	# Tailor the header-strings to the right max. length
	set MSTR_VOLID [string range $MSTR_VOLID 0 31]
	set MSTR_PUBID [string range $MSTR_PUBID 0 127]
	set MSTR_PREID [string range $MSTR_PREID 0 127]
	set MSTR_APPID [string range $MSTR_APPID 0 127]


        # This is needed for the "file"-radiobutton. If you press this
        # button, and its needed to format the partition, this value
        # is used to find out if the programm itself triggered the 
        # button or the user. The programm invokes the button to 
        # ensure mounting after formatting.
        set remount_active 0

        # Draw header-bar
        label $w.l -text "MASTER IMAGE" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

        # Create Devices-Setup
        tixLabelFrame $w.devs -label Devices-Setup 
        set w1 [$w.devs subwidget frame]
        pack $w.devs -expand 1 -fill x

        frame $w1.1
        tixLabelWidget $w1.1.readl -label "Master from : " \
                -options {label.width 25 label.anchor e}
        message $w1.1.readt -anchor w -width 300 -relief groove
        if { $MSTR_DIR != "" } {
                $w1.1.readt configure -text $MSTR_DIR
        } else {
                $w1.1.readt configure -text "Not set yet" 
        }
        tixForm $w1.1.readl -left %0
        tixForm $w1.1.readt -left %32 -right %80

        frame $w1.2
        tixLabelWidget $w1.2.imgl -label "Save Image on : " \
                -options {label.width 25 label.anchor e}
        message $w1.2.imgt -anchor w -width 300 -relief groove  
        label $w1.2.lbl -text "\[$IMAGE_LABEL\]"
        redraw_imagebox $w1.2.imgt

        tixForm $w1.2.imgl -left %0
        tixForm $w1.2.imgt -left %32 -right %80
        tixForm $w1.2.lbl -left %82 

        frame $w1.3
        tixLabelWidget $w1.3.writel -label "Write-Device : " \
                -options {label.width 25 label.anchor e}
        message $w1.3.writet -anchor w -width 300 -relief groove
        $w1.3.writet configure -text $XCDR_DEST_WRITER_DEV
        label $w1.3.spd -text "Speed: $XCDR_DEST_WRITER_SPEED x"

        tixForm $w1.3.writel -left %0
        tixForm $w1.3.writet -left %32 -right %80
        tixForm $w1.3.spd -left %82

        pack $w1.1 $w1.2 $w1.3 -side top -expand 1 -fill x

        #-------------------------------------------------

        set imgfree [ getfreeimgspace ]
	set TMP_freespace $imgfree
	set TMP_spaceused -1

        frame $w.1
        tixLabelWidget $w.1.imgsize -label "Diskspace needed for Image : " \
                -options { label.width 30 label.anchor e }
        message $w.1.imgsizeval -width 150 -relief sunken -borderwidth 1 \
                -text "unknown"
	button $w.1.calc -text "Calculate Size" -bd 1 \
		-font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
		-command "mstrupdatesize $w.1.imgsizeval .root"

        frame $w.15
        tixLabelWidget $w.15.imgfree -label "Diskspace available : " \
                -options { label.width 30 label.anchor e }
        message $w.15.imgfreeval -width 150 -relief sunken -borderwidth 1 \
                -text "$imgfree MB"
        frame $w.16
        tixLabelWidget $w.16.imglabel -label "Image-ISO9660-Label : " \
                -options { label.width 30 label.anchor e }
        message $w.16.imglabelval -width 250 -relief sunken -borderwidth 1 \
                -text "$MSTR_VOLID"
        frame $w.17
        tixLabelWidget $w.17.imgtype -label "Image-Type : " \
                -options { label.width 30 label.anchor e }
        message $w.17.imgtypeval -width 250 -relief sunken -borderwidth 1 \
                -text "$ISOtag($MSTR_TYPE)"


        pack $w.1 -fill x -expand 1 -padx 10 -pady 5 
        tixForm $w.1.imgsize -left %0
        tixForm $w.1.imgsizeval -left %40 -right %60
	tixForm $w.1.calc -left %60 -right %80 
        pack $w.15 -fill x -expand 1 -padx 10 -pady 5 
        tixForm $w.15.imgfree -left %0
        tixForm $w.15.imgfreeval -left %40 -right %60
        pack $w.16 -fill x -expand 1 -padx 10 -pady 5 
        tixForm $w.16.imglabel -left %0
        tixForm $w.16.imglabelval -left %40 -right %80
        pack $w.17 -fill x -expand 1 -padx 10 -pady 5 
        tixForm $w.17.imgtype -left %0
        tixForm $w.17.imgtypeval -left %40 -right %80

        canvas $w.20 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.20 -pady 10 -fill x -expand 1

        frame $w.2
        tixLabelWidget $w.2.l -label "Generate Image on: " \
                -options { label.width 20 label.anchor e }
        radiobutton $w.2.b1 -text "Partition" -variable TMP_DEST \
                -value "part" -command "selectedpart $w"
        radiobutton $w.2.b2 -text "File" -variable TMP_DEST \
                -value "file" -command "selectedfile $w"
        pack $w.2 -expand 1 -fill x -padx 10
        pack $w.2.l $w.2.b1 $w.2.b2 -side left

        frame $w.3

        tixLabelEntry $w.3.imgfname -disabledforeground gray \
                -options {
                        label.width 20 label.anchor e
                        entry.width 15 entry.textVariable TMP_DESTNAME 
                }
        pack $w.3 -fill x -expand 1 -padx 10 -pady 10
        tixForm $w.3.imgfname -left %0 -right %70

        # set default-image-name
        if { $TMP_DESTNAME == "" } {
                set TMP_DESTNAME "image1.raw"
        }
        # Bind to Return in entry-widget the action to update the free-size
        bind $w.3.imgfname.frame.entry <Return> \
                "updatefreesize $w.15.imgfreeval"

        canvas $w.30 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.30 -pady 10 -fill x -expand 1

        button $w.review -text "Review Image-Contents" \
		-command "masterreviewimage .masterreview $w"

        button $w.start -text "Start Master Image" \
                -command "masterimagedoit .master_doit" 

        pack $w.review $w.start -pady 7 -side left -expand 1


        # Trigger default button "partition" if image is not mounted,
        # else trigger "file" 
        if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {
                $w.2.b1 invoke
        } else {
                $w.2.b2 invoke
        }

	# if save on premounted-dir
        if { $IMAGE_PART == "" } {
                $w.2.b1 configure -state disabled
                $w.2.b2 invoke
        }

}


# Update the image-size in the master-image-menu
# takes the excluded paths in account, but NOT the globs!
# Displays a "Please Wait" while in progress

proc mstrupdatesize { w old } {
global MSTR_DIR
global MSTR_EXPATHLIST
global TMP_spaceused

        set new .waitforsizecalc

	set oldf [createsubwindow $new $old 2 "" ]

        $new configure -cursor watch
	label $new.l -text "Calculating Image-Size"
 	label $new.l2 -text "Please wait"
        pack $new.l $new.l2 -padx 10 -pady 10
        update

	set size [askmkisofsforimagesize]

# old code follows:
#	set basesize [ calcdu $MSTR_DIR ]
#	set size $basesize

	# subtract the size of excluded directories
# 	foreach i $MSTR_EXPATHLIST {
#		# check now if the path IS a subpath of master-dir
#		if { [string first $MSTR_DIR $i] != 0 } {
#			# if path does not start with the master-dir-path
#			# then skip it
#			continue
#		}
#		set subsize [ calcdu $i ]
#		set size [expr $size - $subsize]
#	}
#
	set TMP_spaceused [expr $size/512]

	if { $size == -1 } {
		$w configure -text "Invalid Dir."
	} elseif { $size == -2 } {
		$w configure -text "-- Error --"
	} else {
		$w configure -text "[expr $size/512] MB"
	}

	destroysubwindow $new $old {$oldf} 2
}

	
# Call mkisofs with the -print-size option to calculate how big the
# image will be. This method is as acurate as possible.
# returns the size in 2k-blocks (extends)
# or -1 on inv. dir and -2 on error

proc askmkisofsforimagesize { } {
global MSTR_EXPATHLIST
global MSTR_EXGLOBLIST
global MKISOFS
global MSTR_DIR
global ISOtypes

	# check if we have a valid directory
	if { [file isdirectory $MSTR_DIR] != 1 } {
		return -1
	}

	set cmd "$MKISOFS -print-size "
	set flags ""
	for { set i 1 } { $i <= 11 } { incr i } {
		if { $ISOtypes($i) != "" } {
			append flags "$ISOtypes($i) "
		}
	} 

	# add exclude-globs
	if { $MSTR_EXGLOBLIST != "" } {
		foreach i $MSTR_EXGLOBLIST {
			append flags "-m \"$i\" "
		}	
	}

	# add exclude-paths
	if { $MSTR_EXPATHLIST != "" } {
		foreach i $MSTR_EXPATHLIST {
			append flags "-x \"$i\" "
		}
	}

	append cmd $flags
	append cmd " \"$MSTR_DIR\""
	# this way we get stdout and stderr
	set cmd [execshell $cmd]

	set stat [catch { set out [eval exec $cmd] }]

	# mkisofs reported some kind of error
	if { $stat != 0 } {
		return -2
	}

	set lout [split $out "\n"]
	set out 0
	foreach i $lout {
		# get the line with the extents-number
		if { [string first "Total extents " $i] == 0 } {
			set j [split $i "="]
			set out [string trim [lindex $j 1]]
		}
	}

	return $out
}


# Do the mastering of the image.

proc masterimagedoit { w } {
global MSTR_EXPATHLIST
global MSTR_EXGLOBLIST
global MKISOFS
global IMAGE_PART
global IMAGE_MNTPNT
global TMP_DESTNAME
global TMP_DEST
global MSTR_VOLID
global MSTR_PUBID
global MSTR_PREID
global MSTR_APPID
global MSTR_DIR
global ISOtypes
global TMP_freespace
global TMP_spaceused
global XCDR_SUB_VIEW SUB_VIEW
global NONROOT

# This variables must be global, because the fileevent-command
# can't handle local-variables
global pipe tmpw waitforready outval

        # set default view
        if { $SUB_VIEW == "" } {
                set SUB_VIEW $XCDR_SUB_VIEW
        }

	# Check if the Master-Directory is valid 
	if { [ getdircontents $MSTR_DIR] == -1 } {
		Msg_NoMasterDir .nomstrdir .root
		return 		
	}

	# Check if enough space is free on image-disk.    
	if { $TMP_spaceused != -1 && $TMP_spaceused > $TMP_freespace } {
		set stat [Msg_MasterToBig .mstrtobig .root [expr $TMP_spaceused - $TMP_freespace]]
		if { $stat != 0 } {	;# Abort
			return
		} 
	}

        # Sets the image-destination
        if { $TMP_DEST == "file" } {
                # Image to file
                set imgfile [ file tail $TMP_DESTNAME]
                set imagedest "$IMAGE_MNTPNT/$imgfile"
        } else {
                # Image to partition
                set imagedest $IMAGE_PART
		workasroot
        }

        set waitforready 0

	set cmd "$MKISOFS -o $imagedest "
	set flags ""
	for { set i 1 } { $i <= 11 } { incr i } {
		if { $ISOtypes($i) != "" } {
			append flags "$ISOtypes($i) "
		}
	} 

	# add exclude-globs
	if { $MSTR_EXGLOBLIST != "" } {
		foreach i $MSTR_EXGLOBLIST {
			append flags "-m \"$i\" "
		}	
	}

	# add exclude-paths
	if { $MSTR_EXPATHLIST != "" } {
		foreach i $MSTR_EXPATHLIST {
			append flags "-x \"$i\" "
		}
	}

	append cmd $flags

	append cmd "-V \"$MSTR_VOLID\" "
	append cmd "-P \"$MSTR_PUBID\" "
	append cmd "-p \"$MSTR_PREID\" "
	append cmd "-A \"$MSTR_APPID\" "

	append cmd " \"$MSTR_DIR\""
	
	log .root "Master-Image: mastering to $imagedest, masterdir=$MSTR_DIR"
	log .root "Executing: $cmd"

        # create extended command-line
        set cmd [execshell $cmd]

        # create new window
        set oldf [createsubwindow $w .root 1 "Master Image" ]

        set pipe [open "|$cmd" r+]

        # create menu
        frame $w.menu -bd 1 -relief raised
	if { $NONROOT == 0 } {
        menubutton $w.menu.file -menu $w.menu.file.m -text "File" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
        menu $w.menu.file.m
        $w.menu.file.m add command -label "Save Process-Output" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "saveoutputbuffer .savebuf $w $w.t.t masterimg.out" 
	}
        menubutton $w.menu.view -menu $w.menu.view.m -text "View" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
        menu $w.menu.view.m
        $w.menu.view.m add radio -label "Normal" -value 0 -variable SUB_VIEW \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 0"
        $w.menu.view.m add radio -label "Extended" -value 1 -variable SUB_VIEW \
                 -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 1"
        $w.menu.view.m add radio -label "Small" -value 2 -variable SUB_VIEW \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 2" 
	if { $NONROOT == 0 } {
        pack $w.menu.file -side left
	}
        pack $w.menu.view -side left
        pack $w.menu -fill x -expand 1

        
	frame $w.1
        label $w.1.l -text "Mastering Image... Please wait"
        tixMeter $w.1.c -height 20 -width 300 
        pack $w.1.l $w.1.c -padx 10 -pady 10
        pack $w.1

        # alternative "small" view 
        frame $w.2
        tixMeter $w.2.c -height 10 -width 100
        button $w.2.cancel -text "Cancel" -command {
                set waitforready 2 
                catch { close $pipe }
        }
        pack $w.2.c $w.2.cancel -side left

        tixButtonBox $w.1.box -orientation horizontal
        $w.1.box add cancel -text "Cancel" -command {
                set waitforready 2 
                catch { close $pipe }
        }
        pack $w.1.box -fill x -expand 1

        # create an optional text-widget to view any output generated by
        # subprocess
        frame $w.t      
        text $w.t.t -height 4 -width 36 -yscrollcommand "$w.t.scr set"
        scrollbar $w.t.scr -command "$w.t.t yview"
        pack $w.t.scr $w.t.t -side right -fill y
        pack $w.t

        set tmpw $w
        fileevent $pipe readable {
                global pipe tmpw waitforready outval
                set outval [gets $pipe] 

                if { [eof $pipe] } { 
			catch { close $pipe }
                        set waitforready 1;  
                }

		if { [string range $outval 0 1] != "-P" } {
                	# add to text-window and scroll to its end
                	$tmpw.t.t insert end "$outval\n"
               	 	$tmpw.t.t see end
		}

                if { $outval == "Done" } { 
                        set outval 100
                        set waitforready 1; catch { close $pipe }
                }

		if { [string range $outval 0 1] == "-P" } {
			set len [string length $outval]
			if { [string index $outval [expr $len - 1]] == "." } {
				set pct [string trim [string range $outval 2 [expr $len - 2]]]
			} else {
				set pct [string range $outval 2 end]
			}
                	drawbar $tmpw.1.c $pct
               	 	drawbar $tmpw.2.c $pct
		}
        }      

        # redraw window with correct appearance
        changedowriteview $w $SUB_VIEW 

        tkwait variable waitforready

        #we are done with reading now...
        if { $waitforready == 1 } {
		if { $outval == 100 } {
                	$w.1.l configure -text "Image successfully mastered."
			drawbar $tmpw.1.c 100
			drawbar $tmpw.2.c 100
		
			log $w "Master-Image: OK"
		} else {
			$w.1.l configure -text "Some error occured!!!"
			$w.2.cancel config -bg red
			log $w "Master-Image: Some error occured"
		}
        } else {
                $w.1.l configure -text "Master Image aborted!"      
		$w.2.cancel config -bg red
		log $w "Master-Image: aborted"
        }

        $w.1.box.cancel configure -text "Ok" \
                -command "destroysubwindow $w .root {$oldf} 1" -width 5
        $w.2.cancel configure -text "Ok" \
                -command "destroysubwindow $w .root {$oldf} 1" -width 5

	sound 1
	chownfile $imagedest

        # Clear the global variables
        unset pipe tmpw waitforready

        # wait until window is destroyed
        tkwait window $w

	workascaller
}

