/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.accessibility.Accessible;

public class Font2DTest
extends Applet
implements ActionListener,
ItemListener {
    Font2DCanvas symbols;
    TextField tfBaseText;
    TextField tfFontSize;
    TextArea taUnicodeText;
    FontList fontList;
    Choice styleList;
    Choice rangeList;
    Choice transformList;
    Choice methodList;
    Choice displayList;
    Checkbox cbAntialias;
    Checkbox cbFracMetrics;
    Hashtable styles;
    Hashtable ranges;
    Button btnUpdateText;
    PrinterJob printerJob;
    PageFormat pageFormat;
    static final int ASCII_BASE = 0;
    static final int GREEK_BASE = 880;
    static final int HEBREW_BASE = 1424;
    static final int ARABIC_BASE = 1536;
    static final int THAI_BASE = 3584;
    static final int GEORGIAN_BASE = 4256;
    static final int PUNCT_BASE = 8192;
    static final int ARROWS_BASE = 8592;
    static final int SYMBOL_BASE = 8704;
    static final int SHAPES_BASE = 9632;
    static final int DINGBAT_BASE = 9984;

    public void init() {
        Serializable serializable;
        String[] stringArray;
        Accessible accessible;
        this.styles = new Hashtable();
        this.styles.put("Plain", new Integer(0));
        this.styles.put("Bold", new Integer(1));
        this.styles.put("Italic", new Integer(2));
        this.styles.put("Bold Italic", new Integer(3));
        String[] stringArray2 = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
        this.ranges = new Hashtable();
        this.ranges.put("ASCII", new Integer(0));
        this.ranges.put("Greek", new Integer(880));
        this.ranges.put("Hebrew", new Integer(1424));
        this.ranges.put("Arabic", new Integer(1536));
        this.ranges.put("Thai", new Integer(3584));
        this.ranges.put("Georgian", new Integer(4256));
        this.ranges.put("Punctuation", new Integer(8192));
        this.ranges.put("Arrows", new Integer(8592));
        this.ranges.put("Symbols", new Integer(8704));
        this.ranges.put("Shapes", new Integer(9632));
        this.ranges.put("Dingbats", new Integer(9984));
        String[] stringArray3 = new String[]{"ASCII", "Greek", "Hebrew", "Arabic", "Thai", "Georgian", "Punctuation", "Arrows", "Symbols", "Shapes", "Dingbats", "Other..."};
        String[] stringArray4 = new String[]{"None", "Translate", "Rotate", "Scale", "Shear"};
        String[] stringArray5 = new String[]{"drawChars()", "drawString(String)", "drawString(Iterator)", "drawGlyphVector()", "drawBytes()", "TextLayout.draw()"};
        String[] stringArray6 = new String[]{"Unicode Range", "User Text", "All Glyphs", "Resource Text"};
        this.setSize(850, 700);
        this.setLayout(new BorderLayout());
        if (this.getFrame() != null) {
            boolean bl = false;
            accessible = this.getFrame().getMenuBar();
            if (accessible == null) {
                accessible = new MenuBar();
                this.getFrame().setMenuBar((MenuBar)accessible);
                bl = true;
            }
            stringArray = new Menu("File");
            stringArray.addActionListener(this);
            ((MenuBar)accessible).add((Menu)stringArray);
            serializable = new Menu("Help");
            ((MenuItem)serializable).addActionListener(this);
            ((MenuBar)accessible).add((Menu)serializable);
            this.setupMenuComponent("Read Text Data...", (Menu)stringArray);
            this.setupMenuComponent("Read Image Data...", (Menu)stringArray);
            this.setupMenuComponent("Write Image Data...", (Menu)stringArray);
            stringArray.add(new MenuItem("-"));
            this.setupMenuComponent("Read Control Data...", (Menu)stringArray);
            this.setupMenuComponent("Write Control Data...", (Menu)stringArray);
            stringArray.add(new MenuItem("-"));
            this.setupMenuComponent("Page Setup...", (Menu)stringArray);
            this.setupMenuComponent("Print...", (Menu)stringArray);
            if (bl) {
                stringArray.add(new MenuItem("-"));
                this.setupMenuComponent("Exit", (Menu)stringArray);
            }
            this.setupMenuComponent("Readme", (Menu)serializable);
        }
        accessible = new Panel();
        ((Container)((Object)accessible)).add(new Label("Font:", 2));
        this.fontList = new FontList(7);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals("")) {
                serializable = new Font(stringArray[n], 0, 16);
                if (!System.getProperty("os.name").startsWith("Sun")) {
                    if (this.canDisplayRange((Font)serializable, 0)) {
                        this.fontList.add("*" + stringArray[n]);
                    } else {
                        this.fontList.add(stringArray[n]);
                    }
                } else {
                    this.fontList.add(stringArray[n]);
                }
            }
            ++n;
        }
        this.fontList.addItemListener(this);
        this.fontList.select(0);
        ((Container)((Object)accessible)).add(this.fontList);
        ((Container)((Object)accessible)).add(new Label("      "));
        serializable = new Panel(new GridLayout(5, 2));
        ((Container)serializable).add(new Label("Style:", 2));
        this.styleList = new Choice();
        n = 0;
        while (n < stringArray2.length) {
            this.styleList.addItem(stringArray2[n]);
            ++n;
        }
        this.styleList.addItemListener(this);
        ((Container)serializable).add(this.styleList);
        ((Container)serializable).add(new Label("Size:", 2));
        this.tfFontSize = new TextField("16", 3);
        this.tfFontSize.setFont(new Font("Monospaced", 0, 12));
        this.tfFontSize.addActionListener(this);
        ((Container)serializable).add(this.tfFontSize);
        ((Container)serializable).add(new Label("Transform:", 2));
        this.transformList = new Choice();
        n = 0;
        while (n < stringArray4.length) {
            this.transformList.addItem(stringArray4[n]);
            ++n;
        }
        this.transformList.addItemListener(this);
        ((Container)serializable).add(this.transformList);
        ((Container)serializable).add(new Label(""));
        ((Container)serializable).add(new Label(""));
        this.cbAntialias = new Checkbox("Antialiasing");
        this.cbAntialias.addItemListener(this);
        ((Container)serializable).add(this.cbAntialias);
        this.cbFracMetrics = new Checkbox("Fractional Metrics");
        this.cbFracMetrics.addItemListener(this);
        ((Container)serializable).add(this.cbFracMetrics);
        ((Container)((Object)accessible)).add((Component)serializable);
        Panel panel = new Panel(new GridLayout(4, 2));
        panel.add(new Label("Unicode Range:", 2));
        this.rangeList = new Choice();
        n = 0;
        while (n < stringArray3.length) {
            this.rangeList.addItem(stringArray3[n]);
            ++n;
        }
        this.rangeList.addItemListener(this);
        panel.add(this.rangeList);
        panel.add(new Label("Unicode Base:", 2));
        this.tfBaseText = new TextField(Integer.toHexString(0), 4);
        this.tfBaseText.setFont(new Font("Monospaced", 0, 12));
        this.tfBaseText.addActionListener(this);
        this.tfBaseText.setEditable(false);
        panel.add(this.tfBaseText);
        panel.add(new Label("Draw Method:", 2));
        this.methodList = new Choice();
        n = 0;
        while (n < stringArray5.length) {
            this.methodList.addItem(stringArray5[n]);
            ++n;
        }
        this.methodList.addItemListener(this);
        panel.add(this.methodList);
        panel.add(new Label("Display Mode:", 2));
        this.displayList = new Choice();
        n = 0;
        while (n < stringArray6.length) {
            this.displayList.addItem(stringArray6[n]);
            ++n;
        }
        this.displayList.addItemListener(this);
        panel.add(this.displayList);
        ((Container)((Object)accessible)).add(panel);
        this.add("North", (Component)((Object)accessible));
        Font font = new Font(this.fontList.getSelectedItem(), (int)((Integer)this.styles.get(this.styleList.getSelectedItem())), Integer.valueOf(this.tfFontSize.getText()));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 1));
        ScrollPane scrollPane = new ScrollPane();
        this.symbols = new Font2DCanvas(this, font, 0);
        scrollPane.add(this.symbols);
        panel2.add(scrollPane);
        this.add("Center", panel2);
        Panel panel3 = new Panel(new BorderLayout());
        this.taUnicodeText = new TextArea("", 10, 20, 3);
        panel3.add("Center", this.taUnicodeText);
        Panel panel4 = new Panel();
        this.btnUpdateText = new Button("Update");
        this.btnUpdateText.addActionListener(this);
        panel4.add(this.btnUpdateText);
        panel3.add("South", panel4);
        this.add("East", panel3);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getItemSelectable().equals(this.fontList)) {
                this.setSymbolFont();
            } else if (itemEvent.getItemSelectable().equals(this.styleList)) {
                this.setSymbolFont();
            } else if (itemEvent.getItemSelectable().equals(this.rangeList)) {
                String string = (String)itemEvent.getItem();
                if (string.equals("Other...")) {
                    this.tfBaseText.setEditable(true);
                    this.symbols.setBase(Integer.valueOf(this.tfBaseText.getText(), 16));
                } else {
                    int n = (Integer)this.ranges.get(string);
                    this.symbols.setBase(n);
                    this.tfBaseText.setText(Integer.toHexString(n));
                    this.tfBaseText.setEditable(false);
                }
                if (!System.getProperty("os.name").startsWith("Sun")) {
                    this.setupFontList();
                }
            } else if (itemEvent.getItemSelectable().equals(this.transformList)) {
                this.setSymbolFont();
            } else if (itemEvent.getItemSelectable().equals(this.methodList)) {
                this.symbols.setMethod((String)itemEvent.getItem());
            } else if (itemEvent.getItemSelectable().equals(this.displayList)) {
                this.symbols.setDisplayType((String)itemEvent.getItem());
            }
        }
        if (itemEvent.getItemSelectable().equals(this.cbAntialias)) {
            this.symbols.setAntialiasing(this.cbAntialias.getState());
        } else if (itemEvent.getItemSelectable().equals(this.cbFracMetrics)) {
            this.symbols.setFractionalMetrics(this.cbFracMetrics.getState());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.tfBaseText)) {
            try {
                this.symbols.setBase(Integer.valueOf(actionEvent.getActionCommand(), 16));
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
                this.tfBaseText.select(0, Integer.MAX_VALUE);
            }
            if (!System.getProperty("os.name").startsWith("Sun")) {
                this.setupFontList();
            }
        } else if (actionEvent.getSource().equals(this.tfFontSize)) {
            try {
                this.setSymbolFont();
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
                this.tfFontSize.select(0, Integer.MAX_VALUE);
            }
        } else if (actionEvent.getSource().equals(this.btnUpdateText)) {
            this.symbols.setDisplayText(this.convertControlCodes(this.taUnicodeText.getText()));
            this.displayList.select("User Text");
            this.symbols.setDisplayType("User Text");
        } else {
            String string = actionEvent.getActionCommand();
            if (string.equals("Read Image Data...")) {
                this.onReadData();
            } else if (string.equals("Write Image Data...")) {
                this.onWriteData();
            } else if (string.equals("Read Text Data...")) {
                this.onReadTextData();
            } else if (string.equals("Read Control Data...")) {
                this.onReadControlData();
            } else if (string.equals("Write Control Data...")) {
                this.onWriteControlData();
            } else if (string.equals("Page Setup...")) {
                this.onPageSetup();
            } else if (string.equals("Print...")) {
                this.onPrint();
            } else if (string.equals("Exit")) {
                System.exit(0);
            } else if (string.equals("Readme")) {
                Font2DTestTextFrame font2DTestTextFrame = new Font2DTestTextFrame("README", "README.txt");
            }
        }
    }

    public void onReadData() {
        FileDialog fileDialog = new FileDialog(this.getFrame(), "Load data...", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            String string2 = fileDialog.getDirectory() + fileDialog.getFile();
            if (string.endsWith(".jpg")) {
                ImageFrame imageFrame = new ImageFrame(fileDialog.getFile(), string2);
            }
        }
    }

    public void onWriteData() {
        String string = this.fontList.getSelectedItem();
        if (string.startsWith("*")) {
            string = string.substring(1, string.length());
        }
        FileDialog fileDialog = new FileDialog(this.getFrame(), "Save data...", 1);
        fileDialog.setFile(string + "." + this.styleList.getSelectedItem() + "." + this.tfFontSize.getText() + "." + this.tfBaseText.getText() + ".jpg");
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            this.symbols.writeSymbolImage(fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public void onReadControlData() {
        FileDialog fileDialog = new FileDialog(this.getFrame(), "Load control data...", 0);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            this.readControlInfo(fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public void onWriteControlData() {
        FileDialog fileDialog = new FileDialog(this.getFrame(), "Save control data...", 1);
        fileDialog.setFile("control.data");
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            this.writeControlInfo(fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public void onReadTextData() {
        FileDialog fileDialog = new FileDialog(this.getFrame(), "Load data...", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            String string2 = fileDialog.getDirectory() + fileDialog.getFile();
            this.symbols.setDisplayText(this.getFileTextVector(string2));
        }
    }

    public void onPageSetup() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void onPrint() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        if (this.pageFormat == null) {
            this.pageFormat = this.printerJob.defaultPage();
        }
        this.printerJob.setPrintable(this.symbols, this.pageFormat);
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
            }
            catch (PrinterException printerException) {
                System.err.println("Error printing the current symbol canvas");
            }
        }
        this.printerJob = null;
    }

    private Vector convertControlCodes(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = "";
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "\\");
            while (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken();
                string2 = string3.startsWith("u") && string3.length() >= 5 ? string2 + (char)Integer.valueOf(string3.substring(1, 5), 16).intValue() + string3.substring(5, string3.length()) : string2 + string3;
            }
            vector.add(string2);
        }
        return vector;
    }

    public void setSymbolFont() {
        String string = this.fontList.getSelectedItem();
        if (string.startsWith("*")) {
            string = string.substring(1, string.length());
        }
        this.symbols.setFont(new Font(string, (int)((Integer)this.styles.get(this.styleList.getSelectedItem())), Integer.valueOf(this.tfFontSize.getText())), this.transformList.getSelectedItem());
    }

    protected boolean canDisplayRange(Font font, int n) {
        int n2 = n;
        while (n2 < n + 256) {
            if (font.canDisplay((char)n2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setupFontList() {
        int n = Integer.valueOf(this.tfBaseText.getText(), 16);
        int n2 = this.fontList.getSelectedIndex();
        int n3 = 0;
        while (n3 < this.fontList.getItemCount()) {
            Font font;
            String string = this.fontList.getItem(n3);
            if (string.startsWith("*")) {
                string = string.substring(1, string.length());
            }
            if (this.canDisplayRange(font = new Font(string, 0, 16), n)) {
                this.fontList.replaceItem("*" + string, n3);
            } else {
                this.fontList.replaceItem(string, n3);
            }
            ++n3;
        }
        this.fontList.select(n2);
    }

    protected Vector getFileTextVector(String string) {
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("Error reading text from file: " + string);
        }
        return vector;
    }

    private void readControlInfo(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            if (!bufferedReader.readLine().equals("# Font2DTest control info")) {
                System.err.println("Invalid control info file: " + string);
                bufferedReader.close();
                return;
            }
            String string2 = bufferedReader.readLine();
            int n = 0;
            while (n < this.fontList.getItemCount()) {
                String string3 = this.fontList.getItem(n);
                if (string3.startsWith("*")) {
                    string3 = string3.substring(1, string3.length());
                }
                if (string3.equals(string2)) {
                    this.fontList.select(n);
                    this.fontList.makeVisible(n);
                    break;
                }
                ++n;
            }
            this.styleList.select(bufferedReader.readLine());
            this.tfFontSize.setText(bufferedReader.readLine());
            this.transformList.select(bufferedReader.readLine());
            this.cbAntialias.setState(bufferedReader.readLine().equals("AAOn"));
            this.cbFracMetrics.setState(bufferedReader.readLine().equals("FMOn"));
            this.rangeList.select(bufferedReader.readLine());
            this.tfBaseText.setText(bufferedReader.readLine());
            this.methodList.select(bufferedReader.readLine());
            this.displayList.select(bufferedReader.readLine());
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("Error reading control text from file: " + string);
        }
        this.setSymbolFont();
        this.symbols.setBase(Integer.valueOf(this.tfBaseText.getText(), 16));
        this.symbols.setMethod(this.methodList.getSelectedItem());
        this.symbols.setAntialiasing(this.cbAntialias.getState());
        this.symbols.setFractionalMetrics(this.cbFracMetrics.getState());
        this.symbols.setDisplayType(this.displayList.getSelectedItem());
        if (!System.getProperty("os.name").startsWith("Sun")) {
            this.setupFontList();
        }
    }

    private void writeControlInfo(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write("# Font2DTest control info\n");
            String string2 = this.fontList.getSelectedItem();
            if (string2.startsWith("*")) {
                string2 = string2.substring(1, string2.length());
            }
            bufferedWriter.write(string2 + "\n");
            bufferedWriter.write(this.styleList.getSelectedItem() + "\n");
            bufferedWriter.write(this.tfFontSize.getText() + "\n");
            bufferedWriter.write(this.transformList.getSelectedItem() + "\n");
            bufferedWriter.write((this.cbAntialias.getState() ? "AAOn" : "AAOff") + "\n");
            bufferedWriter.write((this.cbFracMetrics.getState() ? "FMOn" : "FMOff") + "\n");
            bufferedWriter.write(this.rangeList.getSelectedItem() + "\n");
            bufferedWriter.write(this.tfBaseText.getText() + "\n");
            bufferedWriter.write(this.methodList.getSelectedItem() + "\n");
            bufferedWriter.write(this.displayList.getSelectedItem() + "\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Error writing control text to file: " + string);
        }
    }

    private void setupMenuComponent(String string, Menu menu) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setActionCommand(string);
        menu.add(menuItem);
    }

    public Frame getFrame() {
        Container container = this;
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    public static void main(String[] stringArray) {
        Font2DTest font2DTest = new Font2DTest();
        Frame frame = new Frame("Font2DTest");
        frame.add("Center", font2DTest);
        font2DTest.init();
        font2DTest.start();
        frame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 850;
        int n2 = 700;
        ((Component)frame).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        ((Component)frame).setSize(n, n2);
        frame.addWindowListener(new MyAdapter());
        frame.show();
    }

    static class MyAdapter
    extends WindowAdapter {
        MyAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

