/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import sun.awt.AppContext;
import sun.plugin.ClassLoaderInfo;
import sun.plugin.JavaRunTime;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.Trace;
import sun.security.action.GetPropertyAction;

class ConsoleWindow
extends JFrame {
    private static EventQueue consoleEventQueue;
    private JTextArea textArea;
    private JScrollPane scroller;
    private JScrollBar sbHor;
    private JScrollBar sbVer;
    private boolean onWindows = false;
    private boolean isMozilla = false;
    private Toolkit toolkit = null;

    ConsoleWindow() {
        super("Java Console");
        Object object;
        Object object2;
        try {
            object2 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (((String)object2).indexOf("Windows") != -1) {
                this.onWindows = true;
            }
            if ((object = AccessController.doPrivileged(new GetPropertyAction("mozilla.workaround", "false"))) != null && ((String)object).equalsIgnoreCase("true")) {
                this.isMozilla = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((Component)this).setSize(450, 400);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        if (!this.onWindows && this.isMozilla) {
            ((JComponent)this.getRootPane()).setDoubleBuffered(false);
            ((JPanel)this.getContentPane()).setDoubleBuffered(false);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(0, 5, 0, 0));
        this.scroller = new JScrollPane(this.textArea);
        object2 = this.scroller.getViewport();
        ((JViewport)object2).setScrollMode(1);
        this.sbVer = this.scroller.getVerticalScrollBar();
        this.sbHor = this.scroller.getHorizontalScrollBar();
        this.getContentPane().add((Component)this.scroller, "Center");
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Dump thread list ...\n");
                Thread thread = Thread.currentThread();
                ThreadGroup threadGroup = thread.getThreadGroup();
                ConsoleWindow.this.dumpThreadGroup(threadGroup, stringBuffer);
                stringBuffer.append("Done.");
                System.out.println(stringBuffer.toString());
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleWindow.this.displaySystemProperties();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleWindow.this.displayHelp();
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassLoaderInfo.dumpClassLoaderCache(System.out);
            }
        };
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassLoaderInfo.clearClassLoaderCache();
                System.out.println("Clear classloader cache .... completed.");
            }
        };
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleWindow.this.textArea.setText("");
                ConsoleWindow.this.textArea.revalidate();
                ConsoleWindow.this.displayVersion();
                ConsoleWindow.this.displayHelp();
            }
        };
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ConsoleWindow.this.textArea.getSelectionStart();
                int n2 = ConsoleWindow.this.textArea.getSelectionEnd();
                if (n2 - n <= 0) {
                    ConsoleWindow.this.textArea.selectAll();
                }
                ConsoleWindow.this.textArea.copy();
            }
        };
        ActionListener actionListener7 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConsoleWindow.this.onWindows || ConsoleWindow.this.isMozilla) {
                    ((Component)ConsoleWindow.this).setVisible(false);
                } else {
                    ConsoleWindow.this.setState(1);
                }
                JavaRunTime.ConsoleStatus(false);
            }
        };
        final ActionListener actionListener8 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                long l = Runtime.getRuntime().freeMemory() / 1024L;
                long l2 = Runtime.getRuntime().totalMemory() / 1024L;
                long l3 = (long)(100.0 / ((double)l2 / (double)l));
                System.out.println("Memory: " + l2 + "K  Free: " + l + "K  (" + l3 + "%) ... completed.");
            }
        };
        ActionListener actionListener9 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.print("Finalize objects on finalization queue ");
                System.runFinalization();
                System.out.println("... completed.");
                actionListener8.actionPerformed(actionEvent);
            }
        };
        ActionListener actionListener10 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.print("Garbage collect ");
                System.gc();
                System.out.println("... completed.");
                actionListener8.actionPerformed(actionEvent);
            }
        };
        ActionListener actionListener11 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(false);
                Trace.setNetTrace(false);
                Trace.setSecurityTrace(false);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                System.out.println("Trace level set to 0: none ... completed.");
            }
        };
        ActionListener actionListener12 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setNetTrace(false);
                Trace.setSecurityTrace(false);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                System.out.println("Trace level set to 1: basic ... completed.");
            }
        };
        ActionListener actionListener13 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(false);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                System.out.println("Trace level set to 2: basic, net ... completed.");
            }
        };
        ActionListener actionListener14 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(true);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                System.out.println("Trace level set to 3: basic, net, security ... completed.");
            }
        };
        ActionListener actionListener15 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(true);
                Trace.setExtTrace(true);
                Trace.setLiveConnectTrace(false);
                System.out.println("Trace level set to 4: basic, net, security, ext ... completed.");
            }
        };
        ActionListener actionListener16 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(true);
                Trace.setExtTrace(true);
                Trace.setLiveConnectTrace(true);
                System.out.println("Trace level set to 5: basic, net, security, ext, liveconnect ... completed.");
            }
        };
        this.textArea.registerKeyboardAction((ActionListener)object, KeyStroke.getKeyStroke(84, 0), 2);
        this.textArea.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(83, 0), 2);
        this.textArea.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(72, 0), 2);
        this.textArea.registerKeyboardAction(actionListener8, KeyStroke.getKeyStroke(77, 0), 2);
        this.textArea.registerKeyboardAction(actionListener5, KeyStroke.getKeyStroke(67, 0), 2);
        this.textArea.registerKeyboardAction(actionListener10, KeyStroke.getKeyStroke(71, 0), 2);
        this.textArea.registerKeyboardAction(actionListener9, KeyStroke.getKeyStroke(70, 0), 2);
        this.textArea.registerKeyboardAction(actionListener7, KeyStroke.getKeyStroke(81, 0), 2);
        this.textArea.registerKeyboardAction(actionListener11, KeyStroke.getKeyStroke(48, 0), 2);
        this.textArea.registerKeyboardAction(actionListener12, KeyStroke.getKeyStroke(49, 0), 2);
        this.textArea.registerKeyboardAction(actionListener13, KeyStroke.getKeyStroke(50, 0), 2);
        this.textArea.registerKeyboardAction(actionListener14, KeyStroke.getKeyStroke(51, 0), 2);
        this.textArea.registerKeyboardAction(actionListener15, KeyStroke.getKeyStroke(52, 0), 2);
        this.textArea.registerKeyboardAction(actionListener16, KeyStroke.getKeyStroke(53, 0), 2);
        this.textArea.registerKeyboardAction(actionListener4, KeyStroke.getKeyStroke(88, 0), 2);
        this.textArea.registerKeyboardAction(actionListener3, KeyStroke.getKeyStroke(76, 0), 2);
        JButton jButton = new JButton(ResourceHandler.getMessage("console.clear"));
        JButton jButton2 = new JButton(ResourceHandler.getMessage("console.copy"));
        JButton jButton3 = new JButton(ResourceHandler.getMessage("console.close"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(new Label("    "));
        jPanel.add(jButton2);
        jPanel.add(new Label("    "));
        jPanel.add(jButton3);
        int n = SystemColor.control.getRGB();
        jPanel.setBackground(new Color(n));
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowDeiconified(WindowEvent windowEvent) {
                if (!ConsoleWindow.this.onWindows && !ConsoleWindow.this.isMozilla) {
                    JavaRunTime.ConsoleStatus(true);
                }
            }

            public void windowIconified(WindowEvent windowEvent) {
                if (!ConsoleWindow.this.onWindows && !ConsoleWindow.this.isMozilla) {
                    JavaRunTime.ConsoleStatus(false);
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                if (ConsoleWindow.this.onWindows || ConsoleWindow.this.isMozilla) {
                    ((Component)ConsoleWindow.this).setVisible(false);
                } else {
                    ConsoleWindow.this.setState(1);
                }
                JavaRunTime.ConsoleStatus(false);
            }
        });
        jButton.addActionListener(actionListener5);
        jButton2.addActionListener(actionListener6);
        jButton3.addActionListener(actionListener7);
        consoleEventQueue = (EventQueue)AppContext.getAppContext().get(AppContext.EVENT_QUEUE_KEY);
        this.toolkit = Toolkit.getDefaultToolkit();
    }

    public void append(final String string) {
        Toolkit toolkit = this.toolkit;
        consoleEventQueue.postEvent(new InvocationEvent((Object)toolkit, new Runnable(){

            public void run() {
                ConsoleWindow.this.textArea.append(string);
                ConsoleWindow.this.textArea.revalidate();
                ConsoleWindow.this.setScrollPosition();
            }
        }));
    }

    private void dumpThreadGroup(ThreadGroup threadGroup, StringBuffer stringBuffer) {
        if (threadGroup != null) {
            try {
                if (threadGroup.activeCount() == 0 && threadGroup.activeGroupCount() == 0 && !threadGroup.isDestroyed()) {
                    threadGroup.destroy();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stringBuffer.append("Group " + threadGroup.getName());
            stringBuffer.append(",ac=" + threadGroup.activeCount());
            stringBuffer.append(",agc=" + threadGroup.activeGroupCount());
            stringBuffer.append(",pri=" + threadGroup.getMaxPriority());
            if (threadGroup.isDestroyed()) {
                stringBuffer.append(",destoyed");
            }
            if (threadGroup.isDaemon()) {
                stringBuffer.append(",daemon");
            }
            stringBuffer.append("\n");
            Thread[] threadArray = new Thread[1000];
            threadGroup.enumerate(threadArray, false);
            int n = 0;
            while (n < threadArray.length) {
                if (threadArray[n] != null) {
                    stringBuffer.append("    ");
                    stringBuffer.append(threadArray[n].getName());
                    stringBuffer.append(",");
                    stringBuffer.append(threadArray[n].getPriority());
                    if (threadArray[n].isAlive()) {
                        stringBuffer.append(",alive");
                    } else {
                        stringBuffer.append(",not alive");
                    }
                    if (threadArray[n].isDaemon()) {
                        stringBuffer.append(",dameon");
                    }
                    if (threadArray[n].isInterrupted()) {
                        stringBuffer.append(",interrupted");
                    }
                    stringBuffer.append("\n");
                }
                ++n;
            }
            ThreadGroup[] threadGroupArray = new ThreadGroup[1000];
            threadGroup.enumerate(threadGroupArray, false);
            int n2 = 0;
            while (n2 < threadGroupArray.length) {
                if (threadGroupArray[n2] != null) {
                    this.dumpThreadGroup(threadGroupArray[n2], stringBuffer);
                }
                ++n2;
            }
        }
    }

    public void displayHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("----------------------------------------------------\n");
        stringBuffer.append("c:   clear console window\n");
        stringBuffer.append("f:   finalize objects on finalization queue\n");
        stringBuffer.append("g:   garbage collect\n");
        stringBuffer.append("h:   display this help message\n");
        stringBuffer.append("l:   dump classloader list\n");
        stringBuffer.append("m:   print memory usage\n");
        stringBuffer.append("q:   hide console\n");
        stringBuffer.append("s:   dump system properties\n");
        stringBuffer.append("t:   dump thread list\n");
        stringBuffer.append("x:   clear classloader cache\n");
        stringBuffer.append("0-5: set trace level to <n>\n");
        stringBuffer.append("----------------------------------------------------");
        System.out.println(stringBuffer.toString());
    }

    public void displayVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ResourceHandler.getMessage("product_name"));
        String string = System.getProperty("javaplugin.version");
        if (string != null) {
            stringBuffer.append(": " + ResourceHandler.getMessage("version") + " " + System.getProperty("javaplugin.version"));
        }
        stringBuffer.append("\n");
        stringBuffer.append(ResourceHandler.getMessage("using_jre_version"));
        stringBuffer.append(" ");
        stringBuffer.append(System.getProperty("java.version"));
        stringBuffer.append(" ");
        stringBuffer.append(System.getProperty("java.vm.name"));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceHandler.getMessage("user_home_dir"));
        stringBuffer.append(" = ");
        stringBuffer.append(System.getProperty("user.home"));
        System.out.println(stringBuffer.toString());
    }

    public void displaySystemProperties() {
        TreeSet treeSet = new TreeSet();
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            treeSet.add(enumeration.nextElement());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Dump system properties ...\n");
        stringBuffer.append("---------------------------------------------------\n");
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = System.getProperty(string);
            if (string2 != null) {
                if (string2.equals("\n")) {
                    string2 = "\\n";
                } else if (string2.equals("\r")) {
                    string2 = "\\r";
                } else if (string2.equals("\r\n")) {
                    string2 = "\\r\\n";
                } else if (string2.equals("\n\r")) {
                    string2 = "\\n\\r";
                } else if (string2.equals("\n\n")) {
                    string2 = "\\n\\n";
                } else if (string2.equals("\r\r")) {
                    string2 = "\\r\\r";
                }
            }
            stringBuffer.append(string + " = " + string2 + "\n");
        }
        stringBuffer.append("---------------------------------------------------\n");
        stringBuffer.append("Done.");
        System.out.println(stringBuffer.toString());
    }

    public void setScrollPosition() {
        this.scroller.validate();
        this.sbVer.setValue(this.sbVer.getMaximum());
        this.sbHor.setValue(this.sbHor.getMinimum());
    }
}

