/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import javax.naming.NamingException;

public final class LdapURL {
    private String url = null;
    private String scheme = null;
    private String host = null;
    private int port = -1;
    private String DN = null;
    private String attributes = null;
    private String scope = null;
    private String filter = null;
    private String extensions = null;

    public LdapURL(String string) throws NamingException {
        this.url = string;
        try {
            this.parse();
        }
        catch (MalformedURLException malformedURLException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(malformedURLException);
            throw namingException;
        }
    }

    void parse() throws MalformedURLException {
        int n;
        int n2;
        int n3 = this.url.indexOf("://");
        if (n3 > -1) {
            this.scheme = this.url.substring(0, n3);
        }
        if (!"ldap".equals(this.scheme)) {
            throw new MalformedURLException("Not an LDAP URL: " + this.url);
        }
        int n4 = this.url.indexOf(47, n3 += 3);
        int n5 = this.url.indexOf(58, n3);
        if (n4 < 0) {
            if (n5 < 0) {
                this.host = this.url.substring(n3);
            } else {
                this.host = this.url.substring(n3, n5);
                this.port = Integer.parseInt(this.url.substring(n5 + 1));
            }
            return;
        }
        if (n5 < 0) {
            this.host = this.url.substring(n3, n4);
        } else {
            this.host = this.url.substring(n3, n5);
            this.port = Integer.parseInt(this.url.substring(n5 + 1, n4));
        }
        int n6 = this.url.indexOf(63, n4);
        this.DN = n6 < 0 ? this.url.substring(n4 + 1) : this.url.substring(n4 + 1, n6);
        if (this.DN != null && this.DN.length() > 0) {
            this.DN = UrlUtil.decode(this.DN);
        }
        if (n6 < 0) {
            return;
        }
        int n7 = this.url.indexOf(63, n6 + 1);
        if (n7 < 0) {
            this.attributes = this.url.substring(n6 + 1);
            return;
        }
        if (n7 != n6 + 1) {
            this.attributes = this.url.substring(n6 + 1, n7);
        }
        if ((n2 = this.url.indexOf(63, n7 + 1)) < 0) {
            this.scope = this.url.substring(n7 + 1);
            return;
        }
        if (n2 != n7 + 1) {
            this.scope = this.url.substring(n7 + 1, n2);
        }
        if ((n = this.url.indexOf(63, n2 + 1)) < 0) {
            this.filter = this.url.substring(n2 + 1);
        } else if (n != n2 + 1) {
            this.filter = this.url.substring(n2 + 1, n);
        }
        if (this.filter != null && this.filter.length() > 0) {
            this.filter = UrlUtil.decode(this.filter);
        }
        if (n != -1) {
            this.extensions = this.url.substring(n + 1);
        }
        if (this.extensions != null && this.extensions.length() > 0) {
            this.extensions = UrlUtil.decode(this.extensions);
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDN() {
        return this.DN;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String toString() {
        return this.url;
    }

    static String toUrlString(String string, int n, String string2) {
        return "ldap://" + string + ":" + n + "/" + string2;
    }

    public static boolean hasQueryComponents(String string) {
        return string.lastIndexOf(63) != -1;
    }
}

