/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;

public class ReferenceQueue {
    static ReferenceQueue NULL = new Null();
    static ReferenceQueue ENQUEUED = new Null();
    private Lock lock = new Lock();
    private Reference head = null;

    boolean enqueue(Reference reference) {
        Reference reference2 = reference;
        synchronized (reference2) {
            if (reference.queue == ENQUEUED) {
                boolean bl = false;
                return bl;
            }
            Lock lock = this.lock;
            synchronized (lock) {
                reference.queue = ENQUEUED;
                reference.next = this.head == null ? reference : this.head;
                this.head = reference;
                this.lock.notifyAll();
                boolean bl = true;
                return bl;
            }
        }
    }

    private Reference reallyPoll() {
        if (this.head != null) {
            Reference reference = this.head;
            this.head = reference.next == reference ? null : reference.next;
            reference.queue = NULL;
            reference.next = reference;
            return reference;
        }
        return null;
    }

    public Reference poll() {
        Lock lock = this.lock;
        synchronized (lock) {
            Reference reference = this.reallyPoll();
            return reference;
        }
    }

    public Reference remove(long l) throws IllegalArgumentException, InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout value");
        }
        Lock lock = this.lock;
        synchronized (lock) {
            Reference reference = this.reallyPoll();
            if (reference != null) {
                Reference reference2 = reference;
                return reference2;
            }
            do {
                this.lock.wait(l);
                reference = this.reallyPoll();
                if (reference == null) continue;
                Reference reference3 = reference;
                return reference3;
            } while (l == 0L);
            Reference reference4 = null;
            return reference4;
        }
    }

    public Reference remove() throws InterruptedException {
        return this.remove(0L);
    }

    private static class Lock {
        private Lock() {
        }
    }

    private static class Null
    extends ReferenceQueue {
        private Null() {
        }

        boolean enqueue(Reference reference) {
            return false;
        }
    }
}

