/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public abstract class LookAndFeel {
    public static void installColors(JComponent jComponent, String string, String string2) {
        Color color;
        Color color2 = jComponent.getBackground();
        if (color2 == null || color2 instanceof UIResource) {
            jComponent.setBackground(UIManager.getColor(string));
        }
        if ((color = jComponent.getForeground()) == null || color instanceof UIResource) {
            jComponent.setForeground(UIManager.getColor(string2));
        }
    }

    public static void installColorsAndFont(JComponent jComponent, String string, String string2, String string3) {
        Font font = jComponent.getFont();
        if (font == null || font instanceof UIResource) {
            jComponent.setFont(UIManager.getFont(string3));
        }
        LookAndFeel.installColors(jComponent, string, string2);
    }

    public static void installBorder(JComponent jComponent, String string) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(UIManager.getBorder(string));
        }
    }

    public static void uninstallBorder(JComponent jComponent) {
        if (jComponent.getBorder() instanceof UIResource) {
            jComponent.setBorder(null);
        }
    }

    public static JTextComponent.KeyBinding[] makeKeyBindings(Object[] objectArray) {
        JTextComponent.KeyBinding[] keyBindingArray = new JTextComponent.KeyBinding[objectArray.length / 2];
        int n = 0;
        while (n < objectArray.length) {
            KeyStroke keyStroke = objectArray[n] instanceof KeyStroke ? (KeyStroke)objectArray[n] : KeyStroke.getKeyStroke((String)objectArray[n]);
            String string = (String)objectArray[n + 1];
            keyBindingArray[n / 2] = new JTextComponent.KeyBinding(keyStroke, string);
            n += 2;
        }
        return keyBindingArray;
    }

    public static InputMap makeInputMap(Object[] objectArray) {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        LookAndFeel.loadKeyBindings(inputMapUIResource, objectArray);
        return inputMapUIResource;
    }

    public static ComponentInputMap makeComponentInputMap(JComponent jComponent, Object[] objectArray) {
        ComponentInputMapUIResource componentInputMapUIResource = new ComponentInputMapUIResource(jComponent);
        LookAndFeel.loadKeyBindings(componentInputMapUIResource, objectArray);
        return componentInputMapUIResource;
    }

    public static void loadKeyBindings(InputMap inputMap, Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object object;
                KeyStroke keyStroke = (object = objectArray[n++]) instanceof KeyStroke ? (KeyStroke)object : KeyStroke.getKeyStroke((String)object);
                inputMap.put(keyStroke, objectArray[n]);
                ++n;
            }
        }
    }

    public static Object makeIcon(final Class clazz, final String string) {
        return new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                byte[][] byArrayArray = new byte[1][];
                SwingUtilities.doPrivileged(new Runnable(this, byArrayArray){
                    private final /* synthetic */ byte[][] val$buffer;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                        this.val$buffer = byArray;
                    }

                    public void run() {
                        try {
                            int n;
                            InputStream inputStream = 1.access$100(this.this$0).getResourceAsStream(1.access$000(this.this$0));
                            if (inputStream == null) {
                                return;
                            }
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                            this.val$buffer[0] = new byte[1024];
                            while ((n = bufferedInputStream.read(this.val$buffer[0])) > 0) {
                                byteArrayOutputStream.write(this.val$buffer[0], 0, n);
                            }
                            bufferedInputStream.close();
                            byteArrayOutputStream.flush();
                            this.val$buffer[0] = byteArrayOutputStream.toByteArray();
                        }
                        catch (IOException iOException) {
                            System.err.println(iOException.toString());
                            return;
                        }
                    }
                });
                if (byArrayArray[0] == null) {
                    System.err.println(clazz.getName() + "/" + string + " not found.");
                    return null;
                }
                if (byArrayArray[0].length == 0) {
                    System.err.println("warning: " + string + " is zero-length");
                    return null;
                }
                return new IconUIResource(new ImageIcon(byArrayArray[0]));
            }

            static /* synthetic */ String access$000(1 var0) {
                return var0.string;
            }

            static /* synthetic */ Class access$100(1 var0) {
                return var0.clazz;
            }
        };
    }

    public abstract String getName();

    public abstract String getID();

    public abstract String getDescription();

    public abstract boolean isNativeLookAndFeel();

    public abstract boolean isSupportedLookAndFeel();

    public void initialize() {
    }

    public void uninitialize() {
    }

    public UIDefaults getDefaults() {
        return null;
    }

    public String toString() {
        return "[" + this.getDescription() + " - " + this.getClass().getName() + "]";
    }
}

