/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import sun.awt.motif.CheckExitCodeRunnable;
import sun.awt.motif.NullProcess;
import sun.awt.motif.PSPaperSize;
import sun.awt.motif.PSPrintJob;
import sun.awt.print.PrintControl;
import sun.awt.print.PrintDialog;
import sun.awt.print.PrintStatusDialog;
import sun.awt.print.PrinterCapabilities;
import sun.awt.print.PrinterListUpdatable;

public class PSPrintControl
extends PrintControl {
    private static ResourceBundle messageRB;
    private static String[] sortedPrinterList;
    private static long lastPrinterListQueryMillis;
    private static final long QUERY_INTERVAL = 900000L;
    private static final String DEST_PROP = "awt.print.destination";
    private static final String PRINTER = "printer";
    private static final String FILE = "file";
    private static final String PRINTER_PROP = "awt.print.printer";
    private static final String FILENAME_PROP = "awt.print.fileName";
    private static final String NUMCOPIES_PROP = "awt.print.numCopies";
    private static final String OPTIONS_PROP = "awt.print.options";
    private static final String ORIENT_PROP = "awt.print.orientation";
    private static final String PORTRAIT = "portrait";
    private static final String LANDSCAPE = "landscape";
    private static final String PAPERSIZE_PROP = "awt.print.paperSize";
    private static final String LETTER = "letter";
    private static final String LEGAL = "legal";
    private static final String EXECUTIVE = "executive";
    private static final String A4 = "a4";
    private Hashtable procTable = new Hashtable();
    private PrintDialog dialog;
    private Properties props;

    static void initResource() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    messageRB = ResourceBundle.getBundle("sun.awt.motif.resources.printcontrol");
                    return null;
                }
                catch (MissingResourceException missingResourceException) {
                    throw new Error("Fatal: Resource for PSPrintControl is missing.");
                }
            }
        });
    }

    static synchronized String getMsg(String string) {
        if (messageRB == null) {
            PSPrintControl.initResource();
        }
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PSPrintControl is broken. There is no " + string + " key in resource");
        }
    }

    public PSPrintControl(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        super(frame, string, jobAttributes, pageAttributes);
    }

    public PSPrintControl(Frame frame, String string, Properties properties) {
        super(frame, string, null, null);
        this.props = properties;
        this.translateInputProps();
    }

    public PrintJob initJob() {
        PrintJob printJob = super.initJob();
        if (printJob != null) {
            this.translateOutputProps();
        }
        return printJob;
    }

    public String getDefaultPrinterName() {
        String string = "lp";
        try {
            Process process;
            final String[] stringArray = new String[3];
            if (System.getProperty("os.name").equals("Linux")) {
                stringArray[0] = "/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = "/usr/sbin/lpc status | grep : | sed -ne '1,1 s/://p'";
            } else {
                stringArray[0] = "/usr/bin/sh";
                stringArray[1] = "-c";
                stringArray[2] = "/usr/bin/lpstat -d|/usr/bin/expand|/usr/bin/cut -f4 -d' '";
            }
            try {
                process = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return Runtime.getRuntime().exec(stringArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            process.waitFor();
            if (process.exitValue() == 0) {
                InputStream inputStream = process.getInputStream();
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                string = new String(byArray).trim();
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return string;
    }

    public boolean getCapabilities(PrinterCapabilities printerCapabilities) {
        printerCapabilities.setCapabilities(3L);
        return true;
    }

    public void getPrinterList(final PrinterListUpdatable printerListUpdatable) {
        long l = System.currentTimeMillis();
        if (sortedPrinterList != null && l - lastPrinterListQueryMillis < 900000L) {
            printerListUpdatable.updatePrinterList(sortedPrinterList);
            return;
        }
        lastPrinterListQueryMillis = l;
        new Thread(new Runnable(){

            public void run() {
                String[] stringArray = null;
                try {
                    Process process;
                    String[] stringArray2 = new String[3];
                    if (System.getProperty("os.name").equals("Linux")) {
                        stringArray2[0] = "/bin/sh";
                        stringArray2[1] = "-c";
                        stringArray2[2] = "/usr/sbin/lpc status | grep : | sed -e 's/://'";
                    } else {
                        stringArray2[0] = "/usr/bin/sh";
                        stringArray2[1] = "-c";
                        stringArray2[2] = "/usr/bin/lpstat -v|/usr/bin/expand|/usr/bin/cut -f3 -d' '|/usr/bin/cut -f1 -d':'|/usr/bin/sort -u";
                    }
                    try {
                        process = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(this, stringArray2){
                            private final /* synthetic */ String[] val$cmd;
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$cmd = stringArray;
                            }

                            public Object run() throws IOException {
                                return Runtime.getRuntime().exec(this.val$cmd);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                    process.waitFor();
                    if (process.exitValue() == 0) {
                        InputStream inputStream = process.getInputStream();
                        String string = "";
                        while (inputStream.available() > 0) {
                            byte[] byArray = new byte[inputStream.available()];
                            inputStream.read(byArray);
                            string = string + new String(byArray);
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        int n = stringTokenizer.countTokens();
                        stringArray = new String[n];
                        int n2 = 0;
                        while (n2 < n) {
                            stringArray[n2] = stringTokenizer.nextToken();
                            ++n2;
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PSPrintControl.access$102(stringArray);
                printerListUpdatable.updatePrinterList(sortedPrinterList);
            }
        }).start();
    }

    private void translateInputProps() {
        if (this.props == null) {
            return;
        }
        String string = this.props.getProperty(DEST_PROP);
        if (string != null) {
            if (string.equals(PRINTER)) {
                this.setDestAttrib(JobAttributes.DestinationType.PRINTER);
            } else if (string.equals(FILE)) {
                this.setDestAttrib(JobAttributes.DestinationType.FILE);
            }
        }
        if ((string = this.props.getProperty(PRINTER_PROP)) != null) {
            this.setPrinterAttrib(string);
        }
        if ((string = this.props.getProperty(FILENAME_PROP)) != null) {
            this.setFileNameAttrib(string);
        }
        if ((string = this.props.getProperty(NUMCOPIES_PROP)) != null) {
            this.setCopiesAttrib(Integer.parseInt(string));
        }
        if ((string = this.props.getProperty(OPTIONS_PROP)) != null) {
            this.setOptions(string);
        }
        if ((string = this.props.getProperty(ORIENT_PROP)) != null) {
            if (string.equals(PORTRAIT)) {
                this.setOrientAttrib(PageAttributes.OrientationRequestedType.PORTRAIT);
            } else if (string.equals(LANDSCAPE)) {
                this.setOrientAttrib(PageAttributes.OrientationRequestedType.LANDSCAPE);
            }
        }
        if ((string = this.props.getProperty(PAPERSIZE_PROP)) != null) {
            if (string.equals(LETTER)) {
                this.setMediaAttrib(PageAttributes.MediaType.LETTER.hashCode());
            } else if (string.equals(LEGAL)) {
                this.setMediaAttrib(PageAttributes.MediaType.LEGAL.hashCode());
            } else if (string.equals(EXECUTIVE)) {
                this.setMediaAttrib(PageAttributes.MediaType.EXECUTIVE.hashCode());
            } else if (string.equals(A4)) {
                this.setMediaAttrib(PageAttributes.MediaType.A4.hashCode());
            }
        }
    }

    private void translateOutputProps() {
        int n;
        if (this.props == null) {
            return;
        }
        this.props.setProperty(DEST_PROP, this.getDestAttrib() == JobAttributes.DestinationType.PRINTER ? PRINTER : FILE);
        String string = this.getPrinterAttrib();
        if (string != null && !string.equals("")) {
            this.props.setProperty(PRINTER_PROP, this.getPrinterAttrib());
        }
        if ((string = this.getFileNameAttrib()) != null && !string.equals("")) {
            this.props.setProperty(FILENAME_PROP, string);
        }
        if ((n = this.getCopiesAttrib()) > 0) {
            this.props.setProperty(NUMCOPIES_PROP, "" + n);
        }
        if ((string = this.getOptions()) != null && !string.equals("")) {
            this.props.setProperty(OPTIONS_PROP, string);
        }
        this.props.setProperty(ORIENT_PROP, this.getOrientAttrib() == PageAttributes.OrientationRequestedType.PORTRAIT ? PORTRAIT : LANDSCAPE);
        PageAttributes.MediaType mediaType = PrintControl.SIZES[this.getMediaAttrib()];
        string = mediaType == PageAttributes.MediaType.LETTER ? LETTER : (mediaType == PageAttributes.MediaType.LEGAL ? LEGAL : (mediaType == PageAttributes.MediaType.EXECUTIVE ? EXECUTIVE : (mediaType == PageAttributes.MediaType.A4 ? A4 : mediaType.toString())));
        this.props.setProperty(PAPERSIZE_PROP, string);
    }

    protected PrintJob createPrintJob() {
        int n;
        Object object;
        OutputStream outputStream = null;
        Process process = null;
        String[] stringArray = new String[1];
        String string = null;
        if (this.getDestAttrib() == JobAttributes.DestinationType.PRINTER) {
            try {
                stringArray = this.printExecCmd(this.getPrinterAttrib(), this.getOptions(), this.doctitle);
                object = stringArray;
                try {
                    process = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction((String[])object){
                        private final /* synthetic */ String[] val$cmd;
                        {
                            this.val$cmd = stringArray;
                        }

                        public Object run() throws IOException {
                            return Runtime.getRuntime().exec(this.val$cmd);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                outputStream = process.getOutputStream();
            }
            catch (IOException iOException) {
                string = PSPrintControl.getMsg("error_msg.exec_print") + stringArray[0];
            }
        } else {
            object = new File(this.getFileNameAttrib());
            String string2 = "";
            try {
                try {
                    string2 = (String)AccessController.doPrivileged(new PrivilegedExceptionAction((File)object){
                        private final /* synthetic */ File val$destFile;
                        {
                            this.val$destFile = file;
                        }

                        public Object run() throws IOException {
                            return this.val$destFile.getCanonicalPath();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                if (this.getDialogAttrib() != JobAttributes.DialogType.NONE && ((File)object).exists()) {
                    String string3 = PSPrintControl.getMsg("warning_button.cancel");
                    String string4 = PSPrintControl.getMsg("warning_button.overwrite");
                    PrintStatusDialog printStatusDialog = new PrintStatusDialog(this.dialog, PSPrintControl.getMsg("warning_dialog.title"), PSPrintControl.getMsg("warning_msg.file_exists") + this.getFileNameAttrib(), string4, string3);
                    printStatusDialog.setLocationRelativeTo(this.dialog);
                    printStatusDialog.setVisible(true);
                    if (printStatusDialog.getCommand().equals(string3)) {
                        return null;
                    }
                }
                try {
                    outputStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction((File)object){
                        private final /* synthetic */ File val$destFile;
                        {
                            this.val$destFile = file;
                        }

                        public Object run() throws IOException {
                            return new FileOutputStream(this.val$destFile);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
            }
            catch (IOException iOException) {
                string = PSPrintControl.getMsg("error_msg.create_file") + string2;
            }
        }
        if (string != null) {
            if (this.getDialogAttrib() == JobAttributes.DialogType.NONE) {
                throw new InternalError(string);
            }
            object = new PrintStatusDialog(this.dialog, PSPrintControl.getMsg("error_dialog.title"), string, PSPrintControl.getMsg("error_button.ok"));
            ((JDialog)object).setLocationRelativeTo(this.dialog);
            ((Component)object).setVisible(true);
            return null;
        }
        object = PSPaperSize.standardSizeTable[this.getMediaAttrib()].size();
        int n2 = ((Dimension)object).width;
        int n3 = ((Dimension)object).height;
        if (this.getOrientAttrib() == PageAttributes.OrientationRequestedType.LANDSCAPE) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
            object = new Dimension(n2, n3);
        }
        if (this.getOriginAttrib() == PageAttributes.OriginType.PRINTABLE) {
            n2 -= 36;
            n3 -= 36;
        }
        if ((n = this.getResAttrib()) != 72) {
            n2 = (int)((double)n2 * ((double)n / 72.0));
            n3 = (int)((double)n3 * ((double)n / 72.0));
        }
        PSPrintJob pSPrintJob = new PSPrintJob(new PrintStream(new BufferedOutputStream(outputStream), false), this.doctitle != null ? this.doctitle : "", new Dimension(n2, n3), n, (Dimension)object, this);
        this.procTable.put(pSPrintJob, process == null ? new NullProcess() : process);
        return pSPrintJob;
    }

    protected PrintJob createPrintJob(PrintDialog printDialog) {
        this.dialog = printDialog;
        PrintJob printJob = super.createPrintJob(printDialog);
        this.dialog = null;
        return printJob;
    }

    public void finishedPrinting(PSPrintJob pSPrintJob) {
        Process process = (Process)this.procTable.get(pSPrintJob);
        new Thread(new CheckExitCodeRunnable(process, this, this.dialogOwner)).start();
    }

    private String[] printExecCmd(String string, String string2, String string3) {
        int n = 1;
        int n2 = 2;
        int n3 = 4;
        int n4 = 8;
        int n5 = 0;
        int n6 = 1;
        int n7 = 0;
        if (string != null && !string.equals("")) {
            n5 |= n;
            ++n6;
        }
        if (string2 != null && !string2.equals("")) {
            n5 |= n2;
            ++n6;
        }
        if (string3 != null && !string3.equals("")) {
            n5 |= n3;
            ++n6;
        } else if (string3 == null) {
            n5 |= n4;
            ++n6;
        }
        String[] stringArray = new String[n6];
        if (System.getProperty("os.name").equals("Linux")) {
            stringArray[n7++] = "/usr/bin/lpr";
            if ((n5 & n) != 0) {
                stringArray[n7++] = new String("-P" + string);
            }
            if ((n5 & n3) != 0) {
                stringArray[n7++] = new String("-T" + this.escapeString(string3));
            }
        } else {
            stringArray[n7++] = "/usr/bin/lp";
            if ((n5 & n) != 0) {
                stringArray[n7++] = new String("-d" + string);
            }
            if ((n5 & n3) != 0) {
                stringArray[n7++] = new String("-t" + this.escapeString(string3));
            }
            if ((n5 & n2) != 0) {
                stringArray[n7++] = new String("-o" + string2);
            }
            if ((n5 & n4) != 0) {
                stringArray[n7++] = new String("-onobanner");
            }
        }
        return stringArray;
    }

    private String escapeString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"\\", true);
        if (stringTokenizer.countTokens() == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1) {
                char c = string2.charAt(0);
                if (c == '\"' || c == '\\') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string2);
        }
        return new String(stringBuffer);
    }

    static /* synthetic */ String[] access$102(String[] stringArray) {
        sortedPrinterList = stringArray;
        return stringArray;
    }

    static {
        sortedPrinterList = null;
        lastPrinterListQueryMillis = 0L;
    }
}

