/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import com.sun.tools.corba.se.idl.Abstract;
import com.sun.tools.corba.se.idl.ForwardEntry;
import com.sun.tools.corba.se.idl.Generator;
import com.sun.tools.corba.se.idl.IDLID;
import com.sun.tools.corba.se.idl.InterfaceGen;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.ParseException;
import com.sun.tools.corba.se.idl.Scanner;
import com.sun.tools.corba.se.idl.SymtabEntry;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class InterfaceEntry
extends SymtabEntry
implements Abstract {
    private Vector _derivedFromNames = new Vector();
    private Vector _derivedFrom = new Vector();
    private Vector _methods = new Vector();
    Vector _allMethods = new Vector();
    Vector forwardedDerivers = new Vector();
    private Vector _contained = new Vector();
    private Vector _state = null;
    private boolean _abstract = false;
    static InterfaceGen interfaceGen;

    protected InterfaceEntry() {
    }

    protected InterfaceEntry(InterfaceEntry interfaceEntry) {
        super(interfaceEntry);
        this._derivedFromNames = (Vector)interfaceEntry._derivedFromNames.clone();
        this._derivedFrom = (Vector)interfaceEntry._derivedFrom.clone();
        this._methods = (Vector)interfaceEntry._methods.clone();
        this._allMethods = (Vector)interfaceEntry._allMethods.clone();
        this.forwardedDerivers = (Vector)interfaceEntry.forwardedDerivers.clone();
        this._contained = (Vector)interfaceEntry._contained.clone();
    }

    protected InterfaceEntry(SymtabEntry symtabEntry, IDLID iDLID) {
        super(symtabEntry, iDLID);
        if (this.module().equals("")) {
            this.module(this.name());
        } else if (!this.name().equals("")) {
            this.module(this.module() + "/" + this.name());
        }
    }

    public Object clone() {
        return new InterfaceEntry(this);
    }

    public void generate(Hashtable hashtable, PrintWriter printWriter) {
        interfaceGen.generate(hashtable, this, printWriter);
    }

    public Generator generator() {
        return interfaceGen;
    }

    public void addDerivedFrom(SymtabEntry symtabEntry) {
        this._derivedFrom.addElement(symtabEntry);
    }

    public Vector derivedFrom() {
        return this._derivedFrom;
    }

    public void addDerivedFromName(String string) {
        this._derivedFromNames.addElement(string);
    }

    public Vector derivedFromNames() {
        return this._derivedFromNames;
    }

    public void addMethod(MethodEntry methodEntry) {
        this._methods.addElement(methodEntry);
    }

    public Vector methods() {
        return this._methods;
    }

    public void addContained(SymtabEntry symtabEntry) {
        this._contained.addElement(symtabEntry);
    }

    public Vector contained() {
        return this._contained;
    }

    void methodsAddElement(MethodEntry methodEntry, Scanner scanner) {
        if (this.verifyMethod(methodEntry, scanner, false)) {
            this.addMethod(methodEntry);
            this._allMethods.addElement(methodEntry);
            this.addToForwardedAllMethods(methodEntry, scanner);
        }
    }

    void addToForwardedAllMethods(MethodEntry methodEntry, Scanner scanner) {
        Enumeration enumeration = this.forwardedDerivers.elements();
        while (enumeration.hasMoreElements()) {
            InterfaceEntry interfaceEntry = (InterfaceEntry)enumeration.nextElement();
            if (!interfaceEntry.verifyMethod(methodEntry, scanner, true)) continue;
            interfaceEntry._allMethods.addElement(methodEntry);
        }
    }

    private boolean verifyMethod(MethodEntry methodEntry, Scanner scanner, boolean bl) {
        boolean bl2 = true;
        String string = methodEntry.name().toLowerCase();
        Enumeration enumeration = this._allMethods.elements();
        while (enumeration.hasMoreElements()) {
            MethodEntry methodEntry2 = (MethodEntry)enumeration.nextElement();
            String string2 = methodEntry2.name().toLowerCase();
            if (methodEntry == methodEntry2 || !string.equals(string2)) continue;
            if (bl) {
                ParseException.methodClash(scanner, this.fullName(), methodEntry.name());
            } else {
                ParseException.alreadyDeclared(scanner, methodEntry.name());
            }
            bl2 = false;
            break;
        }
        return bl2;
    }

    void derivedFromAddElement(SymtabEntry symtabEntry, Scanner scanner) {
        this.addDerivedFrom(symtabEntry);
        this.addDerivedFromName(symtabEntry.fullName());
        this.addParentType(symtabEntry, scanner);
    }

    void addParentType(SymtabEntry symtabEntry, Scanner scanner) {
        if (symtabEntry instanceof ForwardEntry) {
            this.addToDerivers((ForwardEntry)symtabEntry);
        } else {
            InterfaceEntry interfaceEntry = (InterfaceEntry)symtabEntry;
            Enumeration enumeration = interfaceEntry._allMethods.elements();
            while (enumeration.hasMoreElements()) {
                MethodEntry methodEntry = (MethodEntry)enumeration.nextElement();
                if (this.verifyMethod(methodEntry, scanner, true)) {
                    this._allMethods.addElement(methodEntry);
                }
                this.addToForwardedAllMethods(methodEntry, scanner);
            }
            this.lookForForwardEntrys(scanner, interfaceEntry);
        }
    }

    private void lookForForwardEntrys(Scanner scanner, InterfaceEntry interfaceEntry) {
        Enumeration enumeration = interfaceEntry.derivedFrom().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof ForwardEntry) {
                this.addToDerivers((ForwardEntry)symtabEntry);
                continue;
            }
            if (symtabEntry == interfaceEntry) {
                ParseException.selfInherit(scanner, interfaceEntry.fullName());
                continue;
            }
            this.lookForForwardEntrys(scanner, (InterfaceEntry)symtabEntry);
        }
    }

    public boolean replaceForwardDecl(ForwardEntry forwardEntry, InterfaceEntry interfaceEntry) {
        int n = this._derivedFrom.indexOf(forwardEntry);
        if (n >= 0) {
            this._derivedFrom.setElementAt(interfaceEntry, n);
        }
        return n >= 0;
    }

    private void addToDerivers(ForwardEntry forwardEntry) {
        forwardEntry.derivers.addElement(this);
        Enumeration enumeration = this.forwardedDerivers.elements();
        while (enumeration.hasMoreElements()) {
            forwardEntry.derivers.addElement((InterfaceEntry)enumeration.nextElement());
        }
    }

    public Vector state() {
        return this._state;
    }

    public void initState() {
        this._state = new Vector();
    }

    public void addStateElement(InterfaceState interfaceState, Scanner scanner) {
        if (this._state == null) {
            this._state = new Vector();
        }
        String string = interfaceState.entry.name();
        Enumeration enumeration = this._state.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.equals(((InterfaceState)enumeration.nextElement()).entry.name())) continue;
            ParseException.duplicateState(scanner, string);
        }
        this._state.addElement(interfaceState);
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setAbstract(boolean bl) {
        this._abstract = bl;
    }

    public Vector allMethods() {
        return this._allMethods;
    }
}

