/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.util;

import com.sun.tools.javac.v8.util.Util;

public class Bits {
    private static final int wordlen = 32;
    private static final int wordshift = 5;
    private static final int wordmask = 31;
    private int[] bits;

    public Bits() {
        this(new int[1]);
    }

    public Bits(int[] nArray) {
        this.bits = nArray;
    }

    public Bits(int n, int n2) {
        this();
        this.inclRange(n, n2);
    }

    private void sizeTo(int n) {
        if (this.bits.length < n) {
            int[] nArray = new int[n];
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.bits.length) {
            this.bits[n] = 0;
            ++n;
        }
    }

    public Bits dup() {
        int[] nArray = new int[this.bits.length];
        System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
        return new Bits(nArray);
    }

    public void incl(int n) {
        Util.assert(n >= 0);
        this.sizeTo((n >>> 5) + 1);
        this.bits[n >>> 5] = this.bits[n >>> 5] | 1 << (n & 0x1F);
    }

    public void inclRange(int n, int n2) {
        this.sizeTo((n2 >>> 5) + 1);
        int n3 = n;
        while (n3 < n2) {
            this.bits[n3 >>> 5] = this.bits[n3 >>> 5] | 1 << (n3 & 0x1F);
            ++n3;
        }
    }

    public void excl(int n) {
        Util.assert(n >= 0);
        this.sizeTo((n >>> 5) + 1);
        this.bits[n >>> 5] = this.bits[n >>> 5] & ~(1 << (n & 0x1F));
    }

    public boolean isMember(int n) {
        return 0 <= n && n < this.bits.length << 5 && (this.bits[n >>> 5] & 1 << (n & 0x1F)) != 0;
    }

    public Bits andSet(Bits bits) {
        this.sizeTo(bits.bits.length);
        int n = 0;
        while (n < bits.bits.length) {
            this.bits[n] = this.bits[n] & bits.bits[n];
            ++n;
        }
        return this;
    }

    public Bits orSet(Bits bits) {
        this.sizeTo(bits.bits.length);
        int n = 0;
        while (n < bits.bits.length) {
            this.bits[n] = this.bits[n] | bits.bits[n];
            ++n;
        }
        return this;
    }

    public Bits diffSet(Bits bits) {
        int n = 0;
        while (n < this.bits.length) {
            if (n < bits.bits.length) {
                this.bits[n] = this.bits[n] & ~bits.bits[n];
            }
            ++n;
        }
        return this;
    }

    public String toString() {
        char[] cArray = new char[this.bits.length * 32];
        int n = 0;
        while (n < this.bits.length * 32) {
            cArray[n] = this.isMember(n) ? 49 : 48;
            ++n;
        }
        return new String(cArray);
    }
}

