/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.PrintWriter;
import sun.tools.java.BinaryConstantPool;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.Constants;
import sun.tools.javap.JavaPEnvironment;

public final class ConstantPrinter
implements Constants {
    BinaryConstantPool cpool;
    private JavaPEnvironment env;
    private PrintWriter output;
    private boolean decodeTypeSignatures;

    public ConstantPrinter(BinaryConstantPool binaryConstantPool, JavaPEnvironment javaPEnvironment, PrintWriter printWriter, boolean bl) {
        this.cpool = binaryConstantPool;
        this.env = javaPEnvironment;
        this.output = printWriter;
        this.decodeTypeSignatures = bl;
    }

    public String getString(int n) {
        return this.cpool.getString(n);
    }

    private void printNameAndType(int n, String string, boolean bl) {
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        this.output.print(this.cpool.getString(n2) + string);
        if (bl) {
            this.output.print(this.cpool.getType(n3));
        } else {
            this.output.print(this.cpool.getString(n3));
        }
    }

    private void printNameAndTypeFromIndex(int n, String string) {
        int n2 = this.cpool.getInteger(n);
        this.printNameAndType(n2, string, this.decodeTypeSignatures);
    }

    private void printRef(int n, String string) {
        if (this.decodeTypeSignatures) {
            this.output.print(this.cpool.getConstant(n, this.env));
        } else {
            int n2 = this.cpool.getInteger(n);
            int n3 = n2 >> 16;
            int n4 = n2 & 0xFFFF;
            this.output.print(this.cpool.getDeclaration(this.env, n3).getName());
            this.output.print(".");
            this.printNameAndTypeFromIndex(n4, string);
        }
    }

    public void printClassDeclaration(ClassDeclaration classDeclaration) {
        ClassDefinition classDefinition = classDeclaration.getClassDefinition();
        if (classDefinition != null && classDefinition.isInterface()) {
            this.output.print("<Interface ");
        } else {
            this.output.print("<Class ");
        }
        this.output.print(classDeclaration.getName());
        this.output.print(">");
    }

    public void printConstant(int n) {
        int n2 = this.cpool.getConstantType(n);
        switch (n2) {
            case 8: {
                this.output.print("<String \"" + this.cpool.getConstant(n, this.env) + "\"");
                break;
            }
            case 1: {
                this.output.print("<\"" + this.cpool.getString(n) + "\"");
                break;
            }
            case 3: {
                this.output.print("<Integer " + this.cpool.getInteger(n));
                break;
            }
            case 4: {
                this.output.print("<Real " + this.cpool.getValue(n));
                break;
            }
            case 5: {
                this.output.print("<Long " + this.cpool.getValue(n));
                break;
            }
            case 6: {
                this.output.print("<Double " + this.cpool.getValue(n));
                break;
            }
            case 7: {
                this.printClassDeclaration(this.cpool.getDeclaration(this.env, n));
                return;
            }
            case 10: {
                this.output.print("<Method ");
                this.printRef(n, "");
                break;
            }
            case 9: {
                this.output.print("<Field ");
                this.printRef(n, " ");
                break;
            }
            case 11: {
                this.output.print("<InterfaceMethod ");
                this.printRef(n, "");
                break;
            }
            case 12: {
                this.output.print("<NameAndType");
                this.printNameAndTypeFromIndex(n, " ");
                break;
            }
            default: {
                this.output.print("<Unknown " + n2);
            }
        }
        this.output.print('>');
    }
}

