/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public abstract class CustomControls
extends JPanel
implements Runnable {
    protected Thread thread;
    protected boolean doNotifier;
    private CCNotifierThread ccnt;
    private String name = "foo.bar Demo";
    private static final Color blue = new Color(204, 204, 255);

    public CustomControls() {
        this.setBackground(Color.gray);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (CustomControls.this.thread == null) {
                    CustomControls.this.start();
                } else {
                    CustomControls.this.stop();
                }
            }
        });
    }

    public CustomControls(String string) {
        this();
        this.name = string + " Demo";
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.doNotifier ? blue : Color.gray);
        graphics.fillRect(this.getSize().width - 2, 0, 2, 2);
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName(this.name + " ccthread");
            this.thread.start();
            this.ccnt = new CCNotifierThread();
            this.ccnt.start();
            this.ccnt.setName(this.name + " ccthread notifier");
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            if (this.ccnt != null) {
                this.ccnt.interrupt();
            }
        }
        this.thread = null;
    }

    public void run() {
    }

    class CCNotifierThread
    extends Thread {
        CCNotifierThread() {
        }

        public void run() {
            while (CustomControls.this.thread != null) {
                CustomControls.this.doNotifier = !CustomControls.this.doNotifier;
                CustomControls.this.repaint();
                try {
                    Thread.sleep(444L);
                }
                catch (Exception exception) {
                    break;
                }
            }
            CustomControls.this.doNotifier = false;
            CustomControls.this.repaint();
        }
    }
}

