/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

class GeneralPathIterator
implements PathIterator {
    int typeIdx = 0;
    int pointIdx = 0;
    GeneralPath path;
    AffineTransform affine;
    private static final int[] curvesize = new int[]{2, 2, 4, 6, 0};

    GeneralPathIterator(GeneralPath generalPath) {
        this(generalPath, null);
    }

    GeneralPathIterator(GeneralPath generalPath, AffineTransform affineTransform) {
        this.path = generalPath;
        this.affine = affineTransform;
    }

    public int getWindingRule() {
        return this.path.getWindingRule();
    }

    public boolean isDone() {
        return this.typeIdx >= this.path.numTypes;
    }

    public void next() {
        byte by = this.path.pointTypes[this.typeIdx++];
        this.pointIdx += curvesize[by];
    }

    public int currentSegment(float[] fArray) {
        byte by = this.path.pointTypes[this.typeIdx];
        int n = curvesize[by];
        if (n > 0 && this.affine != null) {
            this.affine.transform(this.path.pointCoords, this.pointIdx, fArray, 0, n / 2);
        } else {
            System.arraycopy(this.path.pointCoords, this.pointIdx, fArray, 0, n);
        }
        return by;
    }

    public int currentSegment(double[] dArray) {
        byte by = this.path.pointTypes[this.typeIdx];
        int n = curvesize[by];
        if (n > 0 && this.affine != null) {
            this.affine.transform(this.path.pointCoords, this.pointIdx, dArray, 0, n / 2);
        } else {
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = this.path.pointCoords[this.pointIdx + n2];
                ++n2;
            }
        }
        return by;
    }
}

