/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Dimension;
import java.awt.PageAttributes;
import sun.awt.DebugHelper;
import sun.awt.print.PrintControl;

class PSPaperSize {
    String paperSizeName;
    Dimension paperSize;
    int tolerance;
    private static final String[] PSSIZES = new String[]{"4A0", "2A0", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "A10", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8", "B9", "B10", "JIS.B0", "JIS.B1", "JIS.B2", "JIS.B3", "JIS.B4", "JIS.B5", "JIS.B6", "JIS.B7", "JIS.B8", "JIS.B9", "JIS.B10", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "C10", "ISO.Designated.Long", "Executive", "Folio", "Invoice", "Ledger", "Letter", "Legal", "Quarto", "A", "B", "C", "D", "E", "10x15", "10x14", "10x13", "9x12", "9x11", "7x9", "6x9", "#9.Envelope", "#10.Envelope", "#11.Envelope", "#12.Envelope", "#14.Envelope", "Invite.Envelope", "Italy.Envelope", "Monarch.Envelope", "Personal.Envelope"};
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$motif$PSPaperSize == null ? (class$sun$awt$motif$PSPaperSize = PSPaperSize.class$("sun.awt.motif.PSPaperSize")) : class$sun$awt$motif$PSPaperSize);
    static PSPaperSize[] standardSizeTable = new PSPaperSize[PrintControl.SIZES.length];
    static /* synthetic */ Class class$sun$awt$motif$PSPaperSize;

    public String name() {
        return this.paperSizeName;
    }

    public Dimension size() {
        return this.paperSize;
    }

    public int width() {
        return this.paperSize.width;
    }

    public int height() {
        return this.paperSize.height;
    }

    public String toInitClip(String string, int n) {
        return "mark {\n  currentpagedevice /PageSize get\n  dup 0 get /" + string + "W exch def\n" + "  1 get /" + string + "H exch def\n" + "} stopped {\n" + "  /" + string + "W " + this.width() + " def\n" + "  /" + string + "H " + this.height() + " def\n" + "} if cleartomark\n" + "/" + string + " {\n" + "  initclip matrix currentmatrix initmatrix\n" + "  " + n + " " + n + " moveto\n" + "  " + n + " " + string + "H " + n + " sub lineto\n" + "  " + string + "W " + n + " sub " + string + "H " + n + " sub lineto\n" + "  " + string + "W " + n + " sub " + n + " lineto\n" + "  closepath clip setmatrix newpath\n" + "} bind def";
    }

    public String toPostScriptCode(int n, boolean bl) {
        if (n == 2) {
            return "mark {\n%%BeginFeature: *ManualFeed " + (bl ? "True" : "False") + "\n" + "<< /ManualFeed " + bl + "\n" + "   /Policies << /ManualFeed 1 >>\n" + ">> setpagedevice\n" + "%%EndFeature\n" + "%%BeginFeature: *PageSize " + this.paperSizeName + "\n" + "<< /PageSize [" + this.width() + " " + this.height() + "]\n" + "   /ImagingBBox null\n" + "   /Policies << /PageSize 3 >>\n" + ">> setpagedevice\n" + "%%EndFeature\n" + "} stopped cleartomark";
        }
        String string = this.paperSizeName.toLowerCase();
        if (!bl) {
            string = string + "tray";
        }
        return "mark {\n%%BeginFeature: ManualFeed " + (bl ? "True" : "False") + "\n" + "1 dict dup /ManualFeed " + bl + " put setpagedevice\n" + "%%EndFeature\n" + "} stopped {\n" + "%%BeginFeature: *ManualFeed " + (bl ? "True" : "False") + "\n" + "  statusdict /manualfeed " + bl + " put\n" + "%%EndFeature\n" + "} if cleartomark mark {\n" + "%%BeginFeature: PageSize *" + this.paperSizeName + "\n" + "3 dict begin\n" + "   /PageSize [" + this.width() + " " + this.height() + "] def\n" + "   /ImagingBBox null def\n" + "   /Policies 1 dict dup/PageSize 3 put def\n" + " currentdict end setpagedevice\n" + "%%EndFeature\n" + "} stopped {\n" + "  cleartomark statusdict begin mark {\n" + "%%BeginFeature: *PageSize " + this.paperSizeName + "\n" + "  " + string + "\n" + "%%EndFeature\n" + "  } stopped end\n" + "} if cleartomark\n" + "% now make sure we got what we requested!\n" + "gsave initgraphics clippath pathbbox grestore\n" + "5 dict begin\n" + "  3 -1 roll /yoff exch def 3 -1 roll /xoff exch def\n" + "  yoff sub /h exch def xoff sub /w exch def\n" + "  w " + (this.paperSize.width - 36) + " lt h " + (this.paperSize.height - 36) + " lt or {\n" + "    w 2 div xoff add h 2 div yoff add translate\n" + "    w xoff 2 mul add " + this.paperSize.width + " div\n" + "    h yoff 2 mul add " + this.paperSize.height + " div\n" + "    2 copy gt {exch} if pop dup scale\n" + "    " + -this.paperSize.width / 2 + " " + -this.paperSize.height / 2 + " translate\n" + "  } if\n" + "end\n";
    }

    public String toPostScriptCode() {
        return this.toPostScriptCode(1, false);
    }

    public String toString() {
        return "PSPaperSize[" + this.paperSizeName + ": " + this.paperSize.width + "x" + this.paperSize.height + "]";
    }

    public PSPaperSize(String string, int n, int n2) {
        this.paperSizeName = string;
        this.tolerance = 0;
        this.paperSize = new Dimension(n, n2);
    }

    public PSPaperSize(String string, int n, int n2, int n3) {
        this.paperSizeName = string;
        this.tolerance = n;
        this.paperSize = new Dimension(n2, n3);
    }

    public static PSPaperSize find(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < standardSizeTable.length) {
            if (string.equalsIgnoreCase(PSPaperSize.standardSizeTable[n].paperSizeName)) {
                return standardSizeTable[n];
            }
            ++n;
        }
        return null;
    }

    public static PSPaperSize find(int n, int n2, int n3) {
        int n4 = n3 + 1;
        int n5 = n3 + 1;
        PSPaperSize pSPaperSize = null;
        int n6 = 0;
        while (n6 < standardSizeTable.length) {
            PSPaperSize pSPaperSize2 = standardSizeTable[n6];
            int n7 = Math.abs(pSPaperSize2.paperSize.width - n);
            int n8 = Math.abs(pSPaperSize2.paperSize.height - n2);
            if (n7 <= pSPaperSize2.tolerance && n8 <= pSPaperSize2.tolerance) {
                return pSPaperSize2;
            }
            if (n7 <= n3 && n8 <= n3 && n7 + n8 < n4 + n5) {
                n4 = n7;
                n5 = n8;
                pSPaperSize = pSPaperSize2;
            }
            ++n6;
        }
        return pSPaperSize;
    }

    public static PSPaperSize find(int n, int n2) {
        return PSPaperSize.find(n, n2, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n = PageAttributes.MediaType.EXECUTIVE.hashCode();
        int n2 = 0;
        while (n2 < PrintControl.SIZES.length) {
            PSPaperSize.standardSizeTable[n2] = n2 == n ? new PSPaperSize(PSSIZES[n2], 36, 540, 720) : new PSPaperSize(PSSIZES[n2], PrintControl.WIDTHS[n2], PrintControl.LENGTHS[n2]);
            ++n2;
        }
    }
}

