#/bin/sh
# Move the library into place:
( cd lib/incoming
  for file in * ; do
    if [ ! -r ../$file ]; then
      cp -a $file ..
    fi
  done )
# Now, get rid of the temporary directory:
rm -rf lib/incoming
# Prepare the library for use with ldconfig:
if [ -x sbin/ldconfig ]; then
  chroot . /sbin/ldconfig
else
  ( cd lib ; rm -rf libsafe.so.2 )
  ( cd lib ; ln -sf libsafe.so.2.0 libsafe.so.2 )
fi
# Last, add the library to /etc/ld.so.preload:
if fgrep libsafe.so.2 etc/ld.so.preload 1> /dev/null 2> /dev/null ; then
  GOOD=we_found_it
else
  echo "/lib/libsafe.so.2" >> etc/ld.so.preload
fi
