<!--
    print.dsl.in - stylesheets for hardcopy output.

    $Id: print.dsl.in,v 1.2 1998/10/17 10:38:12 cg Exp $

    SGMLtools - an SGML toolkit.
    Copyright (C) 1998 Cees A. de Groot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  --> 
<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA dsssl>
]>
<style-sheet>

<style-specification id="print" use="docbook">
<style-specification-body> 

    ;; this is necessary because right now jadetex does not understand
    ;; symbolic entities, whereas things work well with numeric entities.
    (declare-characteristic preserve-sdata?
	      "UNREGISTERED::James Clark//Characteristic::preserve-sdata?"
	      #f)

    (define %two-side% #t)
    (define %section-autolabel% #t)
    (define %visual-acuity% "presbyopic")

    (define %graphic-default-extension% "eps")

    ;;
    ;;  Graphical admonitions.
    ;;
    (define %admon-graphics% #t)
    (define %admon-graphics-path%
      "/opt/sgml/share/sgml/stylesheets/docbook/images/")
    (define ($admon-graphic$ #!optional (nd (current-node)))
      (cond ((equal? (gi nd) (normalize "tip"))
	     (string-append %admon-graphics-path% "tip.eps"))
	    ((equal? (gi nd) (normalize "note"))
	     (string-append %admon-graphics-path% "note.eps"))
	    ((equal? (gi nd) (normalize "important"))
	     (string-append %admon-graphics-path% "important.eps"))
	    ((equal? (gi nd) (normalize "caution"))
	     (string-append %admon-graphics-path% "caution.eps"))
	    ((equal? (gi nd) (normalize "warning"))
	     (string-append %admon-graphics-path% "warning.eps"))
	    (else (error (string-append (gi nd) " is not an admonition.")))))
     
</style-specification-body>
</style-specification>

<style-specification id="howto" use="print">
<style-specification-body>
    ;;
    ;;  A paper-saving stylesheet that mimics the SGMLtools 1.0 howto style.
    ;;  Not two-sided, because most people won't print two-sided.
    ;;
    (define %visual-acuity% "normal")
    (define %two-side% #f)
    (define %left-margin% 3pi)
    (define %right-margin% 4pi)
    (define %body-start-indent% 2pi)
    (define %generate-article-toc% #t)
    ;;
    ;;  Gnuishly correct fonts...
    ;;
    (define %body-font-family% "Computer Modern Roman")
    (define %mono-font-family% "Computer Modern Typewriter")
    (define %title-font-family% "Computer Modern Sans");
    (define %admon-font-family% "Computer Modern Sans");
    (define %guilabel-font-family% "Computer Modern Sans");
    
</style-specification-body>
</style-specification>

<external-specification id="docbook" document="docbook.dsl">
</style-sheet>
