/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIChannel.idl
 */

#ifndef __gen_nsIChannel_h__
#define __gen_nsIChannel_h__


#ifndef __gen_nsIRequest_h__
#include "nsIRequest.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIURI; /* forward declaration */

class nsIInterfaceRequestor; /* forward declaration */

class nsIInputStream; /* forward declaration */

class nsIStreamListener; /* forward declaration */


/* starting interface:    nsIChannel */
#define NS_ICHANNEL_IID_STR "1788e79e-f947-11d3-8cda-0060b0fc14a3"

#define NS_ICHANNEL_IID \
  {0x1788e79e, 0xf947, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

/**
 * The nsIChannel interface allows the user to construct GET requests for
 * specific protocols, and manage them in a uniform way. Once a channel
 * is created (via nsIIOService::NewChannel), parameters for that request
 * may be set by using the channel attributes, or by QI'ing to a subclass
 * of nsIChannel for protocol-specific parameters. Then the actual request
 * can be issued via Open or AsyncOpen.
 *
 * After a request has been completed, the channel is still valid for
 * accessing protocol-specific results. For example, QI'ing to nsIHTTPChannel
 * allows response headers to be retrieved for the http transaction. 
 */
class nsIChannel : public nsIRequest {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ICHANNEL_IID)

  /**
     * Returns the original URL used to construct the channel.
     * This is used in the case of a redirect or URI "resolution" (e.g. 
     * resolving a resource: URI to a file: URI) so that the original
     * pre-redirect URI can still be obtained. 
     *
     * Note that this is distinctly different from the http referrer
     * (referring URI) which is typically the page that contained the 
     * original URI (accessible from nsIHTTPChannel).
     */
  /* attribute nsIURI originalURI; */
  NS_IMETHOD GetOriginalURI(nsIURI * *aOriginalURI) = 0;
  NS_IMETHOD SetOriginalURI(nsIURI * aOriginalURI) = 0;

  /**
     * Returns the URL to which the channel currently refers. If a redirect
     * or URI resolution occurs, this accessor returns the current location
     * to which the channel is referring.
     */
  /* readonly attribute nsIURI URI; */
  NS_IMETHOD GetURI(nsIURI * *aURI) = 0;

  /**
     * Accesses the owner corresponding to the entity that is 
     * responsible for this channel. Used by security code to grant
     * or deny privileges to mobile code loaded from this channel. 
     *
     * Note: This is a strong reference to the owner, so if the owner is also
     * holding a pointer to the channel, care must be taken to explicitly drop
     * its reference to the channel -- otherwise a leak will result.
     */
  /* attribute nsISupports owner; */
  NS_IMETHOD GetOwner(nsISupports * *aOwner) = 0;
  NS_IMETHOD SetOwner(nsISupports * aOwner) = 0;

  /**
     * Accesses the capabilities callbacks of the channel. This is set by clients
     * who wish to provide a means to receive progress, status and protocol-specific 
     * notifications.  Interfaces commonly requested include: nsIProgressEventSink
     * and nsIPrompt.
     */
  /* attribute nsIInterfaceRequestor notificationCallbacks; */
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor * *aNotificationCallbacks) = 0;
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor * aNotificationCallbacks) = 0;

  /**
     * Any security information about this channel.  This can be null.
     */
  /* readonly attribute nsISupports securityInfo; */
  NS_IMETHOD GetSecurityInfo(nsISupports * *aSecurityInfo) = 0;

  /**
     * Returns the content MIME type of the channel if available. Note that the 
     * content type can often be wrongly specified (wrong file extension, wrong
     * MIME type, wrong document type stored on a server, etc.) and the caller
     * most likely wants to verify with the actual data. 
     */
  /* attribute string contentType; */
  NS_IMETHOD GetContentType(char * *aContentType) = 0;
  NS_IMETHOD SetContentType(const char * aContentType) = 0;

  /**
     * Returns the length of the data associated with the channel if available.
     * If the length is unknown then -1 is returned.
     */
  /* attribute long contentLength; */
  NS_IMETHOD GetContentLength(PRInt32 *aContentLength) = 0;
  NS_IMETHOD SetContentLength(PRInt32 aContentLength) = 0;

  /**
     * Synchronously open this channel.  Returns a blocking input stream to this
     * channel's data.
     */
  /* nsIInputStream open (); */
  NS_IMETHOD Open(nsIInputStream **_retval) = 0;

  /**
     * Asynchronously open this channel.  Data is fed to the specified stream
     * listener as it becomes available.
     */
  /* void asyncOpen (in nsIStreamListener listener, in nsISupports ctxt); */
  NS_IMETHOD AsyncOpen(nsIStreamListener *listener, nsISupports *ctxt) = 0;

  /**************************************************************************
     * Channel specific load flags:
     */
/**
     * Used exclusively by the uriloader and docshell to indicate whether or
     * not this request corresponds to the toplevel document.
     */
  enum { LOAD_DOCUMENT_URI = 65536U };

  /** 
     * If the end consumer for this load has been retargeted after discovering 
     * it's content, this flag will be set:
     */
  enum { LOAD_RETARGETED_DOCUMENT_URI = 131072U };

  /**
	 * This flag is set to indicate that onStopRequest may be followed by
     * another onStartRequest/onStopRequest pair.  This flag is, for example,
     * used by the multipart/replace stream converter.
	 */
  enum { LOAD_REPLACE = 262144U };

  /**************************************************************************
     * This flag is OBSOLETE and will be removed once the old cache is
     * removed from the code base.  Support for CACHE_AS_FILE is now provided
     * via nsICachingChannel.
     */
  enum { CACHE_AS_FILE = 524288U };

// There is no content available (when asyncOpen is called)
#define NS_ERROR_NO_CONTENT NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 17)
};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICHANNEL \
  NS_IMETHOD GetOriginalURI(nsIURI * *aOriginalURI); \
  NS_IMETHOD SetOriginalURI(nsIURI * aOriginalURI); \
  NS_IMETHOD GetURI(nsIURI * *aURI); \
  NS_IMETHOD GetOwner(nsISupports * *aOwner); \
  NS_IMETHOD SetOwner(nsISupports * aOwner); \
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor * *aNotificationCallbacks); \
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor * aNotificationCallbacks); \
  NS_IMETHOD GetSecurityInfo(nsISupports * *aSecurityInfo); \
  NS_IMETHOD GetContentType(char * *aContentType); \
  NS_IMETHOD SetContentType(const char * aContentType); \
  NS_IMETHOD GetContentLength(PRInt32 *aContentLength); \
  NS_IMETHOD SetContentLength(PRInt32 aContentLength); \
  NS_IMETHOD Open(nsIInputStream **_retval); \
  NS_IMETHOD AsyncOpen(nsIStreamListener *listener, nsISupports *ctxt); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICHANNEL(_to) \
  NS_IMETHOD GetOriginalURI(nsIURI * *aOriginalURI) { return _to ## GetOriginalURI(aOriginalURI); } \
  NS_IMETHOD SetOriginalURI(nsIURI * aOriginalURI) { return _to ## SetOriginalURI(aOriginalURI); } \
  NS_IMETHOD GetURI(nsIURI * *aURI) { return _to ## GetURI(aURI); } \
  NS_IMETHOD GetOwner(nsISupports * *aOwner) { return _to ## GetOwner(aOwner); } \
  NS_IMETHOD SetOwner(nsISupports * aOwner) { return _to ## SetOwner(aOwner); } \
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor * *aNotificationCallbacks) { return _to ## GetNotificationCallbacks(aNotificationCallbacks); } \
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor * aNotificationCallbacks) { return _to ## SetNotificationCallbacks(aNotificationCallbacks); } \
  NS_IMETHOD GetSecurityInfo(nsISupports * *aSecurityInfo) { return _to ## GetSecurityInfo(aSecurityInfo); } \
  NS_IMETHOD GetContentType(char * *aContentType) { return _to ## GetContentType(aContentType); } \
  NS_IMETHOD SetContentType(const char * aContentType) { return _to ## SetContentType(aContentType); } \
  NS_IMETHOD GetContentLength(PRInt32 *aContentLength) { return _to ## GetContentLength(aContentLength); } \
  NS_IMETHOD SetContentLength(PRInt32 aContentLength) { return _to ## SetContentLength(aContentLength); } \
  NS_IMETHOD Open(nsIInputStream **_retval) { return _to ## Open(_retval); } \
  NS_IMETHOD AsyncOpen(nsIStreamListener *listener, nsISupports *ctxt) { return _to ## AsyncOpen(listener, ctxt); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICHANNEL(_to) \
  NS_IMETHOD GetOriginalURI(nsIURI * *aOriginalURI) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetOriginalURI(aOriginalURI); } \
  NS_IMETHOD SetOriginalURI(nsIURI * aOriginalURI) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetOriginalURI(aOriginalURI); } \
  NS_IMETHOD GetURI(nsIURI * *aURI) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetURI(aURI); } \
  NS_IMETHOD GetOwner(nsISupports * *aOwner) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetOwner(aOwner); } \
  NS_IMETHOD SetOwner(nsISupports * aOwner) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetOwner(aOwner); } \
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor * *aNotificationCallbacks) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetNotificationCallbacks(aNotificationCallbacks); } \
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor * aNotificationCallbacks) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetNotificationCallbacks(aNotificationCallbacks); } \
  NS_IMETHOD GetSecurityInfo(nsISupports * *aSecurityInfo) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetSecurityInfo(aSecurityInfo); } \
  NS_IMETHOD GetContentType(char * *aContentType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetContentType(aContentType); } \
  NS_IMETHOD SetContentType(const char * aContentType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetContentType(aContentType); } \
  NS_IMETHOD GetContentLength(PRInt32 *aContentLength) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetContentLength(aContentLength); } \
  NS_IMETHOD SetContentLength(PRInt32 aContentLength) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetContentLength(aContentLength); } \
  NS_IMETHOD Open(nsIInputStream **_retval) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Open(_retval); } \
  NS_IMETHOD AsyncOpen(nsIStreamListener *listener, nsISupports *ctxt) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> AsyncOpen(listener, ctxt); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsChannel : public nsIChannel
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSICHANNEL

  nsChannel();
  virtual ~nsChannel();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsChannel, nsIChannel)

nsChannel::nsChannel()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsChannel::~nsChannel()
{
  /* destructor code */
}

/* attribute nsIURI originalURI; */
NS_IMETHODIMP nsChannel::GetOriginalURI(nsIURI * *aOriginalURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsChannel::SetOriginalURI(nsIURI * aOriginalURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIURI URI; */
NS_IMETHODIMP nsChannel::GetURI(nsIURI * *aURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsISupports owner; */
NS_IMETHODIMP nsChannel::GetOwner(nsISupports * *aOwner)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsChannel::SetOwner(nsISupports * aOwner)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIInterfaceRequestor notificationCallbacks; */
NS_IMETHODIMP nsChannel::GetNotificationCallbacks(nsIInterfaceRequestor * *aNotificationCallbacks)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsChannel::SetNotificationCallbacks(nsIInterfaceRequestor * aNotificationCallbacks)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISupports securityInfo; */
NS_IMETHODIMP nsChannel::GetSecurityInfo(nsISupports * *aSecurityInfo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string contentType; */
NS_IMETHODIMP nsChannel::GetContentType(char * *aContentType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsChannel::SetContentType(const char * aContentType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long contentLength; */
NS_IMETHODIMP nsChannel::GetContentLength(PRInt32 *aContentLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsChannel::SetContentLength(PRInt32 aContentLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIInputStream open (); */
NS_IMETHODIMP nsChannel::Open(nsIInputStream **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void asyncOpen (in nsIStreamListener listener, in nsISupports ctxt); */
NS_IMETHODIMP nsChannel::AsyncOpen(nsIStreamListener *listener, nsISupports *ctxt)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIChannel_h__ */
