/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIEditor.idl
 */

#ifndef __gen_nsIEditor_h__
#define __gen_nsIEditor_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_domstubs_h__
#include "domstubs.h"
#endif

#ifndef __gen_nsISelection_h__
#include "nsISelection.h"
#endif

#ifndef __gen_nsISelectionController_h__
#include "nsISelectionController.h"
#endif

#ifndef __gen_nsIFile_h__
#include "nsIFile.h"
#endif

#ifndef __gen_nsIAtom_h__
#include "nsIAtom.h"
#endif

#ifndef __gen_nsIOutputStream_h__
#include "nsIOutputStream.h"
#endif

#ifndef __gen_nsIDocumentStateListener_h__
#include "nsIDocumentStateListener.h"
#endif

#ifndef __gen_nsITransactionManager_h__
#include "nsITransactionManager.h"
#endif

#ifndef __gen_nsIEditorObserver_h__
#include "nsIEditorObserver.h"
#endif

#ifndef __gen_nsIEditActionListener_h__
#include "nsIEditActionListener.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
//class nsIDOMDocument;
//class nsIDOMElement;
//class nsIDOMNode;
class nsIPresShell;
class nsIContent;
typedef short EDirection;

/* starting interface:    nsIEditor */
#define NS_IEDITOR_IID_STR "06b979ce-1dd2-11b2-b6c7-a8bc47aa06b6"

#define NS_IEDITOR_IID \
  {0x06b979ce, 0x1dd2, 0x11b2, \
    { 0xb6, 0xc7, 0xa8, 0xbc, 0x47, 0xaa, 0x06, 0xb6 }}

class nsIEditor : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IEDITOR_IID)

  typedef short EDirection;
  enum { eNone = 0 };

  enum { eNext = 1 };

  enum { ePrevious = 2 };

  enum { eNextWord = 3 };

  enum { ePreviousWord = 4 };

  enum { eToBeginningOfLine = 5 };

  enum { eToEndOfLine = 6 };

  /**
   * Init is to tell the implementation of nsIEditor to begin its services
   * @param aDoc            The dom document interface being observed
   * @param aPresShell      TEMP: The presentation shell displaying the document
   *                        once events can tell us from what pres shell they originated, 
   *                        this will no longer be necessary and the editor will no longer be
   *                        linked to a single pres shell.
   * @param aRoot           This is the root of the editable section of this document. if it is null then we get root from document body.
   * @param aSelCon         this should be used to get the selection location
   * @param aFlags          A bitmask of flags for specifying the behavior of the editor.
   */
  /* [noscript] void Init (in nsIDOMDocument doc, in nsIPresShellPtr shell, in nsIContentPtr aRoot, in nsISelectionController aSelCon, in unsigned long aFlags); */
  NS_IMETHOD Init(nsIDOMDocument *doc, nsIPresShell * shell, nsIContent * aRoot, nsISelectionController *aSelCon, PRUint32 aFlags) = 0;

  /**
   * PostCreate should be called after Init, and is the time that the editor tells
   * its documentStateObservers that the document has been created.
   */
  /* void PostCreate (); */
  NS_IMETHOD PostCreate(void) = 0;

  /**
   * PreDestroy is called before the editor goes away, and gives the editor a chance
   * to tell its documentStateObservers that the document is going away.
   */
  /* void PreDestroy (); */
  NS_IMETHOD PreDestroy(void) = 0;

  /** return the edit flags for this editor */
  /* void GetFlags (out unsigned long flags); */
  NS_IMETHOD GetFlags(PRUint32 *flags) = 0;

  /** set the edit flags for this editor.  May be called at any time. */
  /* void SetFlags (in unsigned long aFlags); */
  NS_IMETHOD SetFlags(PRUint32 aFlags) = 0;

  /**
   * return the DOM Document this editor is associated with
   *
   * @param aDoc [OUT] the dom interface being observed, refcounted
   */
  /* void GetDocument (out nsIDOMDocument doc); */
  NS_IMETHOD GetDocument(nsIDOMDocument **doc) = 0;

  /** return the body element 
   *  @param aElement return value for the root of the editable document
  */
  /* void GetRootElement (out nsIDOMElement element); */
  NS_IMETHOD GetRootElement(nsIDOMElement **element) = 0;

  /**
   * return the presentation shell this editor is associated with
   *
   * @param aPS [OUT] the pres shell, refcounted
   */
/**
   * return the selection controller for the current presentation
   *
   * @param aSelCon [OUT] the selection controller, refcounted
   */
  /* void GetSelectionController (out nsISelectionController selectioncontroller); */
  NS_IMETHOD GetSelectionController(nsISelectionController **selectioncontroller) = 0;

  /** 
   * return the DOM Selection for the presentation shell that has focus
   * (or most recently had focus.)
   * @param aSelection [OUT] the dom interface for the selection
   */
  /* void GetSelection (out nsISelection selection); */
  NS_IMETHOD GetSelection(nsISelection **selection) = 0;

  /** 
   * DeleteSelection removes all nodes in the current selection.
   * @param aDir  if eLTR, delete to the right (for example, the DEL key)
   *              if eRTL, delete to the left (for example, the BACKSPACE key)
   */
  /* void DeleteSelection (in short action); */
  NS_IMETHOD DeleteSelection(PRInt16 action) = 0;

  /** Returns true if the document has no *meaningful* content */
  /* void GetDocumentIsEmpty (out boolean documentIsEmpty); */
  NS_IMETHOD GetDocumentIsEmpty(PRBool *documentIsEmpty) = 0;

  /** Returns true if the document is modifed and needs saving */
  /* void GetDocumentModified (out boolean outDocModified); */
  NS_IMETHOD GetDocumentModified(PRBool *outDocModified) = 0;

  /** Returns the current 'Save' document character set */
  /* void GetDocumentCharacterSet (out DOMString characterSet); */
  NS_IMETHOD GetDocumentCharacterSet(nsAWritableString & characterSet) = 0;

  /** Sets the current 'Save' document character set */
  /* void SetDocumentCharacterSet (in DOMString characterSet); */
  NS_IMETHOD SetDocumentCharacterSet(const nsAReadableString & characterSet) = 0;

  /** Save document to a file
   *       Note: No UI is used
   *  @param aFileSpec
   *          The file to save to
   *  @param aReplaceExisting
   *          true if replacing an existing file, otherwise false.
   *          If false and aFileSpec exists, SaveFile returns an error.
   *  @param aSaveCopy       
   *          true if we are saving off a copy of the document
   *          without changing the disk file associated with the doc.
   *          This would correspond to a 'Save Copy As' menu command
   *          (currently not in our UI)
   *  @param aFormat
   *          Mime type to save (text/plain or text/html)
   */
  /* void SaveFile (in nsIFile fileSpec, in boolean replaceExisting, in boolean saveCopy, in DOMString format); */
  NS_IMETHOD SaveFile(nsIFile *fileSpec, PRBool replaceExisting, PRBool saveCopy, const nsAReadableString & format) = 0;

  /** GetTransactionManagerDo() Get the transaction manager
    *
    * @return aTxnManager the transaction manager that the editor is using
    */
  /* void GetTransactionManager (out nsITransactionManager txnManager); */
  NS_IMETHOD GetTransactionManager(nsITransactionManager **txnManager) = 0;

  /** Do() fires a transaction.  It is provided here so clients can create their own transactions.
    * If a transaction manager is present, it is used.  
    * Otherwise, the transaction is just executed directly.
    *
    * @param aTxn the transaction to execute
    */
  /* void Do (in nsITransaction txn); */
  NS_IMETHOD Do(nsITransaction *txn) = 0;

  /** turn the undo system on or off
    * @param aEnable  if PR_TRUE, the undo system is turned on if it is available
    *                 if PR_FALSE the undo system is turned off if it was previously on
    * @return         if aEnable is PR_TRUE, returns NS_OK if the undo system could be initialized properly
    *                 if aEnable is PR_FALSE, returns NS_OK.
    */
  /* void EnableUndo (in boolean enable); */
  NS_IMETHOD EnableUndo(PRBool enable) = 0;

  /** Undo reverses the effects of the last Do operation, if Undo is enabled in the editor.
    * It is provided here so clients need no knowledge of whether the editor has a transaction manager or not.
    * If a transaction manager is present, it is told to undo and the result of
    * that undo is returned.  
    * Otherwise, the Undo request is ignored and an error NS_ERROR_NOT_AVAILABLE is returned.
    *
    */
  /* void Undo (in unsigned long count); */
  NS_IMETHOD Undo(PRUint32 count) = 0;

  /** returns state information about the undo system.
    * @param aIsEnabled [OUT] PR_TRUE if undo is enabled
    * @param aCanUndo   [OUT] PR_TRUE if at least one transaction is currently ready to be undone.
    */
  /* void CanUndo (out boolean isEnabled, out boolean canUndo); */
  NS_IMETHOD CanUndo(PRBool *isEnabled, PRBool *canUndo) = 0;

  /** Redo reverses the effects of the last Undo operation
    * It is provided here so clients need no knowledge of whether the editor has a transaction manager or not.
    * If a transaction manager is present, it is told to redo and the result of the previously undone
    * transaction is reapplied to the document.
    * If no transaction is available for Redo, or if the document has no transaction manager,
    * the Redo request is ignored and an error NS_ERROR_NOT_AVAILABLE is returned.
    *
    */
  /* void Redo (in unsigned long count); */
  NS_IMETHOD Redo(PRUint32 count) = 0;

  /** returns state information about the redo system.
    * @param aIsEnabled [OUT] PR_TRUE if redo is enabled
    * @param aCanRedo   [OUT] PR_TRUE if at least one transaction is currently ready to be redone.
    */
  /* void CanRedo (out boolean isEnabled, out boolean canRedo); */
  NS_IMETHOD CanRedo(PRBool *isEnabled, PRBool *canRedo) = 0;

  /** BeginTransaction is a signal from the caller to the editor that the caller will execute multiple updates
    * to the content tree that should be treated as a single logical operation,
    * in the most efficient way possible.<br>
    * All transactions executed between a call to BeginTransaction and EndTransaction will be undoable as
    * an atomic action.<br>
    * EndTransaction must be called after BeginTransaction.<br>
    * Calls to BeginTransaction can be nested, as long as EndTransaction is called once per BeginUpdate.
    */
  /* void BeginTransaction (); */
  NS_IMETHOD BeginTransaction(void) = 0;

  /** EndTransaction is a signal to the editor that the caller is finished updating the content model.<br>
    * BeginUpdate must be called before EndTransaction is called.<br>
    * Calls to BeginTransaction can be nested, as long as EndTransaction is called once per BeginTransaction.
    */
  /* void EndTransaction (); */
  NS_IMETHOD EndTransaction(void) = 0;

  /* void BeginPlaceHolderTransaction (in nsIAtom name); */
  NS_IMETHOD BeginPlaceHolderTransaction(nsIAtom *name) = 0;

  /* void EndPlaceHolderTransaction (); */
  NS_IMETHOD EndPlaceHolderTransaction(void) = 0;

  /* void ShouldTxnSetSelection (out boolean result); */
  NS_IMETHOD ShouldTxnSetSelection(PRBool *result) = 0;

  /** Set the flag that prevents InsertElementTxn from changing the selection
    * @param   should  Set false to suppress changing the selection;
    *                  i.e., before using InsertElement() to insert under <head> element
    * WARNING: You must be very careful to reset back to PR_TRUE after
    *          setting PR_FALSE, else selection/caret is trashed
    *          for further editing
    */
  /* void SetShouldTxnSetSelection (in boolean should); */
  NS_IMETHOD SetShouldTxnSetSelection(PRBool should) = 0;

  /** cut the currently selected text, putting it into the OS clipboard
    * What if no text is selected?
    * What about mixed selections?
    * What are the clipboard formats?
    */
  /* void Cut (); */
  NS_IMETHOD Cut(void) = 0;

  /** Can we cut? True if the doc is modifiable, and we have a non-
    * collapsed selection.
    */
  /* void CanCut (out boolean canCut); */
  NS_IMETHOD CanCut(PRBool *canCut) = 0;

  /** copy the currently selected text, putting it into the OS clipboard
    * What if no text is selected?
    * What about mixed selections?
    * What are the clipboard formats?
    */
  /* void Copy (); */
  NS_IMETHOD Copy(void) = 0;

  /** Can we copy? True if we have a non-collapsed selection.
    */
  /* void CanCopy (out boolean aCanCopy); */
  NS_IMETHOD CanCopy(PRBool *aCanCopy) = 0;

  /** paste the text in the OS clipboard at the cursor position, replacing
    * the selected text (if any)
    */
  /* void Paste (in long aSelectionType); */
  NS_IMETHOD Paste(PRInt32 aSelectionType) = 0;

  /** Can we paste? True if the doc is modifiable, and we have
    * pasteable data in the clipboard.
    */
  /* void CanPaste (in long aSelectionType, out boolean aCanPaste); */
  NS_IMETHOD CanPaste(PRInt32 aSelectionType, PRBool *aCanPaste) = 0;

  /** sets the document selection to the entire contents of the document */
  /* void SelectAll (); */
  NS_IMETHOD SelectAll(void) = 0;

  /** sets the document selection to the beginning of the document */
  /* void BeginningOfDocument (); */
  NS_IMETHOD BeginningOfDocument(void) = 0;

  /** sets the document selection to the end of the document */
  /* void EndOfDocument (); */
  NS_IMETHOD EndOfDocument(void) = 0;

  /** Can we paste? True if the doc is modifiable, and we have
     * pasteable data in the clipboard.
     */
/** 
    * CanDrag decides if a drag should be started
    * (for example, based on the current selection and mousepoint).
    */
  /* void CanDrag (in nsIDOMEvent aEvent, out boolean aCanDrag); */
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *aCanDrag) = 0;

  /** 
    * DoDrag transfers the relevant data (as appropriate)
    * to a transferable so it can later be dropped.
    */
  /* void DoDrag (in nsIDOMEvent aEvent); */
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent) = 0;

  /** 
    * InsertFromDrop looks for a dragsession and inserts the
    * relevant data in response to a drop.
    */
  /* void InsertFromDrop (in nsIDOMEvent aEvent); */
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent) = 0;

  /**
   * SetAttribute() sets the attribute of aElement.
   * No checking is done to see if aAttribute is a legal attribute of the node,
   * or if aValue is a legal value of aAttribute.
   *
   * @param aElement    the content element to operate on
   * @param aAttribute  the string representation of the attribute to set
   * @param aValue      the value to set aAttribute to
   */
  /* void SetAttribute (in nsIDOMElement aElement, in DOMString attributestr, in DOMString attvalue); */
  NS_IMETHOD SetAttribute(nsIDOMElement *aElement, const nsAReadableString & attributestr, const nsAReadableString & attvalue) = 0;

  /**
   * GetAttributeValue() retrieves the attribute's value for aElement.
   *
   * @param aElement      the content element to operate on
   * @param aAttribute    the string representation of the attribute to get
   * @param aResultValue  the value of aAttribute.  only valid if aResultIsSet is PR_TRUE
   * @param aResultIsSet  PR_TRUE if aAttribute is set on the current node, PR_FALSE if it is not.
   */
  /* void GetAttributeValue (in nsIDOMElement aElement, in DOMString attributestr, out DOMString resultValue, out boolean resultIsSet); */
  NS_IMETHOD GetAttributeValue(nsIDOMElement *aElement, const nsAReadableString & attributestr, nsAWritableString & resultValue, PRBool *resultIsSet) = 0;

  /**
   * RemoveAttribute() deletes aAttribute from the attribute list of aElement.
   * If aAttribute is not an attribute of aElement, nothing is done.
   *
   * @param aElement      the content element to operate on
   * @param aAttribute    the string representation of the attribute to get
   */
  /* void RemoveAttribute (in nsIDOMElement aElement, in DOMString aAttribute); */
  NS_IMETHOD RemoveAttribute(nsIDOMElement *aElement, const nsAReadableString & aAttribute) = 0;

  /**
   * CloneAttributes() is similar to nsIDOMNode::cloneNode(),
   *   it assures the attribute nodes of the destination are identical with the source node
   *   by copying all existing attributes from the source and deleting those not in the source.
   *   This is used when the destination node (element) already exists
   *
   * The supplied nodes MUST BE ELEMENTS (most callers are working with nodes)
   * @param aDestNode     the destination element to operate on
   * @param aSourceNode   the source element to copy attributes from
   */
  /* void CloneAttributes (in nsIDOMNode destNode, in nsIDOMNode sourceNode); */
  NS_IMETHOD CloneAttributes(nsIDOMNode *destNode, nsIDOMNode *sourceNode) = 0;

  /** 
   * CreateNode instantiates a new element of type aTag and inserts it into aParent at aPosition.
   * @param aTag      The type of object to create
   * @param aParent   The node to insert the new object into
   * @param aPosition The place in aParent to insert the new node
   * @param aNewNode  [OUT] The node created.  Caller must release aNewNode.
   */
  /* void CreateNode (in DOMString tag, in nsIDOMNode parent, in long position, out nsIDOMNode newNode); */
  NS_IMETHOD CreateNode(const nsAReadableString & tag, nsIDOMNode *parent, PRInt32 position, nsIDOMNode **newNode) = 0;

  /** 
   * InsertNode inserts aNode into aParent at aPosition.
   * No checking is done to verify the legality of the insertion.  That is the 
   * responsibility of the caller.
   * @param aNode     The DOM Node to insert.
   * @param aParent   The node to insert the new object into
   * @param aPosition The place in aParent to insert the new node
   *                  0=first child, 1=second child, etc.
   *                  any number > number of current children = last child
   */
  /* void InsertNode (in nsIDOMNode vode, in nsIDOMNode parent, in long aPosition); */
  NS_IMETHOD InsertNode(nsIDOMNode *vode, nsIDOMNode *parent, PRInt32 aPosition) = 0;

  /** 
   * SplitNode() creates a new node identical to an existing node, and split the contents between the two nodes
   * @param aExistingRightNode   the node to split.  It will become the new node's next sibling.
   * @param aOffset              the offset of aExistingRightNode's content|children to do the split at
   * @param aNewLeftNode         [OUT] the new node resulting from the split, becomes aExistingRightNode's previous sibling.
   */
  /* void SplitNode (in nsIDOMNode existingRightNode, in long offset, out nsIDOMNode newLeftNode); */
  NS_IMETHOD SplitNode(nsIDOMNode *existingRightNode, PRInt32 offset, nsIDOMNode **newLeftNode) = 0;

  /** 
   * JoinNodes() takes 2 nodes and merge their content|children.
   * @param aLeftNode     The left node.  It will be deleted.
   * @param aRightNode    The right node. It will remain after the join.
   * @param aParent       The parent of aExistingRightNode
   *
   *                      There is no requirement that the two nodes be of the same type.
   *                      However, a text node can be merged only with another text node.
   */
  /* void JoinNodes (in nsIDOMNode leftNode, in nsIDOMNode rightNode, in nsIDOMNode parent); */
  NS_IMETHOD JoinNodes(nsIDOMNode *leftNode, nsIDOMNode *rightNode, nsIDOMNode *parent) = 0;

  /** 
   * DeleteNode removes aChild from aParent.
   * @param aChild    The node to delete
   */
  /* void DeleteNode (in nsIDOMNode child); */
  NS_IMETHOD DeleteNode(nsIDOMNode *child) = 0;

  /** 
   * InsertFormattingForNode() sets a special dirty attribute on the node.
   * Usually this will be called immediately after creating a new node.
   * @param aNode      The node for which to insert formatting.
   */
  /* void MarkNodeDirty (in nsIDOMNode node); */
  NS_IMETHOD MarkNodeDirty(nsIDOMNode *node) = 0;

  /**
   * Output methods:
   * aFormatType is a mime type, like text/plain.
   */
  /* void OutputToString (out DOMString outputString, [const] in DOMString formatType, in unsigned long flags); */
  NS_IMETHOD OutputToString(nsAWritableString & outputString, const nsAReadableString & formatType, PRUint32 flags) = 0;

  /* void OutputToStream (in nsIOutputStream outputStream, [const] in DOMString formatType, [const] in DOMString charsetOverride, in unsigned long flags); */
  NS_IMETHOD OutputToStream(nsIOutputStream *outputStream, const nsAReadableString & formatType, const nsAReadableString & charsetOverride, PRUint32 flags) = 0;

  /** add an EditorObserver to the editors list of observers. */
  /* void AddEditorObserver (in nsIEditorObserver observer); */
  NS_IMETHOD AddEditorObserver(nsIEditorObserver *observer) = 0;

  /** Remove an EditorObserver from the editor's list of observers. */
  /* void RemoveEditorObserver (in nsIEditorObserver observer); */
  NS_IMETHOD RemoveEditorObserver(nsIEditorObserver *observer) = 0;

  /** add an EditActionListener to the editors list of listeners. */
  /* void AddEditActionListener (in nsIEditActionListener listener); */
  NS_IMETHOD AddEditActionListener(nsIEditActionListener *listener) = 0;

  /** Remove an EditActionListener from the editor's list of listeners. */
  /* void RemoveEditActionListener (in nsIEditActionListener listener); */
  NS_IMETHOD RemoveEditActionListener(nsIEditActionListener *listener) = 0;

  /** Add a DocumentStateListener to the editors list of doc state listeners. */
  /* void AddDocumentStateListener (in nsIDocumentStateListener listener); */
  NS_IMETHOD AddDocumentStateListener(nsIDocumentStateListener *listener) = 0;

  /** Remove a DocumentStateListener to the editors list of doc state listeners. */
  /* void RemoveDocumentStateListener (in nsIDocumentStateListener listener); */
  NS_IMETHOD RemoveDocumentStateListener(nsIDocumentStateListener *listener) = 0;

  /**
   * And a debug method -- show us what the tree looks like right now
   */
  /* void DumpContentTree (); */
  NS_IMETHOD DumpContentTree(void) = 0;

  /** Dumps a text representation of the content tree to standard out */
  /* void DebugDumpContent (); */
  NS_IMETHOD DebugDumpContent(void) = 0;

  /* void DebugUnitTests (out long outNumTests, out long outNumTestsFailed); */
  NS_IMETHOD DebugUnitTests(PRInt32 *outNumTests, PRInt32 *outNumTestsFailed) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIEDITOR \
  NS_IMETHOD Init(nsIDOMDocument *doc, nsIPresShell * shell, nsIContent * aRoot, nsISelectionController *aSelCon, PRUint32 aFlags); \
  NS_IMETHOD PostCreate(void); \
  NS_IMETHOD PreDestroy(void); \
  NS_IMETHOD GetFlags(PRUint32 *flags); \
  NS_IMETHOD SetFlags(PRUint32 aFlags); \
  NS_IMETHOD GetDocument(nsIDOMDocument **doc); \
  NS_IMETHOD GetRootElement(nsIDOMElement **element); \
  NS_IMETHOD GetSelectionController(nsISelectionController **selectioncontroller); \
  NS_IMETHOD GetSelection(nsISelection **selection); \
  NS_IMETHOD DeleteSelection(PRInt16 action); \
  NS_IMETHOD GetDocumentIsEmpty(PRBool *documentIsEmpty); \
  NS_IMETHOD GetDocumentModified(PRBool *outDocModified); \
  NS_IMETHOD GetDocumentCharacterSet(nsAWritableString & characterSet); \
  NS_IMETHOD SetDocumentCharacterSet(const nsAReadableString & characterSet); \
  NS_IMETHOD SaveFile(nsIFile *fileSpec, PRBool replaceExisting, PRBool saveCopy, const nsAReadableString & format); \
  NS_IMETHOD GetTransactionManager(nsITransactionManager **txnManager); \
  NS_IMETHOD Do(nsITransaction *txn); \
  NS_IMETHOD EnableUndo(PRBool enable); \
  NS_IMETHOD Undo(PRUint32 count); \
  NS_IMETHOD CanUndo(PRBool *isEnabled, PRBool *canUndo); \
  NS_IMETHOD Redo(PRUint32 count); \
  NS_IMETHOD CanRedo(PRBool *isEnabled, PRBool *canRedo); \
  NS_IMETHOD BeginTransaction(void); \
  NS_IMETHOD EndTransaction(void); \
  NS_IMETHOD BeginPlaceHolderTransaction(nsIAtom *name); \
  NS_IMETHOD EndPlaceHolderTransaction(void); \
  NS_IMETHOD ShouldTxnSetSelection(PRBool *result); \
  NS_IMETHOD SetShouldTxnSetSelection(PRBool should); \
  NS_IMETHOD Cut(void); \
  NS_IMETHOD CanCut(PRBool *canCut); \
  NS_IMETHOD Copy(void); \
  NS_IMETHOD CanCopy(PRBool *aCanCopy); \
  NS_IMETHOD Paste(PRInt32 aSelectionType); \
  NS_IMETHOD CanPaste(PRInt32 aSelectionType, PRBool *aCanPaste); \
  NS_IMETHOD SelectAll(void); \
  NS_IMETHOD BeginningOfDocument(void); \
  NS_IMETHOD EndOfDocument(void); \
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *aCanDrag); \
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent); \
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent); \
  NS_IMETHOD SetAttribute(nsIDOMElement *aElement, const nsAReadableString & attributestr, const nsAReadableString & attvalue); \
  NS_IMETHOD GetAttributeValue(nsIDOMElement *aElement, const nsAReadableString & attributestr, nsAWritableString & resultValue, PRBool *resultIsSet); \
  NS_IMETHOD RemoveAttribute(nsIDOMElement *aElement, const nsAReadableString & aAttribute); \
  NS_IMETHOD CloneAttributes(nsIDOMNode *destNode, nsIDOMNode *sourceNode); \
  NS_IMETHOD CreateNode(const nsAReadableString & tag, nsIDOMNode *parent, PRInt32 position, nsIDOMNode **newNode); \
  NS_IMETHOD InsertNode(nsIDOMNode *vode, nsIDOMNode *parent, PRInt32 aPosition); \
  NS_IMETHOD SplitNode(nsIDOMNode *existingRightNode, PRInt32 offset, nsIDOMNode **newLeftNode); \
  NS_IMETHOD JoinNodes(nsIDOMNode *leftNode, nsIDOMNode *rightNode, nsIDOMNode *parent); \
  NS_IMETHOD DeleteNode(nsIDOMNode *child); \
  NS_IMETHOD MarkNodeDirty(nsIDOMNode *node); \
  NS_IMETHOD OutputToString(nsAWritableString & outputString, const nsAReadableString & formatType, PRUint32 flags); \
  NS_IMETHOD OutputToStream(nsIOutputStream *outputStream, const nsAReadableString & formatType, const nsAReadableString & charsetOverride, PRUint32 flags); \
  NS_IMETHOD AddEditorObserver(nsIEditorObserver *observer); \
  NS_IMETHOD RemoveEditorObserver(nsIEditorObserver *observer); \
  NS_IMETHOD AddEditActionListener(nsIEditActionListener *listener); \
  NS_IMETHOD RemoveEditActionListener(nsIEditActionListener *listener); \
  NS_IMETHOD AddDocumentStateListener(nsIDocumentStateListener *listener); \
  NS_IMETHOD RemoveDocumentStateListener(nsIDocumentStateListener *listener); \
  NS_IMETHOD DumpContentTree(void); \
  NS_IMETHOD DebugDumpContent(void); \
  NS_IMETHOD DebugUnitTests(PRInt32 *outNumTests, PRInt32 *outNumTestsFailed); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIEDITOR(_to) \
  NS_IMETHOD Init(nsIDOMDocument *doc, nsIPresShell * shell, nsIContent * aRoot, nsISelectionController *aSelCon, PRUint32 aFlags) { return _to ## Init(doc, shell, aRoot, aSelCon, aFlags); } \
  NS_IMETHOD PostCreate(void) { return _to ## PostCreate(); } \
  NS_IMETHOD PreDestroy(void) { return _to ## PreDestroy(); } \
  NS_IMETHOD GetFlags(PRUint32 *flags) { return _to ## GetFlags(flags); } \
  NS_IMETHOD SetFlags(PRUint32 aFlags) { return _to ## SetFlags(aFlags); } \
  NS_IMETHOD GetDocument(nsIDOMDocument **doc) { return _to ## GetDocument(doc); } \
  NS_IMETHOD GetRootElement(nsIDOMElement **element) { return _to ## GetRootElement(element); } \
  NS_IMETHOD GetSelectionController(nsISelectionController **selectioncontroller) { return _to ## GetSelectionController(selectioncontroller); } \
  NS_IMETHOD GetSelection(nsISelection **selection) { return _to ## GetSelection(selection); } \
  NS_IMETHOD DeleteSelection(PRInt16 action) { return _to ## DeleteSelection(action); } \
  NS_IMETHOD GetDocumentIsEmpty(PRBool *documentIsEmpty) { return _to ## GetDocumentIsEmpty(documentIsEmpty); } \
  NS_IMETHOD GetDocumentModified(PRBool *outDocModified) { return _to ## GetDocumentModified(outDocModified); } \
  NS_IMETHOD GetDocumentCharacterSet(nsAWritableString & characterSet) { return _to ## GetDocumentCharacterSet(characterSet); } \
  NS_IMETHOD SetDocumentCharacterSet(const nsAReadableString & characterSet) { return _to ## SetDocumentCharacterSet(characterSet); } \
  NS_IMETHOD SaveFile(nsIFile *fileSpec, PRBool replaceExisting, PRBool saveCopy, const nsAReadableString & format) { return _to ## SaveFile(fileSpec, replaceExisting, saveCopy, format); } \
  NS_IMETHOD GetTransactionManager(nsITransactionManager **txnManager) { return _to ## GetTransactionManager(txnManager); } \
  NS_IMETHOD Do(nsITransaction *txn) { return _to ## Do(txn); } \
  NS_IMETHOD EnableUndo(PRBool enable) { return _to ## EnableUndo(enable); } \
  NS_IMETHOD Undo(PRUint32 count) { return _to ## Undo(count); } \
  NS_IMETHOD CanUndo(PRBool *isEnabled, PRBool *canUndo) { return _to ## CanUndo(isEnabled, canUndo); } \
  NS_IMETHOD Redo(PRUint32 count) { return _to ## Redo(count); } \
  NS_IMETHOD CanRedo(PRBool *isEnabled, PRBool *canRedo) { return _to ## CanRedo(isEnabled, canRedo); } \
  NS_IMETHOD BeginTransaction(void) { return _to ## BeginTransaction(); } \
  NS_IMETHOD EndTransaction(void) { return _to ## EndTransaction(); } \
  NS_IMETHOD BeginPlaceHolderTransaction(nsIAtom *name) { return _to ## BeginPlaceHolderTransaction(name); } \
  NS_IMETHOD EndPlaceHolderTransaction(void) { return _to ## EndPlaceHolderTransaction(); } \
  NS_IMETHOD ShouldTxnSetSelection(PRBool *result) { return _to ## ShouldTxnSetSelection(result); } \
  NS_IMETHOD SetShouldTxnSetSelection(PRBool should) { return _to ## SetShouldTxnSetSelection(should); } \
  NS_IMETHOD Cut(void) { return _to ## Cut(); } \
  NS_IMETHOD CanCut(PRBool *canCut) { return _to ## CanCut(canCut); } \
  NS_IMETHOD Copy(void) { return _to ## Copy(); } \
  NS_IMETHOD CanCopy(PRBool *aCanCopy) { return _to ## CanCopy(aCanCopy); } \
  NS_IMETHOD Paste(PRInt32 aSelectionType) { return _to ## Paste(aSelectionType); } \
  NS_IMETHOD CanPaste(PRInt32 aSelectionType, PRBool *aCanPaste) { return _to ## CanPaste(aSelectionType, aCanPaste); } \
  NS_IMETHOD SelectAll(void) { return _to ## SelectAll(); } \
  NS_IMETHOD BeginningOfDocument(void) { return _to ## BeginningOfDocument(); } \
  NS_IMETHOD EndOfDocument(void) { return _to ## EndOfDocument(); } \
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *aCanDrag) { return _to ## CanDrag(aEvent, aCanDrag); } \
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent) { return _to ## DoDrag(aEvent); } \
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent) { return _to ## InsertFromDrop(aEvent); } \
  NS_IMETHOD SetAttribute(nsIDOMElement *aElement, const nsAReadableString & attributestr, const nsAReadableString & attvalue) { return _to ## SetAttribute(aElement, attributestr, attvalue); } \
  NS_IMETHOD GetAttributeValue(nsIDOMElement *aElement, const nsAReadableString & attributestr, nsAWritableString & resultValue, PRBool *resultIsSet) { return _to ## GetAttributeValue(aElement, attributestr, resultValue, resultIsSet); } \
  NS_IMETHOD RemoveAttribute(nsIDOMElement *aElement, const nsAReadableString & aAttribute) { return _to ## RemoveAttribute(aElement, aAttribute); } \
  NS_IMETHOD CloneAttributes(nsIDOMNode *destNode, nsIDOMNode *sourceNode) { return _to ## CloneAttributes(destNode, sourceNode); } \
  NS_IMETHOD CreateNode(const nsAReadableString & tag, nsIDOMNode *parent, PRInt32 position, nsIDOMNode **newNode) { return _to ## CreateNode(tag, parent, position, newNode); } \
  NS_IMETHOD InsertNode(nsIDOMNode *vode, nsIDOMNode *parent, PRInt32 aPosition) { return _to ## InsertNode(vode, parent, aPosition); } \
  NS_IMETHOD SplitNode(nsIDOMNode *existingRightNode, PRInt32 offset, nsIDOMNode **newLeftNode) { return _to ## SplitNode(existingRightNode, offset, newLeftNode); } \
  NS_IMETHOD JoinNodes(nsIDOMNode *leftNode, nsIDOMNode *rightNode, nsIDOMNode *parent) { return _to ## JoinNodes(leftNode, rightNode, parent); } \
  NS_IMETHOD DeleteNode(nsIDOMNode *child) { return _to ## DeleteNode(child); } \
  NS_IMETHOD MarkNodeDirty(nsIDOMNode *node) { return _to ## MarkNodeDirty(node); } \
  NS_IMETHOD OutputToString(nsAWritableString & outputString, const nsAReadableString & formatType, PRUint32 flags) { return _to ## OutputToString(outputString, formatType, flags); } \
  NS_IMETHOD OutputToStream(nsIOutputStream *outputStream, const nsAReadableString & formatType, const nsAReadableString & charsetOverride, PRUint32 flags) { return _to ## OutputToStream(outputStream, formatType, charsetOverride, flags); } \
  NS_IMETHOD AddEditorObserver(nsIEditorObserver *observer) { return _to ## AddEditorObserver(observer); } \
  NS_IMETHOD RemoveEditorObserver(nsIEditorObserver *observer) { return _to ## RemoveEditorObserver(observer); } \
  NS_IMETHOD AddEditActionListener(nsIEditActionListener *listener) { return _to ## AddEditActionListener(listener); } \
  NS_IMETHOD RemoveEditActionListener(nsIEditActionListener *listener) { return _to ## RemoveEditActionListener(listener); } \
  NS_IMETHOD AddDocumentStateListener(nsIDocumentStateListener *listener) { return _to ## AddDocumentStateListener(listener); } \
  NS_IMETHOD RemoveDocumentStateListener(nsIDocumentStateListener *listener) { return _to ## RemoveDocumentStateListener(listener); } \
  NS_IMETHOD DumpContentTree(void) { return _to ## DumpContentTree(); } \
  NS_IMETHOD DebugDumpContent(void) { return _to ## DebugDumpContent(); } \
  NS_IMETHOD DebugUnitTests(PRInt32 *outNumTests, PRInt32 *outNumTestsFailed) { return _to ## DebugUnitTests(outNumTests, outNumTestsFailed); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIEDITOR(_to) \
  NS_IMETHOD Init(nsIDOMDocument *doc, nsIPresShell * shell, nsIContent * aRoot, nsISelectionController *aSelCon, PRUint32 aFlags) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(doc, shell, aRoot, aSelCon, aFlags); } \
  NS_IMETHOD PostCreate(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> PostCreate(); } \
  NS_IMETHOD PreDestroy(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> PreDestroy(); } \
  NS_IMETHOD GetFlags(PRUint32 *flags) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetFlags(flags); } \
  NS_IMETHOD SetFlags(PRUint32 aFlags) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetFlags(aFlags); } \
  NS_IMETHOD GetDocument(nsIDOMDocument **doc) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetDocument(doc); } \
  NS_IMETHOD GetRootElement(nsIDOMElement **element) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetRootElement(element); } \
  NS_IMETHOD GetSelectionController(nsISelectionController **selectioncontroller) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetSelectionController(selectioncontroller); } \
  NS_IMETHOD GetSelection(nsISelection **selection) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetSelection(selection); } \
  NS_IMETHOD DeleteSelection(PRInt16 action) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> DeleteSelection(action); } \
  NS_IMETHOD GetDocumentIsEmpty(PRBool *documentIsEmpty) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetDocumentIsEmpty(documentIsEmpty); } \
  NS_IMETHOD GetDocumentModified(PRBool *outDocModified) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetDocumentModified(outDocModified); } \
  NS_IMETHOD GetDocumentCharacterSet(nsAWritableString & characterSet) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetDocumentCharacterSet(characterSet); } \
  NS_IMETHOD SetDocumentCharacterSet(const nsAReadableString & characterSet) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetDocumentCharacterSet(characterSet); } \
  NS_IMETHOD SaveFile(nsIFile *fileSpec, PRBool replaceExisting, PRBool saveCopy, const nsAReadableString & format) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SaveFile(fileSpec, replaceExisting, saveCopy, format); } \
  NS_IMETHOD GetTransactionManager(nsITransactionManager **txnManager) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetTransactionManager(txnManager); } \
  NS_IMETHOD Do(nsITransaction *txn) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Do(txn); } \
  NS_IMETHOD EnableUndo(PRBool enable) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> EnableUndo(enable); } \
  NS_IMETHOD Undo(PRUint32 count) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Undo(count); } \
  NS_IMETHOD CanUndo(PRBool *isEnabled, PRBool *canUndo) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CanUndo(isEnabled, canUndo); } \
  NS_IMETHOD Redo(PRUint32 count) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Redo(count); } \
  NS_IMETHOD CanRedo(PRBool *isEnabled, PRBool *canRedo) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CanRedo(isEnabled, canRedo); } \
  NS_IMETHOD BeginTransaction(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> BeginTransaction(); } \
  NS_IMETHOD EndTransaction(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> EndTransaction(); } \
  NS_IMETHOD BeginPlaceHolderTransaction(nsIAtom *name) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> BeginPlaceHolderTransaction(name); } \
  NS_IMETHOD EndPlaceHolderTransaction(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> EndPlaceHolderTransaction(); } \
  NS_IMETHOD ShouldTxnSetSelection(PRBool *result) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> ShouldTxnSetSelection(result); } \
  NS_IMETHOD SetShouldTxnSetSelection(PRBool should) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetShouldTxnSetSelection(should); } \
  NS_IMETHOD Cut(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Cut(); } \
  NS_IMETHOD CanCut(PRBool *canCut) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CanCut(canCut); } \
  NS_IMETHOD Copy(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Copy(); } \
  NS_IMETHOD CanCopy(PRBool *aCanCopy) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CanCopy(aCanCopy); } \
  NS_IMETHOD Paste(PRInt32 aSelectionType) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Paste(aSelectionType); } \
  NS_IMETHOD CanPaste(PRInt32 aSelectionType, PRBool *aCanPaste) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CanPaste(aSelectionType, aCanPaste); } \
  NS_IMETHOD SelectAll(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SelectAll(); } \
  NS_IMETHOD BeginningOfDocument(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> BeginningOfDocument(); } \
  NS_IMETHOD EndOfDocument(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> EndOfDocument(); } \
  NS_IMETHOD CanDrag(nsIDOMEvent *aEvent, PRBool *aCanDrag) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CanDrag(aEvent, aCanDrag); } \
  NS_IMETHOD DoDrag(nsIDOMEvent *aEvent) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> DoDrag(aEvent); } \
  NS_IMETHOD InsertFromDrop(nsIDOMEvent *aEvent) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> InsertFromDrop(aEvent); } \
  NS_IMETHOD SetAttribute(nsIDOMElement *aElement, const nsAReadableString & attributestr, const nsAReadableString & attvalue) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SetAttribute(aElement, attributestr, attvalue); } \
  NS_IMETHOD GetAttributeValue(nsIDOMElement *aElement, const nsAReadableString & attributestr, nsAWritableString & resultValue, PRBool *resultIsSet) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> GetAttributeValue(aElement, attributestr, resultValue, resultIsSet); } \
  NS_IMETHOD RemoveAttribute(nsIDOMElement *aElement, const nsAReadableString & aAttribute) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RemoveAttribute(aElement, aAttribute); } \
  NS_IMETHOD CloneAttributes(nsIDOMNode *destNode, nsIDOMNode *sourceNode) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CloneAttributes(destNode, sourceNode); } \
  NS_IMETHOD CreateNode(const nsAReadableString & tag, nsIDOMNode *parent, PRInt32 position, nsIDOMNode **newNode) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> CreateNode(tag, parent, position, newNode); } \
  NS_IMETHOD InsertNode(nsIDOMNode *vode, nsIDOMNode *parent, PRInt32 aPosition) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> InsertNode(vode, parent, aPosition); } \
  NS_IMETHOD SplitNode(nsIDOMNode *existingRightNode, PRInt32 offset, nsIDOMNode **newLeftNode) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> SplitNode(existingRightNode, offset, newLeftNode); } \
  NS_IMETHOD JoinNodes(nsIDOMNode *leftNode, nsIDOMNode *rightNode, nsIDOMNode *parent) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> JoinNodes(leftNode, rightNode, parent); } \
  NS_IMETHOD DeleteNode(nsIDOMNode *child) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> DeleteNode(child); } \
  NS_IMETHOD MarkNodeDirty(nsIDOMNode *node) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> MarkNodeDirty(node); } \
  NS_IMETHOD OutputToString(nsAWritableString & outputString, const nsAReadableString & formatType, PRUint32 flags) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OutputToString(outputString, formatType, flags); } \
  NS_IMETHOD OutputToStream(nsIOutputStream *outputStream, const nsAReadableString & formatType, const nsAReadableString & charsetOverride, PRUint32 flags) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> OutputToStream(outputStream, formatType, charsetOverride, flags); } \
  NS_IMETHOD AddEditorObserver(nsIEditorObserver *observer) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> AddEditorObserver(observer); } \
  NS_IMETHOD RemoveEditorObserver(nsIEditorObserver *observer) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RemoveEditorObserver(observer); } \
  NS_IMETHOD AddEditActionListener(nsIEditActionListener *listener) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> AddEditActionListener(listener); } \
  NS_IMETHOD RemoveEditActionListener(nsIEditActionListener *listener) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RemoveEditActionListener(listener); } \
  NS_IMETHOD AddDocumentStateListener(nsIDocumentStateListener *listener) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> AddDocumentStateListener(listener); } \
  NS_IMETHOD RemoveDocumentStateListener(nsIDocumentStateListener *listener) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> RemoveDocumentStateListener(listener); } \
  NS_IMETHOD DumpContentTree(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> DumpContentTree(); } \
  NS_IMETHOD DebugDumpContent(void) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> DebugDumpContent(); } \
  NS_IMETHOD DebugUnitTests(PRInt32 *outNumTests, PRInt32 *outNumTestsFailed) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> DebugUnitTests(outNumTests, outNumTestsFailed); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsEditor : public nsIEditor
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIEDITOR

  nsEditor();
  virtual ~nsEditor();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsEditor, nsIEditor)

nsEditor::nsEditor()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsEditor::~nsEditor()
{
  /* destructor code */
}

/* [noscript] void Init (in nsIDOMDocument doc, in nsIPresShellPtr shell, in nsIContentPtr aRoot, in nsISelectionController aSelCon, in unsigned long aFlags); */
NS_IMETHODIMP nsEditor::Init(nsIDOMDocument *doc, nsIPresShell * shell, nsIContent * aRoot, nsISelectionController *aSelCon, PRUint32 aFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void PostCreate (); */
NS_IMETHODIMP nsEditor::PostCreate()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void PreDestroy (); */
NS_IMETHODIMP nsEditor::PreDestroy()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetFlags (out unsigned long flags); */
NS_IMETHODIMP nsEditor::GetFlags(PRUint32 *flags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetFlags (in unsigned long aFlags); */
NS_IMETHODIMP nsEditor::SetFlags(PRUint32 aFlags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetDocument (out nsIDOMDocument doc); */
NS_IMETHODIMP nsEditor::GetDocument(nsIDOMDocument **doc)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetRootElement (out nsIDOMElement element); */
NS_IMETHODIMP nsEditor::GetRootElement(nsIDOMElement **element)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetSelectionController (out nsISelectionController selectioncontroller); */
NS_IMETHODIMP nsEditor::GetSelectionController(nsISelectionController **selectioncontroller)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetSelection (out nsISelection selection); */
NS_IMETHODIMP nsEditor::GetSelection(nsISelection **selection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteSelection (in short action); */
NS_IMETHODIMP nsEditor::DeleteSelection(PRInt16 action)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetDocumentIsEmpty (out boolean documentIsEmpty); */
NS_IMETHODIMP nsEditor::GetDocumentIsEmpty(PRBool *documentIsEmpty)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetDocumentModified (out boolean outDocModified); */
NS_IMETHODIMP nsEditor::GetDocumentModified(PRBool *outDocModified)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetDocumentCharacterSet (out DOMString characterSet); */
NS_IMETHODIMP nsEditor::GetDocumentCharacterSet(nsAWritableString & characterSet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetDocumentCharacterSet (in DOMString characterSet); */
NS_IMETHODIMP nsEditor::SetDocumentCharacterSet(const nsAReadableString & characterSet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SaveFile (in nsIFile fileSpec, in boolean replaceExisting, in boolean saveCopy, in DOMString format); */
NS_IMETHODIMP nsEditor::SaveFile(nsIFile *fileSpec, PRBool replaceExisting, PRBool saveCopy, const nsAReadableString & format)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetTransactionManager (out nsITransactionManager txnManager); */
NS_IMETHODIMP nsEditor::GetTransactionManager(nsITransactionManager **txnManager)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Do (in nsITransaction txn); */
NS_IMETHODIMP nsEditor::Do(nsITransaction *txn)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void EnableUndo (in boolean enable); */
NS_IMETHODIMP nsEditor::EnableUndo(PRBool enable)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Undo (in unsigned long count); */
NS_IMETHODIMP nsEditor::Undo(PRUint32 count)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CanUndo (out boolean isEnabled, out boolean canUndo); */
NS_IMETHODIMP nsEditor::CanUndo(PRBool *isEnabled, PRBool *canUndo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Redo (in unsigned long count); */
NS_IMETHODIMP nsEditor::Redo(PRUint32 count)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CanRedo (out boolean isEnabled, out boolean canRedo); */
NS_IMETHODIMP nsEditor::CanRedo(PRBool *isEnabled, PRBool *canRedo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void BeginTransaction (); */
NS_IMETHODIMP nsEditor::BeginTransaction()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void EndTransaction (); */
NS_IMETHODIMP nsEditor::EndTransaction()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void BeginPlaceHolderTransaction (in nsIAtom name); */
NS_IMETHODIMP nsEditor::BeginPlaceHolderTransaction(nsIAtom *name)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void EndPlaceHolderTransaction (); */
NS_IMETHODIMP nsEditor::EndPlaceHolderTransaction()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void ShouldTxnSetSelection (out boolean result); */
NS_IMETHODIMP nsEditor::ShouldTxnSetSelection(PRBool *result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetShouldTxnSetSelection (in boolean should); */
NS_IMETHODIMP nsEditor::SetShouldTxnSetSelection(PRBool should)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Cut (); */
NS_IMETHODIMP nsEditor::Cut()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CanCut (out boolean canCut); */
NS_IMETHODIMP nsEditor::CanCut(PRBool *canCut)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Copy (); */
NS_IMETHODIMP nsEditor::Copy()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CanCopy (out boolean aCanCopy); */
NS_IMETHODIMP nsEditor::CanCopy(PRBool *aCanCopy)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void Paste (in long aSelectionType); */
NS_IMETHODIMP nsEditor::Paste(PRInt32 aSelectionType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CanPaste (in long aSelectionType, out boolean aCanPaste); */
NS_IMETHODIMP nsEditor::CanPaste(PRInt32 aSelectionType, PRBool *aCanPaste)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SelectAll (); */
NS_IMETHODIMP nsEditor::SelectAll()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void BeginningOfDocument (); */
NS_IMETHODIMP nsEditor::BeginningOfDocument()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void EndOfDocument (); */
NS_IMETHODIMP nsEditor::EndOfDocument()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CanDrag (in nsIDOMEvent aEvent, out boolean aCanDrag); */
NS_IMETHODIMP nsEditor::CanDrag(nsIDOMEvent *aEvent, PRBool *aCanDrag)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DoDrag (in nsIDOMEvent aEvent); */
NS_IMETHODIMP nsEditor::DoDrag(nsIDOMEvent *aEvent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertFromDrop (in nsIDOMEvent aEvent); */
NS_IMETHODIMP nsEditor::InsertFromDrop(nsIDOMEvent *aEvent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SetAttribute (in nsIDOMElement aElement, in DOMString attributestr, in DOMString attvalue); */
NS_IMETHODIMP nsEditor::SetAttribute(nsIDOMElement *aElement, const nsAReadableString & attributestr, const nsAReadableString & attvalue)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void GetAttributeValue (in nsIDOMElement aElement, in DOMString attributestr, out DOMString resultValue, out boolean resultIsSet); */
NS_IMETHODIMP nsEditor::GetAttributeValue(nsIDOMElement *aElement, const nsAReadableString & attributestr, nsAWritableString & resultValue, PRBool *resultIsSet)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveAttribute (in nsIDOMElement aElement, in DOMString aAttribute); */
NS_IMETHODIMP nsEditor::RemoveAttribute(nsIDOMElement *aElement, const nsAReadableString & aAttribute)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CloneAttributes (in nsIDOMNode destNode, in nsIDOMNode sourceNode); */
NS_IMETHODIMP nsEditor::CloneAttributes(nsIDOMNode *destNode, nsIDOMNode *sourceNode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void CreateNode (in DOMString tag, in nsIDOMNode parent, in long position, out nsIDOMNode newNode); */
NS_IMETHODIMP nsEditor::CreateNode(const nsAReadableString & tag, nsIDOMNode *parent, PRInt32 position, nsIDOMNode **newNode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void InsertNode (in nsIDOMNode vode, in nsIDOMNode parent, in long aPosition); */
NS_IMETHODIMP nsEditor::InsertNode(nsIDOMNode *vode, nsIDOMNode *parent, PRInt32 aPosition)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void SplitNode (in nsIDOMNode existingRightNode, in long offset, out nsIDOMNode newLeftNode); */
NS_IMETHODIMP nsEditor::SplitNode(nsIDOMNode *existingRightNode, PRInt32 offset, nsIDOMNode **newLeftNode)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void JoinNodes (in nsIDOMNode leftNode, in nsIDOMNode rightNode, in nsIDOMNode parent); */
NS_IMETHODIMP nsEditor::JoinNodes(nsIDOMNode *leftNode, nsIDOMNode *rightNode, nsIDOMNode *parent)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DeleteNode (in nsIDOMNode child); */
NS_IMETHODIMP nsEditor::DeleteNode(nsIDOMNode *child)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void MarkNodeDirty (in nsIDOMNode node); */
NS_IMETHODIMP nsEditor::MarkNodeDirty(nsIDOMNode *node)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void OutputToString (out DOMString outputString, [const] in DOMString formatType, in unsigned long flags); */
NS_IMETHODIMP nsEditor::OutputToString(nsAWritableString & outputString, const nsAReadableString & formatType, PRUint32 flags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void OutputToStream (in nsIOutputStream outputStream, [const] in DOMString formatType, [const] in DOMString charsetOverride, in unsigned long flags); */
NS_IMETHODIMP nsEditor::OutputToStream(nsIOutputStream *outputStream, const nsAReadableString & formatType, const nsAReadableString & charsetOverride, PRUint32 flags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void AddEditorObserver (in nsIEditorObserver observer); */
NS_IMETHODIMP nsEditor::AddEditorObserver(nsIEditorObserver *observer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveEditorObserver (in nsIEditorObserver observer); */
NS_IMETHODIMP nsEditor::RemoveEditorObserver(nsIEditorObserver *observer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void AddEditActionListener (in nsIEditActionListener listener); */
NS_IMETHODIMP nsEditor::AddEditActionListener(nsIEditActionListener *listener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveEditActionListener (in nsIEditActionListener listener); */
NS_IMETHODIMP nsEditor::RemoveEditActionListener(nsIEditActionListener *listener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void AddDocumentStateListener (in nsIDocumentStateListener listener); */
NS_IMETHODIMP nsEditor::AddDocumentStateListener(nsIDocumentStateListener *listener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void RemoveDocumentStateListener (in nsIDocumentStateListener listener); */
NS_IMETHODIMP nsEditor::RemoveDocumentStateListener(nsIDocumentStateListener *listener)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DumpContentTree (); */
NS_IMETHODIMP nsEditor::DumpContentTree()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DebugDumpContent (); */
NS_IMETHODIMP nsEditor::DebugDumpContent()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void DebugUnitTests (out long outNumTests, out long outNumTestsFailed); */
NS_IMETHODIMP nsEditor::DebugUnitTests(PRInt32 *outNumTests, PRInt32 *outNumTestsFailed)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIEditor_h__ */
