/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class RDN
implements Serializable {
    static final long serialVersionUID = 7895454691174650321L;
    private String[] m_type;
    private String[] m_value;
    private boolean m_ismultivalued = false;
    private static Hashtable m_attributehash = new Hashtable();
    public static final String[] _cesAttributes = new String[]{"adminurl", "altserver", "automountinformation", "bootfile", "bootparameter", "cirbindcredentials", "generation", "homedirectory", "internationalisdnnumber", "labeleduri", "membercertificatedescription", "membernisnetgroup", "memberuid", "memberurl", "nismapentry", "nisnetgrouptriple", "nsaddressbooksyncurl", "presentationaddress", "ref", "replicaentryfilter", "searchguide", "subtreeaci", "vlvfilter", "vlvname", "x121address"};
    public static final String CES_SYNTAX = "1.3.6.1.4.1.1466.115.121.1.26";

    public RDN(String string) {
        int n = string.indexOf("=");
        if (n <= 0) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(string.substring(0, n).trim());
        int n2 = this.findNextMVSeparator(string, n);
        while (n2 != -1) {
            this.m_ismultivalued = true;
            vector.addElement(string.substring(n + 1, n2 - 1).trim());
            n = string.indexOf("=", n2 + 1);
            if (n == -1) {
                return;
            }
            vector2.addElement(string.substring(n2 + 1, n).trim());
            n2 = this.findNextMVSeparator(string, n);
        }
        vector.addElement(string.substring(n + 1).trim());
        this.m_type = new String[vector2.size()];
        this.m_value = new String[vector.size()];
        int n3 = 0;
        while (n3 < vector2.size()) {
            this.m_type[n3] = (String)vector2.elementAt(n3);
            this.m_value[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
    }

    int findNextMVSeparator(String string, int n) {
        int n2 = string.indexOf(43, n);
        int n3 = string.indexOf(34, n);
        int n4 = -1;
        if (n2 == n) {
            return n;
        }
        if (n3 > -1) {
            n4 = string.indexOf(34, n3 + 1);
        }
        while (n2 != -1) {
            if (string.charAt(n2 - 1) != '\\' && (n3 >= n2 || n2 >= n4)) {
                return n2;
            }
            n2 = string.indexOf(43, n2 + 1);
            if (n3 > -1 && n4 > -1) {
                if (n4 < n2) {
                    n3 = string.indexOf(34, n4 + 1);
                }
            } else {
                n3 = -1;
            }
            int n5 = n4 = n3 > -1 ? string.indexOf(34, n3 + 1) : -1;
        }
        return -1;
    }

    public String[] explodeRDN(boolean bl) {
        if (this.m_type == null) {
            return null;
        }
        String[] stringArray = new String[]{bl ? this.getValue() : this.toString()};
        return stringArray;
    }

    public String getType() {
        return this.m_type[0];
    }

    public String[] getTypes() {
        return this.m_type;
    }

    public String getValue() {
        return this.m_value[0];
    }

    public String[] getValues() {
        return this.m_value;
    }

    public boolean isMultivalued() {
        return this.m_ismultivalued;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.m_type[0]) + "=" + this.m_value[0]);
        int n = 1;
        while (n < this.m_type.length) {
            stringBuffer.append(" + " + this.m_type[n] + "=" + this.m_value[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean isRDN(String string) {
        RDN rDN = new RDN(string);
        return rDN.getTypes() != null && rDN.getValues() != null;
    }

    public boolean equals(RDN rDN) {
        String[] stringArray = (String[])this.getTypes().clone();
        String[] stringArray2 = (String[])this.getValues().clone();
        String[] stringArray3 = (String[])rDN.getTypes().clone();
        String[] stringArray4 = (String[])rDN.getValues().clone();
        if (stringArray.length != stringArray3.length) {
            return false;
        }
        this.sortTypesAndValues(stringArray, stringArray2);
        this.sortTypesAndValues(stringArray3, stringArray4);
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equalsIgnoreCase(stringArray3[n])) {
                return false;
            }
            if (CES_SYNTAX.equals(RDN.getAttributeSyntax(stringArray[n])) ? !stringArray2[n].equals(stringArray4[n]) : !stringArray2[n].equalsIgnoreCase(stringArray4[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void sortTypesAndValues(String[] stringArray, String[] stringArray2) {
        do {
            boolean bl = true;
            int n = 0;
            while (n < stringArray.length - 1) {
                if (stringArray[n].toLowerCase().compareTo(stringArray[n + 1].toLowerCase()) > 0) {
                    String string = stringArray[n];
                    String string2 = stringArray2[n];
                    stringArray[n] = stringArray[n + 1];
                    stringArray2[n] = stringArray2[n + 1];
                    stringArray[n + 1] = string;
                    stringArray2[n + 1] = string2;
                    bl = false;
                }
                ++n;
            }
            bl = false;
        } while (false);
    }

    public static void registerAttributeSyntax(String string, String string2) {
        m_attributehash.put(string.toLowerCase(), string2);
    }

    public static void unregisterAttributeSyntax(String string) {
        m_attributehash.remove(string.toLowerCase());
    }

    public static String getAttributeSyntax(String string) {
        return (String)m_attributehash.get(string.toLowerCase());
    }

    public static String[] getAttributesForSyntax(String string) {
        Enumeration enumeration = m_attributehash.keys();
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string.equals((String)m_attributehash.get(string2))) continue;
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = new String((String)vector.elementAt(n));
            ++n;
        }
        return stringArray;
    }

    static {
        int n = 0;
        while (n < _cesAttributes.length) {
            RDN.registerAttributeSyntax(_cesAttributes[n], CES_SYNTAX);
            ++n;
        }
    }
}

