/*-
 * customsCheck.c --
 *	Check attribute lists
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsCheck.c,v 1.1 1994/05/18 23:00:01 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    <string.h>

#include    "customs.h"


/*-
 *-----------------------------------------------------------------------
 * Customs_CheckAttr
 *	Check a list of attributes for being a subset of another list.
 *
 * Results:
 *	TRUE iff all attributes in lst1 are also in lst2.
 *	An attribute in lst1 starting with ``!'' represents the negation of
 *	the following string, i.e., it returns FALSE if the attribute *is*
 *	present. The pseudo-attribute ``OR'' separates disjuncts.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
Boolean
Customs_CheckAttr (lst1, lst2)
    Lst		lst1, lst2;
{
    LstNode ln;
    Boolean isTrue;

    if (Lst_Open(lst1) == FAILURE) {
	return (TRUE);
    }

    isTrue = TRUE;
    for (ln = Lst_Next(lst1); !Lst_IsAtEnd(lst1); ln = Lst_Next(lst1)) {
	char *attr = (char *)Lst_Datum (ln);

 	if (attr[0] == 'O' && attr[1] == 'R' && attr[2] == '\0') { 
	    if (isTrue) {
		/*
		 * We have scanned a disjunct all of whose conjuncts
		 * were true.  We may return True.
		 */
		break;
	    } else {
		/*
		 * Start evaluating a new disjunct.
		 */
		isTrue = TRUE;
	    }
	    continue;
	}

	isTrue = isTrue && ((attr[0] == '!') ? 
				Lst_Find (lst2, attr + 1, strcmp) == NILLNODE :
				Lst_Find (lst2, attr, strcmp) != NILLNODE);
    }
    Lst_Close (lst1);

    return (isTrue);
}
