#include <stdio.h>
#include <slang.h>
#include <math.h>

#if defined(__FreeBSD__) || defined(__386BSD__)
# include <floatingpoint.h>
# define HAVE_FPSETMASK 1
#endif

static int Ignore_Exit = 0;
static void c_exit (int *code)
{
   if (Ignore_Exit == 0)
     exit (*code);
}

static SLang_Intrin_Fun_Type Intrinsics [] =
{
   MAKE_INTRINSIC_I("exit", c_exit, VOID_TYPE),
   SLANG_END_INTRIN_FUN_TABLE
};


int main (int argc, char **argv)
{
   int i;

   if (argc < 2)
     {
	fprintf (stderr, "Usage: %s FILE...\n", argv[0]);
	return 1;
     }
   
   if ((-1 == SLang_init_all ())
       || (-1 == SLadd_intrin_fun_table (Intrinsics, NULL)))
     return 1;
   
   SLang_Traceback = 1;

   if (-1 == SLang_set_argc_argv (argc, argv))
     return 1;

#ifdef HAVE_FPSETMASK
   fpsetmask (~(FP_X_OFL|FP_X_INV|FP_X_DZ|FP_X_DNML|FP_X_UFL|FP_X_IMP));
#endif

   if (argc > 2)
     Ignore_Exit = 1;

   for (i = 1; i < argc; i++)
     {
	if (-1 == SLang_load_file (argv[i]))
	  return 1;
     }

   return SLang_Error;
}

	
