/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __RESCHANGEDLG_H
#define __RESCHANGEDLG_H

#include <qdialog.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qscrollview.h>

#include "conflictdisplay.h"
#include "device.h"
#include "resbaseconf.h"
#include "resource.h"
#include "resourcespinbox.h"


class ResourceChangeDialog : public QDialog
{
  Q_OBJECT
  
  public:
  
    ResourceChangeDialog(ResourceBaseConfig *, Resource *, Device *,
    			 QWidget *parent = 0L, const char *name = 0L);
    
    ~ResourceChangeDialog() {}

          bool      conflict()    const { return _conflict;   }
    const Resource  *newSetting() const { return _newsetting; }
  
  private:
  
    QLabel              *_hintlabel, *_valuelabel;
    ResourceSpinBox     *_resspinbox;
    QGroupBox           *_conflictgbox;
    QLabel              *_conflictlabel;
    ConflictDisplay     *_conflictdisplay;
    QPushButton         *_ok, *_cancel;
    
    ResourceBaseConfig  *_baseconf;
    Resource            *_res, *_newsetting;
    Device              *_device;
    bool                _conflict;
  
  private slots:
  
    void  slotResourceChanged(int);
};


#endif

