    /*

    Miscellany functions for kdm's greeter
    $Id: miscfunc.c,v 1.5.2.1 2001/03/15 17:35:06 ossi Exp $

    Copyright (C) 2001 Oswald Buddenhagen <ossi@kde.org>


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "miscfunc.h"

#ifdef USE_RDWR_WM

#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <grp.h>

int
rdwr_wm (char *wm, int wml, const char *usr, int rd)
{
    int rv;
    FILE *file;
    char fname[256];
    struct passwd *pwd;

    /* read passwd */
    if (!usr || !usr[0])
	return -2;
    pwd = getpwnam( usr );
    endpwent();
    if (!pwd)
	return -2;

    /* Go user */
    rv = -1;
    setgroups( 0, 0);	/* take away root group - forever! */
    if( !setegid(pwd->pw_gid) ) {
	if( !seteuid(pwd->pw_uid) ) {

	    /* open file as user which is loging in */
	    sprintf(fname, "%s/" WMRC, pwd->pw_dir);
	    if (rd) {
		if ( (file = fopen(fname, "r")) != NULL ) {
		    fgets (wm, wml, file);
		    rv = strlen (wm);
		    if (rv && wm[rv - 1] == '\n')
			wm[--rv] = '\0';
		    fclose (file);
		}
	    } else {
		if ( (file = fopen(fname, "w")) != NULL ) {
		    fputs (wm, file);
		    rv = 1;
		    fclose (file);
		}
	    }

	    seteuid(0);
	}
	setegid(0);
    }

    return rv;
}

#endif /* USE_RDWR_WM */


int s_copy (char *dst, const char *src, int idx, int spc)
{
    int dp = 0;

    while (src[idx] == ' ')
	idx++;
    for (; src[idx] >= ' ' && (spc || src[idx] != ' '); idx++)
	if (dp < F_LEN - 1)
	    dst[dp++] = src[idx];
    dst[dp] = '\0';
    return idx;
}

