/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __taskbarapplet_h__
#define __taskbarapplet_h__

#include <qtoolbutton.h>
#include <qpushbutton.h>
#include <qtimer.h>
#include <qlist.h>
#include <qscrollview.h>

#include <kpanelapplet.h>

class ScrollableTaskbarArea;
class ArrowPreviewButton;
class QScrollView;
class QBoxLayout;
class QPopupMenu;
class QGridLayout;

class KWindowListMenu;
class Task;
class Startup;

class TaskButton : public QPushButton
{
    Q_OBJECT

public:
    TaskButton( Task* task, QWidget* parent, const char *name = 0 );

    QSizePolicy sizePolicy() const  { return(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred)); }
    QSize sizeHint() const;

    Task* task() { return _task; }
    void publishIconGeometry( const QPoint& );

protected:
    enum WindowOperation {
        MaximizeOp = 100,
        IconifyOp,
        CloseOp,
        ToCurrentOp,
        RestoreOp,
        StayOnTopOp,
        ShadeOp
    };
    void drawButton(QPainter *p);
    void mousePressEvent( QMouseEvent *e );

    void dragEnterEvent(QDragEnterEvent* event);
    void dragLeaveEvent(QDragLeaveEvent* event);

protected slots:
    void refresh();
    void toggled();
    void clientPopupAboutToShow();
    void desktopPopupAboutToShow();
    void dragSwitchTimeout();
    void clientPopupActivated(int);
    void sendToDesktop(int);

private:
    Task*               _task;
    QPopupMenu*         _popup;
    QPopupMenu*         _deskpopup;
    QTimer*             _dragSwitchTimer;
};

class StartupButton : public QPushButton
{
    Q_OBJECT

public:
    StartupButton(Startup* startup, QWidget* parent, const char *name = 0);

    QSizePolicy sizePolicy() const  { return(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred)); }
    QSize sizeHint() const;

    Startup* startup() { return _startup; }

protected slots:
    void animTimerFired();

protected:
    void drawButton( QPainter *p );
    void mousePressEvent( QMouseEvent *e );

private:
    Startup*            _startup;
    QList<QPixmap>      _anim;
    QTimer              _animTimer;
    int                 _frame;
};

class TaskBar : public QWidget
{
    Q_OBJECT

public:
    TaskBar(QWidget *parent = 0, const char *name = 0);
    ~TaskBar();

    void setOrientation(Orientation o) { _orientation = o; }
    Orientation orientation() { return _orientation; };

signals:
    void buttonCountChanged();

protected slots:
    void taskAdded(Task*);
    void taskRemoved(Task*);
    void startupAdded(Startup*);
    void startupRemoved(Startup*);
    void desktopChanged(int);
    void publishIconGeometry();

protected:
    void resizeEvent(QResizeEvent*);

    void mousePressEvent(QMouseEvent*);
    void mouseReleaseEvent(QMouseEvent*);
    void mouseDoubleClickEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void propagateMouseEvent(QMouseEvent*);

private:
    QList<TaskButton>           _taskButtons;
    QList<StartupButton>        _startupButtons;
    QGridLayout*                _layout;
    QTimer                      _publishTimer;
    Orientation                 _orientation;
    bool                        _showall;
};

class TaskbarApplet : public KPanelApplet
{
    Q_OBJECT

public:
    TaskbarApplet(const QString& configFile, Type t = Normal, int actions = 0,
                  QWidget *parent = 0, const char *name = 0);
    ~TaskbarApplet();

    int widthForHeight(int h) const;
    int heightForWidth(int w) const;

    void preferences();

protected:
    void popupDirectionChange( Direction );
    void resizeEvent(QResizeEvent*);

protected slots:
    void slotPreferences();
    void slotExecWindowListMenu();
    void slotWindowListMenuAboutToHide();

private:
    Orientation                  m_Orientation;
    ScrollableTaskbarArea       *m_pScrollableArea;
    QBoxLayout                  *m_pBoxLayout;
    KWindowListMenu             *m_pWindowListMenu;
    ArrowPreviewButton          *m_pWindowListBtn;
};

class FittsLawScrollView : public QScrollView
{
    Q_OBJECT

public:
    FittsLawScrollView(QWidget *parent = 0, const char *name = 0);
    virtual ~FittsLawScrollView() {}

protected:
    bool x11Event(XEvent*);

private:
    QWidget* _activeWidget;
};

class ScrollableTaskbarArea : public QWidget
{
    Q_OBJECT

public:
    ScrollableTaskbarArea(QWidget *parent, const char* name = 0);

    void setOrientation(Orientation orientation);
    Orientation getOrientation() { return m_Orientation; };

protected slots:
    void scrollTopLeft ();
    void scrollBottomRight ();
    void scrollTopLeft (int step);
    void scrollBottomRight (int step);
    void taskbarButtonCountChanged();

protected:
    void layoutComponents();
    void buttonsAreaResized();
    bool bScrollButtonsDisplayed() { return scroll_buttons_displayed; };
    void enableDisableScrollButtons();
    void showHideScrollButtons();
    void createArrowPixmaps();

    void resizeEvent( QResizeEvent * );
    void changeItemsSize(int nNewWd, int nNewHg);

    FittsLawScrollView *m_pScroller;
    TaskBar *m_pTaskbarArea;
    Orientation m_Orientation;

    QPushButton *top_left_scroll_button;
    QPushButton *bottom_right_scroll_button;
    bool scroll_buttons_displayed;

    // The maximum width of the scroll area (when scroll buttons
    // aren't displayed)
    int scroll_area_max_size;
    // The minimum width of the scroll area (when scroll buttons
    // are displayed)
    int scroll_area_min_size;

    bool m_bArrowPixmapsCreated;
    int m_nButtonsAreaSize;
};

class ArrowPreviewButton : public QToolButton
{
    Q_OBJECT

public:
    ArrowPreviewButton(QWidget *parent = 0, const char *name = 0);
    void setArrowType(Qt::ArrowType at) { m_ArrowType = at; }

signals:
    void showMenu( const QPoint& );

protected:
    void mousePressEvent( QMouseEvent * e);
    void drawButtonLabel(QPainter * pPainter);

    Qt::ArrowType  m_ArrowType;
};

#endif
