/*****************************************************************

Copyright (c) 2000 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __taskbarextension_h__
#define __taskbarextension_h__

#include <qlist.h>
#include <qpushbutton.h>
#include <kpanelextension.h>

class TaskManager;
class Task;
class Startup;
class QTimer;
class QPopupMenu;
class QGridLayout;

class TaskButton : public QPushButton
{
    Q_OBJECT

public:
    TaskButton( Task* task, QWidget* parent, const char *name = 0 );

    QSizePolicy sizePolicy() const  { return(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred)); }
    QSize sizeHint() const;

    Task* task() { return _task; }
    void publishIconGeometry( const QPoint& );

protected:
    enum WindowOperation {
        MaximizeOp = 100,
        IconifyOp,
        CloseOp,
        ToCurrentOp,
        RestoreOp,
        StayOnTopOp,
        ShadeOp
    };
    void drawButton(QPainter *p);
    void mousePressEvent( QMouseEvent *e );

    void dragEnterEvent(QDragEnterEvent* event);
    void dragLeaveEvent(QDragLeaveEvent* event);

protected slots:
    void refresh();
    void toggled();
    void clientPopupAboutToShow();
    void desktopPopupAboutToShow();
    void dragSwitchTimeout();
    void clientPopupActivated(int);
    void sendToDesktop(int);

private:
    Task*               _task;
    QPopupMenu*         _popup;
    QPopupMenu*         _deskpopup;
    QTimer*             _dragSwitchTimer;
};

class StartupButton : public QPushButton
{
    Q_OBJECT

public:
    StartupButton(Startup* startup, QWidget* parent, const char *name = 0);

    QSizePolicy sizePolicy() const  { return(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred)); }
    QSize sizeHint() const;

    Startup* startup() { return _startup; }

protected slots:
    void animTimerFired();

protected:
    void drawButton( QPainter *p );
    void mousePressEvent( QMouseEvent *e );

private:
    Startup*            _startup;
    QList<QPixmap>      _anim;
    QTimer              _animTimer;
    int                 _frame;
};

class TaskBarExtension : public KPanelExtension
{
    Q_OBJECT

public:
    TaskBarExtension(const QString& configFile, Type t = Normal,
		     int actions = 0, QWidget *parent = 0, const char *name = 0);
    ~TaskBarExtension();

    QSize sizeHint(Position, QSize maxSize) const;
    Position preferedPosition() const { return Bottom; }

protected slots:
    void taskAdded(Task*);
    void taskRemoved(Task*);
    void startupAdded(Startup*);
    void startupRemoved(Startup*);
    void desktopChanged(int);
    void publishIconGeometry();

protected:
    void resizeEvent(QResizeEvent*);

    void mousePressEvent(QMouseEvent*);
    void mouseReleaseEvent(QMouseEvent*);
    void mouseDoubleClickEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void propagateMouseEvent(QMouseEvent*);

    void preferences();

private:
    QList<TaskButton>           _taskButtons;
    QList<StartupButton>        _startupButtons;
    QGridLayout*                _layout;
    QTimer                      _publishTimer;
    bool                        _showall;
};

#endif
