#ifndef __kparthost_h__
#define __kparthost_h__

#include <xparthost.h>

#include <kparts/part.h>

class XPart_stub;
class KBrowserSignals;
class QXEmbed;

class KPartHost : public KParts::ReadOnlyPart, public XPartHost
{
    Q_OBJECT
public:
    KPartHost( QWidget *parent, const char *name );
    virtual ~KPartHost();

    // DCOP stuff
    virtual DCOPRef part();
    virtual DCOPRef registerXPart( const DCOPRef &part );

    // KPart signals
    virtual ASYNC createActions( const QCString &xmlActions );
    virtual ASYNC setWindowCaption( const QString &caption );
    virtual ASYNC setStatusBarText( const QString &text );

    virtual ASYNC started();
    virtual ASYNC completed();
    virtual ASYNC canceled( const QString &errMsg );

    // reimplemented from KReadOnlyPart
    virtual bool openURL( const KURL &url );
    virtual bool closeURL();

protected:
  virtual bool openFile() { return false; }

private slots:
    void actionActivated();

signals:
    void actionsInitialized();

private:
    DCOPRef m_part;
    XPart_stub *m_stub;
    KBrowserSignals *be;
    QXEmbed *embed;
};

#endif
