%{

#define YY_NO_UNPUT

#include <qstring.h>
#include "catalogitem.h"
#include "pofile.cpp.h"
#include <stdlib.h>
#include <iostream.h>

int lineno = 0;

%}

%option noyywrap

%%

[ ]*[\n]	lineno++;
msgid		return T_MSGID;
msgstr		return T_MSGSTR;
#[^\n]*		{
		   yylval.str = new QCString(yytext);
		   return T_COMMENT;
		}
\"([^\n]*(\\\")?)*\"\n	{
			yytext[strlen(yytext)-2] = 0;
			yytext++;
		   yylval.str = new QCString(yytext);
		   return T_STRING;
		}

.		;

%%

extern void yyparse();

void parsepofile(const char *file)
{
    yy_switch_to_buffer( yy_scan_string( file ) );
    yyparse();	
}
