/*
transconf.cpp

KTranslator v. 0.6.0, Setup Dialog 


(C) Andrea Rizzi <rizzi@kde.org>
23 Dec 1999



*/

#include "transconf.h"
#include <kiconloader.h>
#include <qlistbox.h>

// SETUP DIALOG



FileConfig::FileConfig(QString title, QString msg, QWidget *parent, const char *name )
    : QDialog( parent, name,TRUE )
{
setFixedSize(350,340);
setCaption(title);
QLabel *lab=new QLabel(i18n("Filename:"),this,"label0");
lab->setGeometry(10,10,160,30);
le=new QLineEdit(this,"le");
le->setGeometry(10,40,200,30);

lab=new QLabel(msg,this,"label1");
lab->setGeometry(10,70,160,30);
lb=new QListBox(this,"lb");
lb->setGeometry(10,100,200,190);

QPushButton *pb= new QPushButton(i18n("&Add"),this,"p0");
pb->setGeometry(230,40,100,30);
connect(pb,SIGNAL(clicked()),this,SLOT(add()));

pb= new QPushButton(i18n("&Remove"),this,"p1");
pb->setGeometry(230,100,100,30);
connect(pb,SIGNAL(clicked()),this,SLOT(remove()));
pb= new QPushButton(i18n("&Ok"),this,"p2");
pb->setGeometry(10,300,90,30);
connect(pb,SIGNAL(clicked()),this,SLOT(ok()));

pb= new QPushButton(i18n("&Cancel"),this,"p3");
pb->setGeometry(250,300,90,30);
connect(pb,SIGNAL(clicked()),this,SLOT(cancel()));

}

QStrList  FileConfig::getFileList()
{
unsigned int i;
QStrList a;
for(i=0;i<lb->count();i++)
 a.append(QString(lb->text(i)));
return a;
}

void FileConfig::setFileList(QStrList *list)
{
 lb->insertStrList(list);
}

void FileConfig::ok()
{
done(1);
} 

void FileConfig::remove()
{
lb->removeItem(lb->currentItem());
} 

void FileConfig::add()
{
lb->insertItem(le->text());
} 

void FileConfig::cancel()
{
done(0);
} 

Setup::Setup( QWidget *parent, const char *name )
    : QDialog( parent, name,TRUE )
{
setFixedSize(350,340);
    KTabCtl *tab = new KTabCtl( this, "ktab" );
    setCaption( klocale->translate("KTransaltor Setup" ));
    KApplication *app=KApplication::getKApplication();
    config=app->getConfig();

    compiledList.clear();
    int num=config->readNumEntry("NumItem");
    int i; 
    QString s,st;
    for(i=0;i<num;i++)
    {
        s.sprintf("File%d",i+1);
        st=config->readEntry(s).copy();
        compiledList.append(st);
    }    
    sourceList.clear();    
    config->setGroup("SourceCat");
     num=config->readNumEntry("NumItem");
    for(i=0;i<num;i++)
    {
        s.sprintf("File%d",i+1);
        st=config->readEntry(s).copy();
        sourceList.append(st);
    }


    QString sstr;
    QWidget *w = new QWidget( tab, "page one" );    
    config->setGroup("Files");
    Lined[0] = new KLined( w, "LineEdit_1" );    
    Lined[0]->setGeometry( 10, 40, 320, 30 );
    Lined[0]->setText(config->readEntry("BasePath"));

    QPushButton *filebutton=new QPushButton(i18n("Compiled cat. (.mo)"),w);
    filebutton->setGeometry( 10, 120, 130, 30 );
    filebutton->setEnabled(false);
    connect(filebutton,SIGNAL(clicked()),this,SLOT(confCompiled()));
    filebutton=new QPushButton(i18n("Source cat. (.po)"),w);
    filebutton->setGeometry( 160, 120, 130, 30 );
    connect(filebutton,SIGNAL(clicked()),this,SLOT(confSource()));
/*    Lined[1] = new KLined( w, "LineEdit_2" );    
    Lined[1]->setGeometry( 10, 120, 320, 30 );
    Lined[1]->setText(config->readEntry("MsgPath"));
  */ 
    Lined[2] = new KLined( w, "LineEdit_3" );    
    Lined[2]->setGeometry( 10, 200, 200, 30 );
    Lined[2]->setText(config->readEntry("Lang"));

	QLabel* tmpQLabel;
	tmpQLabel = new QLabel( w, "Label_1" );
	tmpQLabel->setGeometry( 10, 10, 320, 30 );
	tmpQLabel->setText( klocale->translate("Path of CVS po dirctory (ex. /usr/local/kdecvs/kde-i18n/)" ));
	
	tmpQLabel = new QLabel( w, "Label_2" );
	tmpQLabel->setGeometry( 10, 90, 320, 30 );
	tmpQLabel->setText( klocale->translate("List of file where I can search a tanslation" ));


	tmpQLabel = new QLabel( w, "Label_3" );
	tmpQLabel->setGeometry( 10, 170, 280, 30 );
	tmpQLabel->setText( klocale->translate("Default Translation Language (it,de,fr,es..)" ));
	
	w->resize( 350, 300 );
	tab->addTab( w, klocale->translate("&Files" ));

	
    w = new QWidget( tab, "page two" );    
    config->setGroup("Identity");
    
    Lined[3] = new KLined( w, "LineEdit_1a" );    
    Lined[3]->setGeometry( 10, 40, 200, 30 );
    Lined[3]->setText(config->readEntry("Name"));
    
    Lined[4] = new KLined( w, "LineEdit_2a" );    
    Lined[4]->setGeometry( 10, 100, 200, 30 );
    Lined[4]->setText(config->readEntry("EMail"));
    
    Lined[5] = new KLined( w, "LineEdit_3a" );    
    Lined[5]->setGeometry( 10, 160, 200, 30 );
    Lined[5]->setText(config->readEntry("MList"));
    
    Lined[6] = new KLined( w, "LineEdit_4a" );    
    Lined[6]->setGeometry( 10, 220, 200, 30 );
    Lined[6]->setText(config->readEntry("Language"));


	tmpQLabel = new QLabel( w, "Label_1a" );
	tmpQLabel->setGeometry( 10, 10, 200, 30 );
	tmpQLabel->setText( klocale->translate("Author Name" ));
	
	tmpQLabel = new QLabel( w, "Label_2a" );
	tmpQLabel->setGeometry( 10, 70, 200, 30 );
	tmpQLabel->setText( klocale->translate("Author E-Mail" ));
	
	tmpQLabel = new QLabel( w, "Label_3a" );
	tmpQLabel->setGeometry( 10, 130, 200, 30 );
	tmpQLabel->setText( klocale->translate("Language MailingList" ));
	
	tmpQLabel = new QLabel( w, "Label_4a" );
	tmpQLabel->setGeometry( 10, 190, 200, 30 );
	tmpQLabel->setText( klocale->translate("Full Language Name" ));
	
    	//QPushButton* tmpQPushButton;

	w->resize( 350, 300 );
    tab->addTab( w, klocale->translate("&Identity" ));


    
        w = new QWidget( tab, "page three" );

    config->setGroup("Translation");

	
	CheckBox[0] = new QCheckBox( w, "CheckBox_1" );
	CheckBox[0]->setGeometry( 10, 10, 160, 20 );
	CheckBox[0]->setText( klocale->translate("&Auto search in cat.") );
	CheckBox[0]->setChecked(config->readNumEntry("AutoSearch"));	
	
	tmpQLabel = new QLabel( w, "Label_1b" );
	tmpQLabel->setGeometry( 10, 40, 300, 30 );
	tmpQLabel->setText( klocale->translate("Message need to be revised if is" ));
	
	CheckBox[1] = new QCheckBox( w, "CheckBox_2" );
	CheckBox[1]->setGeometry( 10, 70, 260, 20 );
	CheckBox[1]->setText( klocale->translate("Fuzz&y") );
	CheckBox[1]->setChecked(config->readNumEntry("NormalFuzzy"));

	CheckBox[2] = new QCheckBox( w, "CheckBox_3" );
	CheckBox[2]->setGeometry( 10, 90, 260, 20 );
	CheckBox[2]->setText( klocale->translate("I&dentical to MsgId") );
	CheckBox[2]->setChecked(config->readNumEntry("NormalSame"));

	CheckBox[3] = new QCheckBox( w, "CheckBox_3" );
	CheckBox[3]->setGeometry( 10, 110, 260, 20 );
	CheckBox[3]->setText( klocale->translate("&Null") );
	CheckBox[3]->setChecked(config->readNumEntry("NormalNull"));

	tmpQLabel = new QLabel( w, "Label_2b" );
	tmpQLabel->setGeometry( 10, 140, 300, 20 );
	tmpQLabel->setText( klocale->translate("Rough translation option:" ));
	
	CheckBox[4] = new QCheckBox( w, "CheckBox_4" );
	CheckBox[4]->setGeometry( 10, 180, 300, 20 );
	CheckBox[4]->setText( klocale->translate("overwrite fu&zzy message") );
	CheckBox[4]->setChecked(config->readNumEntry("Fuzzy"));

	CheckBox[5] = new QCheckBox( w, "CheckBox_5" );
	CheckBox[5]->setGeometry( 10, 200, 300, 20 );
	CheckBox[5]->setText( klocale->translate("&no .mo auto search (use only selected catalogue)") );	
	CheckBox[5]->setChecked(config->readNumEntry("NoAuto"));

	CheckBox[6] = new QCheckBox( w, "CheckBox_6" );
	CheckBox[6]->setGeometry( 10, 220, 300, 20 );
	CheckBox[6]->setText( klocale->translate("search in .&po files too (slow)") );
	CheckBox[6]->setChecked(config->readNumEntry("SearchInPo"));

	CheckBox[7] = new QCheckBox( w, "CheckBox_7" );
	CheckBox[7]->setGeometry( 10, 160, 300, 20 );
	CheckBox[7]->setText( klocale->translate("s&kip if exist a .po file translation") );
	CheckBox[7]->setChecked(config->readNumEntry("TranslPoFile"));
		
	CheckBox[15] = new QCheckBox( w, "CheckBox_15" );
	CheckBox[15]->setGeometry( 10, 240, 300, 20 );
	CheckBox[15]->setText( klocale->translate("translation from .po files are f&uzzy") );
	CheckBox[15]->setChecked(config->readNumEntry("MlIsFuzzy"));


	resize( 350, 300 );
        tab->addTab( w, klocale->translate("&Translation") );

	w = new QWidget( tab, "page four" );

        config->setGroup("Srearch Tran.");

	CheckBox[8] = new QCheckBox( w, "CheckBox_111" );
	CheckBox[8]->setGeometry( 10, 20, 160, 20 );
	CheckBox[8]->setText( klocale->translate("Case Se&nsitive") );
	CheckBox[8]->setChecked(config->readNumEntry("Case"));	
	
	tmpQLabel = new QLabel( w, "Label_1b1" );
	tmpQLabel->setGeometry( 10, 40, 300, 30 );
	tmpQLabel->setText( klocale->translate("Character to ignore:" ));
	
	CheckBox[14] = new QCheckBox( w, "CheckBox_31" );
	CheckBox[14]->setGeometry( 10, 70, 260, 20 );
	CheckBox[14]->setText( klocale->translate("&New Line (\\n)") );
	CheckBox[14]->setChecked(config->readNumEntry("BackSlashN"));


	
	CheckBox[9] = new QCheckBox( w, "CheckBox_21" );
	CheckBox[9]->setGeometry( 10, 90, 260, 20 );
	CheckBox[9]->setText( klocale->translate("&Ampersand (&&)") );
	CheckBox[9]->setChecked(config->readNumEntry("Ampersand"));

	CheckBox[10] = new QCheckBox( w, "CheckBox_31" );
	CheckBox[10]->setGeometry( 10, 110, 260, 20 );
	CheckBox[10]->setText( klocale->translate("&Dots (.)") );
	CheckBox[10]->setChecked(config->readNumEntry("Dots"));

	Lined[7] = new KLined( w, "LineEdit_7" );    
	Lined[7]->setGeometry( 100, 130, 70, 20 );
        Lined[7]->setText(config->readEntry("Other"));


	tmpQLabel = new QLabel( w, "Label_1" );
	tmpQLabel->setGeometry( 10, 130, 80, 20 );
	tmpQLabel->setText( klocale->translate("Other :" ));

	
/*	CheckBox[11] = new QCheckBox( w, "CheckBox_31" );
	CheckBox[11]->setGeometry( 10, 130, 260, 20 );
	CheckBox[11]->setText( klocale->translate("Other") );
	CheckBox[11]->setChecked(config->readNumEntry("NormalNull"));
*/
	tmpQLabel = new QLabel( w, "Label_2b1" );
	tmpQLabel->setGeometry( 10, 170, 300, 20 );
	tmpQLabel->setText( klocale->translate("A string match if: (in OR)" ));
	
	CheckBox[12] = new QCheckBox( w, "CheckBox_41" );
	CheckBox[12]->setGeometry( 10, 190, 260, 20 );
	CheckBox[12]->setText( klocale->translate("is contained in &MsgId") );
	CheckBox[12]->setChecked(config->readNumEntry("Contained"));

	CheckBox[13] = new QCheckBox( w, "CheckBox_51" );
	CheckBox[13]->setGeometry( 10, 210, 280, 20 );
	CheckBox[13]->setText( klocale->translate("&contains MsgId") );	
	CheckBox[13]->setChecked(config->readNumEntry("Contains"));

	CheckBox[11] = new QCheckBox( w, "CheckBox_61" );
	CheckBox[11]->setGeometry( 10, 230, 280, 20 );
	CheckBox[11]->setText( klocale->translate("is &equal to MsgId") );
	CheckBox[11]->setChecked(config->readNumEntry("equal"));

/*	CheckBox[15] = new QCheckBox( w, "CheckBox_71" );
	CheckBox[15]->setGeometry( 10, 240, 280, 20 );
	CheckBox[15]->setText( klocale->translate("boh") );
	CheckBox[15]->setChecked(config->readNumEntry("TranslPoFile"));
*/		


	resize( 350, 300 );
        tab->addTab( w, klocale->translate("&Search Tr.") );



	        w = new QWidget( tab, "page five" );

    config->setGroup("Header");

	HLineEdit = new  QMultiLineEdit(w,"MultiLine Header");
	HLineEdit->setGeometry(10,10,330,250);
	config->setGroup("Header");
/*         int i; 
         QString s,st;*/
config->setGroup("Header");
for(i=0;i<config->readNumEntry("NumLines");i++)
{
    s.sprintf("HLine%d",i+1);
    st=config->readEntry(s).copy();
    HLineEdit->insertLine(st);
}
	
	resize( 350, 300 );
        tab->addTab( w, klocale->translate("&Header") );


    QPushButton *quitButton = new QPushButton( this, "cancelButton" );
    quitButton->setText( klocale->translate("&Cancel") );
    quitButton->setGeometry( 275,305, 65,30 );
    connect( quitButton, SIGNAL(clicked()), SLOT(quit()) );
    
    quitButton = new QPushButton( this, "HelpButton" );
    quitButton->setText( klocale->translate("&Help" ));
    quitButton->setGeometry( 145,305, 65,30 );
    connect( quitButton, SIGNAL(clicked()), SLOT(help()) );
    
    quitButton = new QPushButton( this, "OKButton" );
    quitButton->setText( klocale->translate("&Ok" ));
    quitButton->setGeometry( 10,305, 65,30 );
    connect( quitButton, SIGNAL(clicked()), SLOT(save()) );
    
    
    tab->resize( 350, 300 );




show();
}



  

void Setup::quit()
{
close();
}

void Setup::help()
{
 KApplication::getKApplication()->invokeHTMLHelp("ktranslator/index-2.html", "");
}

void Setup::confCompiled()
{
FileConfig *fc=new FileConfig(i18n("List of compiled (.mo) catalogues"),i18n("List of .mo files:"));

config->setGroup("CompiledCat");
fc->setFileList(&compiledList);
if(fc->exec())
 compiledList=fc->getFileList();

}

void Setup::confSource()
{
FileConfig *fc=new FileConfig(i18n("List of source (.po) catalogues"),i18n(".po files & [lang].message:"));
config->setGroup("SourceCat");
/*
if(sourceList.isEmpty()) {
int num=config->readNumEntry("NumItem");
int i; 
QString s,st;
for(i=0;i<num;i++)
{
    s.sprintf("File%d",i+1);
    st=config->readEntry(s).copy();
    sourceList.append(st);
}
}
*/
fc->setFileList(&sourceList);
if(fc->exec())
 sourceList=fc->getFileList();
}


void Setup::save()
{
QString s,st;
unsigned int i;
config->setGroup("Header");
for(i=0;i<HLineEdit->numLines();i++)
{
    s.sprintf("HLine%d",i+1);
    st=HLineEdit->textLine(i);    
    config->writeEntry(s,st);
}
config->writeEntry("NumLines",HLineEdit->numLines());


config->setGroup("CompiledCat");
for(i=0;i<compiledList.count();i++)
{
    s.sprintf("File%d",i+1);
    st=compiledList.at(i);    
    config->writeEntry(s,st);
}
config->writeEntry("NumItem",compiledList.count());


config->setGroup("SourceCat");
for(i=0;i<sourceList.count();i++)
{
    s.sprintf("File%d",i+1);
    st=sourceList.at(i);    
    config->writeEntry(s,st);
}
config->writeEntry("NumItem",sourceList.count());

config->setGroup("Files");
config->writeEntry("BasePath",Lined[0]->text());
//config->writeEntry("MsgPath",Lined[1]->text());
config->writeEntry("Lang",Lined[2]->text());
config->setGroup("Identity");
config->writeEntry("Name",Lined[3]->text());
config->writeEntry("EMail",Lined[4]->text());
config->writeEntry("MList",Lined[5]->text());
config->writeEntry("Language",Lined[6]->text());
config->setGroup("Translation");
config->writeEntry("AutoSearch",CheckBox[0]->isChecked());
config->writeEntry("NormalFuzzy",CheckBox[1]->isChecked());
config->writeEntry("NormalSame",CheckBox[2]->isChecked());
config->writeEntry("NormalNull",CheckBox[3]->isChecked());
config->writeEntry("Fuzzy",CheckBox[4]->isChecked());
config->writeEntry("MlIsFuzzy",CheckBox[15]->isChecked());
config->writeEntry("NoAuto",CheckBox[5]->isChecked());
config->writeEntry("SearchInPo",CheckBox[6]->isChecked());
config->writeEntry("TranslPoFile",CheckBox[7]->isChecked());
config->setGroup("Search");
config->writeEntry("Other",Lined[7]->text());
config->writeEntry("Case",CheckBox[8]->isChecked());
config->writeEntry("Ampersand",CheckBox[9]->isChecked());
config->writeEntry("Dots",CheckBox[10]->isChecked());
config->writeEntry("Equal",CheckBox[11]->isChecked());
config->writeEntry("Contained",CheckBox[12]->isChecked());
config->writeEntry("Contains",CheckBox[13]->isChecked());
config->writeEntry("BackSlashN",CheckBox[14]->isChecked());

close();
}
#include "transconf.moc"







