/*
 *   kghostview: KDE PostScript viewer
 *   This file: Copyright (C) 2000 Wilco Greven, greven@kde.org
 *   Uses ideas from earlier dialog code by Mark Donohoe and Tim Theisen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "printsetupdialog.h"
#include "printsetupdialogbody.h"

#include <qlineedit.h>

#include <kconfig.h>
#include <kinstance.h>
#include <klocale.h>

#include "kgv_view.h"

PrintSetupDialog::PrintSetupDialog( QWidget* parent, const char* _name, 
				    const QString& caption )
 : KDialogBase( parent, _name, true, caption, Ok|Cancel, Ok, true )
{
    _body = new PrintSetupDialogBody( this );
    setMainWidget( _body );

    // Read the configuration
    KConfig* config = KGVFactory::instance()->config();
    config->setGroup( "Print" );

    QString name = config->readEntry( "Name" );
    QString spool = config->readEntry( "Spool", "lpr" );
    QString variable = config->readEntry( "Variable", "PRINTER" );
    
    _body->leName->setText( name );
    _body->leSpool->setText( spool );
    _body->leVar->setText( variable );

    connect( this, SIGNAL( okClicked() ),
	     this, SLOT( slotWriteConfig() ) );
}

QString PrintSetupDialog::printerName() const
{
    return _body->leName->text();
}

QString PrintSetupDialog::spoolCommand() const
{
    return _body->leSpool->text();
}

QString PrintSetupDialog::environmentVariable() const
{
    return _body->leVar->text();
}

void PrintSetupDialog::slotWriteConfig()
{
    // Write the configuration
    KConfig* config = KGVFactory::instance()->config();
    config->setGroup( "Print" );

    QString name = _body->leName->text();
    QString spool = _body->leSpool->text();
    QString variable = _body->leVar->text();

    config->writeEntry( "Name", name );
    config->writeEntry( "Spool", spool );
    config->writeEntry( "Variable", variable );
}
