/*
 *   kghostview: KDE PostScript viewer
 *   This file: Copyright (C) 2000 Wilco Greven, greven@kde.org
 *   Uses ideas from ealier dialog code by Mark Donohoe and Tim Theisen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _PRINT_SETUP_DIALOG_H_
#define _PRINT_SETUP_DIALOG_H_

#include <kdialogbase.h>

#include "printsetupdialogbody.h"

class PrintSetupDialog : public KDialogBase
{
    Q_OBJECT

public:
    PrintSetupDialog( QWidget* parent, const char* _name, 
		      const QString& caption );

    QString printerName() const;
    QString spoolCommand() const;
    QString environmentVariable() const;

public slots:
    void slotWriteConfig();
    
private:
    PrintSetupDialogBody* _body;
};

#endif
