#ifndef __KPBITMAPLIST_H
#define __KPBITMAPLIST_H

#include <qlistbox.h>
#include <qlist.h>
#include <qbitmap.h>

class KPBitmapWidget;

class KPBitmapList : public QListBox
{
    Q_OBJECT
public:
    KPBitmapList(const QString &defaultPrefix, QWidget *parent=0,
                 const char *name=0);
    KPBitmapList(){;}
    void setBitmapWidget(KPBitmapWidget *w){bmpPreview = w;}
    void insertBitmap(const QBitmap *bitmap, const QColor *color);
    void setPrefix(const QString &str);
    QString prefix(){return(prefixStr);}
    void reset();
    void load();
    void loadFile(const QString &str);
    void saveCurrentBitmap();
    void saveAll();
    void saveCHeader();
    void savePointArray();
signals:
    void saveEnabled(bool en);
    void closeEnabled(bool en);
    void message(const QString &msg);
    void setProgress(int val);
public slots:
    void slotSelected(int index);
protected:
    QString prefixStr;
    QList<QBitmap> bmpList;
    KPBitmapWidget *bmpPreview;
};

class QColorList : public QList<QColor>
{
public:
    QColorList(){;}
    int compareItems(Item s1, Item s2);
};

#endif
