/*
* filtlist.h -- Declaration of class KFilterList.
* Generated by newclass on Mon Apr 13 06:10:04 EST 1998.
*/
#ifndef SSK_FILTLIST_H
#define SSK_FILTLIST_H

#include<qlist.h>
#include<qobject.h>

class KImageFilter;

/** 
 * Encapsulates information about a filter.
 * @internal
 */
struct FilterContainer
{
	KImageFilter *filter;
	bool	del;	
	bool	index;
};

/**
* Maintains a list of filter objects and provides a lookup table.
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: filtlist.h,v 1.2 1998/10/08 14:42:44 kulow Exp $
*/
class KFilterList : public QObject
{
public:
	/**
	* KFilterList Constructor
	*/
	KFilterList();

	/** 
	 */
	enum DeletePolicy {
		AutoDelete,
		NoDelete 
	};

	/** 
	 * Register an image filter.
	 * @param filter	Pointer to a filter object.
	 * @param policy	If set to AutoDelete, the object will 
	 *			delete the filter on delete.
	 * @return The array index of the filter.
	 */
	int registerFilter( KImageFilter *filter, 
			DeletePolicy policy );

	KImageFilter *filter( int index );
	int count() const;

	/**
	* KFilterList Destructor
	*/
	virtual ~KFilterList();

private:
	QList<FilterContainer> *_filters;
};

#endif // SSK_FILTLIST_H
