	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "midiinstdlg.h"
#include <klocale.h>
#include <kstddirs.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>
#include <kbuttonbox.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qlined.h>
#include <kapp.h>
#include <unistd.h>
#include <stdio.h>
#include <dirent.h>

#include <string>
#include <vector>

using namespace std;

static vector<string> getArtsPath()
{
	vector<string> artsPath;
	QString dir = locate("data", "artsbuilder/examples/");
	artsPath.push_back(dir.ascii());
	const char *home = getenv("HOME");
	if(home)
		artsPath.push_back(string(home)+"/arts/structures/");
	return artsPath;
}

static vector<string> *listFiles( const char* directory, const char* extension )
{
	vector<string> *result = new vector<string>;
	vector<string> artsPath = getArtsPath();

	unsigned long l, extlen = strlen(extension);
	for(l=0;l<artsPath.size();l++)
	{
		string pathname = string(artsPath[l])+"/"+directory;

		DIR *dir = opendir(pathname.c_str());
		if(dir != 0)
		{
			struct dirent *de;
			while((de = readdir(dir)) != 0)
			{
				if(strlen(de->d_name) > extlen &&
						strncmp(&de->d_name[strlen(de->d_name)-extlen],
											extension,extlen) == 0)
					result->push_back(de->d_name);
			}
			closedir(dir);
		}
	}
	return result;
}

MidiInstDlg::MidiInstDlg(QWidget *parent)
	:QDialog(parent,"instrument",TRUE)
{
	QVBoxLayout *mainlayout = new QVBoxLayout(this);

// caption label: title

	mainlayout->addSpacing(5);
	QLabel *captionlabel = new QLabel(this);
	QFont labelfont(captionlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	captionlabel->setFont(labelfont);
	captionlabel->setText(QString(" ")+QString(i18n("Instrument"))+QString(" "));
	captionlabel->setAlignment(AlignCenter);
	//min_size(captionlabel);
	mainlayout->addWidget(captionlabel);

// hruler

	mainlayout->addSpacing(5);
	QFrame *ruler2 = new QFrame(this);
	ruler2->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	ruler2->setMinimumSize(50,2);
	mainlayout->addWidget(ruler2);

	mainlayout->addSpacing(5);

// combobox

	box = new QComboBox(this);

	vector<string> *instruments = listFiles(".",".arts");
	unsigned long i;
	for(i=0;i<instruments->size();i++)
	{
		char *modname = strdup((*instruments)[i].c_str());
		const char *prefix = "instrument_";
		if(strlen(modname) > 5)			/* kill .arts extension */
			modname[strlen(modname)-5] = 0;
		if(strncmp(modname,prefix,strlen(prefix)) == 0 &&
		   strcmp(&modname[strlen(modname)-4],"_GUI") != 0)
		{
			box->insertItem(&modname[strlen(prefix)]);
		}
		free(modname);
	}
	delete instruments;

	vector<string> *maps = listFiles(".",".arts-map");
	for(i=0;i<maps->size();i++)
	{
		char *modname = strdup((*maps)[i].c_str());
		const char *prefix = "instrument_";
		if(strlen(modname) > 9)			/* kill .arts extension */
			modname[strlen(modname)-9] = 0;
		if(strncmp(modname,prefix,strlen(prefix)) == 0)
			box->insertItem(&modname[strlen(prefix)]);
		free(modname);
	}
	delete maps;


	mainlayout->addWidget(box);

// hruler

	mainlayout->addSpacing(5);
	QFrame *ruler = new QFrame(this);
	ruler->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	ruler->setMinimumSize(50,2);
	mainlayout->addWidget(ruler);

	mainlayout->addSpacing(5);

// buttons

	QHBoxLayout *buttonlayout = new QHBoxLayout;
	mainlayout->addSpacing(5);
	mainlayout->addLayout(buttonlayout);
	mainlayout->addSpacing(5);

	buttonlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	bbox->addButton(i18n("Help"));
	bbox->addStretch(1);

	QButton *okbutton = bbox->addButton(i18n("OK"));
	connect( okbutton, SIGNAL( clicked() ), SLOT(accept() ) );

	bbox->layout();

	buttonlayout->addWidget(bbox);
	buttonlayout->addSpacing(5);

	mainlayout->freeze();
};

string MidiInstDlg::filename()
{
	vector<string> artsPath = getArtsPath();
	string instrument = box->text(box->currentItem()).ascii();

	unsigned long l;
	for(l=0;l<artsPath.size();l++)
	{
		string pathname;

		pathname = artsPath[l]+"/instrument_"+instrument+".arts";
		if(access(pathname.c_str(),R_OK) == 0)
			return pathname;

		pathname = artsPath[l]+"/instrument_"+instrument+".arts-map";
		if(access(pathname.c_str(),R_OK) == 0)
			return pathname;
	}
	return "";
}
